#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct ParticleEmitterGeometry_Params
{
    int constrained;
    int debug_counter;
    int debug_counter2;
    int debug_counter3;
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    float surface_distance;
    int pending;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int alpha_to_modifier_factor;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM4Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _437;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _461;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _484;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _878;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _935;

layout(set = 0, binding = 10, std140) uniform VM0_0
{
    layout(row_major) ModifierFactorNoise_Params VM0_0_params;
} _1684;

layout(set = 0, binding = 11, std140) uniform VM0_1
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_1_params;
} _1699;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _1729;

layout(set = 0, binding = 12, std140) uniform VM1_0
{
    layout(row_major) ModifierFactorNoise_Params VM1_0_params;
} _2038;

layout(set = 0, binding = 13, std140) uniform VM1_1
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM1_1_params;
} _2051;

layout(set = 0, binding = 14, std140) uniform VM2_0
{
    layout(row_major) ModifierFactorNoise_Params VM2_0_params;
} _2342;

layout(set = 0, binding = 15, std140) uniform VM2_1
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM2_1_params;
} _2355;

layout(set = 0, binding = 16, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _2794;

layout(set = 0, binding = 17, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _2852;

layout(set = 0, binding = 7, std430) buffer VM0
{
    ParticleEmitterGeometry_Params VM0_params;
} _2896;

layout(set = 0, binding = 8, std430) buffer VM1
{
    ParticleEmitterGeometry_Params VM1_params;
} _2933;

layout(set = 0, binding = 9, std430) buffer VM2
{
    ParticleEmitterGeometry_Params VM2_params;
} _2966;

layout(set = 0, binding = 18, std140) uniform VM3
{
    layout(row_major) ModifierFactorNoise_Params VM3_params;
} _2991;

layout(set = 0, binding = 19, std140) uniform VM4
{
    VM4Params VM4_params;
} _3006;

layout(set = 0, binding = 20, std140) uniform VM5
{
    ParticleModifierCurl_Params VM5_params;
} _3031;

layout(set = 0, binding = 21) uniform sampler2D s_Curves;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_484.prt_prev_positions[(id * 3u) + 0u], _484.prt_prev_positions[(id * 3u) + 1u], _484.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _443;
    _443.life_time = _437.prt_states[id].life_time;
    _443.life_span = _437.prt_states[id].life_span;
    _443.generation_id = _437.prt_states[id].generation_id;
    _443.color = _437.prt_states[id].color;
    ParticleState _442 = _443;
    return _442;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

uint particle_emitter_geometry_get_first_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1729.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1729.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _417 = hash(param);
    uint param_1 = _417;
    float _419 = floatConstruct(param_1);
    return _419;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _935.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _935.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _935.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_878.in_vtx_data[coord_offset + 0u], _878.in_vtx_data[coord_offset + 1u], _878.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_878.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash_1 = _permute(param_2);
    vec4 theta = hash_1 * 3.883222103118896484375;
    vec4 sz = (hash_1 * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash_1 * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1501 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1501;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1519 = vector_transform_by_mat43(param, param_1);
        coords = _1519;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1526 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1526;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _1586 = vector_transform_by_mat43(param, param_1);
        coords = _1586;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _1597 = vector_transform_by_mat43(param_2, param_3);
            coords = _1597;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1607 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1607;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

ModifierFactor particle_emitter_geometry_emit_evaluate_modifier_VM0(inout ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _1689;
    _1689.transform_local_to_gizmo = _1684.VM0_0_params.transform_local_to_gizmo;
    _1689.noise_domain_scale = _1684.VM0_0_params.noise_domain_scale;
    _1689.modifier_function = _1684.VM0_0_params.modifier_function;
    _1689.noise_domain_offset = _1684.VM0_0_params.noise_domain_offset;
    _1689.noise_value_scale = _1684.VM0_0_params.noise_value_scale;
    _1689.noise_value_offset = _1684.VM0_0_params.noise_value_offset;
    _1689.influence_scope = _1684.VM0_0_params.influence_scope;
    _1689._pad0 = _1684.VM0_0_params._pad0;
    _1689._pad1 = _1684.VM0_0_params._pad1;
    ModifierFactorNoise_Params param = _1689;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_noise_simplex2(param, param_1, param_2);
    modifier_factor = param_1;
    ModifierFactorDistanceRadial_Params _1704;
    _1704.transform_local_to_gizmo = _1699.VM0_1_params.transform_local_to_gizmo;
    _1704.falloff_curve_idx = _1699.VM0_1_params.falloff_curve_idx;
    _1704.falloff_inverse = _1699.VM0_1_params.falloff_inverse;
    _1704.domain_repeat_x = _1699.VM0_1_params.domain_repeat_x;
    _1704.domain_repeat_y = _1699.VM0_1_params.domain_repeat_y;
    _1704.domain_repeat_z = _1699.VM0_1_params.domain_repeat_z;
    _1704.influence_scope = _1699.VM0_1_params.influence_scope;
    _1704.modifier_function = _1699.VM0_1_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_3 = _1704;
    ModifierFactor param_4 = modifier_factor;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    modifier_factor_distance_radial(param_3, param_4, param_5);
    modifier_factor = param_4;
    return modifier_factor;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _506 = color_convert_rgb_float3_uint(param);
    uint v = _506;
    state.color = v;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

void particle_emitter_geometry_emit_VM0(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    int iteration = 0;
    for (;;)
    {
        if (iteration < 5)
        {
            float fid = float((id + uint(iteration * 45827)) & 16777215u);
            float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
            float param_2 = fid_seed * 5.131999969482421875;
            float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
            float param_3 = fid_seed;
            uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
            face_idx += first_face_idx;
            uint param_4 = face_idx;
            RTFace rt_face = rt_get_face(param_4);
            uint p0_idx = rt_face.v0;
            uint p1_idx = rt_face.v1;
            uint p2_idx = rt_face.v2;
            uint param_5 = p0_idx;
            vec3 p0 = rt_get_vertex(param_5);
            uint param_6 = p1_idx;
            vec3 p1 = rt_get_vertex(param_6);
            uint param_7 = p2_idx;
            vec3 p2 = rt_get_vertex(param_7);
            uint param_8 = p0_idx;
            vec4 c0 = rt_get_vertex_color(param_8);
            uint param_9 = p1_idx;
            vec4 c1 = rt_get_vertex_color(param_9);
            uint param_10 = p2_idx;
            vec4 c2 = rt_get_vertex_color(param_10);
            float param_11 = fid_seed * 0.34130001068115234375;
            bc.x = random(param_11);
            float param_12 = fid_seed * 0.1412999927997589111328125;
            bc.y = random(param_12);
            if ((bc.x + bc.y) >= 1.0)
            {
                bc.x = 1.0 - bc.x;
                bc.y = 1.0 - bc.y;
            }
            vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
            vec4 color = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
            ModifierFactor local_modifier_factor = modifier_factor_defaults();
            local_modifier_factor.factor = 1.0;
            local_modifier_factor.hash = floatBitsToUint(fid_seed);
            local_modifier_factor.id = id;
            local_modifier_factor.position = pos;
            local_modifier_factor.is_spawned = true;
            local_modifier_factor.color = color;
            ModifierFactor param_13 = local_modifier_factor;
            ModifierFactor _1941 = particle_emitter_geometry_emit_evaluate_modifier_VM0(param_13);
            local_modifier_factor = _1941;
            if (local_modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
            {
                int _2027 = iteration;
                iteration = _2027 + 1;
                continue;
            }
            float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
            if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
            {
                if (emitter_params.surface_distance > 0.0)
                {
                    vec3 n = normalize(cross(p0 - p1, p0 - p2));
                    pos += (n * emitter_params.surface_distance);
                }
                if (pos.x == 1234567.0)
                {
                    pos += vec3(fid_seed);
                }
                p.pos = pos;
                ParticleState param_14 = p.state;
                vec3 param_15 = emitter_params.particle_color.xyz;
                prt_set_color(param_14, param_15);
                p.state = param_14;
                ParticleState param_16 = p.state;
                float param_17 = lifetime;
                prt_spawn(param_16, param_17);
                p.state = param_16;
                if (emitter_params.alpha_to_modifier_factor != 0)
                {
                    modifier_factor.factor = color.w;
                }
                emitted = true;
                break;
            }
            int _2027 = iteration;
            iteration = _2027 + 1;
            continue;
        }
        else
        {
            break;
        }
    }
}

ModifierFactor particle_emitter_geometry_emit_evaluate_modifier_VM1(inout ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _2042;
    _2042.transform_local_to_gizmo = _2038.VM1_0_params.transform_local_to_gizmo;
    _2042.noise_domain_scale = _2038.VM1_0_params.noise_domain_scale;
    _2042.modifier_function = _2038.VM1_0_params.modifier_function;
    _2042.noise_domain_offset = _2038.VM1_0_params.noise_domain_offset;
    _2042.noise_value_scale = _2038.VM1_0_params.noise_value_scale;
    _2042.noise_value_offset = _2038.VM1_0_params.noise_value_offset;
    _2042.influence_scope = _2038.VM1_0_params.influence_scope;
    _2042._pad0 = _2038.VM1_0_params._pad0;
    _2042._pad1 = _2038.VM1_0_params._pad1;
    ModifierFactorNoise_Params param = _2042;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_noise_simplex2(param, param_1, param_2);
    modifier_factor = param_1;
    ModifierFactorDistanceRadial_Params _2055;
    _2055.transform_local_to_gizmo = _2051.VM1_1_params.transform_local_to_gizmo;
    _2055.falloff_curve_idx = _2051.VM1_1_params.falloff_curve_idx;
    _2055.falloff_inverse = _2051.VM1_1_params.falloff_inverse;
    _2055.domain_repeat_x = _2051.VM1_1_params.domain_repeat_x;
    _2055.domain_repeat_y = _2051.VM1_1_params.domain_repeat_y;
    _2055.domain_repeat_z = _2051.VM1_1_params.domain_repeat_z;
    _2055.influence_scope = _2051.VM1_1_params.influence_scope;
    _2055.modifier_function = _2051.VM1_1_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_3 = _2055;
    ModifierFactor param_4 = modifier_factor;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    modifier_factor_distance_radial(param_3, param_4, param_5);
    modifier_factor = param_4;
    return modifier_factor;
}

void particle_emitter_geometry_emit_VM1(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    int iteration = 0;
    for (;;)
    {
        if (iteration < 5)
        {
            float fid = float((id + uint(iteration * 45827)) & 16777215u);
            float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
            float param_2 = fid_seed * 5.131999969482421875;
            float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
            float param_3 = fid_seed;
            uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
            face_idx += first_face_idx;
            uint param_4 = face_idx;
            RTFace rt_face = rt_get_face(param_4);
            uint p0_idx = rt_face.v0;
            uint p1_idx = rt_face.v1;
            uint p2_idx = rt_face.v2;
            uint param_5 = p0_idx;
            vec3 p0 = rt_get_vertex(param_5);
            uint param_6 = p1_idx;
            vec3 p1 = rt_get_vertex(param_6);
            uint param_7 = p2_idx;
            vec3 p2 = rt_get_vertex(param_7);
            uint param_8 = p0_idx;
            vec4 c0 = rt_get_vertex_color(param_8);
            uint param_9 = p1_idx;
            vec4 c1 = rt_get_vertex_color(param_9);
            uint param_10 = p2_idx;
            vec4 c2 = rt_get_vertex_color(param_10);
            float param_11 = fid_seed * 0.34130001068115234375;
            bc.x = random(param_11);
            float param_12 = fid_seed * 0.1412999927997589111328125;
            bc.y = random(param_12);
            if ((bc.x + bc.y) >= 1.0)
            {
                bc.x = 1.0 - bc.x;
                bc.y = 1.0 - bc.y;
            }
            vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
            vec4 color = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
            ModifierFactor local_modifier_factor = modifier_factor_defaults();
            local_modifier_factor.factor = 1.0;
            local_modifier_factor.hash = floatBitsToUint(fid_seed);
            local_modifier_factor.id = id;
            local_modifier_factor.position = pos;
            local_modifier_factor.is_spawned = true;
            local_modifier_factor.color = color;
            ModifierFactor param_13 = local_modifier_factor;
            ModifierFactor _2248 = particle_emitter_geometry_emit_evaluate_modifier_VM1(param_13);
            local_modifier_factor = _2248;
            if (local_modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
            {
                int _2331 = iteration;
                iteration = _2331 + 1;
                continue;
            }
            float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
            if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
            {
                if (emitter_params.surface_distance > 0.0)
                {
                    vec3 n = normalize(cross(p0 - p1, p0 - p2));
                    pos += (n * emitter_params.surface_distance);
                }
                if (pos.x == 1234567.0)
                {
                    pos += vec3(fid_seed);
                }
                p.pos = pos;
                ParticleState param_14 = p.state;
                vec3 param_15 = emitter_params.particle_color.xyz;
                prt_set_color(param_14, param_15);
                p.state = param_14;
                ParticleState param_16 = p.state;
                float param_17 = lifetime;
                prt_spawn(param_16, param_17);
                p.state = param_16;
                if (emitter_params.alpha_to_modifier_factor != 0)
                {
                    modifier_factor.factor = color.w;
                }
                emitted = true;
                break;
            }
            int _2331 = iteration;
            iteration = _2331 + 1;
            continue;
        }
        else
        {
            break;
        }
    }
}

ModifierFactor particle_emitter_geometry_emit_evaluate_modifier_VM2(inout ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _2346;
    _2346.transform_local_to_gizmo = _2342.VM2_0_params.transform_local_to_gizmo;
    _2346.noise_domain_scale = _2342.VM2_0_params.noise_domain_scale;
    _2346.modifier_function = _2342.VM2_0_params.modifier_function;
    _2346.noise_domain_offset = _2342.VM2_0_params.noise_domain_offset;
    _2346.noise_value_scale = _2342.VM2_0_params.noise_value_scale;
    _2346.noise_value_offset = _2342.VM2_0_params.noise_value_offset;
    _2346.influence_scope = _2342.VM2_0_params.influence_scope;
    _2346._pad0 = _2342.VM2_0_params._pad0;
    _2346._pad1 = _2342.VM2_0_params._pad1;
    ModifierFactorNoise_Params param = _2346;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_noise_simplex2(param, param_1, param_2);
    modifier_factor = param_1;
    ModifierFactorDistanceRadial_Params _2359;
    _2359.transform_local_to_gizmo = _2355.VM2_1_params.transform_local_to_gizmo;
    _2359.falloff_curve_idx = _2355.VM2_1_params.falloff_curve_idx;
    _2359.falloff_inverse = _2355.VM2_1_params.falloff_inverse;
    _2359.domain_repeat_x = _2355.VM2_1_params.domain_repeat_x;
    _2359.domain_repeat_y = _2355.VM2_1_params.domain_repeat_y;
    _2359.domain_repeat_z = _2355.VM2_1_params.domain_repeat_z;
    _2359.influence_scope = _2355.VM2_1_params.influence_scope;
    _2359.modifier_function = _2355.VM2_1_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_3 = _2359;
    ModifierFactor param_4 = modifier_factor;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    modifier_factor_distance_radial(param_3, param_4, param_5);
    modifier_factor = param_4;
    return modifier_factor;
}

void particle_emitter_geometry_emit_VM2(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    int iteration = 0;
    for (;;)
    {
        if (iteration < 5)
        {
            float fid = float((id + uint(iteration * 45827)) & 16777215u);
            float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
            float param_2 = fid_seed * 5.131999969482421875;
            float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
            float param_3 = fid_seed;
            uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
            face_idx += first_face_idx;
            uint param_4 = face_idx;
            RTFace rt_face = rt_get_face(param_4);
            uint p0_idx = rt_face.v0;
            uint p1_idx = rt_face.v1;
            uint p2_idx = rt_face.v2;
            uint param_5 = p0_idx;
            vec3 p0 = rt_get_vertex(param_5);
            uint param_6 = p1_idx;
            vec3 p1 = rt_get_vertex(param_6);
            uint param_7 = p2_idx;
            vec3 p2 = rt_get_vertex(param_7);
            uint param_8 = p0_idx;
            vec4 c0 = rt_get_vertex_color(param_8);
            uint param_9 = p1_idx;
            vec4 c1 = rt_get_vertex_color(param_9);
            uint param_10 = p2_idx;
            vec4 c2 = rt_get_vertex_color(param_10);
            float param_11 = fid_seed * 0.34130001068115234375;
            bc.x = random(param_11);
            float param_12 = fid_seed * 0.1412999927997589111328125;
            bc.y = random(param_12);
            if ((bc.x + bc.y) >= 1.0)
            {
                bc.x = 1.0 - bc.x;
                bc.y = 1.0 - bc.y;
            }
            vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
            vec4 color = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
            ModifierFactor local_modifier_factor = modifier_factor_defaults();
            local_modifier_factor.factor = 1.0;
            local_modifier_factor.hash = floatBitsToUint(fid_seed);
            local_modifier_factor.id = id;
            local_modifier_factor.position = pos;
            local_modifier_factor.is_spawned = true;
            local_modifier_factor.color = color;
            ModifierFactor param_13 = local_modifier_factor;
            ModifierFactor _2552 = particle_emitter_geometry_emit_evaluate_modifier_VM2(param_13);
            local_modifier_factor = _2552;
            if (local_modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
            {
                int _2635 = iteration;
                iteration = _2635 + 1;
                continue;
            }
            float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
            if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
            {
                if (emitter_params.surface_distance > 0.0)
                {
                    vec3 n = normalize(cross(p0 - p1, p0 - p2));
                    pos += (n * emitter_params.surface_distance);
                }
                if (pos.x == 1234567.0)
                {
                    pos += vec3(fid_seed);
                }
                p.pos = pos;
                ParticleState param_14 = p.state;
                vec3 param_15 = emitter_params.particle_color.xyz;
                prt_set_color(param_14, param_15);
                p.state = param_14;
                ParticleState param_16 = p.state;
                float param_17 = lifetime;
                prt_spawn(param_16, param_17);
                p.state = param_16;
                if (emitter_params.alpha_to_modifier_factor != 0)
                {
                    modifier_factor.factor = color.w;
                }
                emitted = true;
                break;
            }
            int _2635 = iteration;
            iteration = _2635 + 1;
            continue;
        }
        else
        {
            break;
        }
    }
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_2794.globals.time, _2794.globals.time * 0.3014999926090240478515625, (-_2794.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _2817 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_2817 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _450;
    _450.life_time = state.life_time;
    _450.life_span = state.life_span;
    _450.generation_id = state.generation_id;
    _450.color = state.color;
    _437.prt_states[id] = _450;
}

void prt_set_position(uint id, vec3 p)
{
    _461.prt_positions[(id * 3u) + 0u] = p.x;
    _461.prt_positions[(id * 3u) + 1u] = p.y;
    _461.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_2852.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _2901 = atomicAdd(_2896.VM0_params.pending, -1);
        int pending = _2901;
        if (pending > 0)
        {
            ParticleEmitterGeometry_Params _2912;
            _2912.constrained = _2896.VM0_params.constrained;
            _2912.debug_counter = _2896.VM0_params.debug_counter;
            _2912.debug_counter2 = _2896.VM0_params.debug_counter2;
            _2912.debug_counter3 = _2896.VM0_params.debug_counter3;
            _2912.position = _2896.VM0_params.position;
            _2912.falloff_mode = _2896.VM0_params.falloff_mode;
            _2912.radius = _2896.VM0_params.radius;
            _2912.falloff_inverse = _2896.VM0_params.falloff_inverse;
            _2912.particle_color = _2896.VM0_params.particle_color;
            _2912.particle_lifetime = _2896.VM0_params.particle_lifetime;
            _2912.particle_lifetime_randomness = _2896.VM0_params.particle_lifetime_randomness;
            _2912.rate = _2896.VM0_params.rate;
            _2912.seed = _2896.VM0_params.seed;
            _2912.surface_distance = _2896.VM0_params.surface_distance;
            _2912.pending = _2896.VM0_params.pending;
            _2912.transformed_data_location_idx = _2896.VM0_params.transformed_data_location_idx;
            _2912.transformed_data_location_num = _2896.VM0_params.transformed_data_location_num;
            _2912.alpha_to_modifier_factor = _2896.VM0_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_4 = _2912;
            ModifierFactor param_5 = modifier_factor;
            Particle param_6 = p;
            uint param_7 = id;
            uint param_8 = uint(pending);
            particle_emitter_geometry_emit_VM0(param_4, param_5, param_6, param_7, param_8);
            modifier_factor = param_5;
            p = param_6;
        }
    }
    ParticleState param_9 = p.state;
    if (!prt_is_alive(param_9))
    {
        int _2935 = atomicAdd(_2933.VM1_params.pending, -1);
        int pending_1 = _2935;
        if (pending_1 > 0)
        {
            ParticleEmitterGeometry_Params _2945;
            _2945.constrained = _2933.VM1_params.constrained;
            _2945.debug_counter = _2933.VM1_params.debug_counter;
            _2945.debug_counter2 = _2933.VM1_params.debug_counter2;
            _2945.debug_counter3 = _2933.VM1_params.debug_counter3;
            _2945.position = _2933.VM1_params.position;
            _2945.falloff_mode = _2933.VM1_params.falloff_mode;
            _2945.radius = _2933.VM1_params.radius;
            _2945.falloff_inverse = _2933.VM1_params.falloff_inverse;
            _2945.particle_color = _2933.VM1_params.particle_color;
            _2945.particle_lifetime = _2933.VM1_params.particle_lifetime;
            _2945.particle_lifetime_randomness = _2933.VM1_params.particle_lifetime_randomness;
            _2945.rate = _2933.VM1_params.rate;
            _2945.seed = _2933.VM1_params.seed;
            _2945.surface_distance = _2933.VM1_params.surface_distance;
            _2945.pending = _2933.VM1_params.pending;
            _2945.transformed_data_location_idx = _2933.VM1_params.transformed_data_location_idx;
            _2945.transformed_data_location_num = _2933.VM1_params.transformed_data_location_num;
            _2945.alpha_to_modifier_factor = _2933.VM1_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_10 = _2945;
            ModifierFactor param_11 = modifier_factor;
            Particle param_12 = p;
            uint param_13 = id;
            uint param_14 = uint(pending_1);
            particle_emitter_geometry_emit_VM1(param_10, param_11, param_12, param_13, param_14);
            modifier_factor = param_11;
            p = param_12;
        }
    }
    ParticleState param_15 = p.state;
    if (!prt_is_alive(param_15))
    {
        int _2968 = atomicAdd(_2966.VM2_params.pending, -1);
        int pending_2 = _2968;
        if (pending_2 > 0)
        {
            ParticleEmitterGeometry_Params _2978;
            _2978.constrained = _2966.VM2_params.constrained;
            _2978.debug_counter = _2966.VM2_params.debug_counter;
            _2978.debug_counter2 = _2966.VM2_params.debug_counter2;
            _2978.debug_counter3 = _2966.VM2_params.debug_counter3;
            _2978.position = _2966.VM2_params.position;
            _2978.falloff_mode = _2966.VM2_params.falloff_mode;
            _2978.radius = _2966.VM2_params.radius;
            _2978.falloff_inverse = _2966.VM2_params.falloff_inverse;
            _2978.particle_color = _2966.VM2_params.particle_color;
            _2978.particle_lifetime = _2966.VM2_params.particle_lifetime;
            _2978.particle_lifetime_randomness = _2966.VM2_params.particle_lifetime_randomness;
            _2978.rate = _2966.VM2_params.rate;
            _2978.seed = _2966.VM2_params.seed;
            _2978.surface_distance = _2966.VM2_params.surface_distance;
            _2978.pending = _2966.VM2_params.pending;
            _2978.transformed_data_location_idx = _2966.VM2_params.transformed_data_location_idx;
            _2978.transformed_data_location_num = _2966.VM2_params.transformed_data_location_num;
            _2978.alpha_to_modifier_factor = _2966.VM2_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_16 = _2978;
            ModifierFactor param_17 = modifier_factor;
            Particle param_18 = p;
            uint param_19 = id;
            uint param_20 = uint(pending_2);
            particle_emitter_geometry_emit_VM2(param_16, param_17, param_18, param_19, param_20);
            modifier_factor = param_17;
            p = param_18;
        }
    }
    ModifierFactorNoise_Params _2995;
    _2995.transform_local_to_gizmo = _2991.VM3_params.transform_local_to_gizmo;
    _2995.noise_domain_scale = _2991.VM3_params.noise_domain_scale;
    _2995.modifier_function = _2991.VM3_params.modifier_function;
    _2995.noise_domain_offset = _2991.VM3_params.noise_domain_offset;
    _2995.noise_value_scale = _2991.VM3_params.noise_value_scale;
    _2995.noise_value_offset = _2991.VM3_params.noise_value_offset;
    _2995.influence_scope = _2991.VM3_params.influence_scope;
    _2995._pad0 = _2991.VM3_params._pad0;
    _2995._pad1 = _2991.VM3_params._pad1;
    ModifierFactorNoise_Params param_21 = _2995;
    ModifierFactor param_22 = modifier_factor;
    CoordinateSystemTrasforms param_23 = cs_transforms;
    modifier_factor_noise_simplex2(param_21, param_22, param_23);
    modifier_factor = param_22;
    vec3 modifier_position = _3006.VM4_params.position;
    p.pos += ((_3006.VM4_params.velocity * _2852.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_24 = p.state;
    if (prt_is_alive(param_24))
    {
        ParticleModifierCurl_Params _3036;
        _3036.position = _3031.VM5_params.position;
        _3036.falloff_mode = _3031.VM5_params.falloff_mode;
        _3036.radius = _3031.VM5_params.radius;
        _3036.falloff_inverse = _3031.VM5_params.falloff_inverse;
        _3036.noise_strength = _3031.VM5_params.noise_strength;
        _3036.noise_speed = _3031.VM5_params.noise_speed;
        _3036.noise_scale = _3031.VM5_params.noise_scale;
        ParticleModifierCurl_Params param_25 = _3036;
        ParticleLifecycleParams _3041;
        _3041.time_step = _2852.lifecycle_params.time_step;
        _3041.max_lifetime = _2852.lifecycle_params.max_lifetime;
        _3041.reset = _2852.lifecycle_params.reset;
        _3041._pad1 = _2852.lifecycle_params._pad1;
        ParticleLifecycleParams param_26 = _3041;
        ModifierFactor param_27 = modifier_factor;
        Particle param_28 = p;
        uint param_29 = id;
        particle_modifier_curl(param_25, param_26, param_27, param_28, param_29);
        modifier_factor = param_27;
        p = param_28;
    }
    ParticleState param_30 = p.state;
    float param_31 = _2852.lifecycle_params.time_step;
    float param_32 = _2852.lifecycle_params.max_lifetime;
    prt_advance_life(param_30, param_31, param_32);
    p.state = param_30;
    uint param_33 = id;
    ParticleState param_34 = p.state;
    prt_set_state(param_33, param_34);
    uint param_35 = id;
    vec3 param_36 = p.pos;
    prt_set_position(param_35, param_36);
}

 