#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleModifierSwirl_Params
{
    vec3 position;
    int falloff_curve_idx;
    vec3 radius;
    int falloff_inverse;
    float velocity;
    float velocity_randomness;
    float time_step;
    float axis_randomness;
    vec3 axis;
    float _pad0;
    vec3 scale;
    float _pad1;
};

struct ParticleModifierColorize_Params
{
    vec4 color;
    int mode;
    int blend_mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM10Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _523;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _547;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _570;

layout(set = 0, binding = 6, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1398;

layout(set = 0, binding = 7, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1736;

layout(set = 0, binding = 4, std430) buffer VM0
{
    layout(row_major) ParticleEmitterPrimitive_Params VM0_params;
} _1780;

layout(set = 0, binding = 8, std140) uniform VM1
{
    layout(row_major) ModifierFactorDistancePlane_Params VM1_params;
} _1807;

layout(set = 0, binding = 9, std140) uniform VM2
{
    ModifierFactorMulAdd_Params VM2_params;
} _1822;

layout(set = 0, binding = 10, std140) uniform VM3
{
    layout(row_major) ModifierFactorNoise_Params VM3_params;
} _1835;

layout(set = 0, binding = 11, std140) uniform VM4
{
    ModifierFactorMulAdd_Params VM4_params;
} _1849;

layout(set = 0, binding = 12, std140) uniform VM5
{
    ModifierFactorClamp_Params VM5_params;
} _1861;

layout(set = 0, binding = 13, std140) uniform VM6
{
    ParticleModifierCurl_Params VM6_params;
} _1880;

layout(set = 0, binding = 14, std140) uniform VM7
{
    ParticleModifierCurl_Params VM7_params;
} _1907;

layout(set = 0, binding = 15, std140) uniform VM8
{
    ParticleModifierCurl_Params VM8_params;
} _1933;

layout(set = 0, binding = 5, std430) buffer VM9
{
    ParticleModifierSwirl_Params VM9_params;
} _1960;

layout(set = 0, binding = 16, std140) uniform VM10
{
    VM10Params VM10_params;
} _1982;

layout(set = 0, binding = 17, std140) uniform VM11
{
    ParticleModifierColorize_Params VM11_params;
} _2007;

layout(set = 0, binding = 18, std140) uniform VM12
{
    ModifierFactorMulAdd_Params VM12_params;
} _2024;

layout(set = 0, binding = 19, std140) uniform VM13
{
    ParticleModifierCurl_Params VM13_params;
} _2041;

layout(set = 0, binding = 20) uniform sampler2D s_Curves;
layout(set = 0, binding = 21) uniform sampler2D s_Gradients;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_570.prt_prev_positions[(id * 3u) + 0u], _570.prt_prev_positions[(id * 3u) + 1u], _570.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _529;
    _529.life_time = _523.prt_states[id].life_time;
    _529.life_span = _523.prt_states[id].life_span;
    _529.generation_id = _523.prt_states[id].generation_id;
    _529.color = _523.prt_states[id].color;
    ParticleState _528 = _529;
    return _528;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _606 = color_convert_rgb_float3_uint(param);
    uint v = _606;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    vec3 _1058 = vector_transform_by_mat43(param_6, param_7);
    pos = _1058;
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1102 = vector_transform_by_mat43(param, param_1);
        coords = _1102;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1109 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1109;
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_4 = modifier_params.falloff_curve_idx;
    float param_5 = influence;
    influence = curve_sample(param_4, param_5);
    float v = influence;
    ModifierFactor param_6 = modifier_factor;
    uint param_7 = uint(modifier_params.modifier_function);
    float param_8 = v;
    modifier_process_modifier_factor(param_6, param_7, param_8);
    modifier_factor = param_6;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1181 = vector_transform_by_mat43(param, param_1);
        coords = _1181;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1188 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1188;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1398.globals.time, _1398.globals.time * 0.3014999926090240478515625, (-_1398.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1420 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1420 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _503 = hash(param);
    uint param_1 = _503;
    float _505 = floatConstruct(param_1);
    return _505;
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

void particle_modifier_swirl(ParticleModifierSwirl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 influence_pos = p.pos;
    float influence = length((influence_pos - modifier_position) / (modifier_params.radius * 0.5));
    if (influence > 1.0)
    {
        influence = 1.0;
    }
    if (modifier_params.falloff_inverse == 0)
    {
        influence = 1.0 - influence;
    }
    influence = 1.0 - influence;
    int param = modifier_params.falloff_curve_idx;
    float param_1 = influence;
    influence = clamp(curve_sample(param, param_1), 0.0, 1.0);
    vec3 axis = modifier_params.axis;
    float param_2 = float(id) * 0.012470000423491001129150390625;
    float randomness_1 = random(param_2);
    float param_3 = float(id) * 0.1031199991703033447265625;
    float randomness_2 = random(param_3);
    axis.x += (randomness_1 * modifier_params.axis_randomness);
    axis.y -= (randomness_1 * modifier_params.axis_randomness);
    axis.z += (randomness_2 * modifier_params.axis_randomness);
    axis = normalize(axis);
    float angle_rad = modifier_params.velocity * (1.0 + (randomness_1 * modifier_params.velocity_randomness));
    angle_rad *= (lifecycle_params.time_step * influence);
    vec3 param_4 = axis;
    float param_5 = angle_rad * modifier_factor.factor;
    vec4 q = quaternion_from_axis_angle(param_4, param_5);
    vec3 pos = p.pos - modifier_params.position;
    vec3 param_6 = pos;
    vec4 param_7 = q;
    pos = vector_rotate_by_quaternion(param_6, param_7);
    vec3 pos_scaled = pos * modifier_params.scale;
    pos = mix(pos, pos_scaled, vec3(lifecycle_params.time_step * influence));
    pos += modifier_params.position;
    p.pos = pos;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _593 = color_convert_uint_to_float3(param);
    c.x = _593.x;
    c.y = _593.y;
    c.z = _593.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    float v = 0.0;
    if (uint(modifier_params.mode) == 0u)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (uint(modifier_params.mode) == 1u)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (uint(modifier_params.mode) == 2u)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    if (uint(modifier_params.mode) == 3u)
    {
        v = 1.0;
    }
    v = fract(v);
    vec3 color;
    if (modifier_params.color_gradient_idx != (-1))
    {
        int param_2 = modifier_params.color_gradient_idx;
        float param_3 = v;
        color = gradient_sample(param_2, param_3).xyz * modifier_params.color.xyz;
    }
    else
    {
        color = modifier_params.color.xyz;
    }
    if (uint(modifier_params.blend_mode) == 0u)
    {
        ParticleState param_4 = p.state;
        vec4 color_previous = prt_get_color(param_4);
        color = mix(color_previous.xyz, color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
    }
    else
    {
        if (uint(modifier_params.blend_mode) == 2u)
        {
            color = mix(vec3(1.0), color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
        }
        else
        {
            if (uint(modifier_params.blend_mode) == 1u)
            {
                color = mix(vec3(0.0), color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
            }
        }
    }
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _536;
    _536.life_time = state.life_time;
    _536.life_span = state.life_span;
    _536.generation_id = state.generation_id;
    _536.color = state.color;
    _523.prt_states[id] = _536;
}

void prt_set_position(uint id, vec3 p)
{
    _547.prt_positions[(id * 3u) + 0u] = p.x;
    _547.prt_positions[(id * 3u) + 1u] = p.y;
    _547.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_1736.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _1783 = atomicAdd(_1780.VM0_params.pending, -1);
        int pending = _1783;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _1792;
            _1792.transform = _1780.VM0_params.transform;
            _1792.particle_color = _1780.VM0_params.particle_color;
            _1792.primitive_size = _1780.VM0_params.primitive_size;
            _1792.perimeter_only = _1780.VM0_params.perimeter_only;
            _1792.primitive_type = _1780.VM0_params.primitive_type;
            _1792.particle_lifetime = _1780.VM0_params.particle_lifetime;
            _1792.particle_lifetime_randomness = _1780.VM0_params.particle_lifetime_randomness;
            _1792.rate = _1780.VM0_params.rate;
            _1792.seed = _1780.VM0_params.seed;
            _1792.pending = _1780.VM0_params.pending;
            ParticleEmitterPrimitive_Params param_4 = _1792;
            ParticleLifecycleParams _1797;
            _1797.time_step = _1736.lifecycle_params.time_step;
            _1797.max_lifetime = _1736.lifecycle_params.max_lifetime;
            _1797.reset = _1736.lifecycle_params.reset;
            _1797._pad1 = _1736.lifecycle_params._pad1;
            ParticleLifecycleParams param_5 = _1797;
            Particle param_6 = p;
            uint param_7 = id;
            particle_emitter_primitive_emit(param_4, param_5, param_6, param_7);
            p = param_6;
        }
    }
    ModifierFactorDistancePlane_Params _1812;
    _1812.transform_local_to_gizmo = _1807.VM1_params.transform_local_to_gizmo;
    _1812.falloff_curve_idx = _1807.VM1_params.falloff_curve_idx;
    _1812.falloff_inverse = _1807.VM1_params.falloff_inverse;
    _1812.domain_mirror = _1807.VM1_params.domain_mirror;
    _1812.domain_repeat = _1807.VM1_params.domain_repeat;
    _1812.influence_scope = _1807.VM1_params.influence_scope;
    _1812.modifier_function = _1807.VM1_params.modifier_function;
    ModifierFactorDistancePlane_Params param_8 = _1812;
    ModifierFactor param_9 = modifier_factor;
    CoordinateSystemTrasforms param_10 = cs_transforms;
    modifier_factor_distance_plane(param_8, param_9, param_10);
    modifier_factor = param_9;
    ModifierFactorMulAdd_Params _1827;
    _1827.multiply_value = _1822.VM2_params.multiply_value;
    _1827.add_value = _1822.VM2_params.add_value;
    ModifierFactorMulAdd_Params param_11 = _1827;
    ModifierFactor param_12 = modifier_factor;
    modifier_factor_mul_add(param_11, param_12);
    modifier_factor = param_12;
    ModifierFactorNoise_Params _1840;
    _1840.transform_local_to_gizmo = _1835.VM3_params.transform_local_to_gizmo;
    _1840.noise_domain_scale = _1835.VM3_params.noise_domain_scale;
    _1840.modifier_function = _1835.VM3_params.modifier_function;
    _1840.noise_domain_offset = _1835.VM3_params.noise_domain_offset;
    _1840.noise_value_scale = _1835.VM3_params.noise_value_scale;
    _1840.noise_value_offset = _1835.VM3_params.noise_value_offset;
    _1840.influence_scope = _1835.VM3_params.influence_scope;
    _1840._pad0 = _1835.VM3_params._pad0;
    _1840._pad1 = _1835.VM3_params._pad1;
    ModifierFactorNoise_Params param_13 = _1840;
    ModifierFactor param_14 = modifier_factor;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    modifier_factor_noise_default(param_13, param_14, param_15);
    modifier_factor = param_14;
    ModifierFactorMulAdd_Params _1853;
    _1853.multiply_value = _1849.VM4_params.multiply_value;
    _1853.add_value = _1849.VM4_params.add_value;
    ModifierFactorMulAdd_Params param_16 = _1853;
    ModifierFactor param_17 = modifier_factor;
    modifier_factor_mul_add(param_16, param_17);
    modifier_factor = param_17;
    ModifierFactorClamp_Params _1866;
    _1866.clamp_min = _1861.VM5_params.clamp_min;
    _1866.clamp_max = _1861.VM5_params.clamp_max;
    _1866.clamp_min_enable = _1861.VM5_params.clamp_min_enable;
    _1866.clamp_max_enable = _1861.VM5_params.clamp_max_enable;
    ModifierFactorClamp_Params param_18 = _1866;
    ModifierFactor param_19 = modifier_factor;
    modifier_factor_clamp(param_18, param_19);
    modifier_factor = param_19;
    ParticleState param_20 = p.state;
    if (prt_is_alive(param_20))
    {
        ParticleModifierCurl_Params _1885;
        _1885.position = _1880.VM6_params.position;
        _1885.falloff_mode = _1880.VM6_params.falloff_mode;
        _1885.radius = _1880.VM6_params.radius;
        _1885.falloff_inverse = _1880.VM6_params.falloff_inverse;
        _1885.noise_strength = _1880.VM6_params.noise_strength;
        _1885.noise_speed = _1880.VM6_params.noise_speed;
        _1885.noise_scale = _1880.VM6_params.noise_scale;
        ParticleModifierCurl_Params param_21 = _1885;
        ParticleLifecycleParams _1889;
        _1889.time_step = _1736.lifecycle_params.time_step;
        _1889.max_lifetime = _1736.lifecycle_params.max_lifetime;
        _1889.reset = _1736.lifecycle_params.reset;
        _1889._pad1 = _1736.lifecycle_params._pad1;
        ParticleLifecycleParams param_22 = _1889;
        ModifierFactor param_23 = modifier_factor;
        Particle param_24 = p;
        uint param_25 = id;
        particle_modifier_curl(param_21, param_22, param_23, param_24, param_25);
        modifier_factor = param_23;
        p = param_24;
    }
    ParticleState param_26 = p.state;
    if (prt_is_alive(param_26))
    {
        ParticleModifierCurl_Params _1911;
        _1911.position = _1907.VM7_params.position;
        _1911.falloff_mode = _1907.VM7_params.falloff_mode;
        _1911.radius = _1907.VM7_params.radius;
        _1911.falloff_inverse = _1907.VM7_params.falloff_inverse;
        _1911.noise_strength = _1907.VM7_params.noise_strength;
        _1911.noise_speed = _1907.VM7_params.noise_speed;
        _1911.noise_scale = _1907.VM7_params.noise_scale;
        ParticleModifierCurl_Params param_27 = _1911;
        ParticleLifecycleParams _1915;
        _1915.time_step = _1736.lifecycle_params.time_step;
        _1915.max_lifetime = _1736.lifecycle_params.max_lifetime;
        _1915.reset = _1736.lifecycle_params.reset;
        _1915._pad1 = _1736.lifecycle_params._pad1;
        ParticleLifecycleParams param_28 = _1915;
        ModifierFactor param_29 = modifier_factor;
        Particle param_30 = p;
        uint param_31 = id;
        particle_modifier_curl(param_27, param_28, param_29, param_30, param_31);
        modifier_factor = param_29;
        p = param_30;
    }
    ParticleState param_32 = p.state;
    if (prt_is_alive(param_32))
    {
        ParticleModifierCurl_Params _1937;
        _1937.position = _1933.VM8_params.position;
        _1937.falloff_mode = _1933.VM8_params.falloff_mode;
        _1937.radius = _1933.VM8_params.radius;
        _1937.falloff_inverse = _1933.VM8_params.falloff_inverse;
        _1937.noise_strength = _1933.VM8_params.noise_strength;
        _1937.noise_speed = _1933.VM8_params.noise_speed;
        _1937.noise_scale = _1933.VM8_params.noise_scale;
        ParticleModifierCurl_Params param_33 = _1937;
        ParticleLifecycleParams _1941;
        _1941.time_step = _1736.lifecycle_params.time_step;
        _1941.max_lifetime = _1736.lifecycle_params.max_lifetime;
        _1941.reset = _1736.lifecycle_params.reset;
        _1941._pad1 = _1736.lifecycle_params._pad1;
        ParticleLifecycleParams param_34 = _1941;
        ModifierFactor param_35 = modifier_factor;
        Particle param_36 = p;
        uint param_37 = id;
        particle_modifier_curl(param_33, param_34, param_35, param_36, param_37);
        modifier_factor = param_35;
        p = param_36;
    }
    ParticleState param_38 = p.state;
    if (prt_is_alive(param_38))
    {
        ParticleModifierSwirl_Params _1965;
        _1965.position = _1960.VM9_params.position;
        _1965.falloff_curve_idx = _1960.VM9_params.falloff_curve_idx;
        _1965.radius = _1960.VM9_params.radius;
        _1965.falloff_inverse = _1960.VM9_params.falloff_inverse;
        _1965.velocity = _1960.VM9_params.velocity;
        _1965.velocity_randomness = _1960.VM9_params.velocity_randomness;
        _1965.time_step = _1960.VM9_params.time_step;
        _1965.axis_randomness = _1960.VM9_params.axis_randomness;
        _1965.axis = _1960.VM9_params.axis;
        _1965._pad0 = _1960.VM9_params._pad0;
        _1965.scale = _1960.VM9_params.scale;
        _1965._pad1 = _1960.VM9_params._pad1;
        ParticleModifierSwirl_Params param_39 = _1965;
        ParticleLifecycleParams _1969;
        _1969.time_step = _1736.lifecycle_params.time_step;
        _1969.max_lifetime = _1736.lifecycle_params.max_lifetime;
        _1969.reset = _1736.lifecycle_params.reset;
        _1969._pad1 = _1736.lifecycle_params._pad1;
        ParticleLifecycleParams param_40 = _1969;
        ModifierFactor param_41 = modifier_factor;
        Particle param_42 = p;
        uint param_43 = id;
        particle_modifier_swirl(param_39, param_40, param_41, param_42, param_43);
        p = param_42;
    }
    vec3 modifier_position = _1982.VM10_params.position;
    p.pos += ((_1982.VM10_params.velocity * _1736.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_44 = p.state;
    if (prt_is_alive(param_44))
    {
        ParticleModifierColorize_Params _2012;
        _2012.color = _2007.VM11_params.color;
        _2012.mode = _2007.VM11_params.mode;
        _2012.blend_mode = _2007.VM11_params.blend_mode;
        _2012.color_gradient_idx = _2007.VM11_params.color_gradient_idx;
        _2012.randomness = _2007.VM11_params.randomness;
        _2012.blend_from_previous = _2007.VM11_params.blend_from_previous;
        ParticleModifierColorize_Params param_45 = _2012;
        ModifierFactor param_46 = modifier_factor;
        Particle param_47 = p;
        uint param_48 = id;
        particle_modifier_colorize(param_45, param_46, param_47, param_48);
        modifier_factor = param_46;
        p = param_47;
    }
    ModifierFactorMulAdd_Params _2028;
    _2028.multiply_value = _2024.VM12_params.multiply_value;
    _2028.add_value = _2024.VM12_params.add_value;
    ModifierFactorMulAdd_Params param_49 = _2028;
    ModifierFactor param_50 = modifier_factor;
    modifier_factor_mul_add(param_49, param_50);
    modifier_factor = param_50;
    ParticleState param_51 = p.state;
    if (prt_is_alive(param_51))
    {
        ParticleModifierCurl_Params _2045;
        _2045.position = _2041.VM13_params.position;
        _2045.falloff_mode = _2041.VM13_params.falloff_mode;
        _2045.radius = _2041.VM13_params.radius;
        _2045.falloff_inverse = _2041.VM13_params.falloff_inverse;
        _2045.noise_strength = _2041.VM13_params.noise_strength;
        _2045.noise_speed = _2041.VM13_params.noise_speed;
        _2045.noise_scale = _2041.VM13_params.noise_scale;
        ParticleModifierCurl_Params param_52 = _2045;
        ParticleLifecycleParams _2049;
        _2049.time_step = _1736.lifecycle_params.time_step;
        _2049.max_lifetime = _1736.lifecycle_params.max_lifetime;
        _2049.reset = _1736.lifecycle_params.reset;
        _2049._pad1 = _1736.lifecycle_params._pad1;
        ParticleLifecycleParams param_53 = _2049;
        ModifierFactor param_54 = modifier_factor;
        Particle param_55 = p;
        uint param_56 = id;
        particle_modifier_curl(param_52, param_53, param_54, param_55, param_56);
        modifier_factor = param_54;
        p = param_55;
    }
    ParticleState param_57 = p.state;
    float param_58 = _1736.lifecycle_params.time_step;
    float param_59 = _1736.lifecycle_params.max_lifetime;
    prt_advance_life(param_57, param_58, param_59);
    p.state = param_57;
    uint param_60 = id;
    ParticleState param_61 = p.state;
    prt_set_state(param_60, param_61);
    uint param_62 = id;
    vec3 param_63 = p.pos;
    prt_set_position(param_62, param_63);
}

 