#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VertexModifierGerstnerWavesParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    uvec4 wave_directions[16];
    vec4 noise_phase;
    vec3 domain_scale;
    int _pad0;
    vec3 strength;
    int _pad1;
    vec3 position;
    int noise_relative_to_modifier;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
    float wave_length;
    float wave_steepness;
    int wave_octaves;
    float wave_octave_scale;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct _1315
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 10, scalar) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _246;

layout(set = 0, binding = 1, std430) readonly buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) readonly buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) readonly buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) readonly buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 5, std430) readonly buffer VTXCustom0
{
    uint custom0[];
} vtx_custom0;

layout(set = 0, binding = 11, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _941;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _952;

layout(set = 0, binding = 7, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1040;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1232;

layout(set = 0, binding = 12, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1273;

layout(set = 0, binding = 13, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_params;
} _1286;

layout(set = 0, binding = 14, std140) uniform VM1
{
    layout(row_major) VertexModifierGerstnerWavesParams VM1_params;
} _1302;

layout(set = 0, binding = 9, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1410;

layout(set = 0, binding = 15) uniform sampler2D s_Curves;

layout(location = 1) out _1315 vtx_output;
layout(location = 0) out uint instanceID;

vec3 vtx_coords_load(inout uint idx)
{
    idx *= _246.geometry_information.attributes[0].stride;
    idx += _246.geometry_information.attributes[0].offset;
    return vec3(vtx_coords.coords[idx + 0u], vtx_coords.coords[idx + 1u], vtx_coords.coords[idx + 2u]);
}

vec3 vtx_albedo_load(inout uint idx)
{
    idx *= _246.geometry_information.attributes[2].stride;
    idx += _246.geometry_information.attributes[2].offset;
    return vec3(vtx_albedo.albedo[idx + 0u], vtx_albedo.albedo[idx + 1u], vtx_albedo.albedo[idx + 2u]);
}

vec3 vtx_normals_load(inout uint idx)
{
    idx *= _246.geometry_information.attributes[1].stride;
    idx += _246.geometry_information.attributes[1].offset;
    return vec3(vtx_normals.normals[idx + 0u], vtx_normals.normals[idx + 1u], vtx_normals.normals[idx + 2u]);
}

vec2 vtx_uv0_load(inout uint idx)
{
    idx *= _246.geometry_information.attributes[3].stride;
    idx += _246.geometry_information.attributes[3].offset;
    return vec2(vtx_uv0.uv0[idx + 0u], vtx_uv0.uv0[idx + 1u]);
}

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

uint vtx_custom0_load(inout uint idx)
{
    idx *= _246.geometry_information.attributes[6].stride;
    idx += _246.geometry_information.attributes[6].offset;
    return vtx_custom0.custom0[idx + 0u];
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _404 = vector_transform_by_mat43(param, param_1);
        coords = _404;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _415 = vector_transform_by_mat43(param_2, param_3);
            coords = _415;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _425 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _425;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec2 gerstner_evaluate_single(vec2 p, float t, float steepness, float wave_length, vec2 wave_direction)
{
    float k = 6.283185482025146484375 / wave_length;
    float c = sqrt(9.80000019073486328125 / k);
    float f = k * (dot(wave_direction, p) - (c * t));
    float a = steepness / k;
    return vec2(a * cos(f), a * sin(f));
}

void vertex_modifier_gerstner_waves_apply(VertexModifierGerstnerWavesParams params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx.pos;
    vec3 influence_pos = vtx.pos;
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param = noise_pos;
        mat4 param_1 = params.transform_local;
        vec3 _547 = vector_transform_by_mat43(param, param_1);
        noise_pos = _547;
    }
    float influence = modifier_factor.factor;
    if (influence > 0.0)
    {
        vec2 wave = vec2(0.0);
        float wave_length = params.wave_length;
        vec2 wave_direction;
        int wi = 0;
        for (;;)
        {
            if (wi < params.wave_octaves)
            {
                if ((wi & 3) == 0)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].x);
                }
                if ((wi & 3) == 1)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].y);
                }
                if ((wi & 3) == 2)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].z);
                }
                if ((wi & 3) == 3)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].w);
                }
                float steepness_modulated_by_strength = params.wave_steepness / params.strength.x;
                vec2 param_2 = (noise_pos.xz * params.domain_scale.xy) + (params.domain_scale.xy * float(wi));
                float param_3 = params.noise_phase.x;
                float param_4 = steepness_modulated_by_strength;
                float param_5 = wave_length;
                vec2 param_6 = wave_direction;
                wave += gerstner_evaluate_single(param_2, param_3, param_4, param_5, param_6);
                wave_length *= params.wave_octave_scale;
                wi++;
                continue;
            }
            else
            {
                break;
            }
        }
        wave += vec2(params.noise_value_base);
        vec3 local_norm = vtx.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_7 = modifier_position;
            mat4 param_8 = params.transform_local;
            vec3 _673 = vector_transform_by_mat43(param_7, param_8);
            local_norm = normalize(base_pos - _673);
        }
        vec3 new_pos = base_pos;
        new_pos.x += (wave.x * params.strength.x);
        new_pos.y += (wave.y * params.strength.y);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        vtx.pos = new_pos;
    }
    if (false)
    {
        vtx.color.x = 0.0;
        vtx.color.y = 0.0;
        vtx.color.z = 0.0;
        vtx.color.x = max(0.0, influence);
    }
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    uint load_vertex_idx = uint(gl_VertexIndex);
    if (_941.instance_params.stride > 0)
    {
        uint flipbook_card = _952.instance_flipbook_card[gl_InstanceIndex];
        flipbook_card = min(flipbook_card, (_246.geometry_information.flipbook_cards_num - 1u));
        load_vertex_idx += (_246.geometry_information.vtx_num * flipbook_card);
    }
    VertexInput vtx_input;
    vtx_input.id = uint(gl_VertexIndex);
    uint param = load_vertex_idx;
    vec3 _974 = vtx_coords_load(param);
    vtx_input.pos = _974;
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_246.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vec3 _992 = vtx_albedo_load(param_1);
        vtx_input.color.x = _992.x;
        vtx_input.color.y = _992.y;
        vtx_input.color.z = _992.z;
    }
    if ((_246.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = load_vertex_idx;
        vec3 _1007 = vtx_normals_load(param_2);
        vtx_input.norm = _1007;
    }
    if ((_246.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vec2 _1018 = vtx_uv0_load(param_3);
        vtx_input.uv0 = _1018;
    }
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 mat_instance_model_inv = mat_instance_model;
    if (_941.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1040.instance_transform[(gl_InstanceIndex * _941.instance_params.stride) + 0];
        vec4 inst_m1 = _1040.instance_transform[(gl_InstanceIndex * _941.instance_params.stride) + 1];
        vec4 inst_m2 = _1040.instance_transform[(gl_InstanceIndex * _941.instance_params.stride) + 2];
        vec3 _1071 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1071.x;
        mat_instance_model[0].y = _1071.y;
        mat_instance_model[0].z = _1071.z;
        vec3 _1084 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1084.x;
        mat_instance_model[1].y = _1084.y;
        mat_instance_model[1].z = _1084.z;
        vec3 _1097 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1097.x;
        mat_instance_model[2].y = _1097.y;
        mat_instance_model[2].z = _1097.z;
        vec3 _1110 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1110.x;
        mat_instance_model[3].y = _1110.y;
        mat_instance_model[3].z = _1110.z;
        mat_instance_model_inv = mat_instance_model;
        mat3 param_4 = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
        mat3 inv = inverse_mat3(param_4);
        mat_instance_model_inv[0].x = inv[0].x;
        mat_instance_model_inv[0].y = inv[0].y;
        mat_instance_model_inv[0].z = inv[0].z;
        mat_instance_model_inv[1].x = inv[1].x;
        mat_instance_model_inv[1].y = inv[1].y;
        mat_instance_model_inv[1].z = inv[1].z;
        mat_instance_model_inv[2].x = inv[2].x;
        mat_instance_model_inv[2].y = inv[2].y;
        mat_instance_model_inv[2].z = inv[2].z;
        mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
        mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
        mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_VertexIndex);
    modifier_factor.id = uint(gl_VertexIndex);
    modifier_factor.instance_id = uint(gl_InstanceIndex);
    if (_941.instance_params.stride > 0)
    {
        modifier_factor.instance_id = _1232.instance_hash[gl_InstanceIndex];
    }
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    if ((_246.geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param_5 = uint(gl_VertexIndex);
        uint _1255 = vtx_custom0_load(param_5);
        modifier_factor.custom0 = _1255;
    }
    if ((_246.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_6 = uint(gl_VertexIndex);
        vec2 _1266 = vtx_uv0_load(param_6);
        modifier_factor.uv0 = _1266;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1273.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1273.transform_params.mModelInv;
    ModifierFactorDistanceRadial_Params _1291;
    _1291.transform_local_to_gizmo = _1286.VM0_params.transform_local_to_gizmo;
    _1291.falloff_curve_idx = _1286.VM0_params.falloff_curve_idx;
    _1291.falloff_inverse = _1286.VM0_params.falloff_inverse;
    _1291.domain_repeat_x = _1286.VM0_params.domain_repeat_x;
    _1291.domain_repeat_y = _1286.VM0_params.domain_repeat_y;
    _1291.domain_repeat_z = _1286.VM0_params.domain_repeat_z;
    _1291.influence_scope = _1286.VM0_params.influence_scope;
    _1291.modifier_function = _1286.VM0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_7 = _1291;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_distance_radial(param_7, param_8, param_9);
    modifier_factor = param_8;
    VertexModifierGerstnerWavesParams _1307;
    _1307.transform_world_to_local = _1302.VM1_params.transform_world_to_local;
    _1307.transform_local_to_world = _1302.VM1_params.transform_local_to_world;
    _1307.transform_local = _1302.VM1_params.transform_local;
    _1307.transform_local_inv = _1302.VM1_params.transform_local_inv;
    _1307.transform_parent = _1302.VM1_params.transform_parent;
    _1307.transform_parent_inv = _1302.VM1_params.transform_parent_inv;
    _1307.wave_directions[0] = _1302.VM1_params.wave_directions[0];
    _1307.wave_directions[1] = _1302.VM1_params.wave_directions[1];
    _1307.wave_directions[2] = _1302.VM1_params.wave_directions[2];
    _1307.wave_directions[3] = _1302.VM1_params.wave_directions[3];
    _1307.wave_directions[4] = _1302.VM1_params.wave_directions[4];
    _1307.wave_directions[5] = _1302.VM1_params.wave_directions[5];
    _1307.wave_directions[6] = _1302.VM1_params.wave_directions[6];
    _1307.wave_directions[7] = _1302.VM1_params.wave_directions[7];
    _1307.wave_directions[8] = _1302.VM1_params.wave_directions[8];
    _1307.wave_directions[9] = _1302.VM1_params.wave_directions[9];
    _1307.wave_directions[10] = _1302.VM1_params.wave_directions[10];
    _1307.wave_directions[11] = _1302.VM1_params.wave_directions[11];
    _1307.wave_directions[12] = _1302.VM1_params.wave_directions[12];
    _1307.wave_directions[13] = _1302.VM1_params.wave_directions[13];
    _1307.wave_directions[14] = _1302.VM1_params.wave_directions[14];
    _1307.wave_directions[15] = _1302.VM1_params.wave_directions[15];
    _1307.noise_phase = _1302.VM1_params.noise_phase;
    _1307.domain_scale = _1302.VM1_params.domain_scale;
    _1307._pad0 = _1302.VM1_params._pad0;
    _1307.strength = _1302.VM1_params.strength;
    _1307._pad1 = _1302.VM1_params._pad1;
    _1307.position = _1302.VM1_params.position;
    _1307.noise_relative_to_modifier = _1302.VM1_params.noise_relative_to_modifier;
    _1307.displacement_mode = _1302.VM1_params.displacement_mode;
    _1307.noise_value_base = _1302.VM1_params.noise_value_base;
    _1307.noise_value_absolute = _1302.VM1_params.noise_value_absolute;
    _1307.wave_length = _1302.VM1_params.wave_length;
    _1307.wave_steepness = _1302.VM1_params.wave_steepness;
    _1307.wave_octaves = _1302.VM1_params.wave_octaves;
    _1307.wave_octave_scale = _1302.VM1_params.wave_octave_scale;
    VertexModifierGerstnerWavesParams param_10 = _1307;
    ModifierFactor param_11 = modifier_factor;
    VertexInput param_12 = vtx_input;
    vertex_modifier_gerstner_waves_apply(param_10, param_11, param_12);
    modifier_factor = param_11;
    vtx_input = param_12;
    vtx_output.vLocalPos = vtx_input.pos;
    instanceID = uint(gl_InstanceIndex);
    if (_941.instance_params.stride > 0)
    {
        vec4 inst_m0_1 = _1040.instance_transform[(gl_InstanceIndex * _941.instance_params.stride) + 0];
        vec4 inst_m1_1 = _1040.instance_transform[(gl_InstanceIndex * _941.instance_params.stride) + 1];
        vec4 inst_m2_1 = _1040.instance_transform[(gl_InstanceIndex * _941.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_13 = vtx_input.norm;
        mat4 param_14 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_13, param_14));
        vec2 _1416 = unpackHalf2x16(_1410.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1416.x;
        inst_c.y = _1416.y;
        vec2 _1426 = unpackHalf2x16(_1410.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1426.x;
        inst_c.w = _1426.y;
        vec4 _1432 = vtx_input.color;
        vec3 _1436 = _1432.xyz * inst_c.xyz;
        vtx_input.color.x = _1436.x;
        vtx_input.color.y = _1436.y;
        vtx_input.color.z = _1436.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_15 = vtx_input.pos;
    mat4 param_16 = _1273.transform_params.mModel;
    vec3 _1456 = vector_transform_by_mat43(param_15, param_16);
    vec3 vPosModel = _1456;
    vec3 param_17 = vtx_input.norm;
    mat4 param_18 = _1273.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vector_transform_by_mat33(param_17, param_18);
    vec3 param_19 = vPosModel;
    mat4 param_20 = _1273.transform_params.mView;
    vec3 _1471 = vector_transform_by_mat43(param_19, param_20);
    vec3 vPosModelView = _1471;
    vtx_output.vCoords = vPosModelView;
    vtx_output.vCameraRelativeWorldPos = vPosModel - _1273.transform_params.vCameraPosition;
    vtx_output.vNorm.x = dot(_1273.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_1273.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_1273.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vtx_input.norm;
    vtx_output.vColor = vtx_input.color;
    vtx_output.vUV0 = vtx_input.uv0;
    vec3 param_21 = vtx_output.vCoords;
    mat4 param_22 = _1273.transform_params.mProjection;
    vec4 _1524 = vector_transform_by_mat_projection(param_21, param_22);
    gl_Position = _1524;
}

 