#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct PostprocessParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
    vec2 _pad0;
    float param1;
    float param2;
    float _pad1;
    float _pad2;
    int txt1_flip_y;
    int txt2_flip_y;
    int txt3_flip_y;
    int _pad3;
};

layout(set = 1, binding = 1, std140) uniform PostprocessParamsBuffer
{
    PostprocessParams params;
} _32;

layout(set = 1, binding = 2) uniform sampler2D s_texture0;
layout(set = 1, binding = 3) uniform sampler2D sImage1;

layout(location = 0) out vec4 outColor;
layout(location = 0) in vec2 vTexcoord0;

void main()
{
    outColor = texture(s_texture0, vTexcoord0);
    vec2 vTexcoord1 = vTexcoord0;
    vec2 vTexcoord2 = vTexcoord0;
    vec2 vTexcoord3 = vTexcoord0;
    if (_32.params.txt1_flip_y != 0)
    {
        vTexcoord1.y = 1.0 - vTexcoord1.y;
    }
    if (_32.params.txt2_flip_y != 0)
    {
        vTexcoord2.y = 1.0 - vTexcoord2.y;
    }
    if (_32.params.txt3_flip_y != 0)
    {
        vTexcoord3.y = 1.0 - vTexcoord3.y;
    }
    if (vTexcoord0.y > 0.699999988079071044921875)
    {
        outColor += (texture(sImage1, vTexcoord0 + vec2(0.0, 0.0500000007450580596923828125)) * _32.params.param1);
    }
}

 