#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterInstances_Params
{
    vec4 particle_color;
    vec3 primitive_size;
    float particle_lifetime;
    vec3 position_randomness;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
    int random_source_instance;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceParamsVM0
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _327;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _351;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _374;

layout(set = 0, binding = 7, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _928;

layout(set = 0, binding = 8, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1124;

layout(set = 0, binding = 4, std430) buffer VM0
{
    ParticleEmitterInstances_Params VM0_params;
} _1170;

layout(set = 0, binding = 9, std140) uniform InstanceParamsBufferVM0
{
    InstanceParamsVM0 instance_params_VM0;
} _1220;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBufferVM0
{
    vec4 instance_transform_VM0[];
} _1233;

layout(set = 0, binding = 10, std140) uniform VM1
{
    ParticleModifierCurl_Params VM1_params;
} _1321;

layout(set = 0, binding = 11, std140) uniform VM2
{
    ParticleModifierCurl_Params VM2_params;
} _1349;

layout(set = 0, binding = 6, std430) buffer VM3
{
    ParticleModifierAttractor_Params VM3_params;
} _1376;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_374.prt_prev_positions[(id * 3u) + 0u], _374.prt_prev_positions[(id * 3u) + 1u], _374.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _333;
    _333.life_time = _327.prt_states[id].life_time;
    _333.life_span = _327.prt_states[id].life_span;
    _333.generation_id = _327.prt_states[id].generation_id;
    _333.color = _327.prt_states[id].color;
    ParticleState _332 = _333;
    return _332;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _307 = hash(param);
    uint param_1 = _307;
    float _309 = floatConstruct(param_1);
    return _309;
}

float particle_emitter_instances_rand(float n)
{
    float param = n;
    return random(param);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _396 = color_convert_rgb_float3_uint(param);
    uint v = _396;
    state.color = v;
}

void particle_emitter_instances_emit(ParticleEmitterInstances_Params emitter_params, vec4 instance_transform0, vec4 instance_transform1, vec4 instance_transform2, inout Particle p, uint id)
{
    float fid = float(id);
    float param = (_928.globals.time + (fid * 5.131999969482421875)) + emitter_params.seed;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_instances_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    vec3 pos = vec3(instance_transform0.w, instance_transform1.w, instance_transform2.w);
    float param_3 = fid + (emitter_params.seed * 0.1271300017833709716796875);
    pos.x += (emitter_params.position_randomness.x * (particle_emitter_instances_rand(param_3) - 0.5));
    float param_4 = fid - (emitter_params.seed * 1.2127130031585693359375);
    pos.y += (emitter_params.position_randomness.y * (particle_emitter_instances_rand(param_4) - 0.5));
    float param_5 = fid + (emitter_params.seed * 2.3127129077911376953125);
    pos.z += (emitter_params.position_randomness.z * (particle_emitter_instances_rand(param_5) - 0.5));
    p.pos = pos;
    ParticleState param_6 = p.state;
    vec3 param_7 = emitter_params.particle_color.xyz;
    prt_set_color(param_6, param_7);
    p.state = param_6;
}

vec4 saturate(vec4 a)
{
    return max(min(a, vec4(1.0)), vec4(0.0));
}

uvec2 btn_pcg4d16(uvec4 p)
{
    uvec4 v = (p * uvec4(1664525u)) + uvec4(1013904223u);
    v.x += (v.y * v.w);
    v.y += (v.z * v.x);
    v.z += (v.x * v.y);
    v.w += (v.y * v.z);
    v.x += (v.y * v.w);
    v.y += (v.z * v.x);
    return v.xy;
}

vec4 btn_gradient4d(uint hash_1)
{
    vec4 g = vec4(uvec4(hash_1) & uvec4(524288u, 262144u, 131072u, 65536u));
    return (g * vec4(3.814697265625e-06, 7.62939453125e-06, 1.52587890625e-05, 3.0517578125e-05)) - vec4(1.0);
}

vec3 saturate(vec3 a)
{
    return max(vec3(0.0), min(vec3(1.0), a));
}

vec2 saturate(vec2 a)
{
    return max(vec2(0.0), min(vec2(1.0), a));
}

vec3 BitangentNoise4D(vec4 p)
{
    vec4 i = floor(p + vec4(dot(p, vec4(0.309017002582550048828125))));
    vec4 x0 = (p - i) + vec4(dot(i, vec4(0.13819660246372222900390625)));
    vec3 isX = step(x0.yzw, x0.xxx);
    vec3 isYZ = step(x0.zww, x0.yyz);
    vec4 i0;
    i0.x = (isX.x + isX.y) + isX.z;
    vec3 _540 = vec3(1.0) - isX;
    i0.y = _540.x;
    i0.z = _540.y;
    i0.w = _540.z;
    i0.y += (isYZ.x + isYZ.y);
    vec4 _560 = i0;
    vec2 _562 = _560.zw + (vec2(1.0) - isYZ.xy);
    i0.z = _562.x;
    i0.w = _562.y;
    i0.z += isYZ.z;
    i0.w += (1.0 - isYZ.z);
    vec4 param = i0;
    vec4 i3 = saturate(param);
    vec4 param_1 = i0 - vec4(1.0);
    vec4 i2 = saturate(param_1);
    vec4 param_2 = i0 - vec4(2.0);
    vec4 i1 = saturate(param_2);
    vec4 x1 = (x0 - i1) + vec4(0.13819660246372222900390625);
    vec4 x2 = (x0 - i2) + vec4(0.2763932049274444580078125);
    vec4 x3 = (x0 - i3) + vec4(0.4145897924900054931640625);
    vec4 x4 = x0 + vec4(-0.447213590145111083984375);
    i += vec4(32768.5);
    uvec4 param_3 = uvec4(i);
    uvec2 hash0 = btn_pcg4d16(param_3);
    uvec4 param_4 = uvec4(i + i1);
    uvec2 hash1 = btn_pcg4d16(param_4);
    uvec4 param_5 = uvec4(i + i2);
    uvec2 hash2 = btn_pcg4d16(param_5);
    uvec4 param_6 = uvec4(i + i3);
    uvec2 hash3 = btn_pcg4d16(param_6);
    uvec4 param_7 = uvec4(i + vec4(1.0));
    uvec2 hash4 = btn_pcg4d16(param_7);
    uint param_8 = hash0.x;
    vec4 p00 = btn_gradient4d(param_8);
    uint param_9 = hash0.y;
    vec4 p01 = btn_gradient4d(param_9);
    uint param_10 = hash1.x;
    vec4 p10 = btn_gradient4d(param_10);
    uint param_11 = hash1.y;
    vec4 p11 = btn_gradient4d(param_11);
    uint param_12 = hash2.x;
    vec4 p20 = btn_gradient4d(param_12);
    uint param_13 = hash2.y;
    vec4 p21 = btn_gradient4d(param_13);
    uint param_14 = hash3.x;
    vec4 p30 = btn_gradient4d(param_14);
    uint param_15 = hash3.y;
    vec4 p31 = btn_gradient4d(param_15);
    uint param_16 = hash4.x;
    vec4 p40 = btn_gradient4d(param_16);
    uint param_17 = hash4.y;
    vec4 p41 = btn_gradient4d(param_17);
    vec3 param_18 = vec3(0.60000002384185791015625) - vec3(dot(x0, x0), dot(x1, x1), dot(x2, x2));
    vec3 m0 = saturate(param_18);
    vec2 param_19 = vec2(0.60000002384185791015625) - vec2(dot(x3, x3), dot(x4, x4));
    vec2 m1 = saturate(param_19);
    vec3 m02 = m0 * m0;
    vec3 m03 = m02 * m0;
    vec2 m12 = m1 * m1;
    vec2 m13 = m12 * m1;
    vec3 temp0 = m02 * vec3(dot(p00, x0), dot(p10, x1), dot(p20, x2));
    vec2 temp1 = m12 * vec2(dot(p30, x3), dot(p40, x4));
    vec4 grad0 = (((((x0 * temp0.x) + (x1 * temp0.y)) + (x2 * temp0.z)) + (x3 * temp1.x)) + (x4 * temp1.y)) * (-6.0);
    grad0 += (((((p00 * m03.x) + (p10 * m03.y)) + (p20 * m03.z)) + (p30 * m13.x)) + (p40 * m13.y));
    temp0 = m02 * vec3(dot(p01, x0), dot(p11, x1), dot(p21, x2));
    temp1 = m12 * vec2(dot(p31, x3), dot(p41, x4));
    vec4 grad1 = (((((x0 * temp0.x) + (x1 * temp0.y)) + (x2 * temp0.z)) + (x3 * temp1.x)) + (x4 * temp1.y)) * (-6.0);
    grad1 += (((((p01 * m03.x) + (p11 * m03.y)) + (p21 * m03.z)) + (p31 * m13.x)) + (p41 * m13.y));
    return cross(grad0.xyz, grad1.xyz) * 81.0;
}

void particle_modifier_curl_fast(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec4 param = vec4(p.pos * modifier_params.noise_scale, _928.globals.time * modifier_params.noise_speed);
    vec3 n = BitangentNoise4D(param);
    n = normalize(n);
    p.pos += (((n * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _340;
    _340.life_time = state.life_time;
    _340.life_span = state.life_span;
    _340.generation_id = state.generation_id;
    _340.color = state.color;
    _327.prt_states[id] = _340;
}

void prt_set_position(uint id, vec3 p)
{
    _351.prt_positions[(id * 3u) + 0u] = p.x;
    _351.prt_positions[(id * 3u) + 1u] = p.y;
    _351.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_1124.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    bool _1164 = !prt_is_alive(param_3);
    bool _1175;
    if (_1164)
    {
        _1175 = _1170.VM0_params.pending > 0;
    }
    else
    {
        _1175 = _1164;
    }
    if (_1175)
    {
        int final_emit_idx = -1;
        if (_1170.VM0_params.random_source_instance != 0)
        {
            int pi = 0;
            for (;;)
            {
                if (pi < 8)
                {
                    float param_4 = float(id) * 1.61803400516510009765625;
                    float fid = random(param_4);
                    uint instance_id = uint(fid * 10000000.0);
                    instance_id = (instance_id + uint(_1170.VM0_params.seed)) + uint(pi * 7919);
                    instance_id %= uint(_1220.instance_params_VM0.instance_count);
                    uint transform_idx = instance_id * 3u;
                    vec4 instance_transform0 = _1233.instance_transform_VM0[transform_idx + 0u];
                    float s = dot(instance_transform0.xyz, instance_transform0.xyz);
                    if (s > 9.9999997473787516355514526367188e-06)
                    {
                        final_emit_idx = int(instance_id);
                        break;
                    }
                    pi++;
                    continue;
                }
                else
                {
                    break;
                }
            }
        }
        else
        {
            if (id < uint(_1220.instance_params_VM0.instance_count))
            {
                final_emit_idx = int(id);
            }
        }
        if (final_emit_idx != (-1))
        {
            int _1271 = atomicAdd(_1170.VM0_params.pending, -1);
            int pending = _1271;
            if (pending > 0)
            {
                uint transform_idx_1 = uint(final_emit_idx) * 3u;
                vec4 instance_transform0_1 = _1233.instance_transform_VM0[transform_idx_1 + 0u];
                vec4 instance_transform1 = _1233.instance_transform_VM0[transform_idx_1 + 1u];
                vec4 instance_transform2 = _1233.instance_transform_VM0[transform_idx_1 + 2u];
                ParticleEmitterInstances_Params _1299;
                _1299.particle_color = _1170.VM0_params.particle_color;
                _1299.primitive_size = _1170.VM0_params.primitive_size;
                _1299.particle_lifetime = _1170.VM0_params.particle_lifetime;
                _1299.position_randomness = _1170.VM0_params.position_randomness;
                _1299.particle_lifetime_randomness = _1170.VM0_params.particle_lifetime_randomness;
                _1299.rate = _1170.VM0_params.rate;
                _1299.seed = _1170.VM0_params.seed;
                _1299.pending = _1170.VM0_params.pending;
                _1299.random_source_instance = _1170.VM0_params.random_source_instance;
                ParticleEmitterInstances_Params param_5 = _1299;
                vec4 param_6 = instance_transform0_1;
                vec4 param_7 = instance_transform1;
                vec4 param_8 = instance_transform2;
                Particle param_9 = p;
                uint param_10 = id;
                particle_emitter_instances_emit(param_5, param_6, param_7, param_8, param_9, param_10);
                p = param_9;
            }
        }
    }
    ParticleState param_11 = p.state;
    if (prt_is_alive(param_11))
    {
        ParticleModifierCurl_Params _1326;
        _1326.position = _1321.VM1_params.position;
        _1326.falloff_mode = _1321.VM1_params.falloff_mode;
        _1326.radius = _1321.VM1_params.radius;
        _1326.falloff_inverse = _1321.VM1_params.falloff_inverse;
        _1326.noise_strength = _1321.VM1_params.noise_strength;
        _1326.noise_speed = _1321.VM1_params.noise_speed;
        _1326.noise_scale = _1321.VM1_params.noise_scale;
        ParticleModifierCurl_Params param_12 = _1326;
        ParticleLifecycleParams _1331;
        _1331.time_step = _1124.lifecycle_params.time_step;
        _1331.max_lifetime = _1124.lifecycle_params.max_lifetime;
        _1331.reset = _1124.lifecycle_params.reset;
        _1331._pad1 = _1124.lifecycle_params._pad1;
        ParticleLifecycleParams param_13 = _1331;
        ModifierFactor param_14 = modifier_factor;
        Particle param_15 = p;
        uint param_16 = id;
        particle_modifier_curl_fast(param_12, param_13, param_14, param_15, param_16);
        modifier_factor = param_14;
        p = param_15;
    }
    ParticleState param_17 = p.state;
    if (prt_is_alive(param_17))
    {
        ParticleModifierCurl_Params _1353;
        _1353.position = _1349.VM2_params.position;
        _1353.falloff_mode = _1349.VM2_params.falloff_mode;
        _1353.radius = _1349.VM2_params.radius;
        _1353.falloff_inverse = _1349.VM2_params.falloff_inverse;
        _1353.noise_strength = _1349.VM2_params.noise_strength;
        _1353.noise_speed = _1349.VM2_params.noise_speed;
        _1353.noise_scale = _1349.VM2_params.noise_scale;
        ParticleModifierCurl_Params param_18 = _1353;
        ParticleLifecycleParams _1357;
        _1357.time_step = _1124.lifecycle_params.time_step;
        _1357.max_lifetime = _1124.lifecycle_params.max_lifetime;
        _1357.reset = _1124.lifecycle_params.reset;
        _1357._pad1 = _1124.lifecycle_params._pad1;
        ParticleLifecycleParams param_19 = _1357;
        ModifierFactor param_20 = modifier_factor;
        Particle param_21 = p;
        uint param_22 = id;
        particle_modifier_curl_fast(param_18, param_19, param_20, param_21, param_22);
        modifier_factor = param_20;
        p = param_21;
    }
    ParticleState param_23 = p.state;
    if (prt_is_alive(param_23))
    {
        ParticleModifierAttractor_Params _1381;
        _1381.position = _1376.VM3_params.position;
        _1381.radius = _1376.VM3_params.radius;
        _1381.velocity = _1376.VM3_params.velocity;
        ParticleModifierAttractor_Params param_24 = _1381;
        ModifierFactor param_25 = modifier_factor;
        ParticleLifecycleParams _1387;
        _1387.time_step = _1124.lifecycle_params.time_step;
        _1387.max_lifetime = _1124.lifecycle_params.max_lifetime;
        _1387.reset = _1124.lifecycle_params.reset;
        _1387._pad1 = _1124.lifecycle_params._pad1;
        ParticleLifecycleParams param_26 = _1387;
        Particle param_27 = p;
        uint param_28 = id;
        particle_modifier_attractor(param_24, param_25, param_26, param_27, param_28);
        p = param_27;
    }
    ParticleState param_29 = p.state;
    float param_30 = _1124.lifecycle_params.time_step;
    float param_31 = _1124.lifecycle_params.max_lifetime;
    prt_advance_life(param_29, param_30, param_31);
    p.state = param_29;
    uint param_32 = id;
    ParticleState param_33 = p.state;
    prt_set_state(param_32, param_33);
    uint param_34 = id;
    vec3 param_35 = p.pos;
    prt_set_position(param_34, param_35);
}

 