#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct PostDisplaceParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec2 offset;
    vec2 radial;
    float color_separation;
    uint included_tags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 1, std140) uniform PostDisplaceParamsBuffer
{
    PostDisplaceParams displace_params;
} _194;

layout(set = 1, binding = 2, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _259;

layout(set = 1, binding = 3) uniform sampler2D s_texture0;
layout(set = 1, binding = 4) uniform sampler2D sImageDisplacement;
layout(set = 1, binding = 5) uniform sampler2D sImageMask;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

float luma(vec3 v)
{
    return ((v.x * 0.699999988079071044921875) + (v.y * 0.20000000298023223876953125)) + (v.z * 0.100000001490116119384765625);
}

vec2 radialdistort(vec2 coord, vec2 amt)
{
    vec2 cc = coord - vec2(0.5);
    return coord + ((cc * 2.0) * amt);
}

vec2 distort(vec2 uv, float t, vec2 min_distort, vec2 max_distort)
{
    vec2 dist = mix(min_distort, max_distort, vec2(t));
    vec2 param = uv;
    vec2 param_1 = dist * 2.0;
    return radialdistort(param, param_1);
}

vec2 remap(vec2 t, vec2 a, vec2 b)
{
    return clamp((t - a) / (b - a), vec2(0.0), vec2(1.0));
}

float nrand(vec2 n)
{
    return fract(sin(dot(n, vec2(12.98980045318603515625, 78.233001708984375))) * 43758.546875);
}

vec3 spectrum_offset_rgb(float t)
{
    float t0 = (3.0 * t) - 1.5;
    vec3 ret = clamp(vec3(-t0, 1.0 - abs(t0), t0), vec3(0.0), vec3(1.0));
    return ret;
}

vec3 spectrum_offset(float t)
{
    float param = t;
    return spectrum_offset_rgb(param);
}

vec3 render(vec2 uv)
{
    return texture(s_texture0, uv).xyz;
}

void main()
{
    vec4 base_color = texture(s_texture0, vTexcoord0);
    vec4 displacement_color = texture(sImageDisplacement, vTexcoord0);
    float mask_color = texture(sImageMask, vTexcoord0).x;
    if (mask_color == 0.0)
    {
        outColor = base_color;
        return;
    }
    vec2 uv = gl_FragCoord.xy / _194.displace_params.resolution;
    vec3 param = displacement_color.xyz;
    float max_distort_px = 50.0 * luma(param);
    vec2 max_distort = (vec2(max_distort_px) * max(_194.displace_params.radial, _194.displace_params.offset)) * _194.displace_params.inv_resolution;
    vec2 min_distort = max_distort * 0.100000001490116119384765625;
    vec2 param_1 = vec2(1.0);
    float param_2 = 1.0;
    vec2 param_3 = min_distort;
    vec2 param_4 = max_distort;
    vec2 oversiz = distort(param_1, param_2, param_3, param_4);
    vec2 param_5 = uv;
    vec2 param_6 = vec2(1.0) - oversiz;
    vec2 param_7 = oversiz;
    uv = remap(param_5, param_6, param_7);
    uv += (((_194.displace_params.offset * displacement_color.xy) * 50.0) * _194.displace_params.inv_resolution);
    vec2 param_8 = uv + vec2(fract(_259.globals.time));
    float rnd = nrand(param_8);
    float t = 0.0;
    vec3 sumcol = vec3(0.0);
    vec3 sumw = vec3(0.0);
    int i = 0;
    for (;;)
    {
        if (i < 1)
        {
            float param_9 = t;
            vec3 w = mix(spectrum_offset(param_9), vec3(1.0), vec3(1.0 - _194.displace_params.color_separation));
            sumw += w;
            vec2 param_10 = uv;
            float param_11 = t;
            vec2 param_12 = min_distort;
            vec2 param_13 = max_distort;
            vec2 uvd = distort(param_10, param_11, param_12, param_13);
            vec2 param_14 = uvd;
            sumcol += (w * render(param_14));
            t += uintBitsToFloat(0x7f800000u /* inf */);
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    sumcol /= sumw;
    vec3 outcol = sumcol;
    outColor = vec4(outcol, 1.0);
}

 