#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct PostAberrationParams
{
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
    vec2 _pad0;
    float strength;
    float spread;
    uint includedTags;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 1, std140) uniform PostAberrationParamsBuffer
{
    PostAberrationParams aberration_params;
} _174;

layout(set = 1, binding = 2, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _219;

layout(set = 1, binding = 3) uniform sampler2D s_texture0;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

vec2 radialdistort(vec2 coord, vec2 amt)
{
    vec2 cc = coord - vec2(0.5);
    return coord + ((cc * 2.0) * amt);
}

vec2 distort(vec2 uv, float t, vec2 min_distort, vec2 max_distort)
{
    vec2 dist = mix(min_distort, max_distort, vec2(t));
    vec2 param = uv;
    vec2 param_1 = dist * 2.0;
    return radialdistort(param, param_1);
}

vec2 remap(vec2 t, vec2 a, vec2 b)
{
    return clamp((t - a) / (b - a), vec2(0.0), vec2(1.0));
}

float nrand(vec2 n)
{
    return fract(sin(dot(n, vec2(12.98980045318603515625, 78.233001708984375))) * 43758.546875);
}

vec3 spectrum_offset_rgb(float t)
{
    float t0 = (3.0 * t) - 1.5;
    vec3 ret = clamp(vec3(-t0, 1.0 - abs(t0), t0), vec3(0.0), vec3(1.0));
    return ret;
}

vec3 spectrum_offset(float t)
{
    float param = t;
    return spectrum_offset_rgb(param);
}

vec3 srgb2lin(vec3 c)
{
    return pow(c, vec3(0.4545454680919647216796875));
}

vec3 render(vec2 uv)
{
    vec3 param = texture(s_texture0, uv).xyz;
    return srgb2lin(param);
}

vec3 lin2srgb(vec3 c)
{
    return pow(c, vec3(2.2000000476837158203125));
}

void main()
{
    vec2 tex_coord0 = vTexcoord0;
    vec4 base_color = texture(s_texture0, tex_coord0);
    vec2 uv = gl_FragCoord.xy / _174.aberration_params.resolution;
    float max_distort_px = 50.0 * _174.aberration_params.strength;
    vec2 max_distort = vec2(max_distort_px) / _174.aberration_params.resolution;
    vec2 min_distort = max_distort * 0.5;
    vec2 param = vec2(1.0);
    float param_1 = 1.0;
    vec2 param_2 = min_distort;
    vec2 param_3 = max_distort;
    vec2 oversiz = distort(param, param_1, param_2, param_3);
    vec2 param_4 = uv;
    vec2 param_5 = vec2(1.0) - oversiz;
    vec2 param_6 = oversiz;
    uv = remap(param_4, param_5, param_6);
    vec2 param_7 = uv + vec2(fract(_219.globals.time));
    float rnd = nrand(param_7);
    float t = rnd * 0.076923079788684844970703125;
    vec3 sumcol = vec3(0.0);
    vec3 sumw = vec3(0.0);
    int i = 0;
    for (;;)
    {
        if (i < 14)
        {
            float param_8 = t;
            vec3 w = mix(spectrum_offset(param_8), vec3(1.0), vec3(clamp(1.0 - _174.aberration_params.spread, 0.0, 1.0)));
            sumw += w;
            vec2 param_9 = uv;
            float param_10 = t;
            vec2 param_11 = min_distort;
            vec2 param_12 = max_distort;
            vec2 uvd = distort(param_9, param_10, param_11, param_12);
            vec2 param_13 = uvd;
            sumcol += (w * render(param_13));
            t += 0.076923079788684844970703125;
            i++;
            continue;
        }
        else
        {
            break;
        }
    }
    sumcol /= sumw;
    vec3 outcol = sumcol;
    vec3 param_14 = outcol;
    outcol = lin2srgb(param_14);
    outColor = vec4(max(vec3(0.0), outcol), 1.0);
}

 