#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierAlongPath_Params
{
    float velocity;
    float attraction;
    float keyframes_per_second;
    int keyframes;
    uint64_t transforms;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct ModifierFactorWrap_Params
{
    float min_value;
    float max_value;
};

struct ParticleModifierColorize_Params
{
    vec4 color;
    int mode;
    int blend_mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(buffer_reference) buffer PointerToVec4;
layout(buffer_reference, buffer_reference_align = 4, std430) buffer PointerToVec4
{
    vec4 v;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _480;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _504;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _527;

layout(set = 0, binding = 7, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1899;

layout(set = 0, binding = 8, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _2182;

layout(set = 0, binding = 4, std430) buffer VM0
{
    layout(row_major) ParticleEmitterPrimitive_Params VM0_params;
} _2226;

layout(set = 0, binding = 9, std140) uniform VM1
{
    ParticleModifierAlongPath_Params VM1_params;
} _2259;

layout(set = 0, binding = 10, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _2280;

layout(set = 0, binding = 11, std140) uniform VM3
{
    ParticleModifierCurl_Params VM3_params;
} _2301;

layout(set = 0, binding = 5, std430) buffer VM4
{
    ParticleModifierAttractor_Params VM4_params;
} _2329;

layout(set = 0, binding = 6, std430) buffer VM5
{
    ModifierFactorWrap_Params VM5_params;
} _2350;

layout(set = 0, binding = 12, std140) uniform VM6
{
    ParticleModifierColorize_Params VM6_params;
} _2369;

layout(set = 0, binding = 13) uniform sampler2D s_Gradients;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_527.prt_prev_positions[(id * 3u) + 0u], _527.prt_prev_positions[(id * 3u) + 1u], _527.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _486;
    _486.life_time = _480.prt_states[id].life_time;
    _486.life_span = _480.prt_states[id].life_span;
    _486.generation_id = _480.prt_states[id].generation_id;
    _486.color = _480.prt_states[id].color;
    ParticleState _485 = _486;
    return _485;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _563 = color_convert_rgb_float3_uint(param);
    uint v = _563;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    vec3 _1017 = vector_transform_by_mat43(param_6, param_7);
    pos = _1017;
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

vec4 _mat3ToQuaternion(mat3 r)
{
    float trace = (r[0].x + r[1].y) + r[2].z;
    vec4 q;
    if (trace > 0.0)
    {
        float s = sqrt(trace + 1.0) * 2.0;
        q.w = 0.25 * s;
        q.x = (r[2].y - r[1].z) / s;
        q.y = (r[0].z - r[2].x) / s;
        q.z = (r[1].x - r[0].y) / s;
    }
    else
    {
        bool _1083 = r[0].x > r[1].y;
        bool _1091;
        if (_1083)
        {
            _1091 = r[0].x > r[2].z;
        }
        else
        {
            _1091 = _1083;
        }
        if (_1091)
        {
            float s_1 = sqrt(((1.0 + r[0].x) - r[1].y) - r[2].z) * 2.0;
            q.w = (r[2].y - r[1].z) / s_1;
            q.x = 0.25 * s_1;
            q.y = (r[0].y + r[1].x) / s_1;
            q.z = (r[0].z + r[2].x) / s_1;
        }
        else
        {
            if (r[1].y > r[2].z)
            {
                float s_2 = sqrt(((1.0 + r[1].y) - r[0].x) - r[2].z) * 2.0;
                q.w = (r[0].z - r[2].x) / s_2;
                q.x = (r[0].y + r[1].x) / s_2;
                q.y = 0.25 * s_2;
                q.z = (r[1].z + r[2].y) / s_2;
            }
            else
            {
                float s_3 = sqrt(((1.0 + r[2].z) - r[0].x) - r[1].y) * 2.0;
                q.w = (r[1].x - r[0].y) / s_3;
                q.x = (r[0].z + r[2].x) / s_3;
                q.y = (r[1].z + r[2].y) / s_3;
                q.z = 0.25 * s_3;
            }
        }
    }
    return q;
}

vec4 _slerp(inout vec4 q1, inout vec4 q2, float t)
{
    q1 = normalize(q1);
    q2 = normalize(q2);
    float _dot = dot(q1, q2);
    if (_dot < 0.0)
    {
        q2 = -q2;
        _dot = -_dot;
    }
    if (_dot > 0.999499976634979248046875)
    {
        vec4 result = mix(q1, q2, vec4(t));
        return normalize(result);
    }
    float theta_0 = acos(_dot);
    float theta = theta_0 * t;
    float sin_theta = sin(theta);
    float sin_theta_0 = sin(theta_0);
    float s1 = cos(theta) - ((_dot * sin_theta) / sin_theta_0);
    float s2 = sin_theta / sin_theta_0;
    return (q1 * s1) + (q2 * s2);
}

vec4 _quatInverse(vec4 q)
{
    return vec4(-q.x, -q.y, -q.z, q.w);
}

vec4 _quatMultiply(vec4 q1, vec4 q2)
{
    return vec4((((q1.w * q2.x) + (q1.x * q2.w)) + (q1.y * q2.z)) - (q1.z * q2.y), (((q1.w * q2.y) - (q1.x * q2.z)) + (q1.y * q2.w)) + (q1.z * q2.x), (((q1.w * q2.z) + (q1.x * q2.y)) - (q1.y * q2.x)) + (q1.z * q2.w), (((q1.w * q2.w) - (q1.x * q2.x)) - (q1.y * q2.y)) - (q1.z * q2.z));
}

vec3 _transformPoint(vec3 point, vec4 quat1, vec4 quat2)
{
    vec4 p = vec4(point, 0.0);
    vec4 param = quat1;
    vec4 quat1_inv = _quatInverse(param);
    vec4 param_1 = quat1_inv;
    vec4 param_2 = p;
    vec4 param_3 = _quatMultiply(param_1, param_2);
    vec4 param_4 = quat1;
    vec4 p_prime = _quatMultiply(param_3, param_4);
    vec4 param_5 = quat2;
    vec4 quat2_inv = _quatInverse(param_5);
    vec4 param_6 = quat2;
    vec4 param_7 = p_prime;
    vec4 param_8 = _quatMultiply(param_6, param_7);
    vec4 param_9 = quat2_inv;
    vec4 p_double_prime = _quatMultiply(param_8, param_9);
    return p_double_prime.xyz;
}

void particle_modifier_along_path(ParticleModifierAlongPath_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    uint param = id;
    ParticleState state = prt_get_state(param);
    float lifetime = state.life_time * modifier_params.velocity;
    int keyframe0 = int(floor(lifetime * modifier_params.keyframes_per_second));
    int keyframe1 = keyframe0 + 1;
    float t0 = (lifetime * modifier_params.keyframes_per_second) - float(keyframe0);
    float t1 = ((lifetime + (lifecycle_params.time_step * modifier_params.velocity)) * modifier_params.keyframes_per_second) - float(keyframe0);
    if (keyframe1 >= modifier_params.keyframes)
    {
        return;
    }
    float dt0 = t0;
    float dt1 = t1;
    PointerToVec4 transform0 = PointerToVec4(modifier_params.transforms + uint64_t(16u * uint((keyframe0 * 3) + 0)));
    PointerToVec4 transform1 = PointerToVec4(modifier_params.transforms + uint64_t(16u * uint((keyframe0 * 3) + 1)));
    PointerToVec4 transform2 = PointerToVec4(modifier_params.transforms + uint64_t(16u * uint((keyframe0 * 3) + 2)));
    mat3 m0;
    m0[0] = transform0.v.xyz;
    m0[1] = transform1.v.xyz;
    m0[2] = transform2.v.xyz;
    vec3 pos0 = vec3(transform0.v.w, transform1.v.w, transform2.v.w);
    transform0 = PointerToVec4(modifier_params.transforms + uint64_t(16u * uint((keyframe1 * 3) + 0)));
    transform1 = PointerToVec4(modifier_params.transforms + uint64_t(16u * uint((keyframe1 * 3) + 1)));
    transform2 = PointerToVec4(modifier_params.transforms + uint64_t(16u * uint((keyframe1 * 3) + 2)));
    mat3 m1;
    m1[0] = transform0.v.xyz;
    m1[1] = transform1.v.xyz;
    m1[2] = transform2.v.xyz;
    vec3 pos1 = vec3(transform0.v.w, transform1.v.w, transform2.v.w);
    vec3 pos_dt0 = mix(pos0, pos1, vec3(dt0));
    vec3 pos_dt1 = mix(pos0, pos1, vec3(dt1));
    vec3 pos_dt = pos_dt1 - pos_dt0;
    m0 = transpose(m0);
    m1 = transpose(m1);
    mat3 param_1 = m0;
    vec4 q0 = _mat3ToQuaternion(param_1);
    mat3 param_2 = m1;
    vec4 q1 = _mat3ToQuaternion(param_2);
    vec4 param_3 = q0;
    vec4 param_4 = q1;
    float param_5 = dt0;
    vec4 _1647 = _slerp(param_3, param_4, param_5);
    vec4 q_dt0 = _1647;
    vec4 param_6 = q0;
    vec4 param_7 = q1;
    float param_8 = dt1;
    vec4 _1655 = _slerp(param_6, param_7, param_8);
    vec4 q_dt1 = _1655;
    vec3 pos = p.pos;
    if (id == 0u)
    {
    }
    vec3 param_9 = pos - pos_dt0;
    vec4 param_10 = q_dt0;
    vec4 param_11 = q_dt1;
    pos = _transformPoint(param_9, param_10, param_11);
    if (id == 0u)
    {
    }
    pos = (pos * max(0.0, 1.0 - (modifier_params.attraction * lifecycle_params.time_step))) + pos_dt0;
    pos += pos_dt;
    p.pos = pos;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1706 = vector_transform_by_mat43(param, param_1);
        coords = _1706;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1713 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1713;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1899.globals.time, _1899.globals.time * 0.3014999926090240478515625, (-_1899.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1921 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1921 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _460 = hash(param);
    uint param_1 = _460;
    float _462 = floatConstruct(param_1);
    return _462;
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

void modifier_factor_wrap(ModifierFactorWrap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    float range = modifier_params.max_value - modifier_params.min_value;
    float offset = mod(v - modifier_params.min_value, range) + range;
    v = mod(offset, range) + modifier_params.min_value;
    modifier_factor.factor = v;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _550 = color_convert_uint_to_float3(param);
    c.x = _550.x;
    c.y = _550.y;
    c.z = _550.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    float v = 0.0;
    if (uint(modifier_params.mode) == 0u)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (uint(modifier_params.mode) == 1u)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (uint(modifier_params.mode) == 2u)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    if (uint(modifier_params.mode) == 3u)
    {
        v = 1.0;
    }
    v = fract(v);
    vec3 color;
    if (modifier_params.color_gradient_idx != (-1))
    {
        int param_2 = modifier_params.color_gradient_idx;
        float param_3 = v;
        color = gradient_sample(param_2, param_3).xyz * modifier_params.color.xyz;
    }
    else
    {
        color = modifier_params.color.xyz;
    }
    if (uint(modifier_params.blend_mode) == 0u)
    {
        ParticleState param_4 = p.state;
        vec4 color_previous = prt_get_color(param_4);
        color = mix(color_previous.xyz, color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
    }
    else
    {
        if (uint(modifier_params.blend_mode) == 2u)
        {
            color = mix(vec3(1.0), color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
        }
        else
        {
            if (uint(modifier_params.blend_mode) == 1u)
            {
                color = mix(vec3(0.0), color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
            }
        }
    }
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _493;
    _493.life_time = state.life_time;
    _493.life_span = state.life_span;
    _493.generation_id = state.generation_id;
    _493.color = state.color;
    _480.prt_states[id] = _493;
}

void prt_set_position(uint id, vec3 p)
{
    _504.prt_positions[(id * 3u) + 0u] = p.x;
    _504.prt_positions[(id * 3u) + 1u] = p.y;
    _504.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_2182.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _2229 = atomicAdd(_2226.VM0_params.pending, -1);
        int pending = _2229;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _2238;
            _2238.transform = _2226.VM0_params.transform;
            _2238.particle_color = _2226.VM0_params.particle_color;
            _2238.primitive_size = _2226.VM0_params.primitive_size;
            _2238.perimeter_only = _2226.VM0_params.perimeter_only;
            _2238.primitive_type = _2226.VM0_params.primitive_type;
            _2238.particle_lifetime = _2226.VM0_params.particle_lifetime;
            _2238.particle_lifetime_randomness = _2226.VM0_params.particle_lifetime_randomness;
            _2238.rate = _2226.VM0_params.rate;
            _2238.seed = _2226.VM0_params.seed;
            _2238.pending = _2226.VM0_params.pending;
            ParticleEmitterPrimitive_Params param_4 = _2238;
            ParticleLifecycleParams _2243;
            _2243.time_step = _2182.lifecycle_params.time_step;
            _2243.max_lifetime = _2182.lifecycle_params.max_lifetime;
            _2243.reset = _2182.lifecycle_params.reset;
            _2243._pad1 = _2182.lifecycle_params._pad1;
            ParticleLifecycleParams param_5 = _2243;
            Particle param_6 = p;
            uint param_7 = id;
            particle_emitter_primitive_emit(param_4, param_5, param_6, param_7);
            p = param_6;
        }
    }
    ParticleState param_8 = p.state;
    if (prt_is_alive(param_8))
    {
        ParticleModifierAlongPath_Params _2264;
        _2264.velocity = _2259.VM1_params.velocity;
        _2264.attraction = _2259.VM1_params.attraction;
        _2264.keyframes_per_second = _2259.VM1_params.keyframes_per_second;
        _2264.keyframes = _2259.VM1_params.keyframes;
        _2264.transforms = _2259.VM1_params.transforms;
        ParticleModifierAlongPath_Params param_9 = _2264;
        ModifierFactor param_10 = modifier_factor;
        ParticleLifecycleParams _2270;
        _2270.time_step = _2182.lifecycle_params.time_step;
        _2270.max_lifetime = _2182.lifecycle_params.max_lifetime;
        _2270.reset = _2182.lifecycle_params.reset;
        _2270._pad1 = _2182.lifecycle_params._pad1;
        ParticleLifecycleParams param_11 = _2270;
        Particle param_12 = p;
        uint param_13 = id;
        particle_modifier_along_path(param_9, param_10, param_11, param_12, param_13);
        p = param_12;
    }
    ModifierFactorNoise_Params _2285;
    _2285.transform_local_to_gizmo = _2280.VM2_params.transform_local_to_gizmo;
    _2285.noise_domain_scale = _2280.VM2_params.noise_domain_scale;
    _2285.modifier_function = _2280.VM2_params.modifier_function;
    _2285.noise_domain_offset = _2280.VM2_params.noise_domain_offset;
    _2285.noise_value_scale = _2280.VM2_params.noise_value_scale;
    _2285.noise_value_offset = _2280.VM2_params.noise_value_offset;
    _2285.influence_scope = _2280.VM2_params.influence_scope;
    _2285._pad0 = _2280.VM2_params._pad0;
    _2285._pad1 = _2280.VM2_params._pad1;
    ModifierFactorNoise_Params param_14 = _2285;
    ModifierFactor param_15 = modifier_factor;
    CoordinateSystemTrasforms param_16 = cs_transforms;
    modifier_factor_noise_default(param_14, param_15, param_16);
    modifier_factor = param_15;
    ParticleState param_17 = p.state;
    if (prt_is_alive(param_17))
    {
        ParticleModifierCurl_Params _2306;
        _2306.position = _2301.VM3_params.position;
        _2306.falloff_mode = _2301.VM3_params.falloff_mode;
        _2306.radius = _2301.VM3_params.radius;
        _2306.falloff_inverse = _2301.VM3_params.falloff_inverse;
        _2306.noise_strength = _2301.VM3_params.noise_strength;
        _2306.noise_speed = _2301.VM3_params.noise_speed;
        _2306.noise_scale = _2301.VM3_params.noise_scale;
        ParticleModifierCurl_Params param_18 = _2306;
        ParticleLifecycleParams _2310;
        _2310.time_step = _2182.lifecycle_params.time_step;
        _2310.max_lifetime = _2182.lifecycle_params.max_lifetime;
        _2310.reset = _2182.lifecycle_params.reset;
        _2310._pad1 = _2182.lifecycle_params._pad1;
        ParticleLifecycleParams param_19 = _2310;
        ModifierFactor param_20 = modifier_factor;
        Particle param_21 = p;
        uint param_22 = id;
        particle_modifier_curl(param_18, param_19, param_20, param_21, param_22);
        modifier_factor = param_20;
        p = param_21;
    }
    ParticleState param_23 = p.state;
    if (prt_is_alive(param_23))
    {
        ParticleModifierAttractor_Params _2334;
        _2334.position = _2329.VM4_params.position;
        _2334.radius = _2329.VM4_params.radius;
        _2334.velocity = _2329.VM4_params.velocity;
        ParticleModifierAttractor_Params param_24 = _2334;
        ModifierFactor param_25 = modifier_factor;
        ParticleLifecycleParams _2340;
        _2340.time_step = _2182.lifecycle_params.time_step;
        _2340.max_lifetime = _2182.lifecycle_params.max_lifetime;
        _2340.reset = _2182.lifecycle_params.reset;
        _2340._pad1 = _2182.lifecycle_params._pad1;
        ParticleLifecycleParams param_26 = _2340;
        Particle param_27 = p;
        uint param_28 = id;
        particle_modifier_attractor(param_24, param_25, param_26, param_27, param_28);
        p = param_27;
    }
    ModifierFactorWrap_Params _2355;
    _2355.min_value = _2350.VM5_params.min_value;
    _2355.max_value = _2350.VM5_params.max_value;
    ModifierFactorWrap_Params param_29 = _2355;
    ModifierFactor param_30 = modifier_factor;
    modifier_factor_wrap(param_29, param_30);
    modifier_factor = param_30;
    ParticleState param_31 = p.state;
    if (prt_is_alive(param_31))
    {
        ParticleModifierColorize_Params _2374;
        _2374.color = _2369.VM6_params.color;
        _2374.mode = _2369.VM6_params.mode;
        _2374.blend_mode = _2369.VM6_params.blend_mode;
        _2374.color_gradient_idx = _2369.VM6_params.color_gradient_idx;
        _2374.randomness = _2369.VM6_params.randomness;
        _2374.blend_from_previous = _2369.VM6_params.blend_from_previous;
        ParticleModifierColorize_Params param_32 = _2374;
        ModifierFactor param_33 = modifier_factor;
        Particle param_34 = p;
        uint param_35 = id;
        particle_modifier_colorize(param_32, param_33, param_34, param_35);
        modifier_factor = param_33;
        p = param_34;
    }
    ParticleState param_36 = p.state;
    float param_37 = _2182.lifecycle_params.time_step;
    float param_38 = _2182.lifecycle_params.max_lifetime;
    prt_advance_life(param_36, param_37, param_38);
    p.state = param_36;
    uint param_39 = id;
    ParticleState param_40 = p.state;
    prt_set_state(param_39, param_40);
    uint param_41 = id;
    vec3 param_42 = p.pos;
    prt_set_position(param_41, param_42);
}

 