#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct InstancingGeneratorParams
{
    int first_ribbon;
    int skip_ribbons;
    int skip_segments;
    int num_ribbons;
    int base_segment;
    int segments;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segments;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _143;

layout(set = 0, binding = 9, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _183;

layout(set = 0, binding = 10, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _196;

layout(set = 0, binding = 2, std430) readonly buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 3, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _396;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _461;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _485;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _505;

layout(set = 0, binding = 8, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _513;

bool prt_is_alive(uint id)
{
    return _143.prt_states[id].life_time < _143.prt_states[id].life_span;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _143.prt_states[id].color;
    vec3 _170 = color_convert_uint_to_float3(param);
    c.x = _170.x;
    c.y = _170.y;
    c.z = _170.z;
    return c;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _160;
    _160.life_time = _143.prt_states[id].life_time;
    _160.life_span = _143.prt_states[id].life_span;
    _160.generation_id = _143.prt_states[id].generation_id;
    _160.color = _143.prt_states[id].color;
    ParticleState _159 = _160;
    return _159;
}

int calculate_vidx_for_ribbon_segment(int ribbon_id, inout int ribbon_segment)
{
    ribbon_segment = _183.instancing_generator_params.base_segment - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _196.ribbon_render_params.max_segments;
    }
    if (ribbon_segment >= _196.ribbon_render_params.max_segments)
    {
        ribbon_segment -= _196.ribbon_render_params.max_segments;
    }
    int vidx = (ribbon_segment * _196.ribbon_render_params.particles_per_segment) + ribbon_id;
    return vidx;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint ribbon_id = (id * uint(_183.instancing_generator_params.skip_ribbons)) + uint(_183.instancing_generator_params.first_ribbon);
    if (ribbon_id >= uint(_183.instancing_generator_params.num_ribbons))
    {
        return;
    }
    uint param = ribbon_id;
    if (prt_is_alive(param) == false)
    {
        return;
    }
    int ribbon_segments = max(0, (min(_196.ribbon_render_params.max_segments, int(prt_states_snapshots.states[ribbon_id].segments)) - 1));
    uint param_1 = ribbon_id;
    vec4 particle_color = prt_get_color(param_1);
    uint param_2 = ribbon_id;
    ParticleState particle_state = prt_get_state(param_2);
    int emited = 0;
    CoordinateSystemTrasforms cs_transforms;
    Instance instance;
    int si = 0;
    for (;;)
    {
        if (si < ribbon_segments)
        {
            int param_3 = int(ribbon_id);
            int param_4 = si;
            int _292 = calculate_vidx_for_ribbon_segment(param_3, param_4);
            int vidx = _292;
            vec3 pos = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
            vec3 pos_prev = pos;
            vec3 normal = vec3(1.0, 0.0, 0.0);
            bool has_direction = true;
            bool _324 = pos.x == pos_prev.x;
            bool _332;
            if (_324)
            {
                _332 = pos.y == pos_prev.y;
            }
            else
            {
                _332 = _324;
            }
            bool _340;
            if (_332)
            {
                _340 = pos.z == pos_prev.z;
            }
            else
            {
                _340 = _332;
            }
            if (_340)
            {
                has_direction = false;
            }
            vec3 nx = vec3(1.0, 0.0, 0.0);
            vec3 ny = vec3(0.0, 1.0, 0.0);
            vec3 nz = vec3(0.0, 0.0, 1.0);
            if (has_direction)
            {
                vec3 d = normalize(pos_prev - pos);
                nz = d;
                nx = cross(nz, ny);
                ny = cross(nz, nx);
            }
            ModifierFactor modifier_factor = modifier_factor_defaults();
            modifier_factor.factor = 1.0;
            modifier_factor.hash = ribbon_id;
            modifier_factor.id = ribbon_id;
            modifier_factor.position = pos;
            modifier_factor.is_spawned = true;
            cs_transforms.mat_local_to_model = mat_identity();
            cs_transforms.mat_local_to_instance = mat_identity();
            cs_transforms.mat_local_to_model_inv = mat_identity();
            if ((modifier_factor.factor <= 9.9999997473787516355514526367188e-05) || modifier_factor.is_discarded)
            {
                int _522 = si;
                si = _522 + _183.instancing_generator_params.skip_segments;
                continue;
            }
            int _399 = atomicAdd(_396.instance_params.instance_count, 1);
            uint instance_id = uint(_399);
            if (instance_id >= uint(_396.instance_params.buffer_capacity))
            {
                break;
            }
            float size = 1.0;
            nx *= size;
            ny *= size;
            nz *= size;
            instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
            instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
            instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
            instance.hash = modifier_factor.hash;
            instance.c = particle_color;
            instance.flipbook_card = 0u;
            _461.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
            _461.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
            _461.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
            _485.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
            _485.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
            _505.instance_hash[instance_id] = instance.hash;
            _513.instance_flipbook_card[instance_id] = instance.flipbook_card;
            emited++;
            int _522 = si;
            si = _522 + _183.instancing_generator_params.skip_segments;
            continue;
        }
        else
        {
            break;
        }
    }
}

 