#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstancingGeneratorParams
{
    int seed;
    int first_particle;
    int skip_particles;
    int num_particles;
    float fade_lifetime;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _331;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _355;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _377;

layout(set = 0, binding = 9, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _962;

layout(set = 0, binding = 4, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1075;

layout(set = 0, binding = 10, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _1178;

layout(set = 0, binding = 11, std140) uniform VM1
{
    InstanceModifierRandomizerV2_Params VM1_params;
} _1193;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1211;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1234;

layout(set = 0, binding = 7, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _1254;

layout(set = 0, binding = 8, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _1262;

layout(set = 0, binding = 12) uniform sampler2D s_NoiseRGBA;

bool prt_is_alive(uint id)
{
    return _331.prt_states[id].life_time < _331.prt_states[id].life_span;
}

vec3 prt_get_prev_position(uint id)
{
    return vec3(_377.prt_prev_positions[(id * 3u) + 0u], _377.prt_prev_positions[(id * 3u) + 1u], _377.prt_prev_positions[(id * 3u) + 2u]);
}

vec3 prt_get_position(uint id)
{
    return vec3(_355.prt_positions[(id * 3u) + 0u], _355.prt_positions[(id * 3u) + 1u], _355.prt_positions[(id * 3u) + 2u]);
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ParticleState prt_get_state(uint id)
{
    ParticleState _348;
    _348.life_time = _331.prt_states[id].life_time;
    _348.life_span = _331.prt_states[id].life_span;
    _348.generation_id = _331.prt_states[id].generation_id;
    _348.color = _331.prt_states[id].color;
    ParticleState _347 = _348;
    return _347;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _331.prt_states[id].color;
    vec3 _402 = color_convert_uint_to_float3(param);
    c.x = _402.x;
    c.y = _402.y;
    c.z = _402.z;
    return c;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    int k = -1;
    for (;;)
    {
        if (k <= 1)
        {
            int j = -1;
            for (;;)
            {
                if (j <= 1)
                {
                    int i = -1;
                    for (;;)
                    {
                        if (i <= 1)
                        {
                            vec3 b = vec3(float(i), float(j), float(k));
                            vec3 param = p + b;
                            vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                            float d = dot(r, r);
                            if (d < res.x)
                            {
                                id = dot(p + b, vec3(1.0, 57.0, 113.0));
                                res = vec2(d, res.x);
                            }
                            else
                            {
                                if (d < res.y)
                                {
                                    res.y = d;
                                }
                            }
                            i++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    j++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            k++;
            continue;
        }
        else
        {
            break;
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _556 = vector_transform_by_mat43(param, param_1);
        coords = _556;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _563 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _563;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _286 = hash(param);
    uint param_1 = v.z;
    uint _291 = hash(param_1);
    uint param_2 = (v.x ^ _286) ^ _291;
    uint _294 = hash(param_2);
    return _294;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _323 = floatConstruct(param_1);
    return _323;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _313 = hash(param);
    uint param_1 = _313;
    float _315 = floatConstruct(param_1);
    return _315;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint particle_idx = (id * uint(_962.instancing_generator_params.skip_particles)) + uint(_962.instancing_generator_params.first_particle);
    if (particle_idx >= uint(_962.instancing_generator_params.num_particles))
    {
        return;
    }
    uint param = particle_idx;
    if (prt_is_alive(param) == false)
    {
        return;
    }
    uint param_1 = particle_idx;
    vec3 pos_prev = prt_get_prev_position(param_1);
    uint param_2 = particle_idx;
    vec3 pos = prt_get_position(param_2);
    bool has_direction = true;
    bool _1001 = pos.x == pos_prev.x;
    bool _1009;
    if (_1001)
    {
        _1009 = pos.y == pos_prev.y;
    }
    else
    {
        _1009 = _1001;
    }
    bool _1017;
    if (_1009)
    {
        _1017 = pos.z == pos_prev.z;
    }
    else
    {
        _1017 = _1009;
    }
    if (_1017)
    {
        has_direction = false;
    }
    vec3 nx = vec3(1.0, 0.0, 0.0);
    vec3 ny = vec3(0.0, 1.0, 0.0);
    vec3 nz = vec3(0.0, 0.0, 1.0);
    if (has_direction)
    {
        vec3 d = normalize(pos_prev - pos);
        nz = d;
        nx = cross(nz, ny);
        ny = cross(nz, nx);
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = particle_idx;
    modifier_factor.id = id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    bool _1060 = modifier_factor.factor <= 9.9999997473787516355514526367188e-05;
    bool _1067;
    if (!_1060)
    {
        _1067 = modifier_factor.is_discarded == true;
    }
    else
    {
        _1067 = _1060;
    }
    if (_1067)
    {
        return;
    }
    int _1078 = atomicAdd(_1075.instance_params.instance_count, 1);
    uint instance_id = uint(_1078);
    if (instance_id >= uint(_1075.instance_params.buffer_capacity))
    {
        return;
    }
    uint param_3 = particle_idx;
    ParticleState particle_state = prt_get_state(param_3);
    float size = 1.0;
    if (particle_state.life_time < _962.instancing_generator_params.fade_lifetime)
    {
        size = smoothstep(0.0, _962.instancing_generator_params.fade_lifetime, particle_state.life_time);
    }
    if (particle_state.life_time >= (particle_state.life_span - _962.instancing_generator_params.fade_lifetime))
    {
        size = 1.0 - smoothstep(particle_state.life_span - _962.instancing_generator_params.fade_lifetime, particle_state.life_span, particle_state.life_time);
    }
    nx *= size;
    ny *= size;
    nz *= size;
    Instance instance;
    instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
    instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
    instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
    instance.hash = modifier_factor.hash;
    uint param_4 = particle_idx;
    instance.c = prt_get_color(param_4);
    instance.flipbook_card = 0u;
    ModifierFactorNoise_Params _1183;
    _1183.transform_local_to_gizmo = _1178.VM0_params.transform_local_to_gizmo;
    _1183.noise_domain_scale = _1178.VM0_params.noise_domain_scale;
    _1183.modifier_function = _1178.VM0_params.modifier_function;
    _1183.noise_domain_offset = _1178.VM0_params.noise_domain_offset;
    _1183.noise_value_scale = _1178.VM0_params.noise_value_scale;
    _1183.noise_value_offset = _1178.VM0_params.noise_value_offset;
    _1183.influence_scope = _1178.VM0_params.influence_scope;
    _1183._pad0 = _1178.VM0_params._pad0;
    _1183._pad1 = _1178.VM0_params._pad1;
    ModifierFactorNoise_Params param_5 = _1183;
    ModifierFactor param_6 = modifier_factor;
    CoordinateSystemTrasforms param_7 = cs_transforms;
    modifier_factor_noise_voronoi(param_5, param_6, param_7);
    modifier_factor = param_6;
    InstanceModifierRandomizerV2_Params _1198;
    _1198.replace_previous_rotation_scale = _1193.VM1_params.replace_previous_rotation_scale;
    _1198.randomness_seed = _1193.VM1_params.randomness_seed;
    _1198.replace_previous_position = _1193.VM1_params.replace_previous_position;
    _1198.randomization_input = _1193.VM1_params.randomization_input;
    _1198.position_modifier_base = _1193.VM1_params.position_modifier_base;
    _1198.position_modifier_base_modifier_factor = _1193.VM1_params.position_modifier_base_modifier_factor;
    _1198.position_modifier_range = _1193.VM1_params.position_modifier_range;
    _1198.position_modifier_range_modifier_factor = _1193.VM1_params.position_modifier_range_modifier_factor;
    _1198.rotation_modifier_base = _1193.VM1_params.rotation_modifier_base;
    _1198.rotation_modifier_base_modifier_factor = _1193.VM1_params.rotation_modifier_base_modifier_factor;
    _1198.rotation_modifier_range = _1193.VM1_params.rotation_modifier_range;
    _1198.rotation_modifier_range_modifier_factor = _1193.VM1_params.rotation_modifier_range_modifier_factor;
    _1198.scale_modifier_base = _1193.VM1_params.scale_modifier_base;
    _1198.scale_modifier_base_modifier_factor = _1193.VM1_params.scale_modifier_base_modifier_factor;
    _1198.scale_modifier_range = _1193.VM1_params.scale_modifier_range;
    _1198.scale_modifier_range_modifier_factor = _1193.VM1_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_8 = _1198;
    ModifierFactor param_9 = modifier_factor;
    Instance param_10 = instance;
    uint param_11 = id;
    instance_modifier_randomizer_v2(param_8, param_9, param_10, param_11);
    modifier_factor = param_9;
    instance = param_10;
    _1211.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _1211.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _1211.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _1234.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _1234.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _1254.instance_hash[instance_id] = instance.hash;
    _1262.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 