#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ParticleEmitterGeometry_Params
{
    int constrained;
    int debug_counter;
    int debug_counter2;
    int debug_counter3;
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    float surface_distance;
    int pending;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int alpha_to_modifier_factor;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct ParticleModifierColorize_Params
{
    vec4 color;
    int mode;
    int blend_mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM8Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _461;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _485;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _508;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _916;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _970;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _1039;

layout(set = 0, binding = 8, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1583;

layout(set = 0, binding = 9, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1793;

layout(set = 0, binding = 7, std430) buffer VM0
{
    ParticleEmitterGeometry_Params VM0_params;
} _1837;

layout(set = 0, binding = 10, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1866;

layout(set = 0, binding = 11, std140) uniform VM2
{
    ModifierFactorMulAdd_Params VM2_params;
} _1881;

layout(set = 0, binding = 12, std140) uniform VM3
{
    ModifierFactorClamp_Params VM3_params;
} _1894;

layout(set = 0, binding = 13, std140) uniform VM4
{
    ParticleModifierCurl_Params VM4_params;
} _1913;

layout(set = 0, binding = 14, std140) uniform VM5
{
    ParticleModifierCurl_Params VM5_params;
} _1941;

layout(set = 0, binding = 15, std140) uniform VM6
{
    ParticleModifierCurl_Params VM6_params;
} _1967;

layout(set = 0, binding = 16, std140) uniform VM7
{
    ParticleModifierColorize_Params VM7_params;
} _1994;

layout(set = 0, binding = 17, std140) uniform VM8
{
    VM8Params VM8_params;
} _2013;

layout(set = 0, binding = 18) uniform sampler2D s_Gradients;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_508.prt_prev_positions[(id * 3u) + 0u], _508.prt_prev_positions[(id * 3u) + 1u], _508.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _467;
    _467.life_time = _461.prt_states[id].life_time;
    _467.life_span = _461.prt_states[id].life_span;
    _467.generation_id = _461.prt_states[id].generation_id;
    _467.color = _461.prt_states[id].color;
    ParticleState _466 = _467;
    return _466;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

uint particle_emitter_geometry_get_first_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1039.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1039.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _441 = hash(param);
    uint param_1 = _441;
    float _443 = floatConstruct(param_1);
    return _443;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _970.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _970.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _970.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_916.in_vtx_data[coord_offset + 0u], _916.in_vtx_data[coord_offset + 1u], _916.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_916.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

ModifierFactor particle_emitter_geometry_emit_evaluate_modifier_VM0(ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    return modifier_factor;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _544 = color_convert_rgb_float3_uint(param);
    uint v = _544;
    state.color = v;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

void particle_emitter_geometry_emit_VM0(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    int iteration = 0;
    for (;;)
    {
        if (iteration < 5)
        {
            float fid = float((id + uint(iteration * 45827)) & 16777215u);
            float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
            float param_2 = fid_seed * 5.131999969482421875;
            float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
            float param_3 = fid_seed;
            uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
            face_idx += first_face_idx;
            uint param_4 = face_idx;
            RTFace rt_face = rt_get_face(param_4);
            uint p0_idx = rt_face.v0;
            uint p1_idx = rt_face.v1;
            uint p2_idx = rt_face.v2;
            uint param_5 = p0_idx;
            vec3 p0 = rt_get_vertex(param_5);
            uint param_6 = p1_idx;
            vec3 p1 = rt_get_vertex(param_6);
            uint param_7 = p2_idx;
            vec3 p2 = rt_get_vertex(param_7);
            uint param_8 = p0_idx;
            vec4 c0 = rt_get_vertex_color(param_8);
            uint param_9 = p1_idx;
            vec4 c1 = rt_get_vertex_color(param_9);
            uint param_10 = p2_idx;
            vec4 c2 = rt_get_vertex_color(param_10);
            float param_11 = fid_seed * 0.34130001068115234375;
            bc.x = random(param_11);
            float param_12 = fid_seed * 0.1412999927997589111328125;
            bc.y = random(param_12);
            if ((bc.x + bc.y) >= 1.0)
            {
                bc.x = 1.0 - bc.x;
                bc.y = 1.0 - bc.y;
            }
            vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
            vec4 color = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
            ModifierFactor local_modifier_factor = modifier_factor_defaults();
            local_modifier_factor.factor = 1.0;
            local_modifier_factor.hash = floatBitsToUint(fid_seed);
            local_modifier_factor.id = id;
            local_modifier_factor.position = pos;
            local_modifier_factor.is_spawned = true;
            local_modifier_factor.color = color;
            ModifierFactor param_13 = local_modifier_factor;
            local_modifier_factor = particle_emitter_geometry_emit_evaluate_modifier_VM0(param_13);
            if (local_modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
            {
                int _1337 = iteration;
                iteration = _1337 + 1;
                continue;
            }
            float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
            if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
            {
                if (emitter_params.surface_distance > 0.0)
                {
                    vec3 n = normalize(cross(p0 - p1, p0 - p2));
                    pos += (n * emitter_params.surface_distance);
                }
                if (pos.x == 1234567.0)
                {
                    pos += vec3(fid_seed);
                }
                p.pos = pos;
                ParticleState param_14 = p.state;
                vec3 param_15 = emitter_params.particle_color.xyz;
                prt_set_color(param_14, param_15);
                p.state = param_14;
                ParticleState param_16 = p.state;
                float param_17 = lifetime;
                prt_spawn(param_16, param_17);
                p.state = param_16;
                if (emitter_params.alpha_to_modifier_factor != 0)
                {
                    modifier_factor.factor = color.w;
                }
                emitted = true;
                break;
            }
            int _1337 = iteration;
            iteration = _1337 + 1;
            continue;
        }
        else
        {
            break;
        }
    }
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1353 = vector_transform_by_mat43(param, param_1);
        coords = _1353;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1360 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1360;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1583.globals.time, _1583.globals.time * 0.3014999926090240478515625, (-_1583.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1606 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1606 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _531 = color_convert_uint_to_float3(param);
    c.x = _531.x;
    c.y = _531.y;
    c.z = _531.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    float v = 0.0;
    if (uint(modifier_params.mode) == 0u)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (uint(modifier_params.mode) == 1u)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (uint(modifier_params.mode) == 2u)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    if (uint(modifier_params.mode) == 3u)
    {
        v = 1.0;
    }
    v = fract(v);
    vec3 color;
    if (modifier_params.color_gradient_idx != (-1))
    {
        int param_2 = modifier_params.color_gradient_idx;
        float param_3 = v;
        color = gradient_sample(param_2, param_3).xyz * modifier_params.color.xyz;
    }
    else
    {
        color = modifier_params.color.xyz;
    }
    if (uint(modifier_params.blend_mode) == 0u)
    {
        ParticleState param_4 = p.state;
        vec4 color_previous = prt_get_color(param_4);
        color = mix(color_previous.xyz, color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
    }
    else
    {
        if (uint(modifier_params.blend_mode) == 2u)
        {
            color = mix(vec3(1.0), color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
        }
        else
        {
            if (uint(modifier_params.blend_mode) == 1u)
            {
                color = mix(vec3(0.0), color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
            }
        }
    }
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _474;
    _474.life_time = state.life_time;
    _474.life_span = state.life_span;
    _474.generation_id = state.generation_id;
    _474.color = state.color;
    _461.prt_states[id] = _474;
}

void prt_set_position(uint id, vec3 p)
{
    _485.prt_positions[(id * 3u) + 0u] = p.x;
    _485.prt_positions[(id * 3u) + 1u] = p.y;
    _485.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_1793.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _1841 = atomicAdd(_1837.VM0_params.pending, -1);
        int pending = _1841;
        if (pending > 0)
        {
            ParticleEmitterGeometry_Params _1852;
            _1852.constrained = _1837.VM0_params.constrained;
            _1852.debug_counter = _1837.VM0_params.debug_counter;
            _1852.debug_counter2 = _1837.VM0_params.debug_counter2;
            _1852.debug_counter3 = _1837.VM0_params.debug_counter3;
            _1852.position = _1837.VM0_params.position;
            _1852.falloff_mode = _1837.VM0_params.falloff_mode;
            _1852.radius = _1837.VM0_params.radius;
            _1852.falloff_inverse = _1837.VM0_params.falloff_inverse;
            _1852.particle_color = _1837.VM0_params.particle_color;
            _1852.particle_lifetime = _1837.VM0_params.particle_lifetime;
            _1852.particle_lifetime_randomness = _1837.VM0_params.particle_lifetime_randomness;
            _1852.rate = _1837.VM0_params.rate;
            _1852.seed = _1837.VM0_params.seed;
            _1852.surface_distance = _1837.VM0_params.surface_distance;
            _1852.pending = _1837.VM0_params.pending;
            _1852.transformed_data_location_idx = _1837.VM0_params.transformed_data_location_idx;
            _1852.transformed_data_location_num = _1837.VM0_params.transformed_data_location_num;
            _1852.alpha_to_modifier_factor = _1837.VM0_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_4 = _1852;
            ModifierFactor param_5 = modifier_factor;
            Particle param_6 = p;
            uint param_7 = id;
            uint param_8 = uint(pending);
            particle_emitter_geometry_emit_VM0(param_4, param_5, param_6, param_7, param_8);
            modifier_factor = param_5;
            p = param_6;
        }
    }
    ModifierFactorNoise_Params _1871;
    _1871.transform_local_to_gizmo = _1866.VM1_params.transform_local_to_gizmo;
    _1871.noise_domain_scale = _1866.VM1_params.noise_domain_scale;
    _1871.modifier_function = _1866.VM1_params.modifier_function;
    _1871.noise_domain_offset = _1866.VM1_params.noise_domain_offset;
    _1871.noise_value_scale = _1866.VM1_params.noise_value_scale;
    _1871.noise_value_offset = _1866.VM1_params.noise_value_offset;
    _1871.influence_scope = _1866.VM1_params.influence_scope;
    _1871._pad0 = _1866.VM1_params._pad0;
    _1871._pad1 = _1866.VM1_params._pad1;
    ModifierFactorNoise_Params param_9 = _1871;
    ModifierFactor param_10 = modifier_factor;
    CoordinateSystemTrasforms param_11 = cs_transforms;
    modifier_factor_noise_default(param_9, param_10, param_11);
    modifier_factor = param_10;
    ModifierFactorMulAdd_Params _1886;
    _1886.multiply_value = _1881.VM2_params.multiply_value;
    _1886.add_value = _1881.VM2_params.add_value;
    ModifierFactorMulAdd_Params param_12 = _1886;
    ModifierFactor param_13 = modifier_factor;
    modifier_factor_mul_add(param_12, param_13);
    modifier_factor = param_13;
    ModifierFactorClamp_Params _1899;
    _1899.clamp_min = _1894.VM3_params.clamp_min;
    _1899.clamp_max = _1894.VM3_params.clamp_max;
    _1899.clamp_min_enable = _1894.VM3_params.clamp_min_enable;
    _1899.clamp_max_enable = _1894.VM3_params.clamp_max_enable;
    ModifierFactorClamp_Params param_14 = _1899;
    ModifierFactor param_15 = modifier_factor;
    modifier_factor_clamp(param_14, param_15);
    modifier_factor = param_15;
    ParticleState param_16 = p.state;
    if (prt_is_alive(param_16))
    {
        ParticleModifierCurl_Params _1918;
        _1918.position = _1913.VM4_params.position;
        _1918.falloff_mode = _1913.VM4_params.falloff_mode;
        _1918.radius = _1913.VM4_params.radius;
        _1918.falloff_inverse = _1913.VM4_params.falloff_inverse;
        _1918.noise_strength = _1913.VM4_params.noise_strength;
        _1918.noise_speed = _1913.VM4_params.noise_speed;
        _1918.noise_scale = _1913.VM4_params.noise_scale;
        ParticleModifierCurl_Params param_17 = _1918;
        ParticleLifecycleParams _1923;
        _1923.time_step = _1793.lifecycle_params.time_step;
        _1923.max_lifetime = _1793.lifecycle_params.max_lifetime;
        _1923.reset = _1793.lifecycle_params.reset;
        _1923._pad1 = _1793.lifecycle_params._pad1;
        ParticleLifecycleParams param_18 = _1923;
        ModifierFactor param_19 = modifier_factor;
        Particle param_20 = p;
        uint param_21 = id;
        particle_modifier_curl(param_17, param_18, param_19, param_20, param_21);
        modifier_factor = param_19;
        p = param_20;
    }
    ParticleState param_22 = p.state;
    if (prt_is_alive(param_22))
    {
        ParticleModifierCurl_Params _1945;
        _1945.position = _1941.VM5_params.position;
        _1945.falloff_mode = _1941.VM5_params.falloff_mode;
        _1945.radius = _1941.VM5_params.radius;
        _1945.falloff_inverse = _1941.VM5_params.falloff_inverse;
        _1945.noise_strength = _1941.VM5_params.noise_strength;
        _1945.noise_speed = _1941.VM5_params.noise_speed;
        _1945.noise_scale = _1941.VM5_params.noise_scale;
        ParticleModifierCurl_Params param_23 = _1945;
        ParticleLifecycleParams _1949;
        _1949.time_step = _1793.lifecycle_params.time_step;
        _1949.max_lifetime = _1793.lifecycle_params.max_lifetime;
        _1949.reset = _1793.lifecycle_params.reset;
        _1949._pad1 = _1793.lifecycle_params._pad1;
        ParticleLifecycleParams param_24 = _1949;
        ModifierFactor param_25 = modifier_factor;
        Particle param_26 = p;
        uint param_27 = id;
        particle_modifier_curl(param_23, param_24, param_25, param_26, param_27);
        modifier_factor = param_25;
        p = param_26;
    }
    ParticleState param_28 = p.state;
    if (prt_is_alive(param_28))
    {
        ParticleModifierCurl_Params _1971;
        _1971.position = _1967.VM6_params.position;
        _1971.falloff_mode = _1967.VM6_params.falloff_mode;
        _1971.radius = _1967.VM6_params.radius;
        _1971.falloff_inverse = _1967.VM6_params.falloff_inverse;
        _1971.noise_strength = _1967.VM6_params.noise_strength;
        _1971.noise_speed = _1967.VM6_params.noise_speed;
        _1971.noise_scale = _1967.VM6_params.noise_scale;
        ParticleModifierCurl_Params param_29 = _1971;
        ParticleLifecycleParams _1975;
        _1975.time_step = _1793.lifecycle_params.time_step;
        _1975.max_lifetime = _1793.lifecycle_params.max_lifetime;
        _1975.reset = _1793.lifecycle_params.reset;
        _1975._pad1 = _1793.lifecycle_params._pad1;
        ParticleLifecycleParams param_30 = _1975;
        ModifierFactor param_31 = modifier_factor;
        Particle param_32 = p;
        uint param_33 = id;
        particle_modifier_curl(param_29, param_30, param_31, param_32, param_33);
        modifier_factor = param_31;
        p = param_32;
    }
    ParticleState param_34 = p.state;
    if (prt_is_alive(param_34))
    {
        ParticleModifierColorize_Params _1999;
        _1999.color = _1994.VM7_params.color;
        _1999.mode = _1994.VM7_params.mode;
        _1999.blend_mode = _1994.VM7_params.blend_mode;
        _1999.color_gradient_idx = _1994.VM7_params.color_gradient_idx;
        _1999.randomness = _1994.VM7_params.randomness;
        _1999.blend_from_previous = _1994.VM7_params.blend_from_previous;
        ParticleModifierColorize_Params param_35 = _1999;
        ModifierFactor param_36 = modifier_factor;
        Particle param_37 = p;
        uint param_38 = id;
        particle_modifier_colorize(param_35, param_36, param_37, param_38);
        modifier_factor = param_36;
        p = param_37;
    }
    vec3 modifier_position = _2013.VM8_params.position;
    p.pos += ((_2013.VM8_params.velocity * _1793.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_39 = p.state;
    float param_40 = _1793.lifecycle_params.time_step;
    float param_41 = _1793.lifecycle_params.max_lifetime;
    prt_advance_life(param_39, param_40, param_41);
    p.state = param_39;
    uint param_42 = id;
    ParticleState param_43 = p.state;
    prt_set_state(param_42, param_43);
    uint param_44 = id;
    vec3 param_45 = p.pos;
    prt_set_position(param_44, param_45);
}

 