#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#extension GL_EXT_shader_explicit_arithmetic_types_int16 : require
#extension GL_EXT_shader_16bit_storage : require
#extension GL_KHR_shader_subgroup_ballot : require
layout(early_fragment_tests) in;

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct AngularInfo
{
    float NdotL;
    float NdotV;
    float NdotH;
    float LdotH;
    float VdotH;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct intersection
{
    float t;
    vec3 normal;
    float denom;
    vec2 bc;
};

struct ray_state_user_data
{
    uint dummy;
};

struct ray_traversal_params
{
    float trace_range_primary;
    float trace_range_secondary;
};

struct ray_state
{
    vec3 color;
    vec3 normal;
    vec3 dir;
    vec3 origin;
    float transparency;
    int16_t bounces;
    int16_t material;
    int tests;
    int face_tests;
    uint flags;
    uint active_threads_factor;
    uint active_threads_samples;
    float final_color_factor;
    ray_state_user_data user_data;
};

struct IBLOutput
{
    vec3 color_weighted;
    vec3 color_raw;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct RTSetup
{
    mat4 mat_projection;
    mat4 mat_model;
    vec3 camera_position;
    int screen_sampling_scale;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 frustum_shift;
    vec2 resolution;
    float trace_range_primary;
    float trace_range_secondary;
    float roughness_clamp;
    float env_map_intensity;
    int lights_num;
    float initial_face_start_distance;
    uint material_flags;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct _3408
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

layout(set = 1, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _643;

layout(set = 1, binding = 2, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _750;

layout(set = 1, binding = 3, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _763;

layout(set = 1, binding = 4, std430) readonly buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _1532;

layout(set = 1, binding = 5, std430) readonly buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    uint node_buffer[];
} in_faces_list_data;

layout(set = 1, binding = 6, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 7, std140) uniform RTSetupBuffer
{
    layout(row_major) RTSetup rt_setup;
} _2329;

layout(set = 1, binding = 8, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 9, std140) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 10, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _3293;

layout(set = 1, binding = 11, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _3418;

layout(set = 1, binding = 15) uniform usampler3D s_grid_marker;
layout(set = 1, binding = 16) uniform samplerCube s_reflection;
layout(set = 1, binding = 17) uniform sampler2D s_BRDF;
layout(set = 1, binding = 18) uniform sampler2D LightProjectorSamplers[16];
layout(set = 1, binding = 34) uniform sampler2D material_textures[64];
layout(set = 1, binding = 98) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 12, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 99) uniform sampler2D sTextureDepth;
layout(set = 1, binding = 13, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 1, binding = 14, rgba16f) uniform readonly image2D imAlbedo;

layout(location = 1) out uvec4 outHitInfo;
layout(location = 1) in _3408 vtx_input;
layout(location = 0) out vec4 outAlbedo;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

float linearizeDepth(float d)
{
    return _2329.rt_setup.near_far_plane.z / ((_2329.rt_setup.near_far_plane.y + _2329.rt_setup.near_far_plane.x) - (d * _2329.rt_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _398;
    if (nor.x > 0.0)
    {
        _398 = -t;
    }
    else
    {
        _398 = t;
    }
    nor.x += _398;
    float _413;
    if (nor.y > 0.0)
    {
        _413 = -t;
    }
    else
    {
        _413 = t;
    }
    nor.y += _413;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

uint rt_set_mask(inout uint f, uint m)
{
    uint _1147 = f;
    uint _1148 = _1147 | m;
    f = _1148;
    return _1148;
}

vec3 glass_refract(vec3 v, vec3 n)
{
    float s = (dot(vec3(v), n) < 0.0) ? 1.0 : (-1.0);
    vec3 new_v = refract(v, n * s, 0.800000011920928955078125);
    if (dot(new_v, new_v) == 0.0)
    {
        return v;
    }
    return new_v;
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 rt_randomize_dir_for_roughness(inout ivec2 screen_pos, inout vec3 dir, vec3 n, inout float roughness, inout float bounce_throughput)
{
    bounce_throughput = 1.0;
    if (roughness > 0.0)
    {
        roughness = min(_2329.rt_setup.roughness_clamp, roughness);
        roughness = dot(dir, n) * roughness;
        bounce_throughput *= max(0.0, 1.0 - roughness);
        int frame = _3293.globals.monotonic & 127;
        float clamped_roughness = roughness * roughness;
        screen_pos &= ivec2(127);
        vec2 _noise = texelFetch(s_BlueNoise, ivec3(screen_pos, 0), 0).xy;
        vec2 hash = fract(_noise + vec2(float(frame) * 1.61803400516510009765625));
        float param = hash.x * clamped_roughness;
        float param_1 = hash.y;
        vec3 d = CosineSampleHemisphere(param, param_1);
        vec3 param_2 = dir;
        mat3 _3341 = matrixFromVector(param_2);
        mat3 vecSpace = _3341;
        d = vecSpace * d;
        float VdotN = dot(d, n);
        if ((VdotN < 0.0) && true)
        {
            hash = fract(_noise + vec2(float(frame + 10) * 1.61803400516510009765625));
            float param_3 = hash.x * clamped_roughness;
            float param_4 = hash.y;
            d = CosineSampleHemisphere(param_3, param_4);
            d = vecSpace * d;
            VdotN = dot(d, n);
            if (VdotN > 0.0)
            {
                dir = d;
            }
        }
        else
        {
            dir = d;
        }
    }
    return dir;
}

uint ballot_count(bool v)
{
    uvec4 ballot = subgroupBallot(v);
    uint cnt = uint(bitCount(ballot.x));
    cnt += uint(bitCount(ballot.y));
    return cnt;
}

uint rt_clear_mask_if(inout uint f, uint m, bool v)
{
    if (v)
    {
        f &= (~m);
    }
    return f;
}

bool rt_is_mask_set(uint f, uint mask)
{
    return (f & mask) != 0u;
}

uint rt_set_mask_if(inout uint f, uint m, bool v)
{
    if (v)
    {
        f |= m;
    }
    return f;
}

uint rt_clear_mask(inout uint f, uint m)
{
    uint _1162 = f;
    uint _1163 = _1162 & (~m);
    f = _1163;
    return _1163;
}

bool is_pos_inside_grid(ivec3 icell)
{
    int icell_mask = (icell.x | icell.y) | icell.z;
    if ((icell_mask & (-256)) == 0)
    {
        return true;
    }
    else
    {
        return false;
    }
}

void rt_pack_grid_marker_to_uint(ivec3 p, out ivec3 p_packed, out uint bit)
{
    ivec3 p_low_bits = p & ivec3(3, 3, 1);
    p_packed = ivec3(p.x >> 2, p.y >> 2, p.z >> 1);
    bit = uint((p_low_bits.x + (p_low_bits.y * 4)) + ((p_low_bits.z * 4) * 4));
}

bool rt_read_grid_marker_high_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 0).x & (1u << bit)) != 0u) ? true : false;
}

bool rt_read_grid_marker_low_res(usampler3D markers, ivec3 pos)
{
    ivec3 param = pos;
    ivec3 param_1;
    uint param_2;
    rt_pack_grid_marker_to_uint(param, param_1, param_2);
    ivec3 pos_packed = param_1;
    uint bit = param_2;
    return ((texelFetch(markers, pos_packed, 2).x & uint(1 << int(bit))) != 0u) ? true : false;
}

bool fetch_grid_marker_for_cell(ivec3 icell, int mip)
{
    if (mip == 0)
    {
        ivec3 param = icell;
        return rt_read_grid_marker_high_res(s_grid_marker, param);
    }
    else
    {
        ivec3 param_1 = icell >> ivec3(2);
        return rt_read_grid_marker_low_res(s_grid_marker, param_1);
    }
}

ivec3 dda_step_from_dir(vec3 dir, vec3 cell_step)
{
    vec3 s;
    s.x = (dir.x > 0.0) ? 1.0 : (-1.0);
    s.y = (dir.y > 0.0) ? 1.0 : (-1.0);
    s.z = (dir.z > 0.0) ? 1.0 : (-1.0);
    vec3 sgn = s * cell_step;
    return ivec3(sgn);
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _763.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _763.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _763.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_643.in_vtx_data[coord_offset + 0u], _643.in_vtx_data[coord_offset + 1u], _643.in_vtx_data[coord_offset + 2u]);
    return p;
}

intersection intersectTriangle3(vec3 orig, vec3 dir, vec3 v0, vec3 v1, vec3 v2)
{
    intersection it;
    it.t = -1.0;
    vec3 e1 = v1 - v0;
    vec3 e2 = v2 - v0;
    vec3 pvec = cross(dir, e2);
    float det = dot(e1, pvec);
    if (abs(det) < 1.0000000116860974230803549289703e-07)
    {
        return it;
    }
    float inv_det = 1.0 / det;
    vec3 tvec = orig - v0;
    float u = dot(tvec, pvec) * inv_det;
    if ((u < 0.0) || (u > 1.0))
    {
        return it;
    }
    vec3 qvec = cross(tvec, e1);
    float v = dot(dir, qvec) * inv_det;
    bool _1466 = v < 0.0;
    bool _1474;
    if (!_1466)
    {
        _1474 = (u + v) > 1.0;
    }
    else
    {
        _1474 = _1466;
    }
    if (_1474)
    {
        return it;
    }
    float t = dot(e2, qvec) * inv_det;
    if (t > 1.0000000116860974230803549289703e-07)
    {
        it.normal = vec3(normalize(cross(e2, e1)));
        float denom = dot(vec3(it.normal), dir);
        vec3 p0l0 = v0 - orig;
        it.t = t;
        it.denom = denom;
        it.bc.x = u / denom;
        it.bc.y = v / denom;
    }
    return it;
}

void findClosestBucket2(ray_state_user_data user_data, uint list_index, bool bucket_full, uint max_tests, vec3 origin, vec3 dir, int skip_fi, float max_t, inout int closest_fi, inout uint material_flags, inout float closest_it, inout vec3 closest_norm, inout vec2 closest_bc, out int face_tests)
{
    face_tests = 0;
    closest_fi = -1;
    closest_it = max_t;
    uint head = _1532.in_faces_list_tails_data[list_index];
    uint cnt = in_faces_list_data.node_buffer[head];
    if ((max_tests != 4294967295u) && (cnt >= max_tests))
    {
        closest_fi = -1;
        return;
    }
    face_tests = int(cnt);
    int fi_idx = 0;
    for (;;)
    {
        if (uint(fi_idx) < cnt)
        {
            int fi = int(in_faces_list_data.node_buffer[(head + uint(fi_idx)) + 1u]);
            if (fi == skip_fi)
            {
                int _1643 = fi_idx;
                fi_idx = _1643 + 1;
                continue;
            }
            uint param = uint(fi);
            RTFace rt_face = rt_get_face(param);
            uint param_1 = rt_face.v0;
            vec3 p0 = rt_get_vertex(param_1);
            uint param_2 = rt_face.v1;
            vec3 p1 = rt_get_vertex(param_2);
            uint param_3 = rt_face.v2;
            vec3 p2 = rt_get_vertex(param_3);
            vec3 param_4 = origin;
            vec3 param_5 = dir;
            vec3 param_6 = p2;
            vec3 param_7 = p1;
            vec3 param_8 = p0;
            intersection it1 = intersectTriangle3(param_4, param_5, param_6, param_7, param_8);
            bool _1615 = it1.t >= 0.0;
            bool _1622;
            if (_1615)
            {
                _1622 = it1.t <= closest_it;
            }
            else
            {
                _1622 = _1615;
            }
            if (_1622)
            {
                if ((rt_face.material_flags & 64u) == 0u)
                {
                    if (dot(dir, it1.normal) >= 0.0)
                    {
                        int _1643 = fi_idx;
                        fi_idx = _1643 + 1;
                        continue;
                    }
                }
                closest_fi = fi;
                closest_it = it1.t;
            }
            int _1643 = fi_idx;
            fi_idx = _1643 + 1;
            continue;
        }
        else
        {
            break;
        }
    }
    if (closest_fi != (-1))
    {
        uint param_9 = uint(closest_fi);
        RTFace rt_face_1 = rt_get_face(param_9);
        uint param_10 = rt_face_1.v0;
        vec3 p0_1 = rt_get_vertex(param_10);
        uint param_11 = rt_face_1.v1;
        vec3 p1_1 = rt_get_vertex(param_11);
        uint param_12 = rt_face_1.v2;
        vec3 p2_1 = rt_get_vertex(param_12);
        vec3 param_13 = origin;
        vec3 param_14 = dir;
        vec3 param_15 = p2_1;
        vec3 param_16 = p1_1;
        vec3 param_17 = p0_1;
        intersection it1_1 = intersectTriangle3(param_13, param_14, param_15, param_16, param_17);
        closest_norm = it1_1.normal;
        closest_bc = it1_1.bc;
        material_flags = rt_face_1.material_flags;
    }
}

vec2 rt_barycentric_yz(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 v0 = b - a;
    vec3 v1 = c - a;
    vec3 v2 = p - a;
    float d00 = dot(v0, v0);
    float d01 = dot(v0, v1);
    float d11 = dot(v1, v1);
    float d20 = dot(v2, v0);
    float d21 = dot(v2, v1);
    float denom = (d00 * d11) - (d01 * d01);
    vec3 bc;
    bc.y = ((d11 * d20) - (d01 * d21)) / denom;
    bc.z = ((d00 * d21) - (d01 * d20)) / denom;
    return bc.yz;
}

vec2 barycentric_for_face_yz(int idx, vec3 p)
{
    uint param = uint(idx);
    RTFace rt_face = rt_get_face(param);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_1 = p0_idx;
    vec3 a = rt_get_vertex(param_1);
    uint param_2 = p1_idx;
    vec3 b = rt_get_vertex(param_2);
    uint param_3 = p2_idx;
    vec3 c = rt_get_vertex(param_3);
    vec3 param_4 = p;
    vec3 param_5 = a;
    vec3 param_6 = b;
    vec3 param_7 = c;
    return vec2(rt_barycentric_yz(param_4, param_5, param_6, param_7));
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _643.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _643.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 interpolate_normal_from_bc_yz(int fi, vec2 bc_yz, vec3 ref_normal)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec3 n0 = vec3(rt_get_vertex_normal(param_1));
    uint param_2 = i1;
    vec3 n1 = vec3(rt_get_vertex_normal(param_2));
    uint param_3 = i2;
    vec3 n2 = vec3(rt_get_vertex_normal(param_3));
    vec3 smooth_normal = ((n0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (n1 * bc_yz.x)) + (n2 * bc_yz.y);
    return vec3(normalize(smooth_normal));
}

int rt_get_triangle_material(uint idx)
{
    int p = int(_750.transformed_data_faces[idx].material_idx);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_643.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

vec4 interpolate_color_from_bc_yz(int fi, vec2 bc_yz)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec4 c0 = vec4(rt_get_vertex_color(param_1));
    uint param_2 = i1;
    vec4 c1 = vec4(rt_get_vertex_color(param_2));
    uint param_3 = i2;
    vec4 c2 = vec4(rt_get_vertex_color(param_3));
    vec4 c = ((c0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (c1 * bc_yz.x)) + (c2 * bc_yz.y);
    return c;
}

vec2 rt_get_vertex_uv0(uint idx)
{
    uint uv0_offset = (idx * 2u) + 50000000u;
    vec2 p = vec2(_643.in_vtx_data[uv0_offset + 0u], _643.in_vtx_data[uv0_offset + 1u]);
    return p;
}

vec2 interpolate_uv_from_bc_yz(int fi, vec2 bc_yz)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec2 uv0 = vec2(rt_get_vertex_uv0(param_1));
    uint param_2 = i1;
    vec2 uv1 = vec2(rt_get_vertex_uv0(param_2));
    uint param_3 = i2;
    vec2 uv2 = vec2(rt_get_vertex_uv0(param_3));
    vec2 uv = ((uv0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (uv1 * bc_yz.x)) + (uv2 * bc_yz.y);
    return uv;
}

vec4 evaluate_albedo(int16_t materialIndex, int fi, vec2 bc)
{
    int param = fi;
    vec2 param_1 = bc;
    vec4 c = interpolate_color_from_bc_yz(param, param_1);
    if (materials.material_properties[materialIndex].albedo_sampler >= 0)
    {
        int param_2 = fi;
        vec2 param_3 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param_2, param_3);
        c *= vec4(textureLod(material_textures[materials.material_properties[materialIndex].albedo_sampler], uv, 1.0));
    }
    return c;
}

vec3 evaluate_emissive(int16_t materialIndex, int fi, vec2 bc)
{
    vec3 c = vec3(1.0);
    if (materials.material_properties[materialIndex].emissive_sampler >= 0)
    {
        int param = fi;
        vec2 param_1 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param, param_1);
        c = vec3(textureLod(material_textures[materials.material_properties[materialIndex].emissive_sampler], uv, 1.0).xyz);
    }
    return c;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position.xyz - pos);
    float falloff = dot(light.direction.xyz, (pos - light.position.xyz) / vec3(light_distance));
    float attenuation = 0.0;
    bool _899 = falloff > cutoff;
    bool _906;
    if (_899)
    {
        _906 = light_distance < light.range;
    }
    else
    {
        _906 = _899;
    }
    if (_906)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

AngularInfo getAngularInfo(vec3 normalized_point_to_light, vec3 normal, vec3 normalized_view)
{
    vec3 n = normal;
    vec3 v = normalized_view;
    vec3 l = normalized_point_to_light;
    vec3 h = normalize(l + v);
    float NdotL = dot(n, l);
    float NdotV = dot(n, v);
    float NdotH = clamp(dot(n, h), 0.0, 1.0);
    float LdotH = clamp(dot(l, h), 0.0, 1.0);
    float VdotH = clamp(dot(v, h), 0.0, 1.0);
    AngularInfo angularInfo = AngularInfo(NdotL, NdotV, NdotH, LdotH, VdotH);
    return angularInfo;
}

vec3 specularReflection(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    return materialInfo.reflectance0 + ((materialInfo.reflectance90 - materialInfo.reflectance0) * pow(clamp(1.0 - angularInfo.VdotH, 0.0, 1.0), 5.0));
}

float visibilityOcclusion(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float NdotL = clamp(angularInfo.NdotL, 0.0, 1.0);
    float NdotV = clamp(angularInfo.NdotV, 0.0, 1.0);
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float GGXV = NdotL * sqrt(((NdotV * NdotV) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGXL = NdotV * sqrt(((NdotL * NdotL) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGX = GGXV + GGXL;
    if (GGX > 0.0)
    {
        return 0.5 / GGX;
    }
    return 0.0;
}

float microfacetDistribution(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float f = (((angularInfo.NdotH * alphaRoughnessSq) - angularInfo.NdotH) * angularInfo.NdotH) + 1.0;
    return alphaRoughnessSq / (((3.1415927410125732421875 * f) * f) + 9.9999999747524270787835121154785e-07);
}

vec3 diffuse(MaterialInfo materialInfo)
{
    return materialInfo.diffuseColor / vec3(3.1415927410125732421875);
}

vec3 getPointShade(vec3 normalized_point_to_light, MaterialInfo materialInfo, vec3 normal, vec3 normalized_view)
{
    vec3 param = normalized_point_to_light;
    vec3 param_1 = normal;
    vec3 param_2 = normalized_view;
    AngularInfo angularInfo = getAngularInfo(param, param_1, param_2);
    bool _1086 = angularInfo.NdotL > 0.0;
    bool _1093;
    if (!_1086)
    {
        _1093 = angularInfo.NdotV > 0.0;
    }
    else
    {
        _1093 = _1086;
    }
    if (_1093)
    {
        MaterialInfo param_3 = materialInfo;
        AngularInfo param_4 = angularInfo;
        vec3 F = specularReflection(param_3, param_4);
        MaterialInfo param_5 = materialInfo;
        AngularInfo param_6 = angularInfo;
        float Vis = visibilityOcclusion(param_5, param_6);
        MaterialInfo param_7 = materialInfo;
        AngularInfo param_8 = angularInfo;
        float D = microfacetDistribution(param_7, param_8);
        MaterialInfo param_9 = materialInfo;
        vec3 diffuseContrib = (vec3(1.0) - F) * diffuse(param_9);
        vec3 specContrib = (F * Vis) * D;
        return (diffuseContrib + specContrib) * clamp(angularInfo.NdotL, 0.0, 1.0);
    }
    return vec3(0.0);
}

vec3 sample_projector_texture(sampler2D smpl, inout vec4 coords)
{
    vec3 color = vec3(0.0);
    if (coords.w <= 0.0)
    {
        return color;
    }
    bool _2480 = coords.x < (-coords.w);
    bool _2489;
    if (!_2480)
    {
        _2489 = coords.x > coords.w;
    }
    else
    {
        _2489 = _2480;
    }
    bool _2499;
    if (!_2489)
    {
        _2499 = coords.y < (-coords.w);
    }
    else
    {
        _2499 = _2489;
    }
    bool _2508;
    if (!_2499)
    {
        _2508 = coords.y > coords.w;
    }
    else
    {
        _2508 = _2499;
    }
    if (_2508)
    {
        return color;
    }
    vec4 _2513 = coords;
    float _2518 = coords.w;
    vec2 _2520 = (_2513.xy * vec2(0.5)) + (vec2(0.5) * _2518);
    coords.x = _2520.x;
    coords.y = _2520.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    color = texture(smpl, coords.xy / vec2(coords.w)).xyz;
    return color;
}

IBLOutput ibl(vec3 n, vec3 v, vec3 diffuseColor, vec3 specularColor, vec3 f0, vec3 f90, float perceptual_roughness)
{
    float NdotV = clamp(dot(n, v), 0.0, 1.0);
    vec3 r = reflect(-v, n);
    float mip_count = 7.5;
    float lod = clamp(perceptual_roughness * mip_count, 0.0, mip_count);
    vec2 brdf_sample_point = clamp(vec2(NdotV, 1.0 - perceptual_roughness), vec2(0.0), vec2(1.0));
    vec2 brdf = texture(s_BRDF, brdf_sample_point).xy;
    vec3 diffuseLight = textureLod(s_reflection, n, 5.0).xyz;
    vec3 specularLight = textureLod(s_reflection, r, lod).xyz * (brdf.x + brdf.y);
    IBLOutput ibl_1;
    ibl_1.color_weighted = (diffuseColor * diffuseLight) + (specularColor * specularLight);
    ibl_1.color_raw = diffuseLight + specularLight;
    return ibl_1;
}

vec3 evaluate_lighting(vec3 p, vec3 o, vec3 n, int material, vec3 albedo, vec3 emissive)
{
    vec3 c = vec3(0.0);
    vec3 world = p;
    vec3 view = normalize(o - p);
    vec3 f0 = vec3(0.039999999105930328369140625);
    float metallic = materials.material_properties[material].metalness;
    vec3 baseColor = vec3(clamp(materials.material_properties[material].diffuse * albedo, vec3(0.0), vec3(1.0)));
    vec3 diffuseColor = (baseColor * (vec3(1.0) - f0)) * (1.0 - metallic);
    vec3 specularColor = vec3(mix(f0, baseColor, vec3(metallic)));
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    float roughness = materials.material_properties[material].roughness;
    float alphaRoughness = roughness * roughness;
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    int light_idx = 0;
    for (;;)
    {
        if (light_idx < _2329.rt_setup.lights_num)
        {
            LightProperties _2668;
            _2668.diffuse = lights.light_properties[light_idx].diffuse;
            _2668.direction = lights.light_properties[light_idx].direction;
            _2668.position = lights.light_properties[light_idx].position;
            _2668.up = lights.light_properties[light_idx].up;
            _2668.right = lights.light_properties[light_idx].right;
            _2668.dimensions = lights.light_properties[light_idx].dimensions;
            _2668._pad1 = lights.light_properties[light_idx]._pad1;
            _2668.intensity = lights.light_properties[light_idx].intensity;
            _2668.range = lights.light_properties[light_idx].range;
            _2668.cutoff = lights.light_properties[light_idx].cutoff;
            _2668.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
            _2668.is_area = lights.light_properties[light_idx].is_area;
            _2668.type = lights.light_properties[light_idx].type;
            _2668.projector_sampler = lights.light_properties[light_idx].projector_sampler;
            _2668.projector_intensity = lights.light_properties[light_idx].projector_intensity;
            _2668.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
            _2668.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
            _2668.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
            _2668.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
            _2668.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
            _2668.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
            _2668.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
            _2668.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
            _2668.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
            _2668.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
            _2668.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
            _2668.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
            _2668.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
            _2668.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
            _2668.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
            _2668.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
            _2668.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
            LightProperties light = _2668;
            if ((light.type & 3) != 0)
            {
                vec3 pointToLight = light.position.xyz - world;
                if ((light.type & 1) != 0)
                {
                    pointToLight = -light.direction.xyz;
                }
                pointToLight = normalize(pointToLight);
                float NdotL = dot(vec3(n), pointToLight);
                vec3 lighting = vec3(0.0);
                if (NdotL > 0.0)
                {
                    float attenuation = 1.0;
                    if ((light.type & 2) != 0)
                    {
                        LightProperties param = light;
                        vec3 param_1 = world;
                        attenuation = light_calculate_spot_attenuation(param, param_1);
                    }
                    if (attenuation > 0.0)
                    {
                        vec4 vShadowCoords = (light.mat_shadow_p[0] * light.mat_shadow_mv) * vec4(world, 1.0);
                        vec3 param_2 = pointToLight;
                        MaterialInfo param_3 = materialInfo;
                        vec3 param_4 = n;
                        vec3 param_5 = view;
                        lighting = (getPointShade(param_2, param_3, param_4, param_5) * (light.intensity * attenuation)) * light.diffuse.xyz;
                        if ((light.type & 16) != 0)
                        {
                            vec4 vShadowCoords_1 = (light.mat_shadow_p[0] * light.mat_shadow_mv) * vec4(world, 1.0);
                            float shadow = 0.0;
                            vec4 param_6 = vShadowCoords_1;
                            vec3 _2781 = sample_projector_texture(LightProjectorSamplers[light.projector_sampler], param_6);
                            lighting *= (_2781 * ((1.0 - shadow) * light.projector_intensity));
                        }
                        c += lighting;
                    }
                }
            }
            light_idx++;
            continue;
        }
        else
        {
            break;
        }
    }
    vec3 param_7 = n;
    vec3 param_8 = view;
    vec3 param_9 = diffuseColor;
    vec3 param_10 = specularColor;
    vec3 param_11 = specularEnvironmentR0;
    vec3 param_12 = specularEnvironmentR90;
    float param_13 = roughness;
    IBLOutput ibl_1 = ibl(param_7, param_8, param_9, param_10, param_11, param_12, param_13);
    c += (ibl_1.color_weighted * _2329.rt_setup.env_map_intensity);
    c += (emissive * materials.material_properties[material].emissive_factor);
    return vec3(c);
}

vec3 yCgCo2rgb(vec3 ycc)
{
    float R = (ycc.x - ycc.y) + ycc.z;
    float G = ycc.x + ycc.y;
    float B = (ycc.x - ycc.y) - ycc.z;
    return vec3(R, G, B);
}

vec3 spectrum_offset_ycgco(float t)
{
    vec3 ygo = vec3(1.0, 0.0, (-1.25) * t);
    vec3 param = ygo;
    return yCgCo2rgb(param);
}

uint rt_neg_mask(inout uint f, uint m)
{
    uint _1177 = f;
    uint _1178 = _1177 ^ m;
    f = _1178;
    return _1178;
}

void evaluate_material(inout ray_state state, vec3 prev_state_origin, int hit_face, uint hit_material_flags, vec2 bc, bool flip_normal_on_glass)
{
    uint param = uint(hit_face);
    int16_t hit_material = int16_t(rt_get_triangle_material(param));
    int16_t param_1 = hit_material;
    int param_2 = hit_face;
    vec2 param_3 = bc;
    vec4 hit_albedo = evaluate_albedo(param_1, param_2, param_3);
    int16_t param_4 = hit_material;
    int param_5 = hit_face;
    vec2 param_6 = bc;
    vec3 hit_emissive = evaluate_emissive(param_4, param_5, param_6) * vec3(materials.material_properties[hit_material].emissive);
    vec3 camera_position = _2329.rt_setup.camera_position;
    if (flip_normal_on_glass)
    {
        vec3 d = camera_position - state.origin;
        camera_position = reflect(d, -state.normal) + state.origin;
    }
    vec3 param_7 = state.origin;
    vec3 param_8 = camera_position;
    vec3 param_9 = state.normal;
    int param_10 = int(hit_material);
    vec3 param_11 = hit_albedo.xyz;
    vec3 param_12 = hit_emissive;
    vec3 hit_color = evaluate_lighting(param_7, param_8, param_9, param_10, param_11, param_12);
    bool hit_material_reflective = materials.material_properties[hit_material].roughness < 1.0;
    if ((materials.material_properties[state.material].flags & 32u) == 0u)
    {
        hit_color = vec3(state.color * hit_color);
        state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
        uint param_13 = state.flags;
        uint param_14 = 4u;
        bool param_15 = int(state.bounces) == 4;
        uint _3051 = rt_set_mask_if(param_13, param_14, param_15);
        state.flags = _3051;
    }
    else
    {
        bool _3055 = hit_material_reflective == false;
        bool _3061;
        if (_3055)
        {
            _3061 = (hit_material_flags & 32u) == 0u;
        }
        else
        {
            _3061 = _3055;
        }
        if (_3061)
        {
            state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
            uint param_16 = state.flags;
            uint param_17 = 4u;
            uint _3080 = rt_set_mask(param_16, param_17);
            state.flags = _3080;
            uint param_18 = state.flags;
            uint param_19 = 32u;
            uint _3086 = rt_clear_mask(param_18, param_19);
            state.flags = _3086;
        }
        else
        {
            bool _3090 = hit_material_reflective == true;
            bool _3096;
            if (_3090)
            {
                _3096 = (hit_material_flags & 32u) == 0u;
            }
            else
            {
                _3096 = _3090;
            }
            if (_3096)
            {
                state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
                uint param_20 = state.flags;
                uint param_21 = 4u;
                bool param_22 = int(state.bounces) == 4;
                uint _3120 = rt_set_mask_if(param_20, param_21, param_22);
                state.flags = _3120;
            }
            else
            {
                float alpha = 0.25 * (1.0 - materials.material_properties[state.material].transparency);
                float absorbance = alpha * (-length(prev_state_origin - state.origin));
                float attenuation = exp(absorbance);
                bool is_current_transparent_and_doublesided = (materials.material_properties[state.material].flags & 96u) == 96u;
                if (is_current_transparent_and_doublesided == false)
                {
                    attenuation = 1.0;
                }
                float hit_transparency = 1.0 - ((1.0 - materials.material_properties[hit_material].transparency) * hit_albedo.w);
                state.transparency = (state.transparency * hit_transparency) * attenuation;
                state.color = vec3(mix(state.color, hit_color, vec3(state.transparency)));
            }
        }
    }
    if ((hit_material_flags & 32u) == 0u)
    {
        state.dir = reflect(state.dir, vec3(state.normal));
        uint param_23 = state.flags;
        uint param_24 = 16u;
        uint _3202 = rt_clear_mask(param_23, param_24);
        state.flags = _3202;
    }
    else
    {
        vec3 param_25 = state.dir;
        vec3 param_26 = state.normal;
        vec3 refracted_dir = glass_refract(param_25, param_26);
        float angle = dot(refracted_dir, state.dir);
        float threshold = 0.0;
        angle = 1.0 - abs(angle);
        float factor = clamp(angle * 5.0, 0.0, 1.0);
        angle *= 10.5;
        float param_27 = angle;
        state.color = mix(state.color, spectrum_offset_ycgco(param_27), vec3(factor));
        state.dir = refracted_dir;
        uint param_28 = state.flags;
        uint param_29 = 16u;
        uint _3244 = rt_neg_mask(param_28, param_29);
        state.flags = _3244;
    }
    bool _3248 = (hit_material_flags & 1u) == 0u;
    bool _3254;
    if (_3248)
    {
        _3254 = (hit_material_flags & 32u) == 0u;
    }
    else
    {
        _3254 = _3248;
    }
    if (_3254)
    {
        uint param_30 = state.flags;
        uint param_31 = 32u;
        uint _3261 = rt_clear_mask(param_30, param_31);
        state.flags = _3261;
        uint param_32 = state.flags;
        uint param_33 = 4u;
        uint _3267 = rt_set_mask(param_32, param_33);
        state.flags = _3267;
    }
    state.material = hit_material;
}

int findClosestDDAMultibounce(ray_traversal_params traversal_params, inout ray_state state, inout int skip_fi, inout int closest_fi, inout float closest_it, int max_bounces)
{
    closest_fi = -1;
    closest_it = 1000000.0;
    vec3 cellDimension = in_bbox_data.grid_size_raytrace.xyz;
    vec3 cellDimensionRecip = in_bbox_data.grid_size_raytrace_recip.xyz;
    float tmin = 0.0;
    float tmax = traversal_params.trace_range_primary;
    vec3 ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
    ivec3 icell = ivec3(floor(ro_cell * cellDimensionRecip));
    vec3 s = step(vec3(0.0), state.dir);
    vec3 sgn = (s * 2.0) - vec3(1.0);
    vec3 deltaT = (sgn * cellDimension) / state.dir;
    vec3 nextCrossingT = vec3(tmin) + ((((floor(ro_cell * cellDimensionRecip) + s) * cellDimension) - ro_cell) / state.dir);
    uint traversal_flags = 0u;
    int max_iter = 1024;
    bool param = true;
    int threads_running = int(ballot_count(param));
    int param_42;
    uint param_43;
    float param_44;
    vec3 param_45;
    vec2 param_46;
    int param_47;
    for (;;)
    {
        bool hit = false;
        max_iter--;
        state.tests++;
        float rt = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
        uint param_1 = state.flags;
        uint param_2 = 32u;
        bool param_3 = rt >= tmax;
        uint _1866 = rt_clear_mask_if(param_1, param_2, param_3);
        state.flags = _1866;
        uint param_4 = state.flags;
        uint param_5 = 32u;
        bool param_6 = max_iter < 0;
        uint _1875 = rt_clear_mask_if(param_4, param_5, param_6);
        state.flags = _1875;
        uint param_7 = state.flags;
        uint param_8 = 32u;
        if (rt_is_mask_set(param_7, param_8) == false)
        {
            break;
        }
        uint param_9 = traversal_flags;
        uint param_10 = 1u;
        uint param_11 = traversal_flags;
        uint param_12 = 2u;
        bool param_13 = rt_is_mask_set(param_9, param_10);
        uint _1894 = rt_set_mask_if(param_11, param_12, param_13);
        traversal_flags = _1894;
        uint param_14 = traversal_flags;
        uint param_15 = 1u;
        uint _1898 = rt_clear_mask(param_14, param_15);
        traversal_flags = _1898;
        bool search_bucket = false;
        bool bucket_full = false;
        ivec3 param_16 = icell;
        if (is_pos_inside_grid(param_16))
        {
            uint param_17 = traversal_flags;
            uint param_18 = 1u;
            uint _1909 = rt_set_mask(param_17, param_18);
            traversal_flags = _1909;
            ivec3 param_19 = icell;
            int param_20 = 0;
            bucket_full = fetch_grid_marker_for_cell(param_19, param_20);
        }
        if (true)
        {
            bool _1930;
            if (!bucket_full)
            {
                bool _1923 = (traversal_flags & 1u) != 0u;
                bool _1929;
                if (_1923)
                {
                    _1929 = (traversal_flags & 2u) == 0u;
                }
                else
                {
                    _1929 = _1923;
                }
                _1930 = _1929;
            }
            else
            {
                _1930 = bucket_full;
            }
            bool done_criteria = _1930;
            bool param_21 = done_criteria;
            uint hit_threads = ballot_count(param_21);
            int ii = 0;
            for (;;)
            {
                if ((hit_threads < 16u) && (ii < 4))
                {
                    ii++;
                    if (done_criteria == false)
                    {
                        state.tests++;
                        max_iter--;
                        vec3 mm = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
                        vec3 param_22 = state.dir;
                        vec3 param_23 = mm;
                        icell += dda_step_from_dir(param_22, param_23);
                        nextCrossingT += (mm * deltaT);
                        uint param_24 = traversal_flags;
                        uint param_25 = 1u;
                        uint _1984 = rt_clear_mask(param_24, param_25);
                        traversal_flags = _1984;
                        ivec3 param_26 = icell;
                        if (is_pos_inside_grid(param_26))
                        {
                            uint param_27 = traversal_flags;
                            uint param_28 = 3u;
                            uint _1993 = rt_set_mask(param_27, param_28);
                            traversal_flags = _1993;
                        }
                        uint param_29 = traversal_flags;
                        uint param_30 = 1u;
                        if (rt_is_mask_set(param_29, param_30))
                        {
                            ivec3 param_31 = icell;
                            int param_32 = 0;
                            bucket_full = fetch_grid_marker_for_cell(param_31, param_32);
                        }
                        bool _2017;
                        if (!bucket_full)
                        {
                            bool _2010 = (traversal_flags & 2u) != 0u;
                            bool _2016;
                            if (_2010)
                            {
                                _2016 = (traversal_flags & 1u) == 0u;
                            }
                            else
                            {
                                _2016 = _2010;
                            }
                            _2017 = _2016;
                        }
                        else
                        {
                            _2017 = bucket_full;
                        }
                        done_criteria = _2017;
                    }
                    continue;
                }
                else
                {
                    break;
                }
            }
        }
        if (bucket_full)
        {
            uint icell_idx = uint((((icell.z * 256) * 256) + (icell.y * 256)) + icell.x);
            bool param_33 = true;
            state.active_threads_factor += ballot_count(param_33);
            state.active_threads_samples++;
            int face_tests = 0;
            uint max_tests = 4294967295u;
            bool _2050 = closest_fi == (-1);
            bool _2057;
            if (_2050)
            {
                _2057 = state.face_tests > 512;
            }
            else
            {
                _2057 = _2050;
            }
            if (_2057)
            {
                max_tests = 256u;
            }
            float rt_1 = tmin + min(nextCrossingT.x, min(nextCrossingT.y, nextCrossingT.z));
            ray_state_user_data param_34 = state.user_data;
            uint param_35 = icell_idx;
            bool param_36 = bucket_full;
            uint param_37 = max_tests;
            vec3 param_38 = state.origin;
            vec3 param_39 = state.dir;
            int param_40 = skip_fi;
            float param_41 = min(tmax, rt_1);
            findClosestBucket2(param_34, param_35, param_36, param_37, param_38, param_39, param_40, param_41, param_42, param_43, param_44, param_45, param_46, param_47);
            state.user_data = param_34;
            closest_fi = param_42;
            uint closest_material_flags = param_43;
            closest_it = param_44;
            vec3 closest_normal = param_45;
            vec2 closest_bc = param_46;
            face_tests = param_47;
            state.face_tests += face_tests;
            if (closest_fi != (-1))
            {
                state.bounces += 1s;
                state.normal = closest_normal;
                hit = true;
                skip_fi = closest_fi;
                bool _2134 = int(state.bounces) >= max_bounces;
                bool _2142;
                if (!_2134)
                {
                    _2142 = (closest_material_flags & 2048u) != 0u;
                }
                else
                {
                    _2142 = _2134;
                }
                if (_2142)
                {
                    uint param_48 = state.flags;
                    uint param_49 = 32u;
                    uint _2149 = rt_clear_mask(param_48, param_49);
                    state.flags = _2149;
                }
                int param_50 = closest_fi;
                vec3 param_51 = state.origin + (state.dir * closest_it);
                vec2 bc = barycentric_for_face_yz(param_50, param_51);
                if ((closest_material_flags & 128u) == 0u)
                {
                    int param_52 = closest_fi;
                    vec2 param_53 = bc;
                    vec3 param_54 = state.normal;
                    state.normal = interpolate_normal_from_bc_yz(param_52, param_53, param_54);
                }
                bool flip_normal_on_glass = false;
                if ((closest_material_flags & 32u) != 0u)
                {
                    flip_normal_on_glass = (dot(state.normal, state.dir) > 0.0) ? true : false;
                }
                vec3 prev_state_origin = state.origin;
                state.origin += (state.dir * closest_it);
                ray_state param_55 = state;
                vec3 param_56 = prev_state_origin;
                int param_57 = closest_fi;
                uint param_58 = closest_material_flags;
                vec2 param_59 = bc;
                bool param_60 = flip_normal_on_glass;
                evaluate_material(param_55, param_56, param_57, param_58, param_59, param_60);
                state = param_55;
                if (max_bounces > 1)
                {
                    vec3 ird = vec3(1.0) / state.dir;
                    ro_cell = state.origin - in_bbox_data.bbox_raytrace_min.xyz;
                    vec3 s_1 = step(vec3(0.0), state.dir);
                    vec3 sgn_1 = (s_1 * 2.0) - vec3(1.0);
                    deltaT = (sgn_1 * cellDimension) * ird;
                    nextCrossingT = vec3(tmin) + ((((floor(ro_cell * cellDimensionRecip) + s_1) * cellDimension) - ro_cell) * ird);
                    tmax = traversal_params.trace_range_secondary;
                    rt_1 = tmin;
                }
            }
        }
        uint param_61 = traversal_flags;
        uint param_62 = 1u;
        bool _2267 = rt_is_mask_set(param_61, param_62) == false;
        bool _2275;
        if (_2267)
        {
            uint param_63 = traversal_flags;
            uint param_64 = 2u;
            _2275 = rt_is_mask_set(param_63, param_64) == true;
        }
        else
        {
            _2275 = _2267;
        }
        if (_2275)
        {
            uint param_65 = state.flags;
            uint param_66 = 32u;
            uint _2282 = rt_clear_mask(param_65, param_66);
            state.flags = _2282;
            uint param_67 = state.flags;
            uint param_68 = 64u;
            uint _2288 = rt_set_mask(param_67, param_68);
            state.flags = _2288;
            uint param_69 = state.flags;
            uint param_70 = 8u;
            uint _2295 = rt_set_mask(param_69, param_70);
            state.flags = _2295;
        }
        if (!hit)
        {
            vec3 mm_1 = step(nextCrossingT, nextCrossingT.yxy) * step(nextCrossingT, nextCrossingT.zzx);
            vec3 param_71 = state.dir;
            vec3 param_72 = mm_1;
            icell += dda_step_from_dir(param_71, param_72);
            nextCrossingT += (mm_1 * deltaT);
        }
        continue;
    }
    return 0;
}

vec4 sample_env_map(vec3 r, float roughness)
{
    vec4 v = textureLod(s_reflection, r, 0.5 + (roughness * 15.0));
    return vec4(max(vec4(0.0), v));
}

void main()
{
    outHitInfo.x = 0u;
    ivec2 scaled_sample_pos = ivec2(gl_FragCoord.xy) * ivec2(_2329.rt_setup.screen_sampling_scale);
    ivec2 native_sample_pos = ivec2(gl_FragCoord.xy);
    vec4 color = vec4(1.0);
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos;
    vec3 dir = -normalize(_3418.transform_params.vCameraPosition - worldPos);
    vec3 origin = _3418.transform_params.vCameraPosition;
    int closest_fi = -1;
    int16_t material = 0s;
    uvec2 param = imageLoad(imMetalnessRoughnessMaterialTags, scaled_sample_pos).xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    float metalness = param_1;
    float roughness = param_2;
    uint materialIndex = param_3;
    if (materialIndex == 1u)
    {
    }
    material = int16_t(uint16_t(materialIndex));
    vec2 vd_pos = vec2(scaled_sample_pos) - ((_2329.rt_setup.frustum_shift * _2329.rt_setup.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_2329.rt_setup.camera_projection_params.z) + ((_2329.rt_setup.camera_projection_params.x * vd_pos.x) / _2329.rt_setup.resolution.x);
    view_direction.y = (-_2329.rt_setup.camera_projection_params.w) + ((_2329.rt_setup.camera_projection_params.y * vd_pos.y) / _2329.rt_setup.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float param_4 = texelFetch(sTextureDepth, native_sample_pos, 0).x;
    float depth = linearizeDepth(param_4);
    vec3 param_5 = view_direction;
    float param_6 = depth;
    vec3 view_coords = positionFromDepth(param_5, param_6);
    view_coords = (_2329.rt_setup.mat_model * vec4(view_coords, 1.0)).xyz;
    dir = -normalize(_3418.transform_params.vCameraPosition - view_coords);
    float closest_it = length(origin - view_coords);
    uint encoded_normal_material = imageLoad(imNormalMaterial, scaled_sample_pos).x;
    uint param_7 = encoded_normal_material;
    vec3 _3549 = decode_normal(param_7);
    vec3 normal = vec3(normalize(_3549));
    vec3 worldNorm = normal;
    vec3 ro = (origin + (dir * closest_it)) - in_bbox_data.bbox_raytrace_min.xyz;
    ivec3 icell = ivec3(floor(ro * in_bbox_data.grid_size_raytrace_recip.xyz));
    bool _3577 = icell.x >= 0;
    bool _3583;
    if (_3577)
    {
        _3583 = icell.y >= 0;
    }
    else
    {
        _3583 = _3577;
    }
    bool _3589;
    if (_3583)
    {
        _3589 = icell.z >= 0;
    }
    else
    {
        _3589 = _3583;
    }
    bool _3595;
    if (_3589)
    {
        _3595 = icell.x < 256;
    }
    else
    {
        _3595 = _3589;
    }
    bool _3601;
    if (_3595)
    {
        _3601 = icell.y < 256;
    }
    else
    {
        _3601 = _3595;
    }
    bool _3607;
    if (_3601)
    {
        _3607 = icell.z < 256;
    }
    else
    {
        _3607 = _3601;
    }
    if (_3607)
    {
        uint icell_idx = uint(((icell.z * 65536) + (icell.y * 256)) + icell.x);
    }
    origin += (dir * closest_it);
    ray_traversal_params traversal_params;
    traversal_params.trace_range_primary = _2329.rt_setup.trace_range_primary;
    traversal_params.trace_range_secondary = _2329.rt_setup.trace_range_secondary;
    vec4 albedo_value = imageLoad(imAlbedo, scaled_sample_pos);
    ray_state state;
    state.color = vec3(1.0);
    float _3648;
    if (materials.material_properties[material].transparency == 0.0)
    {
        _3648 = 1.0;
    }
    else
    {
        _3648 = materials.material_properties[material].transparency;
    }
    state.transparency = _3648;
    state.transparency = 1.0 - ((1.0 - state.transparency) * albedo_value.w);
    state.normal = normal;
    state.material = material;
    state.dir = dir;
    state.origin = origin;
    state.bounces = 1s;
    state.tests = 0;
    state.face_tests = 0;
    state.active_threads_factor = 0u;
    state.active_threads_samples = 0u;
    state.final_color_factor = 1.0;
    state.flags = 0u;
    uint param_8 = state.flags;
    uint param_9 = 32u;
    uint _3684 = rt_set_mask(param_8, param_9);
    state.flags = _3684;
    bool pre_step_along_ray = false;
    bool pre_step_along_normal = !pre_step_along_ray;
    if ((materials.material_properties[material].flags & 2048u) != 0u)
    {
        state.bounces = 3s;
    }
    bool _3702 = materials.material_properties[material].roughness == 1.0;
    bool _3710;
    if (_3702)
    {
        _3710 = (materials.material_properties[material].flags & 32u) == 0u;
    }
    else
    {
        _3710 = _3702;
    }
    if (_3710)
    {
        dir = reflect(dir, vec3(normal));
        uint param_10 = state.flags;
        uint param_11 = 4u;
        uint _3724 = rt_set_mask(param_10, param_11);
        state.flags = _3724;
    }
    else
    {
        if ((materials.material_properties[material].flags & 32u) != 0u)
        {
        }
        if ((materials.material_properties[state.material].flags & 32u) == 0u)
        {
            if (pre_step_along_normal)
            {
                state.origin += (vec3(normal) * _2329.rt_setup.initial_face_start_distance);
            }
            state.dir = reflect(state.dir, vec3(state.normal));
            if (state.final_color_factor <= 0.0)
            {
                return;
            }
        }
        else
        {
            if (pre_step_along_normal)
            {
                state.origin += (vec3(-normal) * _2329.rt_setup.initial_face_start_distance);
            }
            vec3 param_12 = state.dir;
            vec3 param_13 = -state.normal;
            state.dir = glass_refract(param_12, param_13);
            uint param_14 = state.flags;
            uint param_15 = 16u;
            uint _3803 = rt_set_mask(param_14, param_15);
            state.flags = _3803;
        }
        if (materials.material_properties[state.material].roughness > 0.0)
        {
            ivec2 param_16 = ivec2(native_sample_pos);
            vec3 param_17 = state.dir;
            vec3 param_18 = state.normal;
            float param_19 = materials.material_properties[state.material].roughness;
            float param_20;
            vec3 _3829 = rt_randomize_dir_for_roughness(param_16, param_17, param_18, param_19, param_20);
            state.final_color_factor = param_20;
            state.dir = _3829;
        }
        dir = state.dir;
        if (pre_step_along_ray)
        {
            state.origin += (state.dir * _2329.rt_setup.initial_face_start_distance);
        }
        ray_traversal_params param_21 = traversal_params;
        ray_state param_22 = state;
        int param_23 = closest_fi;
        int param_26 = 4;
        int param_24;
        float param_25;
        int _3856 = findClosestDDAMultibounce(param_21, param_22, param_23, param_24, param_25, param_26);
        state = param_22;
        closest_fi = param_24;
        closest_it = param_25;
        uint param_27 = state.flags;
        uint param_28 = 4u;
        bool _3865 = rt_is_mask_set(param_27, param_28) == false;
        bool _3872;
        if (_3865)
        {
            _3872 = state.bounces >= 2s;
        }
        else
        {
            _3872 = _3865;
        }
        if (_3872)
        {
            float current_roughness = materials.material_properties[state.material].roughness;
            if ((materials.material_properties[state.material].flags & 32u) != 0u)
            {
                vec3 param_29 = state.dir;
                float param_30 = current_roughness;
                vec3 env_map_color = sample_env_map(param_29, param_30).xyz;
                state.color = mix(state.color, env_map_color, vec3(1.0 - state.transparency));
            }
            else
            {
                vec3 param_31 = dir;
                float param_32 = current_roughness;
                vec3 mat_color = vec3(mix(materials.material_properties[material].diffuse * sample_env_map(param_31, param_32).xyz, materials.material_properties[material].diffuse, vec3(materials.material_properties[material].roughness)));
                vec3 param_33 = state.dir;
                float param_34 = current_roughness;
                state.color = vec3(mix(state.color, state.color * sample_env_map(param_33, param_34).xyz, vec3(state.transparency)));
                state.color = vec3(mix(mat_color, state.color, vec3(state.transparency)));
            }
        }
        else
        {
            uint param_35 = state.flags;
            uint param_36 = 4u;
            bool _3968 = rt_is_mask_set(param_35, param_36) == false;
            bool _3974;
            if (_3968)
            {
                _3974 = state.bounces < 2s;
            }
            else
            {
                _3974 = _3968;
            }
            if (_3974)
            {
                state.color = vec3(0.0);
            }
        }
    }
    vec3 _3982 = state.color * state.final_color_factor;
    color.x = _3982.x;
    color.y = _3982.y;
    color.z = _3982.z;
    uint param_37 = state.flags;
    uint param_38 = 4u;
    if (rt_is_mask_set(param_37, param_38))
    {
    }
    if (materials.material_properties[material].transparency == 0.0)
    {
        outAlbedo.w = 0.0;
    }
    else
    {
        outAlbedo.w = state.transparency;
    }
    outHitInfo.x = uint(int(state.bounces));
    outAlbedo.x = color.xyz.x;
    outAlbedo.y = color.xyz.y;
    outAlbedo.z = color.xyz.z;
}

 