#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ParticleEmitterGeometry_Params
{
    int constrained;
    int debug_counter;
    int debug_counter2;
    int debug_counter3;
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    float surface_distance;
    int pending;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int alpha_to_modifier_factor;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint reset;
    uint _pad1;
};

struct ParticleModifierColorize_Params
{
    vec4 color;
    int mode;
    int blend_mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM2Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _495;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _519;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _542;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _1451;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _1505;

layout(set = 0, binding = 8, std140) uniform VM0_0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_0_params;
} _1678;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _1708;

layout(set = 0, binding = 9, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _2082;

layout(set = 0, binding = 10, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _2277;

layout(set = 0, binding = 7, std430) buffer VM0
{
    ParticleEmitterGeometry_Params VM0_params;
} _2321;

layout(set = 0, binding = 11, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _2350;

layout(set = 0, binding = 12, std140) uniform VM2
{
    VM2Params VM2_params;
} _2366;

layout(set = 0, binding = 13, std140) uniform VM3
{
    ParticleModifierCurl_Params VM3_params;
} _2391;

layout(set = 0, binding = 14, std140) uniform VM4
{
    ParticleModifierColorize_Params VM4_params;
} _2420;

layout(set = 0, binding = 15) uniform sampler2D s_Curves;
layout(set = 0, binding = 16) uniform sampler2D s_Gradients;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_542.prt_prev_positions[(id * 3u) + 0u], _542.prt_prev_positions[(id * 3u) + 1u], _542.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _501;
    _501.life_time = _495.prt_states[id].life_time;
    _501.life_span = _495.prt_states[id].life_span;
    _501.generation_id = _495.prt_states[id].generation_id;
    _501.color = _495.prt_states[id].color;
    ParticleState _500 = _501;
    return _500;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

uint particle_emitter_geometry_get_first_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1708.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1708.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _475 = hash(param);
    uint param_1 = _475;
    float _477 = floatConstruct(param_1);
    return _477;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _1505.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _1505.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _1505.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_1451.in_vtx_data[coord_offset + 0u], _1451.in_vtx_data[coord_offset + 1u], _1451.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_1451.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _1580 = vector_transform_by_mat43(param, param_1);
        coords = _1580;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _1591 = vector_transform_by_mat43(param_2, param_3);
            coords = _1591;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1601 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1601;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

ModifierFactor particle_emitter_geometry_emit_evaluate_modifier_VM0(inout ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorDistanceRadial_Params _1683;
    _1683.transform_local_to_gizmo = _1678.VM0_0_params.transform_local_to_gizmo;
    _1683.falloff_curve_idx = _1678.VM0_0_params.falloff_curve_idx;
    _1683.falloff_inverse = _1678.VM0_0_params.falloff_inverse;
    _1683.domain_repeat_x = _1678.VM0_0_params.domain_repeat_x;
    _1683.domain_repeat_y = _1678.VM0_0_params.domain_repeat_y;
    _1683.domain_repeat_z = _1678.VM0_0_params.domain_repeat_z;
    _1683.influence_scope = _1678.VM0_0_params.influence_scope;
    _1683.modifier_function = _1678.VM0_0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param = _1683;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_distance_radial(param, param_1, param_2);
    modifier_factor = param_1;
    return modifier_factor;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _578 = color_convert_rgb_float3_uint(param);
    uint v = _578;
    state.color = v;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

void particle_emitter_geometry_emit_VM0(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    int iteration = 0;
    for (;;)
    {
        if (iteration < 5)
        {
            float fid = float((id + uint(iteration * 45827)) & 16777215u);
            float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
            float param_2 = fid_seed * 5.131999969482421875;
            float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
            float param_3 = fid_seed;
            uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
            face_idx += first_face_idx;
            uint param_4 = face_idx;
            RTFace rt_face = rt_get_face(param_4);
            uint p0_idx = rt_face.v0;
            uint p1_idx = rt_face.v1;
            uint p2_idx = rt_face.v2;
            uint param_5 = p0_idx;
            vec3 p0 = rt_get_vertex(param_5);
            uint param_6 = p1_idx;
            vec3 p1 = rt_get_vertex(param_6);
            uint param_7 = p2_idx;
            vec3 p2 = rt_get_vertex(param_7);
            uint param_8 = p0_idx;
            vec4 c0 = rt_get_vertex_color(param_8);
            uint param_9 = p1_idx;
            vec4 c1 = rt_get_vertex_color(param_9);
            uint param_10 = p2_idx;
            vec4 c2 = rt_get_vertex_color(param_10);
            float param_11 = fid_seed * 0.34130001068115234375;
            bc.x = random(param_11);
            float param_12 = fid_seed * 0.1412999927997589111328125;
            bc.y = random(param_12);
            if ((bc.x + bc.y) >= 1.0)
            {
                bc.x = 1.0 - bc.x;
                bc.y = 1.0 - bc.y;
            }
            vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
            vec4 color = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
            ModifierFactor local_modifier_factor = modifier_factor_defaults();
            local_modifier_factor.factor = 1.0;
            local_modifier_factor.hash = floatBitsToUint(fid_seed);
            local_modifier_factor.id = id;
            local_modifier_factor.position = pos;
            local_modifier_factor.is_spawned = true;
            local_modifier_factor.color = color;
            ModifierFactor param_13 = local_modifier_factor;
            ModifierFactor _1920 = particle_emitter_geometry_emit_evaluate_modifier_VM0(param_13);
            local_modifier_factor = _1920;
            if (local_modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
            {
                int _2017 = iteration;
                iteration = _2017 + 1;
                continue;
            }
            float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
            if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
            {
                if (emitter_params.surface_distance > 0.0)
                {
                    vec3 n = normalize(cross(p0 - p1, p0 - p2));
                    pos += (n * emitter_params.surface_distance);
                }
                if (pos.x == 1234566.0)
                {
                    pos += vec3(fid_seed);
                }
                if (pos.x == 1234567.0)
                {
                    pos += vec3(fid_seed * 5.131999969482421875);
                }
                p.pos = pos;
                ParticleState param_14 = p.state;
                vec3 param_15 = emitter_params.particle_color.xyz;
                prt_set_color(param_14, param_15);
                p.state = param_14;
                ParticleState param_16 = p.state;
                float param_17 = lifetime;
                prt_spawn(param_16, param_17);
                p.state = param_16;
                if (emitter_params.alpha_to_modifier_factor != 0)
                {
                    modifier_factor.factor = color.w;
                }
                emitted = true;
                break;
            }
            int _2017 = iteration;
            iteration = _2017 + 1;
            continue;
        }
        else
        {
            break;
        }
    }
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _2033 = vector_transform_by_mat43(param, param_1);
        coords = _2033;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _2040 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _2040;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec4 saturate(vec4 a)
{
    return max(min(a, vec4(1.0)), vec4(0.0));
}

uvec2 btn_pcg4d16(uvec4 p)
{
    uvec4 v = (p * uvec4(1664525u)) + uvec4(1013904223u);
    v.x += (v.y * v.w);
    v.y += (v.z * v.x);
    v.z += (v.x * v.y);
    v.w += (v.y * v.z);
    v.x += (v.y * v.w);
    v.y += (v.z * v.x);
    return v.xy;
}

vec4 btn_gradient4d(uint hash_1)
{
    vec4 g = vec4(uvec4(hash_1) & uvec4(524288u, 262144u, 131072u, 65536u));
    return (g * vec4(3.814697265625e-06, 7.62939453125e-06, 1.52587890625e-05, 3.0517578125e-05)) - vec4(1.0);
}

vec3 saturate(vec3 a)
{
    return max(vec3(0.0), min(vec3(1.0), a));
}

vec2 saturate(vec2 a)
{
    return max(vec2(0.0), min(vec2(1.0), a));
}

vec3 BitangentNoise4D(vec4 p)
{
    vec4 i = floor(p + vec4(dot(p, vec4(0.309017002582550048828125))));
    vec4 x0 = (p - i) + vec4(dot(i, vec4(0.13819660246372222900390625)));
    vec3 isX = step(x0.yzw, x0.xxx);
    vec3 isYZ = step(x0.zww, x0.yyz);
    vec4 i0;
    i0.x = (isX.x + isX.y) + isX.z;
    vec3 _1072 = vec3(1.0) - isX;
    i0.y = _1072.x;
    i0.z = _1072.y;
    i0.w = _1072.z;
    i0.y += (isYZ.x + isYZ.y);
    vec4 _1092 = i0;
    vec2 _1094 = _1092.zw + (vec2(1.0) - isYZ.xy);
    i0.z = _1094.x;
    i0.w = _1094.y;
    i0.z += isYZ.z;
    i0.w += (1.0 - isYZ.z);
    vec4 param = i0;
    vec4 i3 = saturate(param);
    vec4 param_1 = i0 - vec4(1.0);
    vec4 i2 = saturate(param_1);
    vec4 param_2 = i0 - vec4(2.0);
    vec4 i1 = saturate(param_2);
    vec4 x1 = (x0 - i1) + vec4(0.13819660246372222900390625);
    vec4 x2 = (x0 - i2) + vec4(0.2763932049274444580078125);
    vec4 x3 = (x0 - i3) + vec4(0.4145897924900054931640625);
    vec4 x4 = x0 + vec4(-0.447213590145111083984375);
    i += vec4(32768.5);
    uvec4 param_3 = uvec4(i);
    uvec2 hash0 = btn_pcg4d16(param_3);
    uvec4 param_4 = uvec4(i + i1);
    uvec2 hash1 = btn_pcg4d16(param_4);
    uvec4 param_5 = uvec4(i + i2);
    uvec2 hash2 = btn_pcg4d16(param_5);
    uvec4 param_6 = uvec4(i + i3);
    uvec2 hash3 = btn_pcg4d16(param_6);
    uvec4 param_7 = uvec4(i + vec4(1.0));
    uvec2 hash4 = btn_pcg4d16(param_7);
    uint param_8 = hash0.x;
    vec4 p00 = btn_gradient4d(param_8);
    uint param_9 = hash0.y;
    vec4 p01 = btn_gradient4d(param_9);
    uint param_10 = hash1.x;
    vec4 p10 = btn_gradient4d(param_10);
    uint param_11 = hash1.y;
    vec4 p11 = btn_gradient4d(param_11);
    uint param_12 = hash2.x;
    vec4 p20 = btn_gradient4d(param_12);
    uint param_13 = hash2.y;
    vec4 p21 = btn_gradient4d(param_13);
    uint param_14 = hash3.x;
    vec4 p30 = btn_gradient4d(param_14);
    uint param_15 = hash3.y;
    vec4 p31 = btn_gradient4d(param_15);
    uint param_16 = hash4.x;
    vec4 p40 = btn_gradient4d(param_16);
    uint param_17 = hash4.y;
    vec4 p41 = btn_gradient4d(param_17);
    vec3 param_18 = vec3(0.60000002384185791015625) - vec3(dot(x0, x0), dot(x1, x1), dot(x2, x2));
    vec3 m0 = saturate(param_18);
    vec2 param_19 = vec2(0.60000002384185791015625) - vec2(dot(x3, x3), dot(x4, x4));
    vec2 m1 = saturate(param_19);
    vec3 m02 = m0 * m0;
    vec3 m03 = m02 * m0;
    vec2 m12 = m1 * m1;
    vec2 m13 = m12 * m1;
    vec3 temp0 = m02 * vec3(dot(p00, x0), dot(p10, x1), dot(p20, x2));
    vec2 temp1 = m12 * vec2(dot(p30, x3), dot(p40, x4));
    vec4 grad0 = (((((x0 * temp0.x) + (x1 * temp0.y)) + (x2 * temp0.z)) + (x3 * temp1.x)) + (x4 * temp1.y)) * (-6.0);
    grad0 += (((((p00 * m03.x) + (p10 * m03.y)) + (p20 * m03.z)) + (p30 * m13.x)) + (p40 * m13.y));
    temp0 = m02 * vec3(dot(p01, x0), dot(p11, x1), dot(p21, x2));
    temp1 = m12 * vec2(dot(p31, x3), dot(p41, x4));
    vec4 grad1 = (((((x0 * temp0.x) + (x1 * temp0.y)) + (x2 * temp0.z)) + (x3 * temp1.x)) + (x4 * temp1.y)) * (-6.0);
    grad1 += (((((p01 * m03.x) + (p11 * m03.y)) + (p21 * m03.z)) + (p31 * m13.x)) + (p41 * m13.y));
    return cross(grad0.xyz, grad1.xyz) * 81.0;
}

void particle_modifier_curl_fast(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec4 param = vec4(p.pos * modifier_params.noise_scale, _2082.globals.time * modifier_params.noise_speed);
    vec3 n = BitangentNoise4D(param);
    n = normalize(n);
    p.pos += (((n * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _565 = color_convert_uint_to_float3(param);
    c.x = _565.x;
    c.y = _565.y;
    c.z = _565.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    float v = 0.0;
    if (uint(modifier_params.mode) == 0u)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (uint(modifier_params.mode) == 1u)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (uint(modifier_params.mode) == 2u)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    if (uint(modifier_params.mode) == 3u)
    {
        v = 1.0;
    }
    v = fract(v);
    vec3 color;
    if (modifier_params.color_gradient_idx != (-1))
    {
        int param_2 = modifier_params.color_gradient_idx;
        float param_3 = v;
        color = gradient_sample(param_2, param_3).xyz * modifier_params.color.xyz;
    }
    else
    {
        color = modifier_params.color.xyz;
    }
    if (uint(modifier_params.blend_mode) == 0u)
    {
        ParticleState param_4 = p.state;
        vec4 color_previous = prt_get_color(param_4);
        color = mix(color_previous.xyz, color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
    }
    else
    {
        if (uint(modifier_params.blend_mode) == 2u)
        {
            color = mix(vec3(1.0), color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
        }
        else
        {
            if (uint(modifier_params.blend_mode) == 1u)
            {
                color = mix(vec3(0.0), color, vec3(modifier_params.blend_from_previous * modifier_factor.factor));
            }
        }
    }
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _508;
    _508.life_time = state.life_time;
    _508.life_span = state.life_span;
    _508.generation_id = state.generation_id;
    _508.color = state.color;
    _495.prt_states[id] = _508;
}

void prt_set_position(uint id, vec3 p)
{
    _519.prt_positions[(id * 3u) + 0u] = p.x;
    _519.prt_positions[(id * 3u) + 1u] = p.y;
    _519.prt_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    if (_2277.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = p.pos;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_3 = p.state;
    if (!prt_is_alive(param_3))
    {
        int _2325 = atomicAdd(_2321.VM0_params.pending, -1);
        int pending = _2325;
        if (pending > 0)
        {
            ParticleEmitterGeometry_Params _2336;
            _2336.constrained = _2321.VM0_params.constrained;
            _2336.debug_counter = _2321.VM0_params.debug_counter;
            _2336.debug_counter2 = _2321.VM0_params.debug_counter2;
            _2336.debug_counter3 = _2321.VM0_params.debug_counter3;
            _2336.position = _2321.VM0_params.position;
            _2336.falloff_mode = _2321.VM0_params.falloff_mode;
            _2336.radius = _2321.VM0_params.radius;
            _2336.falloff_inverse = _2321.VM0_params.falloff_inverse;
            _2336.particle_color = _2321.VM0_params.particle_color;
            _2336.particle_lifetime = _2321.VM0_params.particle_lifetime;
            _2336.particle_lifetime_randomness = _2321.VM0_params.particle_lifetime_randomness;
            _2336.rate = _2321.VM0_params.rate;
            _2336.seed = _2321.VM0_params.seed;
            _2336.surface_distance = _2321.VM0_params.surface_distance;
            _2336.pending = _2321.VM0_params.pending;
            _2336.transformed_data_location_idx = _2321.VM0_params.transformed_data_location_idx;
            _2336.transformed_data_location_num = _2321.VM0_params.transformed_data_location_num;
            _2336.alpha_to_modifier_factor = _2321.VM0_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_4 = _2336;
            ModifierFactor param_5 = modifier_factor;
            Particle param_6 = p;
            uint param_7 = id;
            uint param_8 = uint(pending);
            particle_emitter_geometry_emit_VM0(param_4, param_5, param_6, param_7, param_8);
            modifier_factor = param_5;
            p = param_6;
        }
    }
    ModifierFactorNoise_Params _2355;
    _2355.transform_local_to_gizmo = _2350.VM1_params.transform_local_to_gizmo;
    _2355.noise_domain_scale = _2350.VM1_params.noise_domain_scale;
    _2355.modifier_function = _2350.VM1_params.modifier_function;
    _2355.noise_domain_offset = _2350.VM1_params.noise_domain_offset;
    _2355.noise_value_scale = _2350.VM1_params.noise_value_scale;
    _2355.noise_value_offset = _2350.VM1_params.noise_value_offset;
    _2355.influence_scope = _2350.VM1_params.influence_scope;
    _2355._pad0 = _2350.VM1_params._pad0;
    _2355._pad1 = _2350.VM1_params._pad1;
    ModifierFactorNoise_Params param_9 = _2355;
    ModifierFactor param_10 = modifier_factor;
    CoordinateSystemTrasforms param_11 = cs_transforms;
    modifier_factor_noise_default(param_9, param_10, param_11);
    modifier_factor = param_10;
    vec3 modifier_position = _2366.VM2_params.position;
    p.pos += ((_2366.VM2_params.velocity * _2277.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_12 = p.state;
    if (prt_is_alive(param_12))
    {
        ParticleModifierCurl_Params _2396;
        _2396.position = _2391.VM3_params.position;
        _2396.falloff_mode = _2391.VM3_params.falloff_mode;
        _2396.radius = _2391.VM3_params.radius;
        _2396.falloff_inverse = _2391.VM3_params.falloff_inverse;
        _2396.noise_strength = _2391.VM3_params.noise_strength;
        _2396.noise_speed = _2391.VM3_params.noise_speed;
        _2396.noise_scale = _2391.VM3_params.noise_scale;
        ParticleModifierCurl_Params param_13 = _2396;
        ParticleLifecycleParams _2401;
        _2401.time_step = _2277.lifecycle_params.time_step;
        _2401.max_lifetime = _2277.lifecycle_params.max_lifetime;
        _2401.reset = _2277.lifecycle_params.reset;
        _2401._pad1 = _2277.lifecycle_params._pad1;
        ParticleLifecycleParams param_14 = _2401;
        ModifierFactor param_15 = modifier_factor;
        Particle param_16 = p;
        uint param_17 = id;
        particle_modifier_curl_fast(param_13, param_14, param_15, param_16, param_17);
        modifier_factor = param_15;
        p = param_16;
    }
    ParticleState param_18 = p.state;
    if (prt_is_alive(param_18))
    {
        ParticleModifierColorize_Params _2425;
        _2425.color = _2420.VM4_params.color;
        _2425.mode = _2420.VM4_params.mode;
        _2425.blend_mode = _2420.VM4_params.blend_mode;
        _2425.color_gradient_idx = _2420.VM4_params.color_gradient_idx;
        _2425.randomness = _2420.VM4_params.randomness;
        _2425.blend_from_previous = _2420.VM4_params.blend_from_previous;
        ParticleModifierColorize_Params param_19 = _2425;
        ModifierFactor param_20 = modifier_factor;
        Particle param_21 = p;
        uint param_22 = id;
        particle_modifier_colorize(param_19, param_20, param_21, param_22);
        modifier_factor = param_20;
        p = param_21;
    }
    ParticleState param_23 = p.state;
    float param_24 = _2277.lifecycle_params.time_step;
    float param_25 = _2277.lifecycle_params.max_lifetime;
    prt_advance_life(param_23, param_24, param_25);
    p.state = param_23;
    uint param_26 = id;
    ParticleState param_27 = p.state;
    prt_set_state(param_26, param_27);
    uint param_28 = id;
    vec3 param_29 = p.pos;
    prt_set_position(param_28, param_29);
}

 