#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchDeferredParams
{
    mat4 mat_projection;
    mat4 mat_projection_previous;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 camera_projection_params_previous;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
    vec2 frustum_shift;
};

struct RenderBackgroundParams
{
    vec4 fog_color;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchDeferredParams dispatch_setup;
} _232;

layout(set = 0, binding = 2, std140) uniform RenderBackgroundParamsBuffer
{
    RenderBackgroundParams render_background_params;
} _395;

layout(set = 0, binding = 3, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 6) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 4, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 7) uniform samplerCube sEnviromentMap;
layout(set = 0, binding = 5, rgba16f) uniform writeonly image2D imTarget;

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec3 deferred_get_view_direction_from_screen_pos(DispatchDeferredParams ddp, vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((ddp.frustum_shift * ddp.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-ddp.camera_projection_params.z) + ((ddp.camera_projection_params.x * vd_pos.x) * ddp.inv_resolution.x);
    view_direction.y = (-ddp.camera_projection_params.w) + ((ddp.camera_projection_params.y * vd_pos.y) * ddp.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _163;
    if (nor.x > 0.0)
    {
        _163 = -t;
    }
    else
    {
        _163 = t;
    }
    nor.x += _163;
    float _178;
    if (nor.y > 0.0)
    {
        _178 = -t;
    }
    else
    {
        _178 = t;
    }
    nor.y += _178;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

float linearizeDepth(float d)
{
    return _232.dispatch_setup.near_far_plane.z / ((_232.dispatch_setup.near_far_plane.y + _232.dispatch_setup.near_far_plane.x) - (d * _232.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_232.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    ivec2 pos = ivec2(pixel_pos);
    uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
    uint param = encoded_normal_material;
    int materialId = decode_material(param);
    if ((materialId & 1) != 1)
    {
    }
    else
    {
        DispatchDeferredParams _313;
        _313.mat_projection = _232.dispatch_setup.mat_projection;
        _313.mat_projection_previous = _232.dispatch_setup.mat_projection_previous;
        _313.mat_model = _232.dispatch_setup.mat_model;
        _313.mat_model_previous = _232.dispatch_setup.mat_model_previous;
        _313.mat_view_inverse = _232.dispatch_setup.mat_view_inverse;
        _313.mat_view_previous = _232.dispatch_setup.mat_view_previous;
        _313.camera_position = _232.dispatch_setup.camera_position;
        _313.camera_projection_params = _232.dispatch_setup.camera_projection_params;
        _313.camera_projection_params_previous = _232.dispatch_setup.camera_projection_params_previous;
        _313.near_far_plane = _232.dispatch_setup.near_far_plane;
        _313.resolution = _232.dispatch_setup.resolution;
        _313.inv_resolution = _232.dispatch_setup.inv_resolution;
        _313.frustum_shift = _232.dispatch_setup.frustum_shift;
        DispatchDeferredParams param_1 = _313;
        vec2 param_2 = vec2(pos);
        vec3 view_direction = deferred_get_view_direction_from_screen_pos(param_1, param_2);
        uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
        uint param_3 = encoded_normal_material_1;
        vec3 _324 = decode_normal(param_3);
        vec3 vNorm = _324;
        uint param_4 = encoded_normal_material_1;
        int materialId_1 = decode_material(param_4);
        float param_5 = texelFetch(sTextureDepth, pos, 0).x;
        float depth = linearizeDepth(param_5);
        vec3 param_6 = view_direction;
        float param_7 = depth;
        vec3 world = positionFromDepth(param_6, param_7);
        uvec2 param_8 = imageLoad(imMetalnessRoughnessMaterialTags, pos).xy;
        float param_9;
        float param_10;
        uint param_11;
        decode_metalness_roughness_material(param_8, param_9, param_10, param_11);
        float metalness = param_9;
        float roughness = param_10;
        uint material = param_11;
        vec3 dir = world - _232.dispatch_setup.camera_position;
        float max_t = length(dir);
        dir /= vec3(max_t);
        vec3 ro = _232.dispatch_setup.camera_position;
        vec3 rd = dir;
        float fog_blend = 1.0 - pow(clamp(rd.y, 0.0, 1.0), 0.89999997615814208984375);
        vec3 fog_color = _395.render_background_params.fog_color.xyz;
        vec3 env_map = textureLod(sEnviromentMap, normalize(rd), 0.0).xyz;
        imageStore(imTarget, pos, vec4(mix(env_map, fog_color, vec3(fog_blend)), 1.0));
    }
}

 