#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 5, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _88;

layout(set = 0, binding = 6, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _101;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _115;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _141;

layout(set = 0, binding = 3, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _166;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _174;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_88.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_101.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _115.instance_transform[(id * 3u) + 0u];
    instance.m1 = _115.instance_transform[(id * 3u) + 1u];
    instance.m2 = _115.instance_transform[(id * 3u) + 2u];
    vec2 _148 = unpackHalf2x16(_141.instance_color[(id * 2u) + 0u]);
    instance.c.x = _148.x;
    instance.c.y = _148.y;
    vec2 _158 = unpackHalf2x16(_141.instance_color[(id * 2u) + 1u]);
    instance.c.z = _158.x;
    instance.c.w = _158.y;
    instance.flipbook_card = _166.instance_flipbook_card[id];
    instance.hash = _174.instance_hash[id];
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = instance.hash;
    modifier_factor.id = id;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.is_spawned = false;
    modifier_factor.instance_id = id;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    _115.instance_transform[(id * 3u) + 0u] = instance.m0;
    _115.instance_transform[(id * 3u) + 1u] = instance.m1;
    _115.instance_transform[(id * 3u) + 2u] = instance.m2;
    _141.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _141.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _166.instance_flipbook_card[id] = instance.flipbook_card;
}

 