#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct RaytraceRefinementToStencilParams
{
    int scale_denominator;
    int material_flags;
    int _pad0;
    int _pad1;
};

layout(set = 1, binding = 1, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _117;

layout(set = 1, binding = 2, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 3, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 1, binding = 4, rgba32f) uniform readonly image2D imHitDirectionPrimitiveIDReflection;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

int rt_get_triangle_material(uint idx)
{
    int p = int(_117.transformed_data_faces[idx].material_idx);
    return p;
}

void main()
{
    ivec2 pixel_pos = ivec2(gl_FragCoord.xy);
    uvec4 param = imageLoad(imMetalnessRoughnessMaterialTags, pixel_pos);
    MetalnessRoughnessMeterialTags mrmt = decode_metalness_roughness_material_tags(param);
    bool is_background = true;
    uint encoded_normal_material = imageLoad(imNormalMaterial, pixel_pos).x;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    if ((materialId & 1) != 1)
    {
        is_background = false;
    }
    if (is_background)
    {
        discard;
    }
    vec4 hit_direction_primitiveID_reflection = imageLoad(imHitDirectionPrimitiveIDReflection, pixel_pos);
    float param_2 = hit_direction_primitiveID_reflection.w;
    uint hit_primitiveID = asuint(param_2);
    uint param_3 = hit_primitiveID;
    int hit_material = rt_get_triangle_material(param_3);
    bool is_candidate = false;
    uint x0 = uint(pixel_pos.x & (-2));
    uint y0 = uint(pixel_pos.y & (-2));
    int iy = 0;
    for (;;)
    {
        if (iy < 2)
        {
            int ix = 0;
            for (;;)
            {
                if (ix < 2)
                {
                    ivec2 neighbor_pixel_pos = ivec2(int(x0), int(y0)) + ivec2(ix, iy);
                    ivec2 neighbor_block_pixel_pos = ivec2(int(x0), int(y0)) + (ivec2(ix, iy) * ivec2(2));
                    bool _243 = neighbor_pixel_pos.x == pixel_pos.x;
                    bool _251;
                    if (_243)
                    {
                        _251 = neighbor_pixel_pos.y == pixel_pos.y;
                    }
                    else
                    {
                        _251 = _243;
                    }
                    if (_251)
                    {
                        int _300 = ix;
                        ix = _300 + 1;
                        continue;
                    }
                    uvec4 param_4 = imageLoad(imMetalnessRoughnessMaterialTags, neighbor_pixel_pos);
                    MetalnessRoughnessMeterialTags neighbor_mrmt = decode_metalness_roughness_material_tags(param_4);
                    uint neighbor_encoded_normal_material = imageLoad(imNormalMaterial, neighbor_pixel_pos).x;
                    uint param_5 = neighbor_encoded_normal_material;
                    int neighbor_materialId = decode_material(param_5);
                    if ((neighbor_materialId & 1) != 1)
                    {
                        if (mrmt.material_index != neighbor_mrmt.material_index)
                        {
                            is_candidate = true;
                        }
                        vec4 neighbor_hit_direction_primitiveID = imageLoad(imHitDirectionPrimitiveIDReflection, neighbor_block_pixel_pos);
                        float param_6 = neighbor_hit_direction_primitiveID.w;
                        uint neighbor_hit_primitiveID = asuint(param_6);
                        uint param_7 = neighbor_hit_primitiveID;
                        int neighbor_hit_material = rt_get_triangle_material(param_7);
                        if (hit_material != neighbor_hit_material)
                        {
                            is_candidate = true;
                        }
                    }
                    int _300 = ix;
                    ix = _300 + 1;
                    continue;
                }
                else
                {
                    break;
                }
            }
            iy++;
            continue;
        }
        else
        {
            break;
        }
    }
    if (is_candidate == false)
    {
        discard;
    }
}

 