#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometryCopyDeformParams
{
    int surfaces_num;
    int surface_idx;
    int attribute_mask;
    int create_copy;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

layout(set = 0, binding = 1, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _252;

layout(set = 0, binding = 2, std430) buffer OutIndexBuffer
{
    uint data[];
} out_idx_data;

layout(set = 0, binding = 3, std430) buffer OutVTXCoords
{
    float data[];
} out_vtx_coords;

layout(set = 0, binding = 4, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 5, std430) buffer OutVTXAlbedo
{
    float data[];
} out_vtx_albedo;

layout(set = 0, binding = 6, std430) buffer OutVTXCustom0
{
    uint data[];
} out_vtx_custom0;

layout(set = 0, binding = 13, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _365;

layout(set = 0, binding = 7, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 8, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 9, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 10, std430) readonly buffer InVTXAlbedo
{
    float data[];
} in_vtx_albedo;

layout(set = 0, binding = 11, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 14, std140) uniform VM0
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM0_params;
} _900;

layout(set = 0, binding = 15, std140) uniform VM1
{
    ModifierFactorClamp_Params VM1_params;
} _915;

layout(set = 0, binding = 16, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _928;

layout(set = 0, binding = 17, std140) uniform VM3
{
    VertexModifierDisplaceParams VM3_params;
} _943;

layout(set = 0, binding = 18, std140) uniform GeometryCopyDeformParamsBuffer
{
    GeometryCopyDeformParams geometry_copy_deform_params;
} _974;

layout(set = 0, binding = 12, std430) buffer VertexCopyFlagBuffer
{
    uint data[];
} vtx_copy_flag_data;

layout(set = 0, binding = 19) uniform sampler2D s_Curves;
layout(set = 0, binding = 20) uniform sampler2D s_NoiseRGBA;

uint get_idx(inout uint idx)
{
    idx += _365.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

void put_idx(inout uint idx, uint v)
{
    idx += _252.output_geometry_information.idx_buffer_offset;
    out_idx_data.data[idx] = v;
}

vec3 get_coords(inout uint idx)
{
    idx *= _365.input_geometry_information.attributes[0].stride;
    idx += _365.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

vec3 get_normal(inout uint idx)
{
    idx *= _365.input_geometry_information.attributes[1].stride;
    idx += _365.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

vec3 get_albedo(inout uint idx)
{
    idx *= _365.input_geometry_information.attributes[2].stride;
    idx += _365.input_geometry_information.attributes[2].offset;
    return vec3(in_vtx_albedo.data[idx + 0u], in_vtx_albedo.data[idx + 1u], in_vtx_albedo.data[idx + 2u]);
}

uint get_custom0(inout uint idx)
{
    idx *= _365.input_geometry_information.attributes[6].stride;
    idx += _365.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _511 = vector_transform_by_mat43(param, param_1);
        coords = _511;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _522 = vector_transform_by_mat43(param_2, param_3);
            coords = _522;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _532 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _532;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    int k = -1;
    for (;;)
    {
        if (k <= 1)
        {
            int j = -1;
            for (;;)
            {
                if (j <= 1)
                {
                    int i = -1;
                    for (;;)
                    {
                        if (i <= 1)
                        {
                            vec3 b = vec3(float(i), float(j), float(k));
                            vec3 param = p + b;
                            vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                            float d = dot(r, r);
                            if (d < res.x)
                            {
                                id = dot(p + b, vec3(1.0, 57.0, 113.0));
                                res = vec2(d, res.x);
                            }
                            else
                            {
                                if (d < res.y)
                                {
                                    res.y = d;
                                }
                            }
                            i++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    j++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            k++;
            continue;
        }
        else
        {
            break;
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _761 = vector_transform_by_mat43(param, param_1);
        coords = _761;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _768 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _768;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

VertexInput apply_vertex_modifier_for_vtx(uint i0, inout VertexInput vtx_input, out float factor)
{
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_instance_model;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = i0;
    modifier_factor.id = i0;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    if ((_365.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param = i0;
        uint _872 = get_custom0(param);
        modifier_factor.custom0 = _872;
    }
    if ((_365.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = i0;
        vec3 _882 = get_albedo(param_1);
        modifier_factor.color.x = _882.x;
        modifier_factor.color.y = _882.y;
        modifier_factor.color.z = _882.z;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorDistanceRadial_Params _905;
    _905.transform_local_to_gizmo = _900.VM0_params.transform_local_to_gizmo;
    _905.falloff_curve_idx = _900.VM0_params.falloff_curve_idx;
    _905.falloff_inverse = _900.VM0_params.falloff_inverse;
    _905.domain_repeat_x = _900.VM0_params.domain_repeat_x;
    _905.domain_repeat_y = _900.VM0_params.domain_repeat_y;
    _905.domain_repeat_z = _900.VM0_params.domain_repeat_z;
    _905.influence_scope = _900.VM0_params.influence_scope;
    _905.modifier_function = _900.VM0_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_2 = _905;
    ModifierFactor param_3 = modifier_factor;
    CoordinateSystemTrasforms param_4 = cs_transforms;
    modifier_factor_distance_radial(param_2, param_3, param_4);
    modifier_factor = param_3;
    ModifierFactorClamp_Params _920;
    _920.clamp_min = _915.VM1_params.clamp_min;
    _920.clamp_max = _915.VM1_params.clamp_max;
    _920.clamp_min_enable = _915.VM1_params.clamp_min_enable;
    _920.clamp_max_enable = _915.VM1_params.clamp_max_enable;
    ModifierFactorClamp_Params param_5 = _920;
    ModifierFactor param_6 = modifier_factor;
    modifier_factor_clamp(param_5, param_6);
    modifier_factor = param_6;
    ModifierFactorNoise_Params _933;
    _933.transform_local_to_gizmo = _928.VM2_params.transform_local_to_gizmo;
    _933.noise_domain_scale = _928.VM2_params.noise_domain_scale;
    _933.modifier_function = _928.VM2_params.modifier_function;
    _933.noise_domain_offset = _928.VM2_params.noise_domain_offset;
    _933.noise_value_scale = _928.VM2_params.noise_value_scale;
    _933.noise_value_offset = _928.VM2_params.noise_value_offset;
    _933.influence_scope = _928.VM2_params.influence_scope;
    _933._pad0 = _928.VM2_params._pad0;
    _933._pad1 = _928.VM2_params._pad1;
    ModifierFactorNoise_Params param_7 = _933;
    ModifierFactor param_8 = modifier_factor;
    CoordinateSystemTrasforms param_9 = cs_transforms;
    modifier_factor_noise_voronoi(param_7, param_8, param_9);
    modifier_factor = param_8;
    VertexModifierDisplaceParams _948;
    _948.displace_normal = _943.VM3_params.displace_normal;
    _948.displace_normal_modifier_factor = _943.VM3_params.displace_normal_modifier_factor;
    _948.displace_base = _943.VM3_params.displace_base;
    _948.displace_base_modifier_factor = _943.VM3_params.displace_base_modifier_factor;
    _948.influence_scope = _943.VM3_params.influence_scope;
    VertexModifierDisplaceParams param_10 = _948;
    ModifierFactor param_11 = modifier_factor;
    VertexInput param_12 = vtx_input;
    CoordinateSystemTrasforms param_13 = cs_transforms;
    vertex_modifier_displace_apply(param_10, param_11, param_12, param_13);
    modifier_factor = param_11;
    vtx_input = param_12;
    factor = modifier_factor.factor;
    return vtx_input;
}

void put_coords(inout uint idx, vec3 v)
{
    idx *= _252.output_geometry_information.attributes[0].stride;
    idx += _252.output_geometry_information.attributes[0].offset;
    out_vtx_coords.data[idx + 0u] = v.x;
    out_vtx_coords.data[idx + 1u] = v.y;
    out_vtx_coords.data[idx + 2u] = v.z;
}

void put_normal(inout uint idx, vec3 v)
{
    idx *= _252.output_geometry_information.attributes[1].stride;
    idx += _252.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

void put_albedo(inout uint idx, vec3 v)
{
    idx *= _252.output_geometry_information.attributes[2].stride;
    idx += _252.output_geometry_information.attributes[2].offset;
    out_vtx_albedo.data[idx + 0u] = v.x;
    out_vtx_albedo.data[idx + 1u] = v.y;
    out_vtx_albedo.data[idx + 2u] = v.z;
}

void put_custom0(inout uint idx, uint v)
{
    idx *= _252.output_geometry_information.attributes[6].stride;
    idx += _252.output_geometry_information.attributes[6].offset;
    out_vtx_custom0.data[idx + 0u] = v;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = uint(_974.geometry_copy_deform_params.surface_idx);
    uint src_faces_num = _365.input_geometry_information.faces_num_per_surface[surface_idx];
    uint src_face_idx = thread_idx;
    for (;;)
    {
        if (src_face_idx < src_faces_num)
        {
            uint param = (src_face_idx * 3u) + 0u;
            uint _998 = get_idx(param);
            uint i0 = _998;
            uint param_1 = (src_face_idx * 3u) + 1u;
            uint _1004 = get_idx(param_1);
            uint i1 = _1004;
            uint param_2 = (src_face_idx * 3u) + 2u;
            uint _1010 = get_idx(param_2);
            uint i2 = _1010;
            uint dst_face_idx = src_face_idx;
            uint param_3 = (dst_face_idx * 3u) + 0u;
            uint param_4 = i0;
            put_idx(param_3, param_4);
            uint param_5 = (dst_face_idx * 3u) + 1u;
            uint param_6 = i1;
            put_idx(param_5, param_6);
            uint param_7 = (dst_face_idx * 3u) + 2u;
            uint param_8 = i2;
            put_idx(param_7, param_8);
            src_face_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
    _252.output_geometry_information.faces_num_per_surface[surface_idx] = src_faces_num;
    if (surface_idx == 0u)
    {
        uint src_vtx_num = _365.input_geometry_information.vtx_num;
        VertexInput vtx_input;
        float param_15;
        uint src_vtx_idx = thread_idx;
        for (;;)
        {
            if (src_vtx_idx < src_vtx_num)
            {
                uint i0_1 = src_vtx_idx;
                uint i0_remapped = vtx_copy_flag_data.data[i0_1];
                bool i0_copy = i0_remapped != 0u;
                i0_remapped--;
                if (i0_copy)
                {
                    uint param_9 = i0_1;
                    vec3 _1078 = get_coords(param_9);
                    vec3 v0_coords = _1078;
                    vec3 v0_normal = vec3(0.0, 0.0, 1.0);
                    if ((_365.input_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_10 = i0_1;
                        vec3 _1089 = get_normal(param_10);
                        v0_normal = _1089;
                    }
                    vec3 v0_albedo = vec3(1.0);
                    if ((_365.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
                    {
                        uint param_11 = i0_1;
                        vec3 _1100 = get_albedo(param_11);
                        v0_albedo = _1100;
                    }
                    uint v0_custom0 = 0u;
                    if ((_365.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_12 = i0_1;
                        uint _1110 = get_custom0(param_12);
                        v0_custom0 = _1110;
                    }
                    vtx_input.pos = v0_coords;
                    vtx_input.norm = v0_normal;
                    vtx_input.color.x = v0_albedo.x;
                    vtx_input.color.y = v0_albedo.y;
                    vtx_input.color.z = v0_albedo.z;
                    uint param_13 = i0_1;
                    VertexInput param_14 = vtx_input;
                    VertexInput _1129 = apply_vertex_modifier_for_vtx(param_13, param_14, param_15);
                    float modifier_factor = param_15;
                    vtx_input = _1129;
                    if (_974.geometry_copy_deform_params.export_factor_as_custom0 != 0)
                    {
                        v0_custom0 = floatBitsToUint(modifier_factor);
                    }
                    uint param_16 = i0_remapped;
                    vec3 param_17 = vtx_input.pos;
                    put_coords(param_16, param_17);
                    if ((_252.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_18 = i0_remapped;
                        vec3 param_19 = vtx_input.norm;
                        put_normal(param_18, param_19);
                    }
                    if ((_252.output_geometry_information.builtin_attribute_mask & 4u) != 0u)
                    {
                        uint param_20 = i0_remapped;
                        vec3 param_21 = v0_albedo;
                        put_albedo(param_20, param_21);
                    }
                    if ((_252.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_22 = i0_remapped;
                        uint param_23 = v0_custom0;
                        put_custom0(param_22, param_23);
                    }
                }
                src_vtx_idx += 131072u;
                continue;
            }
            else
            {
                break;
            }
        }
    }
}

 