#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct GPUHashMapInsertResult
{
    uint slot;
    bool duplicate;
};

struct InstancingGeneratorParams
{
    int seed;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float surface_distance;
    vec3 instance_scale;
    int alpha_to_modifier_factor;
    vec3 duplicate_elimination_position_decimation;
    int duplicate_elimination_position;
    vec3 duplicate_elimination_position_decimation_rcp;
    float duplicate_elimination_normal_decimation;
    float duplicate_elimination_normal_decimation_rcp;
    int duplicate_elimination_normal;
    float min_face_size;
    int _pad0;
};

struct GPUHashMapHeader
{
    uint capacity;
    uint _pad0;
    uint _pad1;
    uint _pad2;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _186;

layout(set = 0, binding = 2, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _247;

layout(set = 0, binding = 3, std430) buffer DuplicateEliminationHashMapKeysBuffer
{
    GPUHashMapHeader header;
    uint64_t keys[];
} duplicate_elimination_hashmap;

layout(set = 0, binding = 4, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _458;

layout(set = 0, binding = 10, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _491;

layout(set = 0, binding = 5, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _838;

layout(set = 0, binding = 6, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _919;

layout(set = 0, binding = 7, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _942;

layout(set = 0, binding = 8, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _962;

layout(set = 0, binding = 9, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _970;

uint particle_emitter_geometry_get_first_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _458.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(InstancingGeneratorParams emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _458.transformed_data_location[tdl_idx].last_face_idx;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _247.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _247.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _247.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_186.in_vtx_data[coord_offset + 0u], _186.in_vtx_data[coord_offset + 1u], _186.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_186.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _172 = hash(param);
    uint param_1 = _172;
    float _174 = floatConstruct(param_1);
    return _174;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

uint64_t GPUHashMapHash64(inout uint64_t h)
{
    h ^= (h >> 33);
    h *= 18397679294719823053ul;
    h ^= (h >> 33);
    h *= 14181476777654086739ul;
    h ^= (h >> 33);
    return h;
}

GPUHashMapInsertResult duplicate_elimination_hashmap_insert(uint64_t key)
{
    GPUHashMapInsertResult res;
    res.slot = 4294967295u;
    res.duplicate = false;
    uint64_t param = key;
    uint64_t _392 = GPUHashMapHash64(param);
    uint64_t hash_1 = _392;
    uint slot = uint(hash_1 & uint64_t(duplicate_elimination_hashmap.header.capacity - 1u));
    for (;;)
    {
        if (true)
        {
            uint64_t _418 = atomicCompSwap(duplicate_elimination_hashmap.keys[slot], 18446744073709551615ul, key);
            uint64_t prev = _418;
            if ((prev == 18446744073709551615ul) || (prev == key))
            {
                res.slot = slot;
                res.duplicate = prev == key;
                return res;
            }
            slot = (slot + 1u) & (duplicate_elimination_hashmap.header.capacity - 1u);
            continue;
        }
        else
        {
            break;
        }
    }
    return res;
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    InstancingGeneratorParams _496;
    _496.seed = _491.instancing_generator_params.seed;
    _496.transformed_data_location_idx = _491.instancing_generator_params.transformed_data_location_idx;
    _496.transformed_data_location_num = _491.instancing_generator_params.transformed_data_location_num;
    _496.surface_distance = _491.instancing_generator_params.surface_distance;
    _496.instance_scale = _491.instancing_generator_params.instance_scale;
    _496.alpha_to_modifier_factor = _491.instancing_generator_params.alpha_to_modifier_factor;
    _496.duplicate_elimination_position_decimation = _491.instancing_generator_params.duplicate_elimination_position_decimation;
    _496.duplicate_elimination_position = _491.instancing_generator_params.duplicate_elimination_position;
    _496.duplicate_elimination_position_decimation_rcp = _491.instancing_generator_params.duplicate_elimination_position_decimation_rcp;
    _496.duplicate_elimination_normal_decimation = _491.instancing_generator_params.duplicate_elimination_normal_decimation;
    _496.duplicate_elimination_normal_decimation_rcp = _491.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
    _496.duplicate_elimination_normal = _491.instancing_generator_params.duplicate_elimination_normal;
    _496.min_face_size = _491.instancing_generator_params.min_face_size;
    _496._pad0 = _491.instancing_generator_params._pad0;
    InstancingGeneratorParams param = _496;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    InstancingGeneratorParams _502;
    _502.seed = _491.instancing_generator_params.seed;
    _502.transformed_data_location_idx = _491.instancing_generator_params.transformed_data_location_idx;
    _502.transformed_data_location_num = _491.instancing_generator_params.transformed_data_location_num;
    _502.surface_distance = _491.instancing_generator_params.surface_distance;
    _502.instance_scale = _491.instancing_generator_params.instance_scale;
    _502.alpha_to_modifier_factor = _491.instancing_generator_params.alpha_to_modifier_factor;
    _502.duplicate_elimination_position_decimation = _491.instancing_generator_params.duplicate_elimination_position_decimation;
    _502.duplicate_elimination_position = _491.instancing_generator_params.duplicate_elimination_position;
    _502.duplicate_elimination_position_decimation_rcp = _491.instancing_generator_params.duplicate_elimination_position_decimation_rcp;
    _502.duplicate_elimination_normal_decimation = _491.instancing_generator_params.duplicate_elimination_normal_decimation;
    _502.duplicate_elimination_normal_decimation_rcp = _491.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
    _502.duplicate_elimination_normal = _491.instancing_generator_params.duplicate_elimination_normal;
    _502.min_face_size = _491.instancing_generator_params.min_face_size;
    _502._pad0 = _491.instancing_generator_params._pad0;
    InstancingGeneratorParams param_1 = _502;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float face_min_size_threshold = _491.instancing_generator_params.min_face_size;
    float fid = float(id);
    float fid_seed = float(_491.instancing_generator_params.seed);
    uint face_idx = id;
    face_idx += first_face_idx;
    uint param_2 = face_idx;
    RTFace rt_face = rt_get_face(param_2);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_3 = p0_idx;
    vec3 p0 = rt_get_vertex(param_3);
    uint param_4 = p1_idx;
    vec3 p1 = rt_get_vertex(param_4);
    uint param_5 = p2_idx;
    vec3 p2 = rt_get_vertex(param_5);
    float face_size = length(cross(p0 - p1, p0 - p2));
    if (face_size < face_min_size_threshold)
    {
        return;
    }
    uint param_6 = p0_idx;
    vec4 c0 = rt_get_vertex_color(param_6);
    uint param_7 = p1_idx;
    vec4 c1 = rt_get_vertex_color(param_7);
    uint param_8 = p2_idx;
    vec4 c2 = rt_get_vertex_color(param_8);
    float param_9 = fid_seed * 0.34130001068115234375;
    vec3 bc;
    bc.x = random(param_9);
    float param_10 = fid_seed * 0.1412999927997589111328125;
    bc.y = random(param_10);
    if ((bc.x + bc.y) >= 1.0)
    {
        bc.x = 1.0 - bc.x;
        bc.y = 1.0 - bc.y;
    }
    vec4 col = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
    vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
    vec3 nx = normalize(p0 - p2);
    vec3 ny = normalize(p0 - p1);
    vec3 nz = normalize(cross(nx, ny));
    ny = cross(nz, nx);
    ModifierFactor modifier_factor = modifier_factor_defaults();
    float _669;
    if (_491.instancing_generator_params.alpha_to_modifier_factor != 0)
    {
        _669 = col.w;
    }
    else
    {
        _669 = 1.0;
    }
    modifier_factor.factor = _669;
    modifier_factor.hash = floatBitsToUint(fid_seed);
    modifier_factor.id = id;
    modifier_factor.position = pos;
    modifier_factor.is_spawned = true;
    modifier_factor.color = col;
    modifier_factor.normal = nz;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    if (modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
    {
        return;
    }
    bool _708 = _491.instancing_generator_params.duplicate_elimination_position != 0;
    bool _715;
    if (!_708)
    {
        _715 = _491.instancing_generator_params.duplicate_elimination_normal != 0;
    }
    else
    {
        _715 = _708;
    }
    if (_715)
    {
        vec3 kv = (pos * _491.instancing_generator_params.duplicate_elimination_position_decimation_rcp) + vec3(0.5);
        vec3 kn = (nz * _491.instancing_generator_params.duplicate_elimination_normal_decimation) + vec3(0.5);
        uint64_t k = 0ul;
        if (_491.instancing_generator_params.duplicate_elimination_position != 0)
        {
            k += uint64_t(((int64_t(kv.x) * 8521703l) + (int64_t(kv.y) * 15150437l)) + (int64_t(kv.z) * 10072093l));
        }
        if (_491.instancing_generator_params.duplicate_elimination_normal != 0)
        {
            k += uint64_t(((int64_t(kn.x) * 913273l) + (int64_t(kn.y) * 16320103l)) + (int64_t(kn.z) * 15850061l));
        }
        uint64_t param_11 = k;
        GPUHashMapInsertResult _790 = duplicate_elimination_hashmap_insert(param_11);
        GPUHashMapInsertResult ires = _790;
        if (ires.duplicate)
        {
            return;
        }
        else
        {
            if (_491.instancing_generator_params.duplicate_elimination_position != 0)
            {
                pos = (vec3(ivec3(kv)) - vec3(0.5)) * _491.instancing_generator_params.duplicate_elimination_position_decimation;
            }
            if (_491.instancing_generator_params.duplicate_elimination_normal != 0)
            {
                nz = (vec3(ivec3(kn)) - vec3(0.5)) * _491.instancing_generator_params.duplicate_elimination_normal_decimation_rcp;
                nz = normalize(nz);
                vec3 param_12 = nz;
                mat3 _830 = matrixFromVector(param_12);
                mat3 _m = _830;
                nx = _m[0];
                ny = _m[1];
            }
        }
    }
    if (_838.instance_params.instance_count >= _838.instance_params.buffer_capacity)
    {
        return;
    }
    int _850 = atomicAdd(_838.instance_params.instance_count, 1);
    uint instance_id = uint(_850);
    if (instance_id >= uint(_838.instance_params.buffer_capacity))
    {
        return;
    }
    pos -= (nz * _491.instancing_generator_params.surface_distance);
    nx *= _491.instancing_generator_params.instance_scale.x;
    ny *= _491.instancing_generator_params.instance_scale.y;
    nz *= _491.instancing_generator_params.instance_scale.z;
    Instance instance;
    instance.m0 = vec4(nx.x, ny.x, nz.x, pos.x);
    instance.m1 = vec4(nx.y, ny.y, nz.y, pos.y);
    instance.m2 = vec4(nx.z, ny.z, nz.z, pos.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(1.0);
    instance.flipbook_card = 0u;
    _919.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _919.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _919.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _942.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _942.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _962.instance_hash[instance_id] = instance.hash;
    _970.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 