#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorRangeRemap_Params
{
    float input_min;
    float input_max;
    float output_min;
    float output_max;
    int min_out_of_bounds_mode;
    int max_out_of_bounds_mode;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    uvec3 resolution;
    vec3 bbox_position;
    vec3 bbox_dimensions;
    vec3 instance_scale_base;
    vec3 instance_scale_factor;
    float function_scale;
    float function_threshold;
    float orientation_blend;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1655;

layout(set = 0, binding = 6, scalar) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _1673;

layout(set = 0, binding = 7, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _1747;

layout(set = 0, binding = 8, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1761;

layout(set = 0, binding = 9, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _1774;

layout(set = 0, binding = 10, std140) uniform VM3
{
    ModifierFactorMulAdd_Params VM3_params;
} _1792;

layout(set = 0, binding = 11, std140) uniform VM4
{
    ModifierFactorRangeRemap_Params VM4_params;
} _1805;

layout(set = 0, binding = 12, std140) uniform VM5
{
    ModifierFactorCurveTransfer_Params VM5_params;
} _1818;

layout(set = 0, binding = 13, std140) uniform VM6
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM6_params;
} _1831;

layout(set = 0, binding = 2, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _2290;

layout(set = 0, binding = 3, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2313;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _2334;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _2342;

layout(set = 0, binding = 14) uniform sampler2D s_NoiseRGBA;
layout(set = 0, binding = 15) uniform sampler2D s_Curves;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1108 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1108;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1302 = vector_transform_by_mat43(param, param_1);
        coords = _1302;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1309 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1309;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1253 = vector_transform_by_mat43(param, param_1);
        coords = _1253;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1260 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1260;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    int k = -1;
    for (;;)
    {
        if (k <= 1)
        {
            int j = -1;
            for (;;)
            {
                if (j <= 1)
                {
                    int i = -1;
                    for (;;)
                    {
                        if (i <= 1)
                        {
                            vec3 b = vec3(float(i), float(j), float(k));
                            vec3 param = p + b;
                            vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                            float d = dot(r, r);
                            if (d < res.x)
                            {
                                id = dot(p + b, vec3(1.0, 57.0, 113.0));
                                res = vec2(d, res.x);
                            }
                            else
                            {
                                if (d < res.y)
                                {
                                    res.y = d;
                                }
                            }
                            i++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    j++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            k++;
            continue;
        }
        else
        {
            break;
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1351 = vector_transform_by_mat43(param, param_1);
        coords = _1351;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1358 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1358;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_range_remap(ModifierFactorRangeRemap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    bool set_const = false;
    float set_const_value = 0.0;
    float t = (v - modifier_params.input_min) / (modifier_params.input_max - modifier_params.input_min);
    if (t < 0.0)
    {
        if (modifier_params.min_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 0)
        {
            t = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.min_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    if (t > 1.0)
    {
        if (modifier_params.max_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 0)
        {
            t = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.max_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    v = modifier_params.output_min + (t * (modifier_params.output_max - modifier_params.output_min));
    if (set_const)
    {
        v = set_const_value;
    }
    modifier_factor.factor = v;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _1557 = vector_transform_by_mat43(param, param_1);
        coords = _1557;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _1568 = vector_transform_by_mat43(param_2, param_3);
            coords = _1568;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1578 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1578;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_1655.instance_params.instance_count >= _1655.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_1673.instancing_generator_params.resolution.x * _1673.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_1673.instancing_generator_params.resolution.x * _1673.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _1673.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _1673.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = _1673.instancing_generator_params.bbox_position;
    vec3 instancing_bbox_size = _1673.instancing_generator_params.bbox_dimensions;
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_1673.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _1752;
    _1752.transform_local_to_gizmo = _1747.VM0_params.transform_local_to_gizmo;
    _1752.noise_domain_scale = _1747.VM0_params.noise_domain_scale;
    _1752.modifier_function = _1747.VM0_params.modifier_function;
    _1752.noise_domain_offset = _1747.VM0_params.noise_domain_offset;
    _1752.noise_value_scale = _1747.VM0_params.noise_value_scale;
    _1752.noise_value_offset = _1747.VM0_params.noise_value_offset;
    _1752.influence_scope = _1747.VM0_params.influence_scope;
    _1752._pad0 = _1747.VM0_params._pad0;
    _1752._pad1 = _1747.VM0_params._pad1;
    ModifierFactorNoise_Params param = _1752;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_noise_simplex2(param, param_1, param_2);
    modifier_factor = param_1;
    ModifierFactorNoise_Params _1765;
    _1765.transform_local_to_gizmo = _1761.VM1_params.transform_local_to_gizmo;
    _1765.noise_domain_scale = _1761.VM1_params.noise_domain_scale;
    _1765.modifier_function = _1761.VM1_params.modifier_function;
    _1765.noise_domain_offset = _1761.VM1_params.noise_domain_offset;
    _1765.noise_value_scale = _1761.VM1_params.noise_value_scale;
    _1765.noise_value_offset = _1761.VM1_params.noise_value_offset;
    _1765.influence_scope = _1761.VM1_params.influence_scope;
    _1765._pad0 = _1761.VM1_params._pad0;
    _1765._pad1 = _1761.VM1_params._pad1;
    ModifierFactorNoise_Params param_3 = _1765;
    ModifierFactor param_4 = modifier_factor;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    modifier_factor_noise_default(param_3, param_4, param_5);
    modifier_factor = param_4;
    ModifierFactorNoise_Params _1778;
    _1778.transform_local_to_gizmo = _1774.VM2_params.transform_local_to_gizmo;
    _1778.noise_domain_scale = _1774.VM2_params.noise_domain_scale;
    _1778.modifier_function = _1774.VM2_params.modifier_function;
    _1778.noise_domain_offset = _1774.VM2_params.noise_domain_offset;
    _1778.noise_value_scale = _1774.VM2_params.noise_value_scale;
    _1778.noise_value_offset = _1774.VM2_params.noise_value_offset;
    _1778.influence_scope = _1774.VM2_params.influence_scope;
    _1778._pad0 = _1774.VM2_params._pad0;
    _1778._pad1 = _1774.VM2_params._pad1;
    ModifierFactorNoise_Params param_6 = _1778;
    ModifierFactor param_7 = modifier_factor;
    CoordinateSystemTrasforms param_8 = cs_transforms;
    modifier_factor_noise_voronoi(param_6, param_7, param_8);
    modifier_factor = param_7;
    modifier_factor.factor = abs(modifier_factor.factor);
    ModifierFactorMulAdd_Params _1797;
    _1797.multiply_value = _1792.VM3_params.multiply_value;
    _1797.add_value = _1792.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_9 = _1797;
    ModifierFactor param_10 = modifier_factor;
    modifier_factor_mul_add(param_9, param_10);
    modifier_factor = param_10;
    ModifierFactorRangeRemap_Params _1810;
    _1810.input_min = _1805.VM4_params.input_min;
    _1810.input_max = _1805.VM4_params.input_max;
    _1810.output_min = _1805.VM4_params.output_min;
    _1810.output_max = _1805.VM4_params.output_max;
    _1810.min_out_of_bounds_mode = _1805.VM4_params.min_out_of_bounds_mode;
    _1810.max_out_of_bounds_mode = _1805.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_11 = _1810;
    ModifierFactor param_12 = modifier_factor;
    modifier_factor_range_remap(param_11, param_12);
    modifier_factor = param_12;
    ModifierFactorCurveTransfer_Params _1823;
    _1823.curve_idx = _1818.VM5_params.curve_idx;
    _1823.input_range_min = _1818.VM5_params.input_range_min;
    _1823.input_range_max = _1818.VM5_params.input_range_max;
    _1823.amplitude = _1818.VM5_params.amplitude;
    _1823.base = _1818.VM5_params.base;
    ModifierFactorCurveTransfer_Params param_13 = _1823;
    ModifierFactor param_14 = modifier_factor;
    modifier_factor_curve_transfer(param_13, param_14);
    modifier_factor = param_14;
    ModifierFactorDistanceRadial_Params _1836;
    _1836.transform_local_to_gizmo = _1831.VM6_params.transform_local_to_gizmo;
    _1836.falloff_curve_idx = _1831.VM6_params.falloff_curve_idx;
    _1836.falloff_inverse = _1831.VM6_params.falloff_inverse;
    _1836.domain_repeat_x = _1831.VM6_params.domain_repeat_x;
    _1836.domain_repeat_y = _1831.VM6_params.domain_repeat_y;
    _1836.domain_repeat_z = _1831.VM6_params.domain_repeat_z;
    _1836.influence_scope = _1831.VM6_params.influence_scope;
    _1836.modifier_function = _1831.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_15 = _1836;
    ModifierFactor param_16 = modifier_factor;
    CoordinateSystemTrasforms param_17 = cs_transforms;
    modifier_factor_distance_radial(param_15, param_16, param_17);
    modifier_factor = param_16;
    float mf = (modifier_factor.factor * _1673.instancing_generator_params.function_scale) - _1673.instancing_generator_params.function_threshold;
    if ((mf <= 0.0) || modifier_factor.is_discarded)
    {
        return;
    }
    vec3 instance_scale = _1673.instancing_generator_params.instance_scale_base + (_1673.instancing_generator_params.instance_scale_factor * mf);
    float modifier_factor_v = modifier_factor.factor;
    float modifier_factor_v_dx = modifier_factor.factor;
    float modifier_factor_v_dy = modifier_factor.factor;
    float modifier_factor_v_dz = modifier_factor.factor;
    ModifierFactor modifier_factor_1 = modifier_factor_defaults();
    modifier_factor_1.factor = 1.0;
    modifier_factor_1.hash = id;
    modifier_factor_1.id = id;
    modifier_factor_1.instance_id = id;
    modifier_factor_1.position = instance_position + vec3(instancing_bbox_size.x / float(_1673.instancing_generator_params.resolution.x), 0.0, 0.0);
    modifier_factor_1.is_spawned = true;
    ModifierFactorNoise_Params _1904;
    _1904.transform_local_to_gizmo = _1747.VM0_params.transform_local_to_gizmo;
    _1904.noise_domain_scale = _1747.VM0_params.noise_domain_scale;
    _1904.modifier_function = _1747.VM0_params.modifier_function;
    _1904.noise_domain_offset = _1747.VM0_params.noise_domain_offset;
    _1904.noise_value_scale = _1747.VM0_params.noise_value_scale;
    _1904.noise_value_offset = _1747.VM0_params.noise_value_offset;
    _1904.influence_scope = _1747.VM0_params.influence_scope;
    _1904._pad0 = _1747.VM0_params._pad0;
    _1904._pad1 = _1747.VM0_params._pad1;
    ModifierFactorNoise_Params param_18 = _1904;
    ModifierFactor param_19 = modifier_factor_1;
    CoordinateSystemTrasforms param_20 = cs_transforms;
    modifier_factor_noise_simplex2(param_18, param_19, param_20);
    modifier_factor_1 = param_19;
    ModifierFactorNoise_Params _1914;
    _1914.transform_local_to_gizmo = _1761.VM1_params.transform_local_to_gizmo;
    _1914.noise_domain_scale = _1761.VM1_params.noise_domain_scale;
    _1914.modifier_function = _1761.VM1_params.modifier_function;
    _1914.noise_domain_offset = _1761.VM1_params.noise_domain_offset;
    _1914.noise_value_scale = _1761.VM1_params.noise_value_scale;
    _1914.noise_value_offset = _1761.VM1_params.noise_value_offset;
    _1914.influence_scope = _1761.VM1_params.influence_scope;
    _1914._pad0 = _1761.VM1_params._pad0;
    _1914._pad1 = _1761.VM1_params._pad1;
    ModifierFactorNoise_Params param_21 = _1914;
    ModifierFactor param_22 = modifier_factor_1;
    CoordinateSystemTrasforms param_23 = cs_transforms;
    modifier_factor_noise_default(param_21, param_22, param_23);
    modifier_factor_1 = param_22;
    ModifierFactorNoise_Params _1924;
    _1924.transform_local_to_gizmo = _1774.VM2_params.transform_local_to_gizmo;
    _1924.noise_domain_scale = _1774.VM2_params.noise_domain_scale;
    _1924.modifier_function = _1774.VM2_params.modifier_function;
    _1924.noise_domain_offset = _1774.VM2_params.noise_domain_offset;
    _1924.noise_value_scale = _1774.VM2_params.noise_value_scale;
    _1924.noise_value_offset = _1774.VM2_params.noise_value_offset;
    _1924.influence_scope = _1774.VM2_params.influence_scope;
    _1924._pad0 = _1774.VM2_params._pad0;
    _1924._pad1 = _1774.VM2_params._pad1;
    ModifierFactorNoise_Params param_24 = _1924;
    ModifierFactor param_25 = modifier_factor_1;
    CoordinateSystemTrasforms param_26 = cs_transforms;
    modifier_factor_noise_voronoi(param_24, param_25, param_26);
    modifier_factor_1 = param_25;
    modifier_factor_1.factor = abs(modifier_factor_1.factor);
    ModifierFactorMulAdd_Params _1938;
    _1938.multiply_value = _1792.VM3_params.multiply_value;
    _1938.add_value = _1792.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_27 = _1938;
    ModifierFactor param_28 = modifier_factor_1;
    modifier_factor_mul_add(param_27, param_28);
    modifier_factor_1 = param_28;
    ModifierFactorRangeRemap_Params _1946;
    _1946.input_min = _1805.VM4_params.input_min;
    _1946.input_max = _1805.VM4_params.input_max;
    _1946.output_min = _1805.VM4_params.output_min;
    _1946.output_max = _1805.VM4_params.output_max;
    _1946.min_out_of_bounds_mode = _1805.VM4_params.min_out_of_bounds_mode;
    _1946.max_out_of_bounds_mode = _1805.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_29 = _1946;
    ModifierFactor param_30 = modifier_factor_1;
    modifier_factor_range_remap(param_29, param_30);
    modifier_factor_1 = param_30;
    ModifierFactorCurveTransfer_Params _1954;
    _1954.curve_idx = _1818.VM5_params.curve_idx;
    _1954.input_range_min = _1818.VM5_params.input_range_min;
    _1954.input_range_max = _1818.VM5_params.input_range_max;
    _1954.amplitude = _1818.VM5_params.amplitude;
    _1954.base = _1818.VM5_params.base;
    ModifierFactorCurveTransfer_Params param_31 = _1954;
    ModifierFactor param_32 = modifier_factor_1;
    modifier_factor_curve_transfer(param_31, param_32);
    modifier_factor_1 = param_32;
    ModifierFactorDistanceRadial_Params _1962;
    _1962.transform_local_to_gizmo = _1831.VM6_params.transform_local_to_gizmo;
    _1962.falloff_curve_idx = _1831.VM6_params.falloff_curve_idx;
    _1962.falloff_inverse = _1831.VM6_params.falloff_inverse;
    _1962.domain_repeat_x = _1831.VM6_params.domain_repeat_x;
    _1962.domain_repeat_y = _1831.VM6_params.domain_repeat_y;
    _1962.domain_repeat_z = _1831.VM6_params.domain_repeat_z;
    _1962.influence_scope = _1831.VM6_params.influence_scope;
    _1962.modifier_function = _1831.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_33 = _1962;
    ModifierFactor param_34 = modifier_factor_1;
    CoordinateSystemTrasforms param_35 = cs_transforms;
    modifier_factor_distance_radial(param_33, param_34, param_35);
    modifier_factor_1 = param_34;
    modifier_factor_v_dx = modifier_factor_1.factor;
    ModifierFactor modifier_factor_2 = modifier_factor_defaults();
    modifier_factor_2.factor = 1.0;
    modifier_factor_2.hash = id;
    modifier_factor_2.id = id;
    modifier_factor_2.instance_id = id;
    modifier_factor_2.position = instance_position + vec3(0.0, instancing_bbox_size.y / float(_1673.instancing_generator_params.resolution.y), 0.0);
    modifier_factor_2.is_spawned = true;
    ModifierFactorNoise_Params _1994;
    _1994.transform_local_to_gizmo = _1747.VM0_params.transform_local_to_gizmo;
    _1994.noise_domain_scale = _1747.VM0_params.noise_domain_scale;
    _1994.modifier_function = _1747.VM0_params.modifier_function;
    _1994.noise_domain_offset = _1747.VM0_params.noise_domain_offset;
    _1994.noise_value_scale = _1747.VM0_params.noise_value_scale;
    _1994.noise_value_offset = _1747.VM0_params.noise_value_offset;
    _1994.influence_scope = _1747.VM0_params.influence_scope;
    _1994._pad0 = _1747.VM0_params._pad0;
    _1994._pad1 = _1747.VM0_params._pad1;
    ModifierFactorNoise_Params param_36 = _1994;
    ModifierFactor param_37 = modifier_factor_2;
    CoordinateSystemTrasforms param_38 = cs_transforms;
    modifier_factor_noise_simplex2(param_36, param_37, param_38);
    modifier_factor_2 = param_37;
    ModifierFactorNoise_Params _2004;
    _2004.transform_local_to_gizmo = _1761.VM1_params.transform_local_to_gizmo;
    _2004.noise_domain_scale = _1761.VM1_params.noise_domain_scale;
    _2004.modifier_function = _1761.VM1_params.modifier_function;
    _2004.noise_domain_offset = _1761.VM1_params.noise_domain_offset;
    _2004.noise_value_scale = _1761.VM1_params.noise_value_scale;
    _2004.noise_value_offset = _1761.VM1_params.noise_value_offset;
    _2004.influence_scope = _1761.VM1_params.influence_scope;
    _2004._pad0 = _1761.VM1_params._pad0;
    _2004._pad1 = _1761.VM1_params._pad1;
    ModifierFactorNoise_Params param_39 = _2004;
    ModifierFactor param_40 = modifier_factor_2;
    CoordinateSystemTrasforms param_41 = cs_transforms;
    modifier_factor_noise_default(param_39, param_40, param_41);
    modifier_factor_2 = param_40;
    ModifierFactorNoise_Params _2014;
    _2014.transform_local_to_gizmo = _1774.VM2_params.transform_local_to_gizmo;
    _2014.noise_domain_scale = _1774.VM2_params.noise_domain_scale;
    _2014.modifier_function = _1774.VM2_params.modifier_function;
    _2014.noise_domain_offset = _1774.VM2_params.noise_domain_offset;
    _2014.noise_value_scale = _1774.VM2_params.noise_value_scale;
    _2014.noise_value_offset = _1774.VM2_params.noise_value_offset;
    _2014.influence_scope = _1774.VM2_params.influence_scope;
    _2014._pad0 = _1774.VM2_params._pad0;
    _2014._pad1 = _1774.VM2_params._pad1;
    ModifierFactorNoise_Params param_42 = _2014;
    ModifierFactor param_43 = modifier_factor_2;
    CoordinateSystemTrasforms param_44 = cs_transforms;
    modifier_factor_noise_voronoi(param_42, param_43, param_44);
    modifier_factor_2 = param_43;
    modifier_factor_2.factor = abs(modifier_factor_2.factor);
    ModifierFactorMulAdd_Params _2028;
    _2028.multiply_value = _1792.VM3_params.multiply_value;
    _2028.add_value = _1792.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_45 = _2028;
    ModifierFactor param_46 = modifier_factor_2;
    modifier_factor_mul_add(param_45, param_46);
    modifier_factor_2 = param_46;
    ModifierFactorRangeRemap_Params _2036;
    _2036.input_min = _1805.VM4_params.input_min;
    _2036.input_max = _1805.VM4_params.input_max;
    _2036.output_min = _1805.VM4_params.output_min;
    _2036.output_max = _1805.VM4_params.output_max;
    _2036.min_out_of_bounds_mode = _1805.VM4_params.min_out_of_bounds_mode;
    _2036.max_out_of_bounds_mode = _1805.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_47 = _2036;
    ModifierFactor param_48 = modifier_factor_2;
    modifier_factor_range_remap(param_47, param_48);
    modifier_factor_2 = param_48;
    ModifierFactorCurveTransfer_Params _2044;
    _2044.curve_idx = _1818.VM5_params.curve_idx;
    _2044.input_range_min = _1818.VM5_params.input_range_min;
    _2044.input_range_max = _1818.VM5_params.input_range_max;
    _2044.amplitude = _1818.VM5_params.amplitude;
    _2044.base = _1818.VM5_params.base;
    ModifierFactorCurveTransfer_Params param_49 = _2044;
    ModifierFactor param_50 = modifier_factor_2;
    modifier_factor_curve_transfer(param_49, param_50);
    modifier_factor_2 = param_50;
    ModifierFactorDistanceRadial_Params _2052;
    _2052.transform_local_to_gizmo = _1831.VM6_params.transform_local_to_gizmo;
    _2052.falloff_curve_idx = _1831.VM6_params.falloff_curve_idx;
    _2052.falloff_inverse = _1831.VM6_params.falloff_inverse;
    _2052.domain_repeat_x = _1831.VM6_params.domain_repeat_x;
    _2052.domain_repeat_y = _1831.VM6_params.domain_repeat_y;
    _2052.domain_repeat_z = _1831.VM6_params.domain_repeat_z;
    _2052.influence_scope = _1831.VM6_params.influence_scope;
    _2052.modifier_function = _1831.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_51 = _2052;
    ModifierFactor param_52 = modifier_factor_2;
    CoordinateSystemTrasforms param_53 = cs_transforms;
    modifier_factor_distance_radial(param_51, param_52, param_53);
    modifier_factor_2 = param_52;
    modifier_factor_v_dy = modifier_factor_2.factor;
    ModifierFactor modifier_factor_3 = modifier_factor_defaults();
    modifier_factor_3.factor = 1.0;
    modifier_factor_3.hash = id;
    modifier_factor_3.id = id;
    modifier_factor_3.instance_id = id;
    modifier_factor_3.position = instance_position + vec3(0.0, 0.0, instancing_bbox_size.z / float(_1673.instancing_generator_params.resolution.z));
    modifier_factor_3.is_spawned = true;
    ModifierFactorNoise_Params _2084;
    _2084.transform_local_to_gizmo = _1747.VM0_params.transform_local_to_gizmo;
    _2084.noise_domain_scale = _1747.VM0_params.noise_domain_scale;
    _2084.modifier_function = _1747.VM0_params.modifier_function;
    _2084.noise_domain_offset = _1747.VM0_params.noise_domain_offset;
    _2084.noise_value_scale = _1747.VM0_params.noise_value_scale;
    _2084.noise_value_offset = _1747.VM0_params.noise_value_offset;
    _2084.influence_scope = _1747.VM0_params.influence_scope;
    _2084._pad0 = _1747.VM0_params._pad0;
    _2084._pad1 = _1747.VM0_params._pad1;
    ModifierFactorNoise_Params param_54 = _2084;
    ModifierFactor param_55 = modifier_factor_3;
    CoordinateSystemTrasforms param_56 = cs_transforms;
    modifier_factor_noise_simplex2(param_54, param_55, param_56);
    modifier_factor_3 = param_55;
    ModifierFactorNoise_Params _2094;
    _2094.transform_local_to_gizmo = _1761.VM1_params.transform_local_to_gizmo;
    _2094.noise_domain_scale = _1761.VM1_params.noise_domain_scale;
    _2094.modifier_function = _1761.VM1_params.modifier_function;
    _2094.noise_domain_offset = _1761.VM1_params.noise_domain_offset;
    _2094.noise_value_scale = _1761.VM1_params.noise_value_scale;
    _2094.noise_value_offset = _1761.VM1_params.noise_value_offset;
    _2094.influence_scope = _1761.VM1_params.influence_scope;
    _2094._pad0 = _1761.VM1_params._pad0;
    _2094._pad1 = _1761.VM1_params._pad1;
    ModifierFactorNoise_Params param_57 = _2094;
    ModifierFactor param_58 = modifier_factor_3;
    CoordinateSystemTrasforms param_59 = cs_transforms;
    modifier_factor_noise_default(param_57, param_58, param_59);
    modifier_factor_3 = param_58;
    ModifierFactorNoise_Params _2104;
    _2104.transform_local_to_gizmo = _1774.VM2_params.transform_local_to_gizmo;
    _2104.noise_domain_scale = _1774.VM2_params.noise_domain_scale;
    _2104.modifier_function = _1774.VM2_params.modifier_function;
    _2104.noise_domain_offset = _1774.VM2_params.noise_domain_offset;
    _2104.noise_value_scale = _1774.VM2_params.noise_value_scale;
    _2104.noise_value_offset = _1774.VM2_params.noise_value_offset;
    _2104.influence_scope = _1774.VM2_params.influence_scope;
    _2104._pad0 = _1774.VM2_params._pad0;
    _2104._pad1 = _1774.VM2_params._pad1;
    ModifierFactorNoise_Params param_60 = _2104;
    ModifierFactor param_61 = modifier_factor_3;
    CoordinateSystemTrasforms param_62 = cs_transforms;
    modifier_factor_noise_voronoi(param_60, param_61, param_62);
    modifier_factor_3 = param_61;
    modifier_factor_3.factor = abs(modifier_factor_3.factor);
    ModifierFactorMulAdd_Params _2118;
    _2118.multiply_value = _1792.VM3_params.multiply_value;
    _2118.add_value = _1792.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_63 = _2118;
    ModifierFactor param_64 = modifier_factor_3;
    modifier_factor_mul_add(param_63, param_64);
    modifier_factor_3 = param_64;
    ModifierFactorRangeRemap_Params _2126;
    _2126.input_min = _1805.VM4_params.input_min;
    _2126.input_max = _1805.VM4_params.input_max;
    _2126.output_min = _1805.VM4_params.output_min;
    _2126.output_max = _1805.VM4_params.output_max;
    _2126.min_out_of_bounds_mode = _1805.VM4_params.min_out_of_bounds_mode;
    _2126.max_out_of_bounds_mode = _1805.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_65 = _2126;
    ModifierFactor param_66 = modifier_factor_3;
    modifier_factor_range_remap(param_65, param_66);
    modifier_factor_3 = param_66;
    ModifierFactorCurveTransfer_Params _2134;
    _2134.curve_idx = _1818.VM5_params.curve_idx;
    _2134.input_range_min = _1818.VM5_params.input_range_min;
    _2134.input_range_max = _1818.VM5_params.input_range_max;
    _2134.amplitude = _1818.VM5_params.amplitude;
    _2134.base = _1818.VM5_params.base;
    ModifierFactorCurveTransfer_Params param_67 = _2134;
    ModifierFactor param_68 = modifier_factor_3;
    modifier_factor_curve_transfer(param_67, param_68);
    modifier_factor_3 = param_68;
    ModifierFactorDistanceRadial_Params _2142;
    _2142.transform_local_to_gizmo = _1831.VM6_params.transform_local_to_gizmo;
    _2142.falloff_curve_idx = _1831.VM6_params.falloff_curve_idx;
    _2142.falloff_inverse = _1831.VM6_params.falloff_inverse;
    _2142.domain_repeat_x = _1831.VM6_params.domain_repeat_x;
    _2142.domain_repeat_y = _1831.VM6_params.domain_repeat_y;
    _2142.domain_repeat_z = _1831.VM6_params.domain_repeat_z;
    _2142.influence_scope = _1831.VM6_params.influence_scope;
    _2142.modifier_function = _1831.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_69 = _2142;
    ModifierFactor param_70 = modifier_factor_3;
    CoordinateSystemTrasforms param_71 = cs_transforms;
    modifier_factor_distance_radial(param_69, param_70, param_71);
    modifier_factor_3 = param_70;
    modifier_factor_v_dz = modifier_factor_3.factor;
    vec3 n;
    n.x = modifier_factor_v_dx - modifier_factor_v;
    n.y = modifier_factor_v_dy - modifier_factor_v;
    n.z = modifier_factor_v_dz - modifier_factor_v;
    n = mix(vec3(0.0, 0.0, 1.0), n, vec3(_1673.instancing_generator_params.orientation_blend));
    n = normalize(n);
    mat3 r;
    r[2] = n;
    r[1] = cross(vec3(0.0, 1.0, 0.0), r[2]);
    r[0] = cross(r[2], r[1]);
    r[1] = cross(r[2], r[0]);
    mat3 s;
    s[0] = vec3(instance_scale.x, 0.0, 0.0);
    s[1] = vec3(0.0, instance_scale.y, 0.0);
    s[2] = vec3(0.0, 0.0, instance_scale.z);
    mat3 transform = r * s;
    transform = s * r;
    transform = transpose(transform);
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(1.0);
    instance.flipbook_card = 0u;
    bool _2253 = length(instance.m0.xyz) <= 0.0;
    bool _2262;
    if (!_2253)
    {
        _2262 = length(instance.m1.xyz) <= 0.0;
    }
    else
    {
        _2262 = _2253;
    }
    bool _2271;
    if (!_2262)
    {
        _2271 = length(instance.m1.xyz) <= 0.0;
    }
    else
    {
        _2271 = _2262;
    }
    if (_2271)
    {
        return;
    }
    int _2277 = atomicAdd(_1655.instance_params.instance_count, 1);
    uint instance_id = uint(_2277);
    if (instance_id >= uint(_1655.instance_params.buffer_capacity))
    {
        return;
    }
    _2290.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _2290.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _2290.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _2313.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _2313.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _2334.instance_hash[instance_id] = instance.hash;
    _2342.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 