#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct VertexModifierGerstnerWavesParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    uvec4 wave_directions[16];
    vec4 noise_phase;
    vec3 domain_scale;
    int _pad0;
    vec3 strength;
    int _pad1;
    vec3 position;
    int noise_relative_to_modifier;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
    float wave_length;
    float wave_steepness;
    int wave_octaves;
    float wave_octave_scale;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryCopyDeformParams
{
    int surfaces_num;
    int surface_idx;
    int attribute_mask;
    int create_copy;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    vec3 vCameraPosition;
};

layout(set = 0, binding = 1, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _172;

layout(set = 0, binding = 2, std430) buffer OutIndexBuffer
{
    uint data[];
} out_idx_data;

layout(set = 0, binding = 3, std430) buffer OutVTXCoords
{
    float data[];
} out_vtx_coords;

layout(set = 0, binding = 4, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 5, std430) buffer OutVTXAlbedo
{
    float data[];
} out_vtx_albedo;

layout(set = 0, binding = 6, std430) buffer OutVTXCustom0
{
    uint data[];
} out_vtx_custom0;

layout(set = 0, binding = 13, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _287;

layout(set = 0, binding = 7, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 8, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 9, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 10, std430) readonly buffer InVTXAlbedo
{
    float data[];
} in_vtx_albedo;

layout(set = 0, binding = 11, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 14, std140) uniform VM0
{
    layout(row_major) VertexModifierGerstnerWavesParams VM0_params;
} _681;

layout(set = 0, binding = 15, std140) uniform GeometryCopyDeformParamsBuffer
{
    GeometryCopyDeformParams geometry_copy_deform_params;
} _710;

layout(set = 0, binding = 12, std430) buffer VertexCopyFlagBuffer
{
    uint data[];
} vtx_copy_flag_data;

uint get_idx(inout uint idx)
{
    idx += _287.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

void put_idx(inout uint idx, uint v)
{
    idx += _172.output_geometry_information.idx_buffer_offset;
    out_idx_data.data[idx] = v;
}

vec3 get_coords(inout uint idx)
{
    idx *= _287.input_geometry_information.attributes[0].stride;
    idx += _287.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

vec3 get_normal(inout uint idx)
{
    idx *= _287.input_geometry_information.attributes[1].stride;
    idx += _287.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

vec3 get_albedo(inout uint idx)
{
    idx *= _287.input_geometry_information.attributes[2].stride;
    idx += _287.input_geometry_information.attributes[2].offset;
    return vec3(in_vtx_albedo.data[idx + 0u], in_vtx_albedo.data[idx + 1u], in_vtx_albedo.data[idx + 2u]);
}

uint get_custom0(inout uint idx)
{
    idx *= _287.input_geometry_information.attributes[6].stride;
    idx += _287.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec2 gerstner_evaluate_single(vec2 p, float t, float steepness, float wave_length, vec2 wave_direction)
{
    float k = 6.283185482025146484375 / wave_length;
    float c = sqrt(9.80000019073486328125 / k);
    float f = k * (dot(wave_direction, p) - (c * t));
    float a = steepness / k;
    return vec2(a * cos(f), a * sin(f));
}

void vertex_modifier_gerstner_waves_apply(VertexModifierGerstnerWavesParams params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx.pos;
    vec3 influence_pos = vtx.pos;
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param = noise_pos;
        mat4 param_1 = params.transform_local;
        vec3 _456 = vector_transform_by_mat43(param, param_1);
        noise_pos = _456;
    }
    float influence = modifier_factor.factor;
    if (influence > 0.0)
    {
        vec2 wave = vec2(0.0);
        float wave_length = params.wave_length;
        vec2 wave_direction;
        int wi = 0;
        for (;;)
        {
            if (wi < params.wave_octaves)
            {
                if ((wi & 3) == 0)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].x);
                }
                if ((wi & 3) == 1)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].y);
                }
                if ((wi & 3) == 2)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].z);
                }
                if ((wi & 3) == 3)
                {
                    wave_direction = unpackHalf2x16(params.wave_directions[wi >> 2].w);
                }
                float steepness_modulated_by_strength = params.wave_steepness / params.strength.x;
                vec2 param_2 = (noise_pos.xz * params.domain_scale.xy) + (params.domain_scale.xy * float(wi));
                float param_3 = params.noise_phase.x;
                float param_4 = steepness_modulated_by_strength;
                float param_5 = wave_length;
                vec2 param_6 = wave_direction;
                wave += gerstner_evaluate_single(param_2, param_3, param_4, param_5, param_6);
                wave_length *= params.wave_octave_scale;
                wi++;
                continue;
            }
            else
            {
                break;
            }
        }
        wave += vec2(params.noise_value_base);
        vec3 local_norm = vtx.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_7 = modifier_position;
            mat4 param_8 = params.transform_local;
            vec3 _582 = vector_transform_by_mat43(param_7, param_8);
            local_norm = normalize(base_pos - _582);
        }
        vec3 new_pos = base_pos;
        new_pos.x += (wave.x * params.strength.x);
        new_pos.y += (wave.y * params.strength.y);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        vtx.pos = new_pos;
    }
    if (false)
    {
        vtx.color.x = 0.0;
        vtx.color.y = 0.0;
        vtx.color.z = 0.0;
        vtx.color.x = max(0.0, influence);
    }
}

VertexInput apply_vertex_modifier_for_vtx(uint i0, inout VertexInput vtx_input, out float factor)
{
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_instance_model;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = i0;
    modifier_factor.id = i0;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    if ((_287.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param = i0;
        uint _649 = get_custom0(param);
        modifier_factor.custom0 = _649;
    }
    if ((_287.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = i0;
        vec3 _660 = get_albedo(param_1);
        modifier_factor.color.x = _660.x;
        modifier_factor.color.y = _660.y;
        modifier_factor.color.z = _660.z;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    VertexModifierGerstnerWavesParams _686;
    _686.transform_world_to_local = _681.VM0_params.transform_world_to_local;
    _686.transform_local_to_world = _681.VM0_params.transform_local_to_world;
    _686.transform_local = _681.VM0_params.transform_local;
    _686.transform_local_inv = _681.VM0_params.transform_local_inv;
    _686.transform_parent = _681.VM0_params.transform_parent;
    _686.transform_parent_inv = _681.VM0_params.transform_parent_inv;
    _686.wave_directions[0] = _681.VM0_params.wave_directions[0];
    _686.wave_directions[1] = _681.VM0_params.wave_directions[1];
    _686.wave_directions[2] = _681.VM0_params.wave_directions[2];
    _686.wave_directions[3] = _681.VM0_params.wave_directions[3];
    _686.wave_directions[4] = _681.VM0_params.wave_directions[4];
    _686.wave_directions[5] = _681.VM0_params.wave_directions[5];
    _686.wave_directions[6] = _681.VM0_params.wave_directions[6];
    _686.wave_directions[7] = _681.VM0_params.wave_directions[7];
    _686.wave_directions[8] = _681.VM0_params.wave_directions[8];
    _686.wave_directions[9] = _681.VM0_params.wave_directions[9];
    _686.wave_directions[10] = _681.VM0_params.wave_directions[10];
    _686.wave_directions[11] = _681.VM0_params.wave_directions[11];
    _686.wave_directions[12] = _681.VM0_params.wave_directions[12];
    _686.wave_directions[13] = _681.VM0_params.wave_directions[13];
    _686.wave_directions[14] = _681.VM0_params.wave_directions[14];
    _686.wave_directions[15] = _681.VM0_params.wave_directions[15];
    _686.noise_phase = _681.VM0_params.noise_phase;
    _686.domain_scale = _681.VM0_params.domain_scale;
    _686._pad0 = _681.VM0_params._pad0;
    _686.strength = _681.VM0_params.strength;
    _686._pad1 = _681.VM0_params._pad1;
    _686.position = _681.VM0_params.position;
    _686.noise_relative_to_modifier = _681.VM0_params.noise_relative_to_modifier;
    _686.displacement_mode = _681.VM0_params.displacement_mode;
    _686.noise_value_base = _681.VM0_params.noise_value_base;
    _686.noise_value_absolute = _681.VM0_params.noise_value_absolute;
    _686.wave_length = _681.VM0_params.wave_length;
    _686.wave_steepness = _681.VM0_params.wave_steepness;
    _686.wave_octaves = _681.VM0_params.wave_octaves;
    _686.wave_octave_scale = _681.VM0_params.wave_octave_scale;
    VertexModifierGerstnerWavesParams param_2 = _686;
    ModifierFactor param_3 = modifier_factor;
    VertexInput param_4 = vtx_input;
    vertex_modifier_gerstner_waves_apply(param_2, param_3, param_4);
    modifier_factor = param_3;
    vtx_input = param_4;
    factor = modifier_factor.factor;
    return vtx_input;
}

void put_coords(inout uint idx, vec3 v)
{
    idx *= _172.output_geometry_information.attributes[0].stride;
    idx += _172.output_geometry_information.attributes[0].offset;
    out_vtx_coords.data[idx + 0u] = v.x;
    out_vtx_coords.data[idx + 1u] = v.y;
    out_vtx_coords.data[idx + 2u] = v.z;
}

void put_normal(inout uint idx, vec3 v)
{
    idx *= _172.output_geometry_information.attributes[1].stride;
    idx += _172.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

void put_albedo(inout uint idx, vec3 v)
{
    idx *= _172.output_geometry_information.attributes[2].stride;
    idx += _172.output_geometry_information.attributes[2].offset;
    out_vtx_albedo.data[idx + 0u] = v.x;
    out_vtx_albedo.data[idx + 1u] = v.y;
    out_vtx_albedo.data[idx + 2u] = v.z;
}

void put_custom0(inout uint idx, uint v)
{
    idx *= _172.output_geometry_information.attributes[6].stride;
    idx += _172.output_geometry_information.attributes[6].offset;
    out_vtx_custom0.data[idx + 0u] = v;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = uint(_710.geometry_copy_deform_params.surface_idx);
    uint src_faces_num = _287.input_geometry_information.faces_num_per_surface[surface_idx];
    uint src_face_idx = thread_idx;
    for (;;)
    {
        if (src_face_idx < src_faces_num)
        {
            uint param = (src_face_idx * 3u) + 0u;
            uint _734 = get_idx(param);
            uint i0 = _734;
            uint param_1 = (src_face_idx * 3u) + 1u;
            uint _740 = get_idx(param_1);
            uint i1 = _740;
            uint param_2 = (src_face_idx * 3u) + 2u;
            uint _746 = get_idx(param_2);
            uint i2 = _746;
            uint dst_face_idx = src_face_idx;
            uint param_3 = (dst_face_idx * 3u) + 0u;
            uint param_4 = i0;
            put_idx(param_3, param_4);
            uint param_5 = (dst_face_idx * 3u) + 1u;
            uint param_6 = i1;
            put_idx(param_5, param_6);
            uint param_7 = (dst_face_idx * 3u) + 2u;
            uint param_8 = i2;
            put_idx(param_7, param_8);
            src_face_idx += 131072u;
            continue;
        }
        else
        {
            break;
        }
    }
    _172.output_geometry_information.faces_num_per_surface[surface_idx] = src_faces_num;
    if (surface_idx == 0u)
    {
        uint src_vtx_num = _287.input_geometry_information.vtx_num;
        VertexInput vtx_input;
        float param_15;
        uint src_vtx_idx = thread_idx;
        for (;;)
        {
            if (src_vtx_idx < src_vtx_num)
            {
                uint i0_1 = src_vtx_idx;
                uint i0_remapped = vtx_copy_flag_data.data[i0_1];
                bool i0_copy = i0_remapped != 0u;
                i0_remapped--;
                if (i0_copy)
                {
                    uint param_9 = i0_1;
                    vec3 _814 = get_coords(param_9);
                    vec3 v0_coords = _814;
                    vec3 v0_normal = vec3(0.0, 0.0, 1.0);
                    if ((_287.input_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_10 = i0_1;
                        vec3 _825 = get_normal(param_10);
                        v0_normal = _825;
                    }
                    vec3 v0_albedo = vec3(1.0);
                    if ((_287.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
                    {
                        uint param_11 = i0_1;
                        vec3 _836 = get_albedo(param_11);
                        v0_albedo = _836;
                    }
                    uint v0_custom0 = 0u;
                    if ((_287.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_12 = i0_1;
                        uint _846 = get_custom0(param_12);
                        v0_custom0 = _846;
                    }
                    vtx_input.pos = v0_coords;
                    vtx_input.norm = v0_normal;
                    vtx_input.color.x = v0_albedo.x;
                    vtx_input.color.y = v0_albedo.y;
                    vtx_input.color.z = v0_albedo.z;
                    uint param_13 = i0_1;
                    VertexInput param_14 = vtx_input;
                    VertexInput _865 = apply_vertex_modifier_for_vtx(param_13, param_14, param_15);
                    float modifier_factor = param_15;
                    vtx_input = _865;
                    if (_710.geometry_copy_deform_params.export_factor_as_custom0 != 0)
                    {
                        v0_custom0 = floatBitsToUint(modifier_factor);
                    }
                    uint param_16 = i0_remapped;
                    vec3 param_17 = vtx_input.pos;
                    put_coords(param_16, param_17);
                    if ((_172.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                    {
                        uint param_18 = i0_remapped;
                        vec3 param_19 = vtx_input.norm;
                        put_normal(param_18, param_19);
                    }
                    if ((_172.output_geometry_information.builtin_attribute_mask & 4u) != 0u)
                    {
                        uint param_20 = i0_remapped;
                        vec3 param_21 = v0_albedo;
                        put_albedo(param_20, param_21);
                    }
                    if ((_172.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                    {
                        uint param_22 = i0_remapped;
                        uint param_23 = v0_custom0;
                        put_custom0(param_22, param_23);
                    }
                }
                src_vtx_idx += 131072u;
                continue;
            }
            else
            {
                break;
            }
        }
    }
}

 