#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct AngularInfo
{
    float NdotL;
    float NdotV;
    float NdotH;
    float LdotH;
    float VdotH;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct LTCRect
{
    vec3 center;
    vec3 dirx;
    vec3 diry;
    float halfx;
    float halfy;
    vec4 plane;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct intersection
{
    float t;
    vec3 normal;
    float denom;
    vec2 bc;
    bool in_triangle;
};

struct IBLOutput
{
    vec3 color_weighted;
    vec3 color_raw;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct RTSetup
{
    mat4 mat_projection;
    mat4 mat_model;
    vec3 camera_position;
    int screen_sampling_scale;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 frustum_shift;
    vec2 resolution;
    float trace_range_primary;
    float trace_range_secondary;
    float roughness_clamp;
    float env_map_intensity;
    int lights_num;
    float initial_face_start_distance;
    uint material_flags;
    uint reflect_rays;
    int reflection_gradient_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct RTCompositeParams
{
    uint _pad0;
    uint _pad1;
    uint _pad2;
    uint _pad3;
};

layout(set = 0, binding = 4, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _705;

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _1978;

layout(set = 0, binding = 2, std430) buffer TransformedDataFacesBuffer
{
    TransformedDataFace transformed_data_faces[];
} _2085;

layout(set = 0, binding = 3, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _2098;

layout(set = 0, binding = 5, std140) uniform RTSetupBuffer
{
    layout(row_major) RTSetup rt_setup;
} _2209;

layout(set = 0, binding = 6, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 7, std140) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 0, binding = 12) uniform sampler2D s_Gradients;
layout(set = 0, binding = 13) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 14) uniform sampler2D s_LTC2;
layout(set = 0, binding = 15) uniform sampler2D s_BRDF;
layout(set = 0, binding = 16) uniform samplerCube s_reflection;
layout(set = 0, binding = 17) uniform sampler2D material_textures[64];
layout(set = 0, binding = 81) uniform sampler2DShadow LightShadowmapCmpSamplers[16];
layout(set = 0, binding = 97) uniform sampler2D LightProjectorSamplers[16];
layout(set = 0, binding = 113) uniform sampler2D s_LTC1;
layout(set = 0, binding = 8, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 9, rgba32f) uniform readonly image2D imHitDirectionPrimitiveID;
layout(set = 0, binding = 10, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 114) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 11, rgba16f) uniform writeonly image2D imTarget;

bool twoSided;
bool clipless;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _392;
    if (nor.x > 0.0)
    {
        _392 = -t;
    }
    else
    {
        _392 = t;
    }
    nor.x += _392;
    float _407;
    if (nor.y > 0.0)
    {
        _407 = -t;
    }
    else
    {
        _407 = t;
    }
    nor.y += _407;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

float linearizeDepth(float d)
{
    return _2209.rt_setup.near_far_plane.z / ((_2209.rt_setup.near_far_plane.y + _2209.rt_setup.near_far_plane.x) - (d * _2209.rt_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 rt_randomize_dir_for_roughness(inout ivec2 screen_pos, inout vec3 dir, vec3 n, inout float roughness, inout float bounce_throughput)
{
    bounce_throughput = 1.0;
    if (roughness > 0.0)
    {
        roughness = min(_2209.rt_setup.roughness_clamp, roughness);
        roughness = dot(dir, n) * roughness;
        bounce_throughput *= max(0.0, 1.0 - roughness);
        int frame = _705.globals.monotonic & 127;
        float clamped_roughness = roughness * roughness;
        screen_pos &= ivec2(127);
        vec2 _noise = texelFetch(s_BlueNoise, ivec3(screen_pos, 0), 0).xy;
        vec2 hash = fract(_noise + vec2(float(frame) * 1.61803400516510009765625));
        float param = hash.x * clamped_roughness;
        float param_1 = hash.y;
        vec3 d = CosineSampleHemisphere(param, param_1);
        vec3 param_2 = dir;
        mat3 _2657 = matrixFromVector(param_2);
        mat3 vecSpace = _2657;
        d = vecSpace * d;
        float VdotN = dot(d, n);
        if ((VdotN < 0.0) && true)
        {
            hash = fract(_noise + vec2(float(frame + 10) * 1.61803400516510009765625));
            float param_3 = hash.x * clamped_roughness;
            float param_4 = hash.y;
            d = CosineSampleHemisphere(param_3, param_4);
            d = vecSpace * d;
            VdotN = dot(d, n);
            if (VdotN > 0.0)
            {
                dir = d;
            }
        }
        else
        {
            dir = d;
        }
    }
    return dir;
}

vec3 glass_refract(vec3 v, vec3 n)
{
    float s = (dot(vec3(v), n) < 0.0) ? 1.0 : (-1.0);
    vec3 new_v = refract(v, n * s, 0.800000011920928955078125);
    if (dot(new_v, new_v) == 0.0)
    {
        return v;
    }
    return new_v;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _2098.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _2098.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _2098.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_1978.in_vtx_data[coord_offset + 0u], _1978.in_vtx_data[coord_offset + 1u], _1978.in_vtx_data[coord_offset + 2u]);
    return p;
}

RTFace find_best_face_candidate_by_direction(uvec2 pixel_pos, inout uint hit_primitiveID, vec3 origin, vec3 dir, vec3 normal, out float ratio)
{
    uint param = hit_primitiveID;
    RTFace rt_face = rt_get_face(param);
    uint param_1 = rt_face.v0;
    vec3 p0 = rt_get_vertex(param_1);
    uint param_2 = rt_face.v1;
    vec3 p1 = rt_get_vertex(param_2);
    uint param_3 = rt_face.v2;
    vec3 p2 = rt_get_vertex(param_3);
    float closest_dir = 2.0;
    uint encoded_normal_material = imageLoad(imNormalMaterial, ivec2(pixel_pos)).x;
    uint param_4 = encoded_normal_material;
    vec3 _3469 = decode_normal(param_4);
    vec3 n = _3469;
    vec4 hit_direction_primitiveID = imageLoad(imHitDirectionPrimitiveID, ivec2(pixel_pos));
    vec3 hit_direction = hit_direction_primitiveID.xyz;
    closest_dir = 1.0 - dot(hit_direction, dir);
    ratio = closest_dir;
    int iy = -2;
    for (;;)
    {
        if (iy <= 2)
        {
            int ix = -2;
            for (;;)
            {
                if (ix <= 2)
                {
                    vec4 hit_direction_primitiveID_1 = imageLoad(imHitDirectionPrimitiveID, ivec2(pixel_pos) + ivec2(ix, iy));
                    float param_5 = hit_direction_primitiveID_1.w;
                    uint hit_primitiveID_candidate = asuint(param_5);
                    uint encoded_normal_material_1 = imageLoad(imNormalMaterial, ivec2(pixel_pos) + ivec2(ix, iy)).x;
                    uint param_6 = encoded_normal_material_1;
                    vec3 _3530 = decode_normal(param_6);
                    vec3 n_1 = _3530;
                    vec3 hit_direction_1 = hit_direction_primitiveID_1.xyz;
                    bool _3536 = hit_direction_1.x != 0.0;
                    bool _3542;
                    if (_3536)
                    {
                        _3542 = hit_direction_1.y != 0.0;
                    }
                    else
                    {
                        _3542 = _3536;
                    }
                    bool _3548;
                    if (_3542)
                    {
                        _3548 = hit_direction_1.z != 0.0;
                    }
                    else
                    {
                        _3548 = _3542;
                    }
                    if (_3548)
                    {
                        float dir_diff = 1.0 - dot(hit_direction_1, dir);
                        if (dir_diff < closest_dir)
                        {
                            closest_dir = dir_diff;
                            hit_primitiveID = hit_primitiveID_candidate;
                            uint param_7 = hit_primitiveID;
                            rt_face = rt_get_face(param_7);
                        }
                    }
                    ix++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            iy++;
            continue;
        }
        else
        {
            break;
        }
    }
    ratio = closest_dir;
    return rt_face;
}

intersection intersect_triangle(vec3 orig, vec3 dir, vec3 v0, vec3 v1, vec3 v2)
{
    intersection it;
    it.t = -1.0;
    it.in_triangle = true;
    vec3 e1 = v1 - v0;
    vec3 e2 = v2 - v0;
    vec3 pvec = cross(dir, e2);
    float det = dot(e1, pvec);
    if (abs(det) < 1.0000000116860974230803549289703e-07)
    {
        it.in_triangle = false;
    }
    float inv_det = 1.0 / det;
    vec3 tvec = orig - v0;
    float u = dot(tvec, pvec) * inv_det;
    if ((u < 0.0) || (u > 1.0))
    {
        it.in_triangle = false;
    }
    vec3 qvec = cross(tvec, e1);
    float v = dot(dir, qvec) * inv_det;
    bool _2472 = v < 0.0;
    bool _2480;
    if (!_2472)
    {
        _2480 = (u + v) > 1.0;
    }
    else
    {
        _2480 = _2472;
    }
    if (_2480)
    {
        it.in_triangle = false;
    }
    float t = dot(e2, qvec) * inv_det;
    if (t > 1.0000000116860974230803549289703e-07)
    {
        it.normal = vec3(normalize(cross(e2, e1)));
        float denom = dot(vec3(it.normal), dir);
        vec3 p0l0 = v0 - orig;
        it.t = t;
        it.denom = denom;
        it.bc.x = u / denom;
        it.bc.y = v / denom;
    }
    return it;
}

vec2 rt_barycentric_yz(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 v0 = b - a;
    vec3 v1 = c - a;
    vec3 v2 = p - a;
    float d00 = dot(v0, v0);
    float d01 = dot(v0, v1);
    float d11 = dot(v1, v1);
    float d20 = dot(v2, v0);
    float d21 = dot(v2, v1);
    float denom = (d00 * d11) - (d01 * d01);
    vec3 bc;
    bc.y = ((d11 * d20) - (d01 * d21)) / denom;
    bc.z = ((d00 * d21) - (d01 * d20)) / denom;
    return bc.yz;
}

vec2 barycentric_for_face_yz(int idx, vec3 p)
{
    uint param = uint(idx);
    RTFace rt_face = rt_get_face(param);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_1 = p0_idx;
    vec3 a = rt_get_vertex(param_1);
    uint param_2 = p1_idx;
    vec3 b = rt_get_vertex(param_2);
    uint param_3 = p2_idx;
    vec3 c = rt_get_vertex(param_3);
    vec3 param_4 = p;
    vec3 param_5 = a;
    vec3 param_6 = b;
    vec3 param_7 = c;
    return rt_barycentric_yz(param_4, param_5, param_6, param_7);
}

int rt_get_triangle_material(uint idx)
{
    int p = int(_2085.transformed_data_faces[idx].material_idx);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_1978.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

vec4 interpolate_color_from_bc_yz(int fi, vec2 bc_yz)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec4 c0 = rt_get_vertex_color(param_1);
    uint param_2 = i1;
    vec4 c1 = rt_get_vertex_color(param_2);
    uint param_3 = i2;
    vec4 c2 = rt_get_vertex_color(param_3);
    vec4 c = ((c0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (c1 * bc_yz.x)) + (c2 * bc_yz.y);
    return c;
}

vec2 rt_get_vertex_uv0(uint idx)
{
    uint uv0_offset = (idx * 2u) + 50000000u;
    vec2 p = vec2(_1978.in_vtx_data[uv0_offset + 0u], _1978.in_vtx_data[uv0_offset + 1u]);
    return p;
}

vec2 interpolate_uv_from_bc_yz(int fi, vec2 bc_yz)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec2 uv0 = rt_get_vertex_uv0(param_1);
    uint param_2 = i1;
    vec2 uv1 = rt_get_vertex_uv0(param_2);
    uint param_3 = i2;
    vec2 uv2 = rt_get_vertex_uv0(param_3);
    vec2 uv = ((uv0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (uv1 * bc_yz.x)) + (uv2 * bc_yz.y);
    return uv;
}

vec4 evaluate_albedo(int materialIndex, int fi, vec2 bc)
{
    int param = fi;
    vec2 param_1 = bc;
    vec4 c = interpolate_color_from_bc_yz(param, param_1);
    if (materials.material_properties[materialIndex].albedo_sampler >= 0)
    {
        int param_2 = fi;
        vec2 param_3 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param_2, param_3);
        c *= textureLod(material_textures[materials.material_properties[materialIndex].albedo_sampler], uv, 1.0);
    }
    return c;
}

vec3 evaluate_emissive(int materialIndex, int fi, vec2 bc)
{
    vec3 c = vec3(1.0);
    if (materials.material_properties[materialIndex].emissive_sampler >= 0)
    {
        int param = fi;
        vec2 param_1 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param, param_1);
        c = textureLod(material_textures[materials.material_properties[materialIndex].emissive_sampler], uv, 1.0).xyz;
    }
    return c;
}

vec4 evaluate_metalic_roughness(int materialIndex, int fi, vec2 bc)
{
    vec4 c = vec4(1.0);
    if (materials.material_properties[materialIndex].metalic_roughness_sampler >= 0)
    {
        int param = fi;
        vec2 param_1 = bc;
        vec2 uv = interpolate_uv_from_bc_yz(param, param_1);
        c = textureLod(material_textures[materials.material_properties[materialIndex].metalic_roughness_sampler], uv, 1.0);
    }
    return c;
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _1978.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _1978.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 interpolate_normal_from_bc_yz(int fi, vec2 bc_yz, vec3 ref_normal)
{
    uint param = uint(fi);
    RTFace rt_face = rt_get_face(param);
    uint i0 = rt_face.v0;
    uint i1 = rt_face.v1;
    uint i2 = rt_face.v2;
    uint param_1 = i0;
    vec3 n0 = rt_get_vertex_normal(param_1);
    uint param_2 = i1;
    vec3 n1 = rt_get_vertex_normal(param_2);
    uint param_3 = i2;
    vec3 n2 = rt_get_vertex_normal(param_3);
    vec3 smooth_normal = ((n0 * ((1.0 - bc_yz.x) - bc_yz.y)) + (n1 * bc_yz.x)) + (n2 * bc_yz.y);
    return normalize(smooth_normal);
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position.xyz - pos);
    float falloff = dot(light.direction.xyz, (pos - light.position.xyz) / vec3(light_distance));
    float attenuation = 0.0;
    bool _806 = falloff > cutoff;
    bool _813;
    if (_806)
    {
        _813 = light_distance < light.range;
    }
    else
    {
        _813 = _806;
    }
    if (_813)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

AngularInfo getAngularInfo(vec3 normalized_point_to_light, vec3 normal, vec3 normalized_view)
{
    vec3 n = normal;
    vec3 v = normalized_view;
    vec3 l = normalized_point_to_light;
    vec3 h = normalize(l + v);
    float NdotL = dot(n, l);
    float NdotV = dot(n, v);
    float NdotH = clamp(dot(n, h), 0.0, 1.0);
    float LdotH = clamp(dot(l, h), 0.0, 1.0);
    float VdotH = clamp(dot(v, h), 0.0, 1.0);
    AngularInfo angularInfo = AngularInfo(NdotL, NdotV, NdotH, LdotH, VdotH);
    return angularInfo;
}

vec3 specularReflection(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    return materialInfo.reflectance0 + ((materialInfo.reflectance90 - materialInfo.reflectance0) * pow(clamp(1.0 - angularInfo.VdotH, 0.0, 1.0), 5.0));
}

float visibilityOcclusion(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float NdotL = clamp(angularInfo.NdotL, 0.0, 1.0);
    float NdotV = clamp(angularInfo.NdotV, 0.0, 1.0);
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float GGXV = NdotL * sqrt(((NdotV * NdotV) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGXL = NdotV * sqrt(((NdotL * NdotL) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGX = GGXV + GGXL;
    if (GGX > 0.0)
    {
        return 0.5 / GGX;
    }
    return 0.0;
}

float microfacetDistribution(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float f = (((angularInfo.NdotH * alphaRoughnessSq) - angularInfo.NdotH) * angularInfo.NdotH) + 1.0;
    return alphaRoughnessSq / (((3.1415927410125732421875 * f) * f) + 9.9999999747524270787835121154785e-07);
}

vec3 diffuse(MaterialInfo materialInfo)
{
    return materialInfo.diffuseColor / vec3(3.1415927410125732421875);
}

vec3 getPointShade(vec3 normalized_point_to_light, MaterialInfo materialInfo, vec3 normal, vec3 normalized_view)
{
    vec3 param = normalized_point_to_light;
    vec3 param_1 = normal;
    vec3 param_2 = normalized_view;
    AngularInfo angularInfo = getAngularInfo(param, param_1, param_2);
    bool _1017 = angularInfo.NdotL > 0.0;
    bool _1024;
    if (!_1017)
    {
        _1024 = angularInfo.NdotV > 0.0;
    }
    else
    {
        _1024 = _1017;
    }
    if (_1024)
    {
        MaterialInfo param_3 = materialInfo;
        AngularInfo param_4 = angularInfo;
        vec3 F = specularReflection(param_3, param_4);
        MaterialInfo param_5 = materialInfo;
        AngularInfo param_6 = angularInfo;
        float Vis = visibilityOcclusion(param_5, param_6);
        MaterialInfo param_7 = materialInfo;
        AngularInfo param_8 = angularInfo;
        float D = microfacetDistribution(param_7, param_8);
        MaterialInfo param_9 = materialInfo;
        vec3 diffuseContrib = (vec3(1.0) - F) * diffuse(param_9);
        vec3 specContrib = (F * Vis) * D;
        return (diffuseContrib + specContrib) * clamp(angularInfo.NdotL, 0.0, 1.0);
    }
    return vec3(0.0);
}

float sampleShadowPCFNoiseOffset(sampler2DShadow smpl, inout vec4 coords, ivec2 noise_offset, out float in_frustum, int samples, float sampling_range, float shadowmap_bias)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _618 = coords.x < (-coords.w);
    bool _627;
    if (!_618)
    {
        _627 = coords.x > coords.w;
    }
    else
    {
        _627 = _618;
    }
    bool _637;
    if (!_627)
    {
        _637 = coords.y < (-coords.w);
    }
    else
    {
        _637 = _627;
    }
    bool _646;
    if (!_637)
    {
        _646 = coords.y > coords.w;
    }
    else
    {
        _646 = _637;
    }
    bool _653;
    if (!_646)
    {
        _653 = coords.z < 0.0;
    }
    else
    {
        _653 = _646;
    }
    if (_653)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _657 = coords;
    float _662 = coords.w;
    vec2 _664 = (_657.xy * vec2(0.5)) + (vec2(0.5) * _662);
    coords.x = _664.x;
    coords.y = _664.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    float bias = shadowmap_bias;
    float bias2 = 0.300000011920928955078125;
    int taken_samples = 0;
    int h_samples = samples;
    vec3 hash = texelFetch(s_BlueNoise, ivec3(noise_offset & ivec2(127), _705.globals.monotonic & 15), 0).xyz;
    int n = 0;
    for (;;)
    {
        if (n < h_samples)
        {
            vec2 xy = fract(hash.xy + vec2(float(n) * 1.61803400516510009765625)) - vec2(0.5);
            vec4 jittered_coords = coords + vec4((xy.x * sampling_range) * coords.w, (xy.y * sampling_range) * coords.w, bias, 0.0);
            vec4 _760 = jittered_coords;
            vec4 _763 = _760;
            _763.z = _760.w;
            float shadow = textureProjLod(smpl, vec4(_763.xy, _760.z, _763.z), 0.0);
            fact += shadow;
            taken_samples++;
            n++;
            continue;
        }
        else
        {
            break;
        }
    }
    return fact * (1.0 / float(h_samples));
}

vec3 sample_projector_texture(sampler2D smpl, inout vec4 coords)
{
    vec3 color = vec3(0.0);
    if (coords.w <= 0.0)
    {
        return color;
    }
    bool _2716 = coords.x < (-coords.w);
    bool _2725;
    if (!_2716)
    {
        _2725 = coords.x > coords.w;
    }
    else
    {
        _2725 = _2716;
    }
    bool _2735;
    if (!_2725)
    {
        _2735 = coords.y < (-coords.w);
    }
    else
    {
        _2735 = _2725;
    }
    bool _2744;
    if (!_2735)
    {
        _2744 = coords.y > coords.w;
    }
    else
    {
        _2744 = _2735;
    }
    if (_2744)
    {
        return color;
    }
    vec4 _2749 = coords;
    float _2753 = coords.w;
    vec2 _2755 = (_2749.xy * vec2(0.5)) + (vec2(0.5) * _2753);
    coords.x = _2755.x;
    coords.y = _2755.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    color = textureLod(smpl, coords.xy / vec2(coords.w), 0.0).xyz;
    return color;
}

void InitRect(LightProperties light, inout LTCRect rect)
{
    rect.dirx = -light.right.xyz;
    rect.diry = light.up.xyz;
    rect.center = light.position.xyz;
    rect.halfx = 0.5 * light.dimensions.x;
    rect.halfy = 0.5 * light.dimensions.y;
    vec3 rectNormal = cross(rect.dirx, rect.diry);
    rect.plane = vec4(rectNormal, -dot(rectNormal, rect.center));
}

void InitRectPoints(LTCRect rect, inout vec3 points[4])
{
    vec3 ex = rect.dirx * rect.halfx;
    vec3 ey = rect.diry * rect.halfy;
    points[0] = (rect.center - ex) - ey;
    points[1] = (rect.center + ex) - ey;
    points[2] = (rect.center + ex) + ey;
    points[3] = (rect.center - ex) + ey;
}

mat3 mul(mat3 m1, mat3 m2)
{
    return m1 * m2;
}

vec3 mul(mat3 m, vec3 v)
{
    return m * v;
}

vec3 IntegrateEdgeVec(vec3 v1, vec3 v2)
{
    float x = dot(v1, v2);
    float y = abs(x);
    float a = 0.8543984889984130859375 + ((0.4965155124664306640625 + (0.01452060043811798095703125 * y)) * y);
    float b = 3.41759395599365234375 + ((4.1616725921630859375 + y) * y);
    float v = a / b;
    float _1112;
    if (x > 0.0)
    {
        _1112 = v;
    }
    else
    {
        _1112 = (0.5 * inversesqrt(max(1.0 - (x * x), 1.0000000116860974230803549289703e-07))) - v;
    }
    float theta_sintheta = _1112;
    return cross(v1, v2) * theta_sintheta;
}

void ClipQuadToHorizon(inout vec3 L[5], inout int n)
{
    int config = 0;
    if (L[0].z > 0.0)
    {
        config++;
    }
    if (L[1].z > 0.0)
    {
        config += 2;
    }
    if (L[2].z > 0.0)
    {
        config += 4;
    }
    if (L[3].z > 0.0)
    {
        config += 8;
    }
    n = 0;
    if (config == 0)
    {
    }
    else
    {
        if (config == 1)
        {
            n = 3;
            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
            L[2] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
        }
        else
        {
            if (config == 2)
            {
                n = 3;
                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
            }
            else
            {
                if (config == 3)
                {
                    n = 4;
                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                    L[3] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                }
                else
                {
                    if (config == 4)
                    {
                        n = 3;
                        L[0] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                    }
                    else
                    {
                        if (config == 5)
                        {
                            n = 0;
                        }
                        else
                        {
                            if (config == 6)
                            {
                                n = 4;
                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                            }
                            else
                            {
                                if (config == 7)
                                {
                                    n = 5;
                                    L[4] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                                    L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                                }
                                else
                                {
                                    if (config == 8)
                                    {
                                        n = 3;
                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                        L[1] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        L[2] = L[3];
                                    }
                                    else
                                    {
                                        if (config == 9)
                                        {
                                            n = 4;
                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                            L[2] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        }
                                        else
                                        {
                                            if (config == 10)
                                            {
                                                n = 0;
                                            }
                                            else
                                            {
                                                if (config == 11)
                                                {
                                                    n = 5;
                                                    L[4] = L[3];
                                                    L[3] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                                                }
                                                else
                                                {
                                                    if (config == 12)
                                                    {
                                                        n = 4;
                                                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                    }
                                                    else
                                                    {
                                                        if (config == 13)
                                                        {
                                                            n = 5;
                                                            L[4] = L[3];
                                                            L[3] = L[2];
                                                            L[2] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                                        }
                                                        else
                                                        {
                                                            if (config == 14)
                                                            {
                                                                n = 5;
                                                                L[4] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                                            }
                                                            else
                                                            {
                                                                if (config == 15)
                                                                {
                                                                    n = 4;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (n == 3)
    {
        L[3] = L[0];
    }
    if (n == 4)
    {
        L[4] = L[0];
    }
}

float IntegrateEdge(vec3 v1, vec3 v2)
{
    vec3 param = v1;
    vec3 param_1 = v2;
    return IntegrateEdgeVec(param, param_1).z;
}

vec3 LTC_Evaluate(vec3 N, vec3 V, vec3 P, inout mat3 Minv, vec3 points[4], bool twoSided_1)
{
    vec3 T1 = normalize(V - (N * dot(V, N)));
    vec3 T2 = cross(N, T1);
    mat3 param = Minv;
    mat3 param_1 = transpose(mat3(vec3(T1), vec3(T2), vec3(N)));
    Minv = mul(param, param_1);
    mat3 param_2 = Minv;
    vec3 param_3 = points[0] - P;
    vec3 L[5];
    L[0] = mul(param_2, param_3);
    mat3 param_4 = Minv;
    vec3 param_5 = points[1] - P;
    L[1] = mul(param_4, param_5);
    mat3 param_6 = Minv;
    vec3 param_7 = points[2] - P;
    L[2] = mul(param_6, param_7);
    mat3 param_8 = Minv;
    vec3 param_9 = points[3] - P;
    L[3] = mul(param_8, param_9);
    float sum = 0.0;
    if (clipless)
    {
        vec3 dir = points[0] - P;
        vec3 lightNormal = cross(points[1] - points[0], points[3] - points[0]);
        bool behind = dot(dir, lightNormal) < 0.0;
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        vec3 vsum = vec3(0.0);
        vec3 param_10 = L[0];
        vec3 param_11 = L[1];
        vsum += IntegrateEdgeVec(param_10, param_11);
        vec3 param_12 = L[1];
        vec3 param_13 = L[2];
        vsum += IntegrateEdgeVec(param_12, param_13);
        vec3 param_14 = L[2];
        vec3 param_15 = L[3];
        vsum += IntegrateEdgeVec(param_14, param_15);
        vec3 param_16 = L[3];
        vec3 param_17 = L[0];
        vsum += IntegrateEdgeVec(param_16, param_17);
        float len = length(vsum);
        float z = vsum.z / len;
        if (behind)
        {
            z = -z;
        }
        vec2 uv = vec2((z * 0.5) + 0.5, len);
        uv = (uv * 0.984375) + vec2(0.0078125);
        float scale = textureLod(s_LTC2, uv, 0.0).w;
        sum = len * scale;
        if (behind && (!twoSided_1))
        {
            sum = 0.0;
        }
    }
    else
    {
        vec3 param_18[5] = L;
        int param_19;
        ClipQuadToHorizon(param_18, param_19);
        L = param_18;
        int n = param_19;
        if (n == 0)
        {
            return vec3(0.0);
        }
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        L[4] = normalize(L[4]);
        vec3 param_20 = L[0];
        vec3 param_21 = L[1];
        sum += IntegrateEdge(param_20, param_21);
        vec3 param_22 = L[1];
        vec3 param_23 = L[2];
        sum += IntegrateEdge(param_22, param_23);
        vec3 param_24 = L[2];
        vec3 param_25 = L[3];
        sum += IntegrateEdge(param_24, param_25);
        if (n >= 4)
        {
            vec3 param_26 = L[3];
            vec3 param_27 = L[4];
            sum += IntegrateEdge(param_26, param_27);
        }
        if (n == 5)
        {
            vec3 param_28 = L[4];
            vec3 param_29 = L[0];
            sum += IntegrateEdge(param_28, param_29);
        }
        float _1874;
        if (twoSided_1)
        {
            _1874 = abs(sum);
        }
        else
        {
            _1874 = max(0.0, sum);
        }
        sum = _1874;
    }
    vec3 Lo_i = vec3(sum, sum, sum);
    return Lo_i;
}

float light_calculate_area_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position.xyz - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0 - clamp(light_distance / light.range, 0.0, 1.0);
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

IBLOutput ibl(vec3 n, vec3 v, vec3 diffuseColor, vec3 specularColor, vec3 f0, vec3 f90, float perceptual_roughness)
{
    float NdotV = clamp(dot(n, v), 0.0, 1.0);
    vec3 r = reflect(-v, n);
    float mip_count = 7.5;
    float lod = clamp(perceptual_roughness * mip_count, 0.0, mip_count);
    vec2 brdf_sample_point = clamp(vec2(NdotV, 1.0 - perceptual_roughness), vec2(0.0), vec2(1.0));
    vec2 brdf = textureLod(s_BRDF, brdf_sample_point, 0.0).xy;
    vec3 diffuseLight = textureLod(s_reflection, n, 5.0).xyz;
    vec3 specularLight = textureLod(s_reflection, r, lod).xyz * (brdf.x + brdf.y);
    IBLOutput ibl_1;
    ibl_1.color_weighted = (diffuseColor * diffuseLight) + (specularColor * specularLight);
    ibl_1.color_raw = diffuseLight + specularLight;
    return ibl_1;
}

vec3 evaluate_lighting(ivec2 screen_pos, vec3 p, vec3 o, vec3 n, int material, vec3 albedo, vec3 emissive, vec4 metalic_roughness)
{
    vec3 c = vec3(0.0);
    vec3 world = p;
    vec3 view = normalize(o - p);
    vec3 f0 = vec3(0.039999999105930328369140625);
    float metallic = metalic_roughness.x * materials.material_properties[material].metalness;
    vec3 baseColor = clamp(materials.material_properties[material].diffuse * albedo, vec3(0.0), vec3(1.0));
    vec3 diffuseColor = (baseColor * (vec3(1.0) - f0)) * (1.0 - metallic);
    vec3 specularColor = mix(f0, baseColor, vec3(metallic));
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    uint material_flags = materials.material_properties[material].flags;
    float roughness = metalic_roughness.y * materials.material_properties[material].roughness;
    float alphaRoughness = roughness * roughness;
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    float param_8;
    LTCRect param_14;
    vec3 param_16[4];
    int light_idx = 0;
    for (;;)
    {
        if (light_idx < _2209.rt_setup.lights_num)
        {
            LightProperties _3057;
            _3057.diffuse = lights.light_properties[light_idx].diffuse;
            _3057.direction = lights.light_properties[light_idx].direction;
            _3057.position = lights.light_properties[light_idx].position;
            _3057.up = lights.light_properties[light_idx].up;
            _3057.right = lights.light_properties[light_idx].right;
            _3057.dimensions = lights.light_properties[light_idx].dimensions;
            _3057._pad1 = lights.light_properties[light_idx]._pad1;
            _3057.intensity = lights.light_properties[light_idx].intensity;
            _3057.range = lights.light_properties[light_idx].range;
            _3057.cutoff = lights.light_properties[light_idx].cutoff;
            _3057.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
            _3057.is_area = lights.light_properties[light_idx].is_area;
            _3057.type = lights.light_properties[light_idx].type;
            _3057.projector_sampler = lights.light_properties[light_idx].projector_sampler;
            _3057.projector_intensity = lights.light_properties[light_idx].projector_intensity;
            _3057.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
            _3057.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
            _3057.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
            _3057.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
            _3057.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
            _3057.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
            _3057.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
            _3057.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
            _3057.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
            _3057.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
            _3057.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
            _3057.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
            _3057.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
            _3057.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
            _3057.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
            _3057.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
            _3057.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
            LightProperties light = _3057;
            bool _3061 = (material_flags & 512u) != 0u;
            bool _3068;
            if (_3061)
            {
                _3068 = (light.type & 8) != 0;
            }
            else
            {
                _3068 = _3061;
            }
            bool calculate_shadows = _3068;
            vec3 lighting = vec3(0.0);
            if ((light.type & 3) != 0)
            {
                vec3 pointToLight = light.position.xyz - world;
                if ((light.type & 1) != 0)
                {
                    pointToLight = -light.direction.xyz;
                }
                pointToLight = normalize(pointToLight);
                float NdotL = dot(vec3(n), pointToLight);
                if (NdotL > 0.0)
                {
                    float attenuation = 1.0;
                    if ((light.type & 2) != 0)
                    {
                        LightProperties param = light;
                        vec3 param_1 = world;
                        attenuation = light_calculate_spot_attenuation(param, param_1);
                    }
                    if (attenuation > 0.0)
                    {
                        vec3 param_2 = pointToLight;
                        MaterialInfo param_3 = materialInfo;
                        vec3 param_4 = n;
                        vec3 param_5 = view;
                        lighting = (getPointShade(param_2, param_3, param_4, param_5) * (light.intensity * attenuation)) * light.diffuse.xyz;
                    }
                }
                bool _3142 = lighting.x > 0.0;
                bool _3149;
                if (!_3142)
                {
                    _3149 = lighting.y > 0.0;
                }
                else
                {
                    _3149 = _3142;
                }
                bool _3156;
                if (!_3149)
                {
                    _3156 = lighting.z > 0.0;
                }
                else
                {
                    _3156 = _3149;
                }
                if (_3156)
                {
                    vec4 vShadowCoords = (light.mat_shadow_p[0] * light.mat_shadow_mv) * vec4(world, 1.0);
                    float shadow = 0.0;
                    if (calculate_shadows)
                    {
                        float in_frustum = 0.0;
                        int light_iterations = 4;
                        float penumbra = 0.25;
                        vec4 param_6 = vShadowCoords;
                        ivec2 param_7 = screen_pos;
                        int param_9 = light_iterations;
                        float param_10 = max(0.25, penumbra * light.roughness_modifier) / 1024.0;
                        float param_11 = materials.material_properties[material].shadowmap_bias;
                        float _3206 = sampleShadowPCFNoiseOffset(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param_6, param_7, param_8, param_9, param_10, param_11);
                        in_frustum = param_8;
                        shadow = _3206;
                    }
                    if ((light.type & 16) != 0)
                    {
                        vec4 param_12 = vShadowCoords;
                        vec3 _3222 = sample_projector_texture(LightProjectorSamplers[light.projector_sampler], param_12);
                        lighting *= (_3222 * ((1.0 - shadow) * light.projector_intensity));
                    }
                    else
                    {
                        lighting *= (1.0 - shadow);
                    }
                }
            }
            if (light.is_area != 0)
            {
                LightProperties param_13 = light;
                InitRect(param_13, param_14);
                LTCRect rect = param_14;
                LTCRect param_15 = rect;
                InitRectPoints(param_15, param_16);
                vec3 points[4] = param_16;
                float ltc_roughness = roughness;
                float ltc_intensity = light.intensity;
                vec3 dcol = light.diffuse.xyz;
                vec3 scol = dcol;
                vec3 col = vec3(0.0);
                vec3 pos = world;
                vec3 N = n;
                vec3 V = normalize(o - world);
                float ndotv = clamp(dot(N, V), 0.0500000007450580596923828125, 1.0);
                vec2 uv = vec2(ltc_roughness, sqrt(1.0 - ndotv));
                uv = (uv * 0.984375) + vec2(0.0078125);
                vec4 t1 = textureLod(s_LTC1, uv, 0.0);
                vec4 t2 = textureLod(s_LTC2, uv, 0.0);
                mat3 Minv = mat3(vec3(vec3(t1.x, 0.0, t1.y)), vec3(0.0, 1.0, 0.0), vec3(vec3(t1.z, 0.0, t1.w)));
                vec3 param_17 = N;
                vec3 param_18 = V;
                vec3 param_19 = pos;
                mat3 param_20 = Minv;
                vec3 param_21[4] = points;
                bool param_22 = twoSided;
                vec3 _3337 = LTC_Evaluate(param_17, param_18, param_19, param_20, param_21, param_22);
                vec3 spec = _3337;
                spec *= ((scol * t2.x) + ((vec3(1.0) - scol) * t2.y));
                vec3 param_23 = N;
                vec3 param_24 = V;
                vec3 param_25 = pos;
                mat3 param_26 = mat3(vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0));
                vec3 param_27[4] = points;
                bool param_28 = twoSided;
                vec3 _3366 = LTC_Evaluate(param_23, param_24, param_25, param_26, param_27, param_28);
                vec3 diff = _3366;
                col = ((spec * specularColor) + ((dcol * diff) * diffuseColor)) * ltc_intensity;
                lighting = col;
                if ((light.type & 128) == 128)
                {
                    LightProperties param_29 = light;
                    vec3 param_30 = world;
                    float attenuation_1 = light_calculate_area_attenuation(param_29, param_30);
                    lighting *= attenuation_1;
                }
            }
            c += lighting;
            light_idx++;
            continue;
        }
        else
        {
            break;
        }
    }
    vec3 param_31 = n;
    vec3 param_32 = view;
    vec3 param_33 = diffuseColor;
    vec3 param_34 = specularColor;
    vec3 param_35 = specularEnvironmentR0;
    vec3 param_36 = specularEnvironmentR90;
    float param_37 = roughness;
    IBLOutput ibl_1 = ibl(param_31, param_32, param_33, param_34, param_35, param_36, param_37);
    c += (ibl_1.color_weighted * _2209.rt_setup.env_map_intensity);
    c += (emissive * materials.material_properties[material].emissive_factor);
    return vec3(c);
}

vec3 yCgCo2rgb(vec3 ycc)
{
    float R = (ycc.x - ycc.y) + ycc.z;
    float G = ycc.x + ycc.y;
    float B = (ycc.x - ycc.y) - ycc.z;
    return vec3(R, G, B);
}

vec3 spectrum_offset_ycgco(float t)
{
    vec3 ygo = vec3(1.0, 0.0, (-1.25) * t);
    vec3 param = ygo;
    return yCgCo2rgb(param);
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void main()
{
    twoSided = false;
    clipless = false;
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 pixel_pos_inv_y = pixel_pos;
    pixel_pos_inv_y.y = uint(_2209.rt_setup.resolution.y) - pixel_pos_inv_y.y;
    uvec4 param = imageLoad(imMetalnessRoughnessMaterialTags, ivec2(pixel_pos));
    MetalnessRoughnessMeterialTags mrmt = decode_metalness_roughness_material_tags(param);
    bool is_background = true;
    uint encoded_normal_material = imageLoad(imNormalMaterial, ivec2(pixel_pos)).x;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    if ((materialId & 1) != 1)
    {
        is_background = false;
    }
    uint param_2 = encoded_normal_material;
    vec3 _3627 = decode_normal(param_2);
    vec3 normal = normalize(_3627);
    vec4 color = vec4(0.0);
    vec4 hit_direction_primitiveID = imageLoad(imHitDirectionPrimitiveID, ivec2(pixel_pos));
    vec3 hit_direction = hit_direction_primitiveID.xyz;
    float param_3 = hit_direction_primitiveID.w;
    uint hit_primitiveID = asuint(param_3);
    if ((is_background == false) && (hit_primitiveID != 4294967295u))
    {
        color.w = 1.0;
        vec2 vd_pos = vec2(pixel_pos) - ((_2209.rt_setup.frustum_shift * _2209.rt_setup.resolution) * vec2(0.5, -0.5));
        vec3 view_direction;
        view_direction.x = (-_2209.rt_setup.camera_projection_params.z) + ((_2209.rt_setup.camera_projection_params.x * vd_pos.x) / _2209.rt_setup.resolution.x);
        view_direction.y = (-_2209.rt_setup.camera_projection_params.w) + ((_2209.rt_setup.camera_projection_params.y * vd_pos.y) / _2209.rt_setup.resolution.y);
        view_direction.z = 1.0;
        view_direction.y = -view_direction.y;
        float param_4 = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
        float depth = linearizeDepth(param_4);
        vec3 param_5 = view_direction;
        float param_6 = depth;
        vec3 view_coords = positionFromDepth(param_5, param_6);
        vec3 world_coords = (_2209.rt_setup.mat_model * vec4(view_coords, 1.0)).xyz;
        bool pre_step_along_ray = false;
        bool pre_step_along_normal = !pre_step_along_ray;
        vec3 origin = _2209.rt_setup.camera_position;
        vec3 dir = -normalize(_2209.rt_setup.camera_position - world_coords);
        float closest_it = length(origin - world_coords);
        origin += (dir * closest_it);
        if (pre_step_along_normal)
        {
            if (_2209.rt_setup.reflect_rays != 0u)
            {
                origin += (normal * _2209.rt_setup.initial_face_start_distance);
            }
            else
            {
                origin += ((-normal) * _2209.rt_setup.initial_face_start_distance);
            }
        }
        if (_2209.rt_setup.reflect_rays != 0u)
        {
            hit_direction = reflect(dir, normal);
            ivec2 param_7 = ivec2(pixel_pos);
            vec3 param_8 = hit_direction;
            vec3 param_9 = normal;
            float param_10 = mrmt.roughness;
            float param_11;
            vec3 _3791 = rt_randomize_dir_for_roughness(param_7, param_8, param_9, param_10, param_11);
            float foo = param_11;
            hit_direction = _3791;
        }
        else
        {
            vec3 param_12 = dir;
            vec3 param_13 = -normal;
            hit_direction = glass_refract(param_12, param_13);
        }
        float hit_match_ratio = 1.0;
        uvec2 param_14 = pixel_pos;
        uint param_15 = hit_primitiveID;
        vec3 param_16 = origin;
        vec3 param_17 = hit_direction;
        vec3 param_18 = normal;
        float param_19;
        RTFace _3813 = find_best_face_candidate_by_direction(param_14, param_15, param_16, param_17, param_18, param_19);
        hit_primitiveID = param_15;
        hit_match_ratio = param_19;
        RTFace rt_face = _3813;
        if (hit_primitiveID != 4294967295u)
        {
            uint param_20 = rt_face.v0;
            vec3 p0 = rt_get_vertex(param_20);
            uint param_21 = rt_face.v1;
            vec3 p1 = rt_get_vertex(param_21);
            uint param_22 = rt_face.v2;
            vec3 p2 = rt_get_vertex(param_22);
            vec3 param_23 = origin;
            vec3 param_24 = hit_direction;
            vec3 param_25 = p2;
            vec3 param_26 = p1;
            vec3 param_27 = p0;
            intersection it = intersect_triangle(param_23, param_24, param_25, param_26, param_27);
            bool _3853;
            if (!true)
            {
                _3853 = it.t >= 0.0;
            }
            else
            {
                _3853 = true;
            }
            if (_3853)
            {
                vec3 ri = origin + (hit_direction * it.t);
                int param_28 = int(hit_primitiveID);
                vec3 param_29 = ri;
                vec2 bc = barycentric_for_face_yz(param_28, param_29);
                uint param_30 = hit_primitiveID;
                int hit_material = rt_get_triangle_material(param_30);
                int param_31 = hit_material;
                int param_32 = int(hit_primitiveID);
                vec2 param_33 = bc;
                vec4 hit_albedo = evaluate_albedo(param_31, param_32, param_33);
                int param_34 = hit_material;
                int param_35 = int(hit_primitiveID);
                vec2 param_36 = bc;
                vec3 hit_emissive = evaluate_emissive(param_34, param_35, param_36) * materials.material_properties[hit_material].emissive;
                int param_37 = hit_material;
                int param_38 = int(hit_primitiveID);
                vec2 param_39 = bc;
                vec4 hit_metalic_roughness = evaluate_metalic_roughness(param_37, param_38, param_39);
                vec3 hit_normal = it.normal;
                if ((rt_face.material_flags & 128u) == 0u)
                {
                    int param_40 = int(hit_primitiveID);
                    vec2 param_41 = bc;
                    vec3 param_42 = hit_normal;
                    hit_normal = interpolate_normal_from_bc_yz(param_40, param_41, param_42);
                }
                ivec2 param_43 = ivec2(pixel_pos);
                vec3 param_44 = ri;
                vec3 param_45 = origin;
                vec3 param_46 = hit_normal;
                int param_47 = hit_material;
                vec3 param_48 = hit_albedo.xyz;
                vec3 param_49 = hit_emissive;
                vec4 param_50 = hit_metalic_roughness;
                vec3 _3941 = evaluate_lighting(param_43, param_44, param_45, param_46, param_47, param_48, param_49, param_50);
                color.x = _3941.x;
                color.y = _3941.y;
                color.z = _3941.z;
                color.w = hit_albedo.w * materials.material_properties[hit_material].transparency;
                if (_2209.rt_setup.reflect_rays == 0u)
                {
                    if ((rt_face.material_flags & 32u) != 0u)
                    {
                        float angle = dot(hit_direction, hit_normal);
                        float factor_alpha = clamp(1.0 - pow(1.0 - abs(angle), 4.0), 0.0, 1.0);
                        color.w *= factor_alpha;
                        angle = 1.0 - abs(angle);
                        float factor = clamp(angle * 5.0, 0.0, 1.0);
                        angle *= 0.75;
                        float param_51 = angle;
                        vec3 v = spectrum_offset_ycgco(param_51);
                        angle = pow(angle, 4.0);
                        if (_2209.rt_setup.reflection_gradient_idx != (-1))
                        {
                            int param_52 = _2209.rt_setup.reflection_gradient_idx;
                            float param_53 = angle;
                            v = gradient_sample(param_52, param_53).xyz;
                            v = vec3(0.5) + ((v - vec3(0.5)) * 1.75);
                        }
                        vec4 _4020 = color;
                        vec3 _4026 = mix(_4020.xyz, v, vec3(1.0 - factor_alpha));
                        color.x = _4026.x;
                        color.y = _4026.y;
                        color.z = _4026.z;
                    }
                }
            }
            else
            {
                color.x = 1.0;
                color.y = 0.0;
                color.z = 0.0;
            }
        }
        else
        {
            color.x = 1.0;
            color.y = 0.0;
            color.z = 0.0;
        }
        if ((materials.material_properties[mrmt.material_index].flags & 1u) == 0u)
        {
        }
    }
    else
    {
        if (hit_primitiveID == 4294967295u)
        {
            color.w = 0.0;
            color.x = 0.0;
            color.y = 0.0;
            color.z = 0.0;
        }
    }
    if (hit_primitiveID == 4294967295u)
    {
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 