#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorRangeRemap_Params
{
    float input_min;
    float input_max;
    float output_min;
    float output_max;
    int min_out_of_bounds_mode;
    int max_out_of_bounds_mode;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorFrustumCull_Params
{
    mat4 transform_local_to_gizmo;
    mat4 transform_world_to_view;
    mat4 transform_projection;
    float instance_radius;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstanceModifierFactorToColor_Params
{
    vec3 color;
    int use_gradient;
    int color_gradient_idx;
    int mixing_mode;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    uvec3 resolution;
    vec3 bbox_position;
    vec3 bbox_dimensions;
    vec3 instance_scale_base;
    vec3 instance_scale_factor;
    float function_scale;
    float function_threshold;
    float orientation_blend;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _2360;

layout(set = 0, binding = 7, scalar) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _2377;

layout(set = 0, binding = 8, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _2451;

layout(set = 0, binding = 9, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _2465;

layout(set = 0, binding = 10, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _2478;

layout(set = 0, binding = 11, std140) uniform VM3
{
    ModifierFactorMulAdd_Params VM3_params;
} _2496;

layout(set = 0, binding = 12, std140) uniform VM4
{
    ModifierFactorRangeRemap_Params VM4_params;
} _2509;

layout(set = 0, binding = 13, std140) uniform VM5
{
    ModifierFactorCurveTransfer_Params VM5_params;
} _2522;

layout(set = 0, binding = 14, std140) uniform VM6
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM6_params;
} _2535;

layout(set = 0, binding = 15, std140) uniform VM7
{
    layout(row_major) ModifierFactorFrustumCull_Params VM7_params;
} _2550;

layout(set = 0, binding = 16, std140) uniform VM8
{
    ModifierFactorMulAdd_Params VM8_params;
} _2998;

layout(set = 0, binding = 17, std140) uniform VM9
{
    ModifierFactorMulAdd_Params VM9_params;
} _3009;

layout(set = 0, binding = 18, std140) uniform VM10
{
    ModifierFactorClamp_Params VM10_params;
} _3021;

layout(set = 0, binding = 19, std140) uniform VM11
{
    InstanceModifierRandomizerV2_Params VM11_params;
} _3034;

layout(set = 0, binding = 2, std430) buffer VM12
{
    InstanceModifierFactorToColor_Params VM12_params;
} _3052;

layout(set = 0, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _3106;

layout(set = 0, binding = 4, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _3129;

layout(set = 0, binding = 5, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _3150;

layout(set = 0, binding = 6, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _3158;

layout(set = 0, binding = 20) uniform sampler2D s_NoiseRGBA;
layout(set = 0, binding = 21) uniform sampler2D s_Curves;
layout(set = 0, binding = 22) uniform sampler2D s_Gradients;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1261 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1261;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1455 = vector_transform_by_mat43(param, param_1);
        coords = _1455;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1462 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1462;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1406 = vector_transform_by_mat43(param, param_1);
        coords = _1406;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1413 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1413;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    int k = -1;
    for (;;)
    {
        if (k <= 1)
        {
            int j = -1;
            for (;;)
            {
                if (j <= 1)
                {
                    int i = -1;
                    for (;;)
                    {
                        if (i <= 1)
                        {
                            vec3 b = vec3(float(i), float(j), float(k));
                            vec3 param = p + b;
                            vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                            float d = dot(r, r);
                            if (d < res.x)
                            {
                                id = dot(p + b, vec3(1.0, 57.0, 113.0));
                                res = vec2(d, res.x);
                            }
                            else
                            {
                                if (d < res.y)
                                {
                                    res.y = d;
                                }
                            }
                            i++;
                            continue;
                        }
                        else
                        {
                            break;
                        }
                    }
                    j++;
                    continue;
                }
                else
                {
                    break;
                }
            }
            k++;
            continue;
        }
        else
        {
            break;
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1504 = vector_transform_by_mat43(param, param_1);
        coords = _1504;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1511 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1511;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

void modifier_factor_range_remap(ModifierFactorRangeRemap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    bool set_const = false;
    float set_const_value = 0.0;
    float t = (v - modifier_params.input_min) / (modifier_params.input_max - modifier_params.input_min);
    if (t < 0.0)
    {
        if (modifier_params.min_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 0)
        {
            t = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.min_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    if (t > 1.0)
    {
        if (modifier_params.max_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 0)
        {
            t = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.max_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    v = modifier_params.output_min + (t * (modifier_params.output_max - modifier_params.output_min));
    if (set_const)
    {
        v = set_const_value;
    }
    modifier_factor.factor = v;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _1710 = vector_transform_by_mat43(param, param_1);
        coords = _1710;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _1721 = vector_transform_by_mat43(param_2, param_3);
            coords = _1721;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1731 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1731;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void modifier_factor_frustum_cull(ModifierFactorFrustumCull_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    vec3 param = coords;
    mat4 param_1 = cs_transforms.mat_local_to_model;
    vec3 _1807 = vector_transform_by_mat43(param, param_1);
    coords = _1807;
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_world_to_view;
    vec3 _1813 = vector_transform_by_mat43(param_2, param_3);
    coords = _1813;
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1820 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1820;
    vec3 param_6 = rel_coords;
    mat4 param_7 = modifier_params.transform_projection;
    vec4 _1827 = vector_transform_by_mat_projection(param_6, param_7);
    vec4 projected = _1827;
    float margin = 0.100000001490116119384765625;
    vec4 _1832 = projected;
    vec2 _1834 = _1832.xy * (1.0 - margin);
    projected.x = _1834.x;
    projected.y = _1834.y;
    bool _1844 = projected.x < (-projected.w);
    bool _1853;
    if (!_1844)
    {
        _1853 = projected.x > projected.w;
    }
    else
    {
        _1853 = _1844;
    }
    bool _1863;
    if (!_1853)
    {
        _1863 = projected.y < (-projected.w);
    }
    else
    {
        _1863 = _1853;
    }
    bool _1872;
    if (!_1863)
    {
        _1872 = projected.y > projected.w;
    }
    else
    {
        _1872 = _1863;
    }
    bool _1881;
    if (!_1872)
    {
        _1881 = projected.z < (-margin);
    }
    else
    {
        _1881 = _1872;
    }
    if (_1881)
    {
        modifier_factor.is_discarded = true;
    }
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _349 = hash(param);
    uint param_1 = v.z;
    uint _354 = hash(param_1);
    uint param_2 = (v.x ^ _349) ^ _354;
    uint _357 = hash(param_2);
    return _357;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _386 = floatConstruct(param_1);
    return _386;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _376 = hash(param);
    uint param_1 = _376;
    float _378 = floatConstruct(param_1);
    return _378;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void instance_modifier_factor_to_color(InstanceModifierFactorToColor_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance)
{
    vec3 c = vec3(1.0);
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = fract(modifier_factor.factor);
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color * modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 0)
    {
        instance.c.x = c.x;
        instance.c.y = c.y;
        instance.c.z = c.z;
    }
    if (modifier_params.mixing_mode == 1)
    {
        vec4 _2322 = instance.c;
        vec3 _2328 = mix(_2322.xyz, c, vec3(modifier_factor.factor));
        instance.c.x = _2328.x;
        instance.c.y = _2328.y;
        instance.c.z = _2328.z;
    }
    if (modifier_params.mixing_mode == 2)
    {
        vec4 _2342 = instance.c;
        vec3 _2344 = _2342.xyz + c;
        instance.c.x = _2344.x;
        instance.c.y = _2344.y;
        instance.c.z = _2344.z;
    }
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_2360.instance_params.instance_count >= _2360.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_2377.instancing_generator_params.resolution.x * _2377.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_2377.instancing_generator_params.resolution.x * _2377.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _2377.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _2377.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = _2377.instancing_generator_params.bbox_position;
    vec3 instancing_bbox_size = _2377.instancing_generator_params.bbox_dimensions;
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_2377.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _2456;
    _2456.transform_local_to_gizmo = _2451.VM0_params.transform_local_to_gizmo;
    _2456.noise_domain_scale = _2451.VM0_params.noise_domain_scale;
    _2456.modifier_function = _2451.VM0_params.modifier_function;
    _2456.noise_domain_offset = _2451.VM0_params.noise_domain_offset;
    _2456.noise_value_scale = _2451.VM0_params.noise_value_scale;
    _2456.noise_value_offset = _2451.VM0_params.noise_value_offset;
    _2456.influence_scope = _2451.VM0_params.influence_scope;
    _2456._pad0 = _2451.VM0_params._pad0;
    _2456._pad1 = _2451.VM0_params._pad1;
    ModifierFactorNoise_Params param = _2456;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_noise_simplex2(param, param_1, param_2);
    modifier_factor = param_1;
    ModifierFactorNoise_Params _2469;
    _2469.transform_local_to_gizmo = _2465.VM1_params.transform_local_to_gizmo;
    _2469.noise_domain_scale = _2465.VM1_params.noise_domain_scale;
    _2469.modifier_function = _2465.VM1_params.modifier_function;
    _2469.noise_domain_offset = _2465.VM1_params.noise_domain_offset;
    _2469.noise_value_scale = _2465.VM1_params.noise_value_scale;
    _2469.noise_value_offset = _2465.VM1_params.noise_value_offset;
    _2469.influence_scope = _2465.VM1_params.influence_scope;
    _2469._pad0 = _2465.VM1_params._pad0;
    _2469._pad1 = _2465.VM1_params._pad1;
    ModifierFactorNoise_Params param_3 = _2469;
    ModifierFactor param_4 = modifier_factor;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    modifier_factor_noise_default(param_3, param_4, param_5);
    modifier_factor = param_4;
    ModifierFactorNoise_Params _2482;
    _2482.transform_local_to_gizmo = _2478.VM2_params.transform_local_to_gizmo;
    _2482.noise_domain_scale = _2478.VM2_params.noise_domain_scale;
    _2482.modifier_function = _2478.VM2_params.modifier_function;
    _2482.noise_domain_offset = _2478.VM2_params.noise_domain_offset;
    _2482.noise_value_scale = _2478.VM2_params.noise_value_scale;
    _2482.noise_value_offset = _2478.VM2_params.noise_value_offset;
    _2482.influence_scope = _2478.VM2_params.influence_scope;
    _2482._pad0 = _2478.VM2_params._pad0;
    _2482._pad1 = _2478.VM2_params._pad1;
    ModifierFactorNoise_Params param_6 = _2482;
    ModifierFactor param_7 = modifier_factor;
    CoordinateSystemTrasforms param_8 = cs_transforms;
    modifier_factor_noise_voronoi(param_6, param_7, param_8);
    modifier_factor = param_7;
    modifier_factor.factor = abs(modifier_factor.factor);
    ModifierFactorMulAdd_Params _2501;
    _2501.multiply_value = _2496.VM3_params.multiply_value;
    _2501.add_value = _2496.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_9 = _2501;
    ModifierFactor param_10 = modifier_factor;
    modifier_factor_mul_add(param_9, param_10);
    modifier_factor = param_10;
    ModifierFactorRangeRemap_Params _2514;
    _2514.input_min = _2509.VM4_params.input_min;
    _2514.input_max = _2509.VM4_params.input_max;
    _2514.output_min = _2509.VM4_params.output_min;
    _2514.output_max = _2509.VM4_params.output_max;
    _2514.min_out_of_bounds_mode = _2509.VM4_params.min_out_of_bounds_mode;
    _2514.max_out_of_bounds_mode = _2509.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_11 = _2514;
    ModifierFactor param_12 = modifier_factor;
    modifier_factor_range_remap(param_11, param_12);
    modifier_factor = param_12;
    ModifierFactorCurveTransfer_Params _2527;
    _2527.curve_idx = _2522.VM5_params.curve_idx;
    _2527.input_range_min = _2522.VM5_params.input_range_min;
    _2527.input_range_max = _2522.VM5_params.input_range_max;
    _2527.amplitude = _2522.VM5_params.amplitude;
    _2527.base = _2522.VM5_params.base;
    ModifierFactorCurveTransfer_Params param_13 = _2527;
    ModifierFactor param_14 = modifier_factor;
    modifier_factor_curve_transfer(param_13, param_14);
    modifier_factor = param_14;
    ModifierFactorDistanceRadial_Params _2540;
    _2540.transform_local_to_gizmo = _2535.VM6_params.transform_local_to_gizmo;
    _2540.falloff_curve_idx = _2535.VM6_params.falloff_curve_idx;
    _2540.falloff_inverse = _2535.VM6_params.falloff_inverse;
    _2540.domain_repeat_x = _2535.VM6_params.domain_repeat_x;
    _2540.domain_repeat_y = _2535.VM6_params.domain_repeat_y;
    _2540.domain_repeat_z = _2535.VM6_params.domain_repeat_z;
    _2540.influence_scope = _2535.VM6_params.influence_scope;
    _2540.modifier_function = _2535.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_15 = _2540;
    ModifierFactor param_16 = modifier_factor;
    CoordinateSystemTrasforms param_17 = cs_transforms;
    modifier_factor_distance_radial(param_15, param_16, param_17);
    modifier_factor = param_16;
    ModifierFactorFrustumCull_Params _2555;
    _2555.transform_local_to_gizmo = _2550.VM7_params.transform_local_to_gizmo;
    _2555.transform_world_to_view = _2550.VM7_params.transform_world_to_view;
    _2555.transform_projection = _2550.VM7_params.transform_projection;
    _2555.instance_radius = _2550.VM7_params.instance_radius;
    ModifierFactorFrustumCull_Params param_18 = _2555;
    ModifierFactor param_19 = modifier_factor;
    CoordinateSystemTrasforms param_20 = cs_transforms;
    modifier_factor_frustum_cull(param_18, param_19, param_20);
    modifier_factor = param_19;
    float mf = (modifier_factor.factor * _2377.instancing_generator_params.function_scale) - _2377.instancing_generator_params.function_threshold;
    if ((mf <= 0.0) || modifier_factor.is_discarded)
    {
        return;
    }
    vec3 instance_scale = _2377.instancing_generator_params.instance_scale_base + (_2377.instancing_generator_params.instance_scale_factor * mf);
    float modifier_factor_v = modifier_factor.factor;
    float modifier_factor_v_dx = modifier_factor.factor;
    float modifier_factor_v_dy = modifier_factor.factor;
    float modifier_factor_v_dz = modifier_factor.factor;
    ModifierFactor modifier_factor_1 = modifier_factor_defaults();
    modifier_factor_1.factor = 1.0;
    modifier_factor_1.hash = id;
    modifier_factor_1.id = id;
    modifier_factor_1.instance_id = id;
    modifier_factor_1.position = instance_position + vec3(instancing_bbox_size.x / float(_2377.instancing_generator_params.resolution.x), 0.0, 0.0);
    modifier_factor_1.is_spawned = true;
    ModifierFactorNoise_Params _2623;
    _2623.transform_local_to_gizmo = _2451.VM0_params.transform_local_to_gizmo;
    _2623.noise_domain_scale = _2451.VM0_params.noise_domain_scale;
    _2623.modifier_function = _2451.VM0_params.modifier_function;
    _2623.noise_domain_offset = _2451.VM0_params.noise_domain_offset;
    _2623.noise_value_scale = _2451.VM0_params.noise_value_scale;
    _2623.noise_value_offset = _2451.VM0_params.noise_value_offset;
    _2623.influence_scope = _2451.VM0_params.influence_scope;
    _2623._pad0 = _2451.VM0_params._pad0;
    _2623._pad1 = _2451.VM0_params._pad1;
    ModifierFactorNoise_Params param_21 = _2623;
    ModifierFactor param_22 = modifier_factor_1;
    CoordinateSystemTrasforms param_23 = cs_transforms;
    modifier_factor_noise_simplex2(param_21, param_22, param_23);
    modifier_factor_1 = param_22;
    ModifierFactorNoise_Params _2633;
    _2633.transform_local_to_gizmo = _2465.VM1_params.transform_local_to_gizmo;
    _2633.noise_domain_scale = _2465.VM1_params.noise_domain_scale;
    _2633.modifier_function = _2465.VM1_params.modifier_function;
    _2633.noise_domain_offset = _2465.VM1_params.noise_domain_offset;
    _2633.noise_value_scale = _2465.VM1_params.noise_value_scale;
    _2633.noise_value_offset = _2465.VM1_params.noise_value_offset;
    _2633.influence_scope = _2465.VM1_params.influence_scope;
    _2633._pad0 = _2465.VM1_params._pad0;
    _2633._pad1 = _2465.VM1_params._pad1;
    ModifierFactorNoise_Params param_24 = _2633;
    ModifierFactor param_25 = modifier_factor_1;
    CoordinateSystemTrasforms param_26 = cs_transforms;
    modifier_factor_noise_default(param_24, param_25, param_26);
    modifier_factor_1 = param_25;
    ModifierFactorNoise_Params _2643;
    _2643.transform_local_to_gizmo = _2478.VM2_params.transform_local_to_gizmo;
    _2643.noise_domain_scale = _2478.VM2_params.noise_domain_scale;
    _2643.modifier_function = _2478.VM2_params.modifier_function;
    _2643.noise_domain_offset = _2478.VM2_params.noise_domain_offset;
    _2643.noise_value_scale = _2478.VM2_params.noise_value_scale;
    _2643.noise_value_offset = _2478.VM2_params.noise_value_offset;
    _2643.influence_scope = _2478.VM2_params.influence_scope;
    _2643._pad0 = _2478.VM2_params._pad0;
    _2643._pad1 = _2478.VM2_params._pad1;
    ModifierFactorNoise_Params param_27 = _2643;
    ModifierFactor param_28 = modifier_factor_1;
    CoordinateSystemTrasforms param_29 = cs_transforms;
    modifier_factor_noise_voronoi(param_27, param_28, param_29);
    modifier_factor_1 = param_28;
    modifier_factor_1.factor = abs(modifier_factor_1.factor);
    ModifierFactorMulAdd_Params _2657;
    _2657.multiply_value = _2496.VM3_params.multiply_value;
    _2657.add_value = _2496.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_30 = _2657;
    ModifierFactor param_31 = modifier_factor_1;
    modifier_factor_mul_add(param_30, param_31);
    modifier_factor_1 = param_31;
    ModifierFactorRangeRemap_Params _2665;
    _2665.input_min = _2509.VM4_params.input_min;
    _2665.input_max = _2509.VM4_params.input_max;
    _2665.output_min = _2509.VM4_params.output_min;
    _2665.output_max = _2509.VM4_params.output_max;
    _2665.min_out_of_bounds_mode = _2509.VM4_params.min_out_of_bounds_mode;
    _2665.max_out_of_bounds_mode = _2509.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_32 = _2665;
    ModifierFactor param_33 = modifier_factor_1;
    modifier_factor_range_remap(param_32, param_33);
    modifier_factor_1 = param_33;
    ModifierFactorCurveTransfer_Params _2673;
    _2673.curve_idx = _2522.VM5_params.curve_idx;
    _2673.input_range_min = _2522.VM5_params.input_range_min;
    _2673.input_range_max = _2522.VM5_params.input_range_max;
    _2673.amplitude = _2522.VM5_params.amplitude;
    _2673.base = _2522.VM5_params.base;
    ModifierFactorCurveTransfer_Params param_34 = _2673;
    ModifierFactor param_35 = modifier_factor_1;
    modifier_factor_curve_transfer(param_34, param_35);
    modifier_factor_1 = param_35;
    ModifierFactorDistanceRadial_Params _2681;
    _2681.transform_local_to_gizmo = _2535.VM6_params.transform_local_to_gizmo;
    _2681.falloff_curve_idx = _2535.VM6_params.falloff_curve_idx;
    _2681.falloff_inverse = _2535.VM6_params.falloff_inverse;
    _2681.domain_repeat_x = _2535.VM6_params.domain_repeat_x;
    _2681.domain_repeat_y = _2535.VM6_params.domain_repeat_y;
    _2681.domain_repeat_z = _2535.VM6_params.domain_repeat_z;
    _2681.influence_scope = _2535.VM6_params.influence_scope;
    _2681.modifier_function = _2535.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_36 = _2681;
    ModifierFactor param_37 = modifier_factor_1;
    CoordinateSystemTrasforms param_38 = cs_transforms;
    modifier_factor_distance_radial(param_36, param_37, param_38);
    modifier_factor_1 = param_37;
    ModifierFactorFrustumCull_Params _2691;
    _2691.transform_local_to_gizmo = _2550.VM7_params.transform_local_to_gizmo;
    _2691.transform_world_to_view = _2550.VM7_params.transform_world_to_view;
    _2691.transform_projection = _2550.VM7_params.transform_projection;
    _2691.instance_radius = _2550.VM7_params.instance_radius;
    ModifierFactorFrustumCull_Params param_39 = _2691;
    ModifierFactor param_40 = modifier_factor_1;
    CoordinateSystemTrasforms param_41 = cs_transforms;
    modifier_factor_frustum_cull(param_39, param_40, param_41);
    modifier_factor_1 = param_40;
    modifier_factor_v_dx = modifier_factor_1.factor;
    ModifierFactor modifier_factor_2 = modifier_factor_defaults();
    modifier_factor_2.factor = 1.0;
    modifier_factor_2.hash = id;
    modifier_factor_2.id = id;
    modifier_factor_2.instance_id = id;
    modifier_factor_2.position = instance_position + vec3(0.0, instancing_bbox_size.y / float(_2377.instancing_generator_params.resolution.y), 0.0);
    modifier_factor_2.is_spawned = true;
    ModifierFactorNoise_Params _2723;
    _2723.transform_local_to_gizmo = _2451.VM0_params.transform_local_to_gizmo;
    _2723.noise_domain_scale = _2451.VM0_params.noise_domain_scale;
    _2723.modifier_function = _2451.VM0_params.modifier_function;
    _2723.noise_domain_offset = _2451.VM0_params.noise_domain_offset;
    _2723.noise_value_scale = _2451.VM0_params.noise_value_scale;
    _2723.noise_value_offset = _2451.VM0_params.noise_value_offset;
    _2723.influence_scope = _2451.VM0_params.influence_scope;
    _2723._pad0 = _2451.VM0_params._pad0;
    _2723._pad1 = _2451.VM0_params._pad1;
    ModifierFactorNoise_Params param_42 = _2723;
    ModifierFactor param_43 = modifier_factor_2;
    CoordinateSystemTrasforms param_44 = cs_transforms;
    modifier_factor_noise_simplex2(param_42, param_43, param_44);
    modifier_factor_2 = param_43;
    ModifierFactorNoise_Params _2733;
    _2733.transform_local_to_gizmo = _2465.VM1_params.transform_local_to_gizmo;
    _2733.noise_domain_scale = _2465.VM1_params.noise_domain_scale;
    _2733.modifier_function = _2465.VM1_params.modifier_function;
    _2733.noise_domain_offset = _2465.VM1_params.noise_domain_offset;
    _2733.noise_value_scale = _2465.VM1_params.noise_value_scale;
    _2733.noise_value_offset = _2465.VM1_params.noise_value_offset;
    _2733.influence_scope = _2465.VM1_params.influence_scope;
    _2733._pad0 = _2465.VM1_params._pad0;
    _2733._pad1 = _2465.VM1_params._pad1;
    ModifierFactorNoise_Params param_45 = _2733;
    ModifierFactor param_46 = modifier_factor_2;
    CoordinateSystemTrasforms param_47 = cs_transforms;
    modifier_factor_noise_default(param_45, param_46, param_47);
    modifier_factor_2 = param_46;
    ModifierFactorNoise_Params _2743;
    _2743.transform_local_to_gizmo = _2478.VM2_params.transform_local_to_gizmo;
    _2743.noise_domain_scale = _2478.VM2_params.noise_domain_scale;
    _2743.modifier_function = _2478.VM2_params.modifier_function;
    _2743.noise_domain_offset = _2478.VM2_params.noise_domain_offset;
    _2743.noise_value_scale = _2478.VM2_params.noise_value_scale;
    _2743.noise_value_offset = _2478.VM2_params.noise_value_offset;
    _2743.influence_scope = _2478.VM2_params.influence_scope;
    _2743._pad0 = _2478.VM2_params._pad0;
    _2743._pad1 = _2478.VM2_params._pad1;
    ModifierFactorNoise_Params param_48 = _2743;
    ModifierFactor param_49 = modifier_factor_2;
    CoordinateSystemTrasforms param_50 = cs_transforms;
    modifier_factor_noise_voronoi(param_48, param_49, param_50);
    modifier_factor_2 = param_49;
    modifier_factor_2.factor = abs(modifier_factor_2.factor);
    ModifierFactorMulAdd_Params _2757;
    _2757.multiply_value = _2496.VM3_params.multiply_value;
    _2757.add_value = _2496.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_51 = _2757;
    ModifierFactor param_52 = modifier_factor_2;
    modifier_factor_mul_add(param_51, param_52);
    modifier_factor_2 = param_52;
    ModifierFactorRangeRemap_Params _2765;
    _2765.input_min = _2509.VM4_params.input_min;
    _2765.input_max = _2509.VM4_params.input_max;
    _2765.output_min = _2509.VM4_params.output_min;
    _2765.output_max = _2509.VM4_params.output_max;
    _2765.min_out_of_bounds_mode = _2509.VM4_params.min_out_of_bounds_mode;
    _2765.max_out_of_bounds_mode = _2509.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_53 = _2765;
    ModifierFactor param_54 = modifier_factor_2;
    modifier_factor_range_remap(param_53, param_54);
    modifier_factor_2 = param_54;
    ModifierFactorCurveTransfer_Params _2773;
    _2773.curve_idx = _2522.VM5_params.curve_idx;
    _2773.input_range_min = _2522.VM5_params.input_range_min;
    _2773.input_range_max = _2522.VM5_params.input_range_max;
    _2773.amplitude = _2522.VM5_params.amplitude;
    _2773.base = _2522.VM5_params.base;
    ModifierFactorCurveTransfer_Params param_55 = _2773;
    ModifierFactor param_56 = modifier_factor_2;
    modifier_factor_curve_transfer(param_55, param_56);
    modifier_factor_2 = param_56;
    ModifierFactorDistanceRadial_Params _2781;
    _2781.transform_local_to_gizmo = _2535.VM6_params.transform_local_to_gizmo;
    _2781.falloff_curve_idx = _2535.VM6_params.falloff_curve_idx;
    _2781.falloff_inverse = _2535.VM6_params.falloff_inverse;
    _2781.domain_repeat_x = _2535.VM6_params.domain_repeat_x;
    _2781.domain_repeat_y = _2535.VM6_params.domain_repeat_y;
    _2781.domain_repeat_z = _2535.VM6_params.domain_repeat_z;
    _2781.influence_scope = _2535.VM6_params.influence_scope;
    _2781.modifier_function = _2535.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_57 = _2781;
    ModifierFactor param_58 = modifier_factor_2;
    CoordinateSystemTrasforms param_59 = cs_transforms;
    modifier_factor_distance_radial(param_57, param_58, param_59);
    modifier_factor_2 = param_58;
    ModifierFactorFrustumCull_Params _2791;
    _2791.transform_local_to_gizmo = _2550.VM7_params.transform_local_to_gizmo;
    _2791.transform_world_to_view = _2550.VM7_params.transform_world_to_view;
    _2791.transform_projection = _2550.VM7_params.transform_projection;
    _2791.instance_radius = _2550.VM7_params.instance_radius;
    ModifierFactorFrustumCull_Params param_60 = _2791;
    ModifierFactor param_61 = modifier_factor_2;
    CoordinateSystemTrasforms param_62 = cs_transforms;
    modifier_factor_frustum_cull(param_60, param_61, param_62);
    modifier_factor_2 = param_61;
    modifier_factor_v_dy = modifier_factor_2.factor;
    ModifierFactor modifier_factor_3 = modifier_factor_defaults();
    modifier_factor_3.factor = 1.0;
    modifier_factor_3.hash = id;
    modifier_factor_3.id = id;
    modifier_factor_3.instance_id = id;
    modifier_factor_3.position = instance_position + vec3(0.0, 0.0, instancing_bbox_size.z / float(_2377.instancing_generator_params.resolution.z));
    modifier_factor_3.is_spawned = true;
    ModifierFactorNoise_Params _2823;
    _2823.transform_local_to_gizmo = _2451.VM0_params.transform_local_to_gizmo;
    _2823.noise_domain_scale = _2451.VM0_params.noise_domain_scale;
    _2823.modifier_function = _2451.VM0_params.modifier_function;
    _2823.noise_domain_offset = _2451.VM0_params.noise_domain_offset;
    _2823.noise_value_scale = _2451.VM0_params.noise_value_scale;
    _2823.noise_value_offset = _2451.VM0_params.noise_value_offset;
    _2823.influence_scope = _2451.VM0_params.influence_scope;
    _2823._pad0 = _2451.VM0_params._pad0;
    _2823._pad1 = _2451.VM0_params._pad1;
    ModifierFactorNoise_Params param_63 = _2823;
    ModifierFactor param_64 = modifier_factor_3;
    CoordinateSystemTrasforms param_65 = cs_transforms;
    modifier_factor_noise_simplex2(param_63, param_64, param_65);
    modifier_factor_3 = param_64;
    ModifierFactorNoise_Params _2833;
    _2833.transform_local_to_gizmo = _2465.VM1_params.transform_local_to_gizmo;
    _2833.noise_domain_scale = _2465.VM1_params.noise_domain_scale;
    _2833.modifier_function = _2465.VM1_params.modifier_function;
    _2833.noise_domain_offset = _2465.VM1_params.noise_domain_offset;
    _2833.noise_value_scale = _2465.VM1_params.noise_value_scale;
    _2833.noise_value_offset = _2465.VM1_params.noise_value_offset;
    _2833.influence_scope = _2465.VM1_params.influence_scope;
    _2833._pad0 = _2465.VM1_params._pad0;
    _2833._pad1 = _2465.VM1_params._pad1;
    ModifierFactorNoise_Params param_66 = _2833;
    ModifierFactor param_67 = modifier_factor_3;
    CoordinateSystemTrasforms param_68 = cs_transforms;
    modifier_factor_noise_default(param_66, param_67, param_68);
    modifier_factor_3 = param_67;
    ModifierFactorNoise_Params _2843;
    _2843.transform_local_to_gizmo = _2478.VM2_params.transform_local_to_gizmo;
    _2843.noise_domain_scale = _2478.VM2_params.noise_domain_scale;
    _2843.modifier_function = _2478.VM2_params.modifier_function;
    _2843.noise_domain_offset = _2478.VM2_params.noise_domain_offset;
    _2843.noise_value_scale = _2478.VM2_params.noise_value_scale;
    _2843.noise_value_offset = _2478.VM2_params.noise_value_offset;
    _2843.influence_scope = _2478.VM2_params.influence_scope;
    _2843._pad0 = _2478.VM2_params._pad0;
    _2843._pad1 = _2478.VM2_params._pad1;
    ModifierFactorNoise_Params param_69 = _2843;
    ModifierFactor param_70 = modifier_factor_3;
    CoordinateSystemTrasforms param_71 = cs_transforms;
    modifier_factor_noise_voronoi(param_69, param_70, param_71);
    modifier_factor_3 = param_70;
    modifier_factor_3.factor = abs(modifier_factor_3.factor);
    ModifierFactorMulAdd_Params _2857;
    _2857.multiply_value = _2496.VM3_params.multiply_value;
    _2857.add_value = _2496.VM3_params.add_value;
    ModifierFactorMulAdd_Params param_72 = _2857;
    ModifierFactor param_73 = modifier_factor_3;
    modifier_factor_mul_add(param_72, param_73);
    modifier_factor_3 = param_73;
    ModifierFactorRangeRemap_Params _2865;
    _2865.input_min = _2509.VM4_params.input_min;
    _2865.input_max = _2509.VM4_params.input_max;
    _2865.output_min = _2509.VM4_params.output_min;
    _2865.output_max = _2509.VM4_params.output_max;
    _2865.min_out_of_bounds_mode = _2509.VM4_params.min_out_of_bounds_mode;
    _2865.max_out_of_bounds_mode = _2509.VM4_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_74 = _2865;
    ModifierFactor param_75 = modifier_factor_3;
    modifier_factor_range_remap(param_74, param_75);
    modifier_factor_3 = param_75;
    ModifierFactorCurveTransfer_Params _2873;
    _2873.curve_idx = _2522.VM5_params.curve_idx;
    _2873.input_range_min = _2522.VM5_params.input_range_min;
    _2873.input_range_max = _2522.VM5_params.input_range_max;
    _2873.amplitude = _2522.VM5_params.amplitude;
    _2873.base = _2522.VM5_params.base;
    ModifierFactorCurveTransfer_Params param_76 = _2873;
    ModifierFactor param_77 = modifier_factor_3;
    modifier_factor_curve_transfer(param_76, param_77);
    modifier_factor_3 = param_77;
    ModifierFactorDistanceRadial_Params _2881;
    _2881.transform_local_to_gizmo = _2535.VM6_params.transform_local_to_gizmo;
    _2881.falloff_curve_idx = _2535.VM6_params.falloff_curve_idx;
    _2881.falloff_inverse = _2535.VM6_params.falloff_inverse;
    _2881.domain_repeat_x = _2535.VM6_params.domain_repeat_x;
    _2881.domain_repeat_y = _2535.VM6_params.domain_repeat_y;
    _2881.domain_repeat_z = _2535.VM6_params.domain_repeat_z;
    _2881.influence_scope = _2535.VM6_params.influence_scope;
    _2881.modifier_function = _2535.VM6_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_78 = _2881;
    ModifierFactor param_79 = modifier_factor_3;
    CoordinateSystemTrasforms param_80 = cs_transforms;
    modifier_factor_distance_radial(param_78, param_79, param_80);
    modifier_factor_3 = param_79;
    ModifierFactorFrustumCull_Params _2891;
    _2891.transform_local_to_gizmo = _2550.VM7_params.transform_local_to_gizmo;
    _2891.transform_world_to_view = _2550.VM7_params.transform_world_to_view;
    _2891.transform_projection = _2550.VM7_params.transform_projection;
    _2891.instance_radius = _2550.VM7_params.instance_radius;
    ModifierFactorFrustumCull_Params param_81 = _2891;
    ModifierFactor param_82 = modifier_factor_3;
    CoordinateSystemTrasforms param_83 = cs_transforms;
    modifier_factor_frustum_cull(param_81, param_82, param_83);
    modifier_factor_3 = param_82;
    modifier_factor_v_dz = modifier_factor_3.factor;
    vec3 n;
    n.x = modifier_factor_v_dx - modifier_factor_v;
    n.y = modifier_factor_v_dy - modifier_factor_v;
    n.z = modifier_factor_v_dz - modifier_factor_v;
    n = mix(vec3(0.0, 0.0, 1.0), n, vec3(_2377.instancing_generator_params.orientation_blend));
    n = normalize(n);
    mat3 r;
    r[2] = n;
    r[1] = cross(vec3(0.0, 1.0, 0.0), r[2]);
    r[0] = cross(r[2], r[1]);
    r[1] = cross(r[2], r[0]);
    mat3 s;
    s[0] = vec3(instance_scale.x, 0.0, 0.0);
    s[1] = vec3(0.0, instance_scale.y, 0.0);
    s[2] = vec3(0.0, 0.0, instance_scale.z);
    mat3 transform = r * s;
    transform = s * r;
    transform = transpose(transform);
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(1.0);
    instance.flipbook_card = 0u;
    ModifierFactorMulAdd_Params _3002;
    _3002.multiply_value = _2998.VM8_params.multiply_value;
    _3002.add_value = _2998.VM8_params.add_value;
    ModifierFactorMulAdd_Params param_84 = _3002;
    ModifierFactor param_85 = modifier_factor;
    modifier_factor_mul_add(param_84, param_85);
    modifier_factor = param_85;
    ModifierFactorMulAdd_Params _3013;
    _3013.multiply_value = _3009.VM9_params.multiply_value;
    _3013.add_value = _3009.VM9_params.add_value;
    ModifierFactorMulAdd_Params param_86 = _3013;
    ModifierFactor param_87 = modifier_factor;
    modifier_factor_mul_add(param_86, param_87);
    modifier_factor = param_87;
    ModifierFactorClamp_Params _3026;
    _3026.clamp_min = _3021.VM10_params.clamp_min;
    _3026.clamp_max = _3021.VM10_params.clamp_max;
    _3026.clamp_min_enable = _3021.VM10_params.clamp_min_enable;
    _3026.clamp_max_enable = _3021.VM10_params.clamp_max_enable;
    ModifierFactorClamp_Params param_88 = _3026;
    ModifierFactor param_89 = modifier_factor;
    modifier_factor_clamp(param_88, param_89);
    modifier_factor = param_89;
    InstanceModifierRandomizerV2_Params _3039;
    _3039.replace_previous_rotation_scale = _3034.VM11_params.replace_previous_rotation_scale;
    _3039.randomness_seed = _3034.VM11_params.randomness_seed;
    _3039.replace_previous_position = _3034.VM11_params.replace_previous_position;
    _3039.randomization_input = _3034.VM11_params.randomization_input;
    _3039.position_modifier_base = _3034.VM11_params.position_modifier_base;
    _3039.position_modifier_base_modifier_factor = _3034.VM11_params.position_modifier_base_modifier_factor;
    _3039.position_modifier_range = _3034.VM11_params.position_modifier_range;
    _3039.position_modifier_range_modifier_factor = _3034.VM11_params.position_modifier_range_modifier_factor;
    _3039.rotation_modifier_base = _3034.VM11_params.rotation_modifier_base;
    _3039.rotation_modifier_base_modifier_factor = _3034.VM11_params.rotation_modifier_base_modifier_factor;
    _3039.rotation_modifier_range = _3034.VM11_params.rotation_modifier_range;
    _3039.rotation_modifier_range_modifier_factor = _3034.VM11_params.rotation_modifier_range_modifier_factor;
    _3039.scale_modifier_base = _3034.VM11_params.scale_modifier_base;
    _3039.scale_modifier_base_modifier_factor = _3034.VM11_params.scale_modifier_base_modifier_factor;
    _3039.scale_modifier_range = _3034.VM11_params.scale_modifier_range;
    _3039.scale_modifier_range_modifier_factor = _3034.VM11_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_90 = _3039;
    ModifierFactor param_91 = modifier_factor;
    Instance param_92 = instance;
    uint param_93 = id;
    instance_modifier_randomizer_v2(param_90, param_91, param_92, param_93);
    modifier_factor = param_91;
    instance = param_92;
    InstanceModifierFactorToColor_Params _3057;
    _3057.color = _3052.VM12_params.color;
    _3057.use_gradient = _3052.VM12_params.use_gradient;
    _3057.color_gradient_idx = _3052.VM12_params.color_gradient_idx;
    _3057.mixing_mode = _3052.VM12_params.mixing_mode;
    InstanceModifierFactorToColor_Params param_94 = _3057;
    ModifierFactor param_95 = modifier_factor;
    Instance param_96 = instance;
    instance_modifier_factor_to_color(param_94, param_95, param_96);
    modifier_factor = param_95;
    instance = param_96;
    bool _3069 = length(instance.m0.xyz) <= 0.0;
    bool _3078;
    if (!_3069)
    {
        _3078 = length(instance.m1.xyz) <= 0.0;
    }
    else
    {
        _3078 = _3069;
    }
    bool _3087;
    if (!_3078)
    {
        _3087 = length(instance.m1.xyz) <= 0.0;
    }
    else
    {
        _3087 = _3078;
    }
    if (_3087)
    {
        return;
    }
    int _3093 = atomicAdd(_2360.instance_params.instance_count, 1);
    uint instance_id = uint(_3093);
    if (instance_id >= uint(_2360.instance_params.buffer_capacity))
    {
        return;
    }
    _3106.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _3106.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _3106.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _3129.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _3129.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _3150.instance_hash[instance_id] = instance.hash;
    _3158.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 