; Vintage Computing Christmas Challenge 2024
; Jose Moreno Prieto 'Xeleh' - 06/12/2024

            org     100h
main        push    0b801h          ; b800h (VGA text) + 16 bytes (8 chars + 8 attributes)
            pop     es
            xor     di,di
;draw lace
            mov     si,lace         ; lace chars
.l1         movsb                   ; copy to screen memory
            inc     di              ; next char
            jpo     .l1             ; repeat 2 more times
;draw box
            mov     di,3*2+8*2      ; set pointer to last column
            mov     dx,18           ; dl = row = 18
.row        add     di,160-19*2     ; next line
            mov     bx,'+-'         ; chars for horizontal line: bl = "+", bh = "-"
            mov     al,dl           ; al = current row
            aam     9               ; horizontal line?
            jz      .go             ; yes -> use current chars
            mov     bx,'! '         ; no -> use chars for vertical line: bl = "!", bh = " "
.go         xchg    ax,bx           ; al = bl, ah = bh (optimized)
.l2         stosb
            inc     di
            xchg    al,ah
            stosb
            inc     di
            xchg    al,ah           ; exchange chars so al = fill char
            mov     cl,7            ; 
            rep     stosb           ; add fill char 7 times
            xchg    al,ah           ; exchange chars so al = line char
            cmc                     ; 
            jc      .l2             ; one more time
            stosb                   ; add closing line char to string
            dec     dx              ; previous row
            jns     .row             ; loop until row is -1

%ifdef      debug
            waitkey
            ret
%endif

lace       db      "\O/"