lb1                     = $33                   ; $00 at init
hb1                     = $34                   ; $1E at init
contador                = $b3                   ; $03 at init

*=4096
; SYS 4110
        BYTE    $00, $0B, $04, $0A, $00, $9E, $34, $31, $31, $30, $00, $00, $00

*=4110
        JSR 58719                               ; Clear the screen                                          
        LDA #8                                  ; Black background                              
        STA 36879                               ;

        LDY #0                                  ;

loop0
        LDA bow,Y                               ;
        STA $1E08,Y                             ;
        INY                                     ; Top Bow
        CPY #3                                  ;
        BNE loop0                               ;

loopSquares
        LDX contador                            ; Starts at 3
        BMI stop                                ; When it is -1 -> Stop
        
        LDA lbStart,X                           ;
        STA lb1                                 ; Reads lb1 for next square (it draws 4 squares)
        DEC contador                            ;

square
        LDY #0                                  ; Starts in the upper left corner

horizontalLine
        LDA #43                                 ; 
        STA (lb1),Y                             ; Draws the '+' and prepares to create a line of '-'
        LDA #45                                 ;
        LDX #9                                  ; We'll draw 9 '-'

loop1
        INY                                     ;
        STA (lb1),Y                             ; Draws a '-'
        DEX                                     ; 
        BNE loop1                               ; If haven't drawn 9, draws the next one

        LDA #43                                 ; Draws the final '+'
        STA (lb1),Y                             ;
        CPY #207                                ; Y = 207? -> That is the lower horizontal line. Let's do next square
        BEQ loopSquares                         ;

loop2
        TYA                                     ; Wasn't the lower horizontal line? Then let's do the 8 intermediate lines
        ADC #13                                 ; Adding 9 to position in first char of next line
        TAY                                     ;
        CPY #198                                ; If reach Y 198, that was the last intermediate line->
        BEQ horizontalLine                      ; -> Let's draw the lower horizontal line 

        LDA #33                                 ; 
        STA (lb1),Y                             ; Draws the '!' in the first column
        TYA                                     ;
        ADC #9                                  ; Don't need CLC because Carry is always clear
        TAY                                     ; 
        LDA #33                                 ;
        STA (lb1),Y                             ; Draws the '!' in the last column
        
        BCC loop2                               ; Always Jump to bucle2 (with BCC saves 1 byte)
        
stop
        BMI stop                                ; This is the end. BMI instead of JMP to save another byte

bow
        BYTE 77,15,78                           ; 3 chars for the bow

lbStart
        BYTE 22,31,220,229                      ; LB for upper left corner of every square
