; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the Matel Aquarius computer
; -Dave / Bushy555.
;
;
; USE / INSTRUCTIONS
; ====================
; Emulator : Virtual Aquarius by James Tamer.
; UTIL --> Load Binary file --> Select "FILE.bin"  (CHRISTMAS_PRESENT.BIN)
; Load to address         : $E000
; Set USR Address to      : $0000    (Tick this selection box)
; Then, back in basic, run: X=USR(0)  <CR>
; Program will then execute.
;
; Execution assumptions:
; (First program to run immediately after emulator is ran)
;
;
;
;
; BINARY CODE SIZE
; =================
; Header       : 16  bytes.   (loader header for Aquarius Cartridge area at $E000)
; Code         : 106 bytes.
; Total Binary : 122 bytes.
; Source code  : 498 bytes.   (minimum source code size for successful assembling)
;
;
;
; NOTES
; =======
; Video ram at $3000
;
; The Aquarius's loading routine is just truly bizare to me. I have studied and studied it,
; but yet have never been able to get anything to load nicely except using BIN2CAQ util.
;
;
; ASSEMBLING
; =================
;  Assemble with PASMO                         !
;  pasmo --alocal %1.asm %1.bin
;
;
;
;	org	$4000		; Aquarius 4k cassette.
;	org	$c000		; Aquarius lower 8k cartridge
	org	$e000		; Aquarius upper 8k cartridge


     db  98, 117, 115, 104	; Cartridge encrypted but generic header.
     db  121, 156, 50, 176
     db  48, 108, 50, 100
     db  50, 168, 183, 112


START:	
	ld	hl, line1		; display first line (RIBBON)
	ld	de, $3008
	call	display


	ld	hl, line2		; display first line of box.
	ld	de, $3000+40
	call	display

	

	ld	b, 2
loop1:	push	bc


	ld	b, 21			; dunno any of the Aquarius print ROM routines.
loop2:	inc	de
	djnz	loop2



	ld	b, 8
loop3:	push	bc
	ld	hl, line3
	call	display



	ld	b, 21			; dunno any of the Aquarius print ROM routines.
loop4:	inc	de
	djnz	loop4




	pop	bc
	djnz	loop3
	ld	hl, line2
	call	display

	pop	bc
	djnz	loop1


here:	jr	here


display:ld	a, (hl)			; Display message, character-by-character until reads a zero byte.
	and	a
	ret	z
	ld	(de), a
	inc	hl
	inc	de
	jr	display

	

line1 db '\O/',0
line2 db '+--------+--------+',0
line3 db '!        !        !',0




end
