!cpu 6510

newline			= $aad7			;print a newline
val_03			= $b3			;is preloaded with #$03 (pointer to datasette buffer $033c)
knot			= $ae35			;needed data is there, but with offset of #$71
;knot			= $f5a0			;char sequence via adc/sbc (delta), starting from A = #$c8 + #$85 = #$4d, also works with sbc back to front

			* = $032c
			!word .entry		;y = $0a  x = $00
-
			sbc #$71		;subtract offset
			sta ($d1),y		;print knot data
			dey
.entry
			lda knot - $08,y	;knot values are in ROM, but with offset $71
			bmi -			;luckily the val before knot data is positive -> end condition \o/
.loop
			jsr newline		;newline
			anc #$00		;carry is clear in fact, be save for now. Approach is 1 byte cheaper then setting up directly with ldy #0 #10 #20
-
			tay
			isc ($d1),y		;print "!" by doing $20 -> $21
			adc #9 + 34		;compensate - $21 + carry from isc
			cpy #18			;"!" printed 3 times? 2 bytes for end condition, but handles carry well
			bcc -			;not yet

			dex			;1 to 9 times
			bpl .loop
-						;now transform last line to +---------+---------+ this happens 3 times
			lda #$b6		;%10110110
			sbc ($d1),y		;subtract either %00100000 or %00100001 -> %10010110 or %10010101 and carry is set
			rol			;keep carry set, result is either %00101101 or %00101011
			sta ($d1),y		;write out
			dey
			bpl -

			ldx #8			;another 9 lines, so we print overall: 1 line (+-), 8 lines (!) + 1 line (+-), 8 lines (!) + 1 line (+-)
			dec val_03		;2 more times
			bne .loop
			rts
