; 10 SYS2061
*=$0801
	BYTE $0B, $08, $0A, $00, $9E, $32, $30, $36, $31, $00, $00, $00

*=$080d
	; set to 25 line text mode and turn on the screen
	lda #$1B
	sta $D011

	; disable SHIFT-Commodore
	lda #$80
	sta $0291

	; set screen memory ($0400) and charset bitmap offset ($2000)
	lda #$18
	sta $D018

	; set border color
	lda #$00
	sta $D020
	
	; set background color
	lda #$00
	sta $D021

	; draw screen
	lda #$00
	sta $fb
	sta $fd
	sta $f7

	lda #$28
	sta $fc

	lda #$04
	sta $fe

	lda #$e8
	sta $f9
	lda #$2b
	sta $fa

	lda #$d8
	sta $f8

	ldx #$00
	ldy #$00
	lda ($fb),y
	sta ($fd),y
	lda ($f9),y
	sta ($f7),y
	iny
	bne *-9

	inc $fc
	inc $fe
	inc $fa
	inc $f8

	inx
	cpx #$04
	bne *-24

	; wait for keypress
	lda $c6
	beq *-2

	rts

; Character bitmap definitions 2k
*=$2000
	BYTE	$3C, $66, $6E, $6E, $60, $62, $3C, $00
	BYTE	$18, $3C, $66, $7E, $66, $66, $66, $00
	BYTE	$7C, $66, $66, $7C, $66, $66, $7C, $00
	BYTE	$3C, $66, $60, $60, $60, $66, $3C, $00
	BYTE	$78, $6C, $66, $66, $66, $6C, $78, $00
	BYTE	$7E, $60, $60, $78, $60, $60, $7E, $00
	BYTE	$7E, $60, $60, $78, $60, $60, $60, $00
	BYTE	$3C, $66, $60, $6E, $66, $66, $3C, $00
	BYTE	$66, $66, $66, $7E, $66, $66, $66, $00
	BYTE	$3C, $18, $18, $18, $18, $18, $3C, $00
	BYTE	$1E, $0C, $0C, $0C, $0C, $6C, $38, $00
	BYTE	$66, $6C, $78, $70, $78, $6C, $66, $00
	BYTE	$60, $60, $60, $60, $60, $60, $7E, $00
	BYTE	$63, $77, $7F, $6B, $63, $63, $63, $00
	BYTE	$66, $76, $7E, $7E, $6E, $66, $66, $00
	BYTE	$3C, $66, $66, $66, $66, $66, $3C, $00
	BYTE	$7C, $66, $66, $7C, $60, $60, $60, $00
	BYTE	$3C, $66, $66, $66, $66, $3C, $0E, $00
	BYTE	$7C, $66, $66, $7C, $78, $6C, $66, $00
	BYTE	$3C, $66, $60, $3C, $06, $66, $3C, $00
	BYTE	$7E, $18, $18, $18, $18, $18, $18, $00
	BYTE	$66, $66, $66, $66, $66, $66, $3C, $00
	BYTE	$66, $66, $66, $66, $66, $3C, $18, $00
	BYTE	$63, $63, $63, $6B, $7F, $77, $63, $00
	BYTE	$66, $66, $3C, $18, $3C, $66, $66, $00
	BYTE	$66, $66, $66, $3C, $18, $18, $18, $00
	BYTE	$7E, $06, $0C, $18, $30, $60, $7E, $00
	BYTE	$3C, $30, $30, $30, $30, $30, $3C, $00
	BYTE	$0C, $12, $30, $7C, $30, $62, $FC, $00
	BYTE	$3C, $0C, $0C, $0C, $0C, $0C, $3C, $00
	BYTE	$00, $18, $3C, $7E, $18, $18, $18, $18
	BYTE	$00, $10, $30, $7F, $7F, $30, $10, $00
	BYTE	$00, $00, $00, $00, $00, $00, $00, $00
	BYTE	$18, $18, $18, $18, $00, $00, $18, $00
	BYTE	$66, $66, $66, $00, $00, $00, $00, $00
	BYTE	$66, $66, $FF, $66, $FF, $66, $66, $00
	BYTE	$18, $3E, $60, $3C, $06, $7C, $18, $00
	BYTE	$62, $66, $0C, $18, $30, $66, $46, $00
	BYTE	$3C, $66, $3C, $38, $67, $66, $3F, $00
	BYTE	$06, $0C, $18, $00, $00, $00, $00, $00
	BYTE	$0C, $18, $30, $30, $30, $18, $0C, $00
	BYTE	$30, $18, $0C, $0C, $0C, $18, $30, $00
	BYTE	$00, $66, $3C, $FF, $3C, $66, $00, $00
	BYTE	$00, $18, $18, $7E, $18, $18, $00, $00
	BYTE	$00, $00, $00, $00, $00, $18, $18, $30
	BYTE	$00, $00, $00, $7E, $00, $00, $00, $00
	BYTE	$00, $00, $00, $00, $00, $18, $18, $00
	BYTE	$00, $03, $06, $0C, $18, $30, $60, $00
	BYTE	$3C, $66, $6E, $76, $66, $66, $3C, $00
	BYTE	$18, $18, $38, $18, $18, $18, $7E, $00
	BYTE	$3C, $66, $06, $0C, $30, $60, $7E, $00
	BYTE	$3C, $66, $06, $1C, $06, $66, $3C, $00
	BYTE	$06, $0E, $1E, $66, $7F, $06, $06, $00
	BYTE	$7E, $60, $7C, $06, $06, $66, $3C, $00
	BYTE	$3C, $66, $60, $7C, $66, $66, $3C, $00
	BYTE	$7E, $66, $0C, $18, $18, $18, $18, $00
	BYTE	$3C, $66, $66, $3C, $66, $66, $3C, $00
	BYTE	$3C, $66, $66, $3E, $06, $66, $3C, $00
	BYTE	$00, $00, $18, $00, $00, $18, $00, $00
	BYTE	$00, $00, $18, $00, $00, $18, $18, $30
	BYTE	$0E, $18, $30, $60, $30, $18, $0E, $00
	BYTE	$00, $00, $7E, $00, $7E, $00, $00, $00
	BYTE	$70, $18, $0C, $06, $0C, $18, $70, $00
	BYTE	$3C, $66, $06, $0C, $18, $00, $18, $00
	BYTE	$00, $00, $00, $FF, $FF, $00, $00, $00
	BYTE	$08, $1C, $3E, $7F, $7F, $1C, $3E, $00
	BYTE	$18, $18, $18, $18, $18, $18, $18, $18
	BYTE	$00, $00, $00, $FF, $FF, $00, $00, $00
	BYTE	$00, $00, $FF, $FF, $00, $00, $00, $00
	BYTE	$00, $FF, $FF, $00, $00, $00, $00, $00
	BYTE	$00, $00, $00, $00, $FF, $FF, $00, $00
	BYTE	$30, $30, $30, $30, $30, $30, $30, $30
	BYTE	$0C, $0C, $0C, $0C, $0C, $0C, $0C, $0C
	BYTE	$00, $00, $00, $E0, $F0, $38, $18, $18
	BYTE	$18, $18, $1C, $0F, $07, $00, $00, $00
	BYTE	$18, $18, $38, $F0, $E0, $00, $00, $00
	BYTE	$C0, $C0, $C0, $C0, $C0, $C0, $FF, $FF
	BYTE	$C0, $E0, $70, $38, $1C, $0E, $07, $03
	BYTE	$03, $07, $0E, $1C, $38, $70, $E0, $C0
	BYTE	$FF, $FF, $C0, $C0, $C0, $C0, $C0, $C0
	BYTE	$FF, $FF, $03, $03, $03, $03, $03, $03
	BYTE	$00, $3C, $7E, $7E, $7E, $7E, $3C, $00
	BYTE	$00, $00, $00, $00, $00, $FF, $FF, $00
	BYTE	$36, $7F, $7F, $7F, $3E, $1C, $08, $00
	BYTE	$60, $60, $60, $60, $60, $60, $60, $60
	BYTE	$00, $00, $00, $07, $0F, $1C, $18, $18
	BYTE	$C3, $E7, $7E, $3C, $3C, $7E, $E7, $C3
	BYTE	$00, $3C, $7E, $66, $66, $7E, $3C, $00
	BYTE	$18, $18, $66, $66, $18, $18, $3C, $00
	BYTE	$06, $06, $06, $06, $06, $06, $06, $06
	BYTE	$08, $1C, $3E, $7F, $3E, $1C, $08, $00
	BYTE	$18, $18, $18, $FF, $FF, $18, $18, $18
	BYTE	$C0, $C0, $30, $30, $C0, $C0, $30, $30
	BYTE	$18, $18, $18, $18, $18, $18, $18, $18
	BYTE	$00, $00, $03, $3E, $76, $36, $36, $00
	BYTE	$FF, $7F, $3F, $1F, $0F, $07, $03, $01
	BYTE	$00, $00, $00, $00, $00, $00, $00, $00
	BYTE	$F0, $F0, $F0, $F0, $F0, $F0, $F0, $F0
	BYTE	$00, $00, $00, $00, $FF, $FF, $FF, $FF
	BYTE	$FF, $00, $00, $00, $00, $00, $00, $00
	BYTE	$00, $00, $00, $00, $00, $00, $00, $FF
	BYTE	$C0, $C0, $C0, $C0, $C0, $C0, $C0, $C0
	BYTE	$CC, $CC, $33, $33, $CC, $CC, $33, $33
	BYTE	$03, $03, $03, $03, $03, $03, $03, $03
	BYTE	$00, $00, $00, $00, $CC, $CC, $33, $33
	BYTE	$FF, $FE, $FC, $F8, $F0, $E0, $C0, $80
	BYTE	$03, $03, $03, $03, $03, $03, $03, $03
	BYTE	$18, $18, $18, $1F, $1F, $18, $18, $18
	BYTE	$00, $00, $00, $00, $0F, $0F, $0F, $0F
	BYTE	$18, $18, $18, $1F, $1F, $00, $00, $00
	BYTE	$00, $00, $00, $F8, $F8, $18, $18, $18
	BYTE	$00, $00, $00, $00, $00, $00, $FF, $FF
	BYTE	$00, $00, $00, $1F, $1F, $18, $18, $18
	BYTE	$18, $18, $18, $FF, $FF, $00, $00, $00
	BYTE	$00, $00, $00, $FF, $FF, $18, $18, $18
	BYTE	$18, $18, $18, $F8, $F8, $18, $18, $18
	BYTE	$C0, $C0, $C0, $C0, $C0, $C0, $C0, $C0
	BYTE	$E0, $E0, $E0, $E0, $E0, $E0, $E0, $E0
	BYTE	$07, $07, $07, $07, $07, $07, $07, $07
	BYTE	$FF, $FF, $00, $00, $00, $00, $00, $00
	BYTE	$FF, $FF, $FF, $00, $00, $00, $00, $00
	BYTE	$00, $00, $00, $00, $00, $FF, $FF, $FF
	BYTE	$03, $03, $03, $03, $03, $03, $FF, $FF
	BYTE	$00, $00, $00, $00, $F0, $F0, $F0, $F0
	BYTE	$0F, $0F, $0F, $0F, $00, $00, $00, $00
	BYTE	$18, $18, $18, $F8, $F8, $00, $00, $00
	BYTE	$F0, $F0, $F0, $F0, $00, $00, $00, $00
	BYTE	$F0, $F0, $F0, $F0, $0F, $0F, $0F, $0F
	BYTE	$C3, $99, $91, $91, $9F, $99, $C3, $FF
	BYTE	$E7, $C3, $99, $81, $99, $99, $99, $FF
	BYTE	$83, $99, $99, $83, $99, $99, $83, $FF
	BYTE	$C3, $99, $9F, $9F, $9F, $99, $C3, $FF
	BYTE	$87, $93, $99, $99, $99, $93, $87, $FF
	BYTE	$81, $9F, $9F, $87, $9F, $9F, $81, $FF
	BYTE	$81, $9F, $9F, $87, $9F, $9F, $9F, $FF
	BYTE	$C3, $99, $9F, $91, $99, $99, $C3, $FF
	BYTE	$99, $99, $99, $81, $99, $99, $99, $FF
	BYTE	$C3, $E7, $E7, $E7, $E7, $E7, $C3, $FF
	BYTE	$E1, $F3, $F3, $F3, $F3, $93, $C7, $FF
	BYTE	$99, $93, $87, $8F, $87, $93, $99, $FF
	BYTE	$9F, $9F, $9F, $9F, $9F, $9F, $81, $FF
	BYTE	$9C, $88, $80, $94, $9C, $9C, $9C, $FF
	BYTE	$99, $89, $81, $81, $91, $99, $99, $FF
	BYTE	$C3, $99, $99, $99, $99, $99, $C3, $FF
	BYTE	$83, $99, $99, $83, $9F, $9F, $9F, $FF
	BYTE	$C3, $99, $99, $99, $99, $C3, $F1, $FF
	BYTE	$83, $99, $99, $83, $87, $93, $99, $FF
	BYTE	$C3, $99, $9F, $C3, $F9, $99, $C3, $FF
	BYTE	$81, $E7, $E7, $E7, $E7, $E7, $E7, $FF
	BYTE	$99, $99, $99, $99, $99, $99, $C3, $FF
	BYTE	$99, $99, $99, $99, $99, $C3, $E7, $FF
	BYTE	$9C, $9C, $9C, $94, $80, $88, $9C, $FF
	BYTE	$99, $99, $C3, $E7, $C3, $99, $99, $FF
	BYTE	$99, $99, $99, $C3, $E7, $E7, $E7, $FF
	BYTE	$81, $F9, $F3, $E7, $CF, $9F, $81, $FF
	BYTE	$C3, $CF, $CF, $CF, $CF, $CF, $C3, $FF
	BYTE	$F3, $ED, $CF, $83, $CF, $9D, $03, $FF
	BYTE	$C3, $F3, $F3, $F3, $F3, $F3, $C3, $FF
	BYTE	$FF, $E7, $C3, $81, $E7, $E7, $E7, $E7
	BYTE	$FF, $EF, $CF, $80, $80, $CF, $EF, $FF
	BYTE	$FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF
	BYTE	$E7, $E7, $E7, $E7, $FF, $FF, $E7, $FF
	BYTE	$99, $99, $99, $FF, $FF, $FF, $FF, $FF
	BYTE	$99, $99, $00, $99, $00, $99, $99, $FF
	BYTE	$E7, $C1, $9F, $C3, $F9, $83, $E7, $FF
	BYTE	$9D, $99, $F3, $E7, $CF, $99, $B9, $FF
	BYTE	$C3, $99, $C3, $C7, $98, $99, $C0, $FF
	BYTE	$F9, $F3, $E7, $FF, $FF, $FF, $FF, $FF
	BYTE	$F3, $E7, $CF, $CF, $CF, $E7, $F3, $FF
	BYTE	$CF, $E7, $F3, $F3, $F3, $E7, $CF, $FF
	BYTE	$FF, $99, $C3, $00, $C3, $99, $FF, $FF
	BYTE	$FF, $E7, $E7, $81, $E7, $E7, $FF, $FF
	BYTE	$FF, $FF, $FF, $FF, $FF, $E7, $E7, $CF
	BYTE	$FF, $FF, $FF, $81, $FF, $FF, $FF, $FF
	BYTE	$FF, $FF, $FF, $FF, $FF, $E7, $E7, $FF
	BYTE	$FF, $FC, $F9, $F3, $E7, $CF, $9F, $FF
	BYTE	$C3, $99, $91, $89, $99, $99, $C3, $FF
	BYTE	$E7, $E7, $C7, $E7, $E7, $E7, $81, $FF
	BYTE	$C3, $99, $F9, $F3, $CF, $9F, $81, $FF
	BYTE	$C3, $99, $F9, $E3, $F9, $99, $C3, $FF
	BYTE	$F9, $F1, $E1, $99, $80, $F9, $F9, $FF
	BYTE	$81, $9F, $83, $F9, $F9, $99, $C3, $FF
	BYTE	$C3, $99, $9F, $83, $99, $99, $C3, $FF
	BYTE	$81, $99, $F3, $E7, $E7, $E7, $E7, $FF
	BYTE	$C3, $99, $99, $C3, $99, $99, $C3, $FF
	BYTE	$C3, $99, $99, $C1, $F9, $99, $C3, $FF
	BYTE	$FF, $FF, $E7, $FF, $FF, $E7, $FF, $FF
	BYTE	$FF, $FF, $E7, $FF, $FF, $E7, $E7, $CF
	BYTE	$F1, $E7, $CF, $9F, $CF, $E7, $F1, $FF
	BYTE	$FF, $FF, $81, $FF, $81, $FF, $FF, $FF
	BYTE	$8F, $E7, $F3, $F9, $F3, $E7, $8F, $FF
	BYTE	$C3, $99, $F9, $F3, $E7, $FF, $E7, $FF
	BYTE	$FF, $FF, $FF, $00, $00, $FF, $FF, $FF
	BYTE	$F7, $E3, $C1, $80, $80, $E3, $C1, $FF
	BYTE	$E7, $E7, $E7, $E7, $E7, $E7, $E7, $E7
	BYTE	$FF, $FF, $FF, $00, $00, $FF, $FF, $FF
	BYTE	$FF, $FF, $00, $00, $FF, $FF, $FF, $FF
	BYTE	$FF, $00, $00, $FF, $FF, $FF, $FF, $FF
	BYTE	$FF, $FF, $FF, $FF, $00, $00, $FF, $FF
	BYTE	$CF, $CF, $CF, $CF, $CF, $CF, $CF, $CF
	BYTE	$F3, $F3, $F3, $F3, $F3, $F3, $F3, $F3
	BYTE	$FF, $FF, $FF, $1F, $0F, $C7, $E7, $E7
	BYTE	$E7, $E7, $E3, $F0, $F8, $FF, $FF, $FF
	BYTE	$E7, $E7, $C7, $0F, $1F, $FF, $FF, $FF
	BYTE	$3F, $3F, $3F, $3F, $3F, $3F, $00, $00
	BYTE	$3F, $1F, $8F, $C7, $E3, $F1, $F8, $FC
	BYTE	$FC, $F8, $F1, $E3, $C7, $8F, $1F, $3F
	BYTE	$00, $00, $3F, $3F, $3F, $3F, $3F, $3F
	BYTE	$00, $00, $FC, $FC, $FC, $FC, $FC, $FC
	BYTE	$FF, $C3, $81, $81, $81, $81, $C3, $FF
	BYTE	$FF, $FF, $FF, $FF, $FF, $00, $00, $FF
	BYTE	$C9, $80, $80, $80, $C1, $E3, $F7, $FF
	BYTE	$9F, $9F, $9F, $9F, $9F, $9F, $9F, $9F
	BYTE	$FF, $FF, $FF, $F8, $F0, $E3, $E7, $E7
	BYTE	$3C, $18, $81, $C3, $C3, $81, $18, $3C
	BYTE	$FF, $C3, $81, $99, $99, $81, $C3, $FF
	BYTE	$E7, $E7, $99, $99, $E7, $E7, $C3, $FF
	BYTE	$F9, $F9, $F9, $F9, $F9, $F9, $F9, $F9
	BYTE	$F7, $E3, $C1, $80, $C1, $E3, $F7, $FF
	BYTE	$E7, $E7, $E7, $00, $00, $E7, $E7, $E7
	BYTE	$3F, $3F, $CF, $CF, $3F, $3F, $CF, $CF
	BYTE	$E7, $E7, $E7, $E7, $E7, $E7, $E7, $E7
	BYTE	$FF, $FF, $FC, $C1, $89, $C9, $C9, $FF
	BYTE	$00, $80, $C0, $E0, $F0, $F8, $FC, $FE
	BYTE	$FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF
	BYTE	$0F, $0F, $0F, $0F, $0F, $0F, $0F, $0F
	BYTE	$FF, $FF, $FF, $FF, $00, $00, $00, $00
	BYTE	$00, $FF, $FF, $FF, $FF, $FF, $FF, $FF
	BYTE	$FF, $FF, $FF, $FF, $FF, $FF, $FF, $00
	BYTE	$3F, $3F, $3F, $3F, $3F, $3F, $3F, $3F
	BYTE	$33, $33, $CC, $CC, $33, $33, $CC, $CC
	BYTE	$FC, $FC, $FC, $FC, $FC, $FC, $FC, $FC
	BYTE	$FF, $FF, $FF, $FF, $33, $33, $CC, $CC
	BYTE	$00, $01, $03, $07, $0F, $1F, $3F, $7F
	BYTE	$FC, $FC, $FC, $FC, $FC, $FC, $FC, $FC
	BYTE	$E7, $E7, $E7, $E0, $E0, $E7, $E7, $E7
	BYTE	$FF, $FF, $FF, $FF, $F0, $F0, $F0, $F0
	BYTE	$E7, $E7, $E7, $E0, $E0, $FF, $FF, $FF
	BYTE	$FF, $FF, $FF, $07, $07, $E7, $E7, $E7
	BYTE	$FF, $FF, $FF, $FF, $FF, $FF, $00, $00
	BYTE	$FF, $FF, $FF, $E0, $E0, $E7, $E7, $E7
	BYTE	$E7, $E7, $E7, $00, $00, $FF, $FF, $FF
	BYTE	$FF, $FF, $FF, $00, $00, $E7, $E7, $E7
	BYTE	$E7, $E7, $E7, $07, $07, $E7, $E7, $E7
	BYTE	$3F, $3F, $3F, $3F, $3F, $3F, $3F, $3F
	BYTE	$1F, $1F, $1F, $1F, $1F, $1F, $1F, $1F
	BYTE	$F8, $F8, $F8, $F8, $F8, $F8, $F8, $F8
	BYTE	$00, $00, $FF, $FF, $FF, $FF, $FF, $FF
	BYTE	$00, $00, $00, $FF, $FF, $FF, $FF, $FF
	BYTE	$FF, $FF, $FF, $FF, $FF, $00, $00, $00
	BYTE	$FC, $FC, $FC, $FC, $FC, $FC, $00, $00
	BYTE	$FF, $FF, $FF, $FF, $0F, $0F, $0F, $0F
	BYTE	$F0, $F0, $F0, $F0, $FF, $FF, $FF, $FF
	BYTE	$E7, $E7, $E7, $07, $07, $FF, $FF, $FF
	BYTE	$0F, $0F, $0F, $0F, $FF, $FF, $FF, $FF
	BYTE	$0F, $0F, $0F, $0F, $F0, $F0, $F0, $F0

; screen character data
*=$2800
	BYTE	$57, $04, $57, $70, $43, $43, $43, $57, $20, $57, $40, $40, $43, $40, $40, $43, $40, $40, $43, $40, $40, $43, $40, $40, $43, $40, $40, $43, $40, $40, $6E, $57, $43, $43, $40, $43, $6E, $70, $57, $57
	BYTE	$42, $12, $42, $5D, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $6D, $40, $43, $40, $40, $6E, $42, $42, $70, $71
	BYTE	$71, $6E, $42, $42, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42, $42, $6D, $73, $94
	BYTE	$83, $6B, $7D, $5D, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42, $6D, $43, $73, $85
	BYTE	$90, $6B, $43, $7D, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $6D, $40, $40, $73, $92
	BYTE	$98, $6B, $57, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $57, $73, $B5
	BYTE	$72, $7D, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $70, $73, $B1
	BYTE	$5D, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42, $6D, $72
	BYTE	$42, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $6D, $6E, $42
	BYTE	$71, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $57, $42
	BYTE	$C4, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42
	BYTE	$E4, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $71
	BYTE	$E3, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $E4
	BYTE	$72, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $57, $C4
	BYTE	$42, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42, $E3
	BYTE	$42, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42, $72
	BYTE	$42, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42, $42
	BYTE	$42, $57, $6E, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42, $42
	BYTE	$6D, $6E, $42, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $70, $43, $43, $7D, $42
	BYTE	$57, $42, $42, $57, $20, $57, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $42, $70, $43, $43, $7D
	BYTE	$71, $71, $71, $71, $6E, $5D, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $57, $6E, $57, $42, $42, $70, $43, $6E
	BYTE	$A0, $A0, $A0, $A0, $6B, $7D, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $70, $71, $71, $71, $71, $71, $6E, $57
	BYTE	$8E, $90, $95, $A0, $6B, $40, $43, $6E, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $70, $43, $73, $A0, $A0, $A0, $A0, $A0, $6B, $43
	BYTE	$B1, $B0, $B1, $A0, $6B, $57, $20, $42, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $20, $70, $43, $7D, $57, $73, $A0, $0D, $0F, $13, $A0, $6B, $57
	BYTE	$A0, $A0, $A0, $A0, $6B, $6E, $20, $6D, $40, $40, $43, $40, $40, $43, $43, $57, $20, $57, $43, $43, $43, $43, $43, $43, $43, $43, $43, $43, $7D, $57, $43, $43, $73, $A0, $A0, $A0, $A0, $A0, $6B, $6E

; screen color data
*=$2be8
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
	BYTE	$0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E, $0E
