var Vr = pc.createScript("vr");
Vr.attributes.add("buttonVr", {
    type: "entity",
    title: "VR Button"
}), Vr.attributes.add("elementUnsupported", {
    type: "entity",
    title: "Unsupported Message"
}), Vr.attributes.add("elementHttpsRequired", {
    type: "entity",
    title: "HTTPS Required Message"
}), Vr.attributes.add("cameraEntity", {
    type: "entity",
    title: "Camera"
}), Vr.prototype.initialize = function() {
    this.app.xr.on("available:" + pc.XRTYPE_VR, this.checkButton, this), this.app.xr.on("start", this.checkButton, this), this.app.xr.on("end", this.checkButton, this), this.buttonVr.element.on("click", (function() {
        this.sessionStart()
    }), this), this.app.keyboard.on("keydown", (function(t) {
        t.key === pc.KEY_ESCAPE && this.app.xr.active && (this.app.xr.end(), this.cameraEntity.nearClip = .5)
    }), this), this.checkButton()
}, Vr.prototype.checkButton = function() {
    if (this.app.xr.supported)
        if (this.elementHttpsRequired.enabled = !1, this.elementUnsupported.enabled = !1, this.app.xr.active) this.buttonVr.enabled = !1;
        else {
            this.buttonVr.enabled = !1;
            var t = this.app.xr && !this.app.xr.active && this.app.xr.isAvailable(pc.XRTYPE_VR);
            this.buttonVr.element.opacity = t ? .2 : .1, this.buttonVr.children[0].element.opacity = t ? 1 : .2
        }
    else this.buttonVr.enabled = !1, window.location.protocol, this.elementUnsupported.enabled = !1, this.elementHttpsRequired.enabled = !1
}, Vr.prototype.sessionStart = function() {
    this.app.xr.supported && (this.app.xr.active || this.app.xr.isAvailable(pc.XRTYPE_VR) && (window.DeviceOrientationEvent && window.DeviceOrientationEvent.requestPermission ? DeviceOrientationEvent.requestPermission().then(function(t) {
        "granted" == t && window.addEventListener("deviceorientation", function(t) {
            this.cameraEntity.camera.startXr(pc.XRTYPE_VR, pc.XRSPACE_LOCAL)
        }.bind(this))
    }.bind(this)).catch(console.error) : this.cameraEntity.camera.startXr(pc.XRTYPE_VR, pc.XRSPACE_LOCAL)))
};
var Controllers = pc.createScript("controllers");
Controllers.attributes.add("controllerTemplate", {
    type: "entity",
    title: "Controller Template"
}), Controllers.attributes.add("cameraParent", {
    type: "entity",
    title: "Camera Parent"
}), Controllers.prototype.initialize = function() {
    this.app.xr.input.on("add", (function(t) {
        var e = this.controllerTemplate.clone();
        e.script.controller.setInputSource(t), e.reparent(this.cameraParent), e.enabled = !0;
        var r = t.handedness;
        this.app.fire("controller:register", e, r)
    }), this)
};
var Controller = pc.createScript("controller");
Controller.prototype.initialize = function() {
    this.vecA = new pc.Vec3, this.vecB = new pc.Vec3, this.matA = new pc.Mat4, this.quat = new pc.Quat, this.color = new pc.Color(1, 1, 1), this.modelEntity = this.entity.findByName("model"), this.hoverEntity = null, this.targetPointerSize = 2, this.targetTeleportable = !1, this.pointer = this.entity.findByName("pointer"), this.pointer.element.material.depthTest = !1, this.hoverPoint = new pc.Vec3, this.pointerDistance = 3, this.moving = !0, this.rotating = !0, this.dir = 0, this.menu = !1, axLYonce = !0, axRYonce = !0, axLXonce = !0, axRXonce = !0, axMoveOnceL = !0, axMoveOnceR = !0, axRotOnceL = !0, axRotOnceR = !0, stateLeft = "rotate", stateRight = "rotate", this.app.on("controllerHandler:updateStates", this.updateStates, this)
}, Controller.prototype.setInputSource = function(t) {
    this.inputSource = t, this.inputSource.once("remove", this.onRemove, this), this.on("hover", this.onHover, this), this.on("blur", this.onBlur, this), this.inputSource.on("select", this.onSelect, this)
}, Controller.prototype.onRemove = function() {
    this.app.fire("debug", "destroy", "destroy", 3), this.entity.destroy()
}, Controller.prototype.onSelect = function() {
    if (this.app.fire("object:pick", this), this.hoverEntity)
        if (this.targetTeleportable)("teleport" == stateLeft || "teleport" == stateRight) && this.app.fire("controller:teleport", this.hoverPoint);
        else if (this.hoverEntity.tags.has("interactive")) {
        var t = this.hoverEntity.model.meshInstances[0];
        t.pickedColor || (t.pickedColor = new pc.Color), t.pickedColor.set(Math.random(), Math.random(), Math.random()), t.setParameter("material_diffuse", t.pickedColor.data3)
    }
}, Controller.prototype.onHover = function(t, e) {
    this.hoverEntity = t, this.hoverPoint.copy(e), this.targetPointerSize = 16, this.targetTeleportable = this.hoverEntity.tags.has("teleportable")
}, Controller.prototype.onBlur = function() {
    this.hoverEntity = null, this.targetPointerSize = 4, this.targetTeleportable = !1
}, Controller.prototype.updateStates = function(t, e) {
    "left" == t ? stateLeft = e : "right" == t && (stateRight = e)
}, Controller.prototype.update = function(t) {
    if (this.app.fire("object:pick", this), this.vecA.copy(this.inputSource.getOrigin()), this.vecB.copy(this.inputSource.getDirection()), this.vecB.scale(1e3).add(this.vecA), this.inputSource.selecting ? this.color.set(0, 1, 0) : this.color.set(1, 1, 1), this.inputSource.grip && (this.modelEntity.enabled = !0, this.entity.setPosition(this.inputSource.getPosition()), this.entity.setRotation(this.inputSource.getRotation())), this.hoverEntity) {
        var e = this.vecA.copy(this.hoverPoint).sub(this.inputSource.getOrigin()).length();
        this.pointerDistance += .3 * (e - this.pointerDistance)
    }
    this.vecA.copy(this.inputSource.getDirection()).scale(this.pointerDistance).add(this.inputSource.getOrigin()), this.pointer.setPosition(this.vecA);
    var i = this.targetPointerSize * (this.targetTeleportable ? 8 : 1);
    this.pointer.element.width !== i && (this.pointer.element.width += .3 * (i - this.pointer.element.width), Math.abs(this.pointer.element.width - i) <= 1 && (this.pointer.element.width = i), this.pointer.element.height = this.pointer.element.width), this.targetTeleportable ? this.pointer.setEulerAngles(-90, 0, 0) : this.app.xr.camera && (this.pointer.lookAt(this.app.xr.camera.getPosition(), pc.Vec3.DOWN), this.pointer.rotateLocal(0, 180, 0));
    var o = this.inputSource.gamepad;
    o && (this.inputSource.handedness === pc.XRHAND_LEFT && (o.axes[3] || o.axes[2]) && this.rotating && "rotate" == stateLeft && (this.app.fire("controller:rotate", -o.axes[2], t), this.app.fire("controller:stickRotate", "left", o.axes[2], o.axes[3]), axRotOnceL = !0), this.inputSource.handedness === pc.XRHAND_RIGHT && (o.axes[3] || o.axes[2]) && this.rotating && "rotate" == stateRight && (this.app.fire("controller:rotate", -o.axes[2], t), this.app.fire("controller:stickRotate", "right", o.axes[2], o.axes[3]), axRotOnceR = !0), this.inputSource.handedness !== pc.XRHAND_LEFT || o.axes[3] && o.axes[2] || axRotOnceL && (axRotOnceL = !1, this.app.fire("controller:stickRotate", "left", 0, 0)), this.inputSource.handedness !== pc.XRHAND_RIGHT || o.axes[3] && o.axes[2] || axRotOnceR && (axRotOnceR = !1, this.app.fire("controller:stickRotate", "right", 0, 0)), this.inputSource.handedness === pc.XRHAND_LEFT && o.buttons[0].pressed && this.app.fire("controller:button", "left", 2, "down"), this.inputSource.handedness !== pc.XRHAND_LEFT || o.buttons[0].pressed || this.app.fire("controller:button", "left", 2, "up"), this.inputSource.handedness === pc.XRHAND_RIGHT && o.buttons[0].pressed && this.app.fire("controller:button", "right", 2, "down"), this.inputSource.handedness !== pc.XRHAND_RIGHT || o.buttons[0].pressed || this.app.fire("controller:button", "right", 2, "up"))
};
var ObjectPicker = pc.createScript("objectPicker");
ObjectPicker.prototype.initialize = function() {
    this.entities = this.app.root.findByTag("pickable"), this.ray = new pc.Ray, this.vec3A = new pc.Vec3, this.vec3B = new pc.Vec3, this.app.on("object:pick", this.pick, this)
}, ObjectPicker.prototype.pick = function(i) {
    var t = null,
        e = 1 / 0;
    this.ray.set(i.inputSource.getOrigin(), i.inputSource.getDirection());
    for (var c = 0; c < this.entities.length; c++) {
        if (this.entities[c].model)
            if (this.entities[c].model.meshInstances[0].aabb.intersectsRay(this.ray, this.vec3A)) {
                var s = this.vec3A.distance(this.ray.origin);
                s < e && (e = s, t = this.entities[c], this.vec3B.copy(this.vec3A))
            }
    }
    t ? i.fire("hover", t, this.vec3B) : i.hoverEntity && i.fire("blur")
};
var CameraController = pc.createScript("camera-controller");
CameraController.attributes.add("height", {
    type: "number",
    default: 1.6,
    placeholder: "m",
    title: "Height from Floor"
}), CameraController.attributes.add("movementSpeed", {
    type: "number",
    default: 1.5,
    placeholder: "m/s",
    title: "Movement Speed"
}), CameraController.attributes.add("rotateSpeed", {
    type: "number",
    default: 45,
    placeholder: "°",
    title: "Rotation Speed"
}), CameraController.attributes.add("rotateThreshold", {
    type: "number",
    default: .5,
    min: 0,
    max: 1,
    title: "Rotation thumbstick threshold"
}), CameraController.attributes.add("rotateResetThreshold", {
    type: "number",
    default: .25,
    min: 0,
    max: 1,
    title: "Rotation thumbstick reset threshold"
}), CameraController.attributes.add("camera", {
    type: "entity",
    title: "Camera Entity"
}), CameraController.prototype.initialize = function() {
    this.vec2A = new pc.Vec2, this.vec2B = new pc.Vec2, this.vec3A = new pc.Vec3, this.lastRotate = 0, this.lastRotateValue = 0, this.app.on("controller:teleport", this.onTeleport, this), this.app.on("controller:move", this.onMove, this), this.app.on("controller:rotate", this.onRotate, this), this.app.on("controller:float", this.onFloat, this), this.floating = !0, this.direction = new pc.Vec3, this.currentLerpTime = 0, this.lerpTime = 2, this.resetFloat = !1, this.tScale = 0
}, CameraController.prototype.onTeleport = function(t) {
    this.app.xr.type !== pc.XRTYPE_AR && (this.vec3A.copy(this.camera.getLocalPosition()).scale(-1), this.entity.setPosition(t), this.entity.translate(0, this.height, 0), this.entity.translateLocal(this.vec3A))
}, CameraController.prototype.onMove = function(t, e, i) {
    if (this.vec2A.set(t, e), this.vec2A.length()) {
        this.vec2A.normalize(), this.vec2B.x = this.camera.forward.x, this.vec2B.y = this.camera.forward.z, this.vec2B.normalize();
        var a = Math.atan2(this.vec2B.x, this.vec2B.y) - Math.PI / 2,
            r = this.vec2A.x * Math.sin(a) - this.vec2A.y * Math.cos(a);
        this.vec2A.y = this.vec2A.y * Math.sin(a) + this.vec2A.x * Math.cos(a), this.vec2A.x = r, this.vec2A.scale(this.movementSpeed), this.entity.translate(this.vec2A.x * i, 0, this.vec2A.y * i)
    }
}, CameraController.prototype.onRotate = function(t, e) {
    if (!(Date.now() - this.lastRotate < 200)) {
        if (0 !== this.lastRotateValue)
            if (this.lastRotateValue > 0) {
                if (!(t < this.rotateResetThreshold)) return;
                this.lastRotateValue = 0
            } else {
                if (!(t > -this.rotateResetThreshold)) return;
                this.lastRotateValue = 0
            } Math.abs(t) > this.rotateThreshold && (this.lastRotateValue = Math.sign(t), this.vec3A.copy(this.camera.getLocalPosition()), this.entity.translateLocal(this.vec3A), this.entity.rotateLocal(0, Math.sign(t) * this.rotateSpeed, 0), this.entity.translateLocal(this.vec3A.scale(-1)))
    }
}, CameraController.prototype.onFloat = function(t, e, i) {
    var a = new pc.Vec3(0, .5, 0);
    this.direction.sub2(t.forward, a), this.floating = !0, this.resetFloat = e
}, CameraController.prototype.update = function(t) {
	// this isn't what drives the camera
    this.resetFloat && (this.currentLerpTime = 0, this.tScale = .05), this.currentLerpTime += t, this.currentLerpTime > this.lerpTime && (this.currentLerpTime = this.lerpTime);
    var e = this.currentLerpTime / this.lerpTime;
    if (0 !== this.tScale) {
        this.tScale = pc.math.lerp(.075, 0, pc.math.smootherstep(0, 1, e));
        var i = this.direction.clone();
        i.scale(this.tScale), this.entity.translate(i*5000)
    }
};
var SceneLoader = pc.createScript("sceneLoader");
SceneLoader.attributes.add("currentScene", {
    type: "string",
    default: "MAIN"
}), SceneLoader.attributes.add("rootWorldWrapper", {
    type: "entity"
}), SceneLoader.attributes.add("player", {
    type: "entity"
}), SceneLoader.attributes.add("camEntity", {
    type: "entity"
}), SceneLoader.attributes.add("alreadyLoaded", {
    type: "boolean"
}), SceneLoader.prototype.initialize = function() {
    console.log("init camera and controller"), this.app.on("sceneLoader:loadScene", this.loadScene, this), this.app.mouse.on(pc.EVENT_MOUSEDOWN, this.onMouseDown, this), this.sceneSwitchFlag = !0, this.app.xr.on("start", (function() {
        console.log("xr start")
    })), this.app.xr.on("end", (function() {
        console.log("xr end")
    }))
}, SceneLoader.prototype.onMouseDown = function(e) {
    e.button === pc.MOUSEBUTTON_LEFT && (this.sceneSwitchFlag, this.app.fire("sceneLoader:loadScene", "MAIN"), this.sceneSwitchFlag = !this.sceneSwitchFlag)
}, SceneLoader.prototype.loadScene = function(e) {
    console.log("scene:", e, this.app.root.children);
    var t = this;
    if (this.currentScene === e) {
        this.rootWorldWrapper.enabled = !0;
        var a = t.app.root.findByTag("spawn")[0];
        t.setSpawn(t, a)
    } else {
        this.rootWorldWrapper.enabled = !1;
        this.app.root.findByName("Root");
        for (var o = 0; o < this.app.root.children.length; o++) "Root" === this.app.root.children[o].name && this.app.root.children[o].destroy();
        var n = this.app.scenes.find(e);
        this.app.scenes.loadSceneHierarchy(n.url, (function(e, a) {
            e ? console.error(e) : t.app.scenes.loadSceneSettings(n.url, (function(e) {
                if (e) console.error("loadSceneSettings", e);
                else {
                    var o = a.findByTag("spawn")[0];
                    t.setSpawn(t, o);
                    var n = t.app.root.findByName("Camera");
                    n && (t.camEntity.camera.clearColor = n.camera.clearColor, t.camEntity.camera.nearClip = n.camera.nearClip, t.camEntity.camera.farClip = n.camera.farClip, n.enabled = !1)
                }
            }))
        }))
    }
}, SceneLoader.prototype.setSpawn = function(e, t) {
    var a = t.getPosition();
    e.player.setPosition(a.x, e.player.getPosition().y, a.z)
};
var VrDebug = pc.createScript("vrDebug");
VrDebug.attributes.add("textObj", {
    type: "entity",
    title: "txtObj1",
    array: !0
}), VrDebug.prototype.initialize = function() {
    this.app.on("debug", this.setDebug), to = this.textObj
}, VrDebug.prototype.setDebug = function(t, e, r) {
    to[r].element.text = t + " " + e
}, VrDebug.prototype.update = function(t) {};
var ControllerMenu = pc.createScript("controllerMenu");
ControllerMenu.attributes.add("anim1", {
    type: "asset",
    title: "anim1"
}), ControllerMenu.attributes.add("anim2", {
    type: "asset",
    title: "anim2"
}), ControllerMenu.attributes.add("sndOpn", {
    type: "asset",
    title: "cntrlOpen"
}), ControllerMenu.attributes.add("sndCls", {
    type: "asset",
    title: "cntrlClose"
}), ControllerMenu.attributes.add("sndSld", {
    type: "asset",
    title: "cntrlSlide"
}), ControllerMenu.attributes.add("menu", {
    type: "entity",
    title: "rollMenuEntity"
}), ControllerMenu.attributes.add("cameraParent", {
    type: "entity",
    title: "Camera Parent"
}), ControllerMenu.attributes.add("sceneIndex", {
    type: "string",
    title: "scenes",
    array: !0
}), ControllerMenu.prototype.initialize = function() {
    this.app.on("controller:button", this.onControllerDown, this), this.app.on("controllers:clones", this.addController, this), this.app.on("controller:axis", this.rollMenu, this), this.app.on("rollMenu:counter", this.sceneLoader, this), currentScene = null, nextScene = null, cCounter = 0, sCounter = 7, lAnim = null, rAnim = null, onceL = !1, onceR = !1, axisOnce = !0, roMenu = null, dealy = 0, master = null, crAxis = 0
}, ControllerMenu.prototype.addController = function(e, n, t) {
    "left" == t ? lAnim = e.animation : rAnim = e.animation, 1 === cCounter && (master = t, roMenu = n), cCounter += 1
}, ControllerMenu.prototype.onControllerDown = function(e, n, t) {
    "left" == e && 1 == n && "down" == t && (onceL || (lAnim.play(this.anim2.name), "left" == master && (roMenu.enabled = !0), roMenu.parent.children[4].sound.play("open")), onceL = !0), "left" == e && 1 == n && "up" == t && (onceL && (lAnim.play(this.anim1.name), roMenu.parent.children[4].sound.play("close"), "left" == master && (this.app.fire("sceneLoader:loadScene", this.sceneIndex[sCounter]), roMenu.enabled = !1)), onceL = !1), "right" == e && 1 == n && "down" == t && (onceR || (rAnim.play(this.anim2.name), roMenu.parent.children[4].sound.play("open"), "right" == master && (roMenu.enabled = !0)), onceR = !0), "right" == e && 1 == n && "up" == t && (onceR && (rAnim.play(this.anim1.name), roMenu.parent.children[4].sound.play("close"), "right" == master && (this.app.fire("sceneLoader:loadScene", this.sceneIndex[sCounter]), roMenu.enabled = !1)), onceR = !1)
}, ControllerMenu.prototype.rollMenu = function(e) {
    crAxis = e, this.app.fire("debug", "theAxis:", e, 0), 0 !== e && axisOnce && (e < 0 && (roMenu.script.rollMenu.goLeft(), roMenu.parent.children[4].sound.play("swipe"), sCounter > 0 ? sCounter -= 1 : sCounter = this.sceneIndex.length - 1), e > 0 && (roMenu.script.rollMenu.goRight(), roMenu.parent.children[4].sound.play("swipe"), sCounter < this.sceneIndex.length - 1 ? sCounter += 1 : sCounter = 0), axisOnce = !1), axisOnce = 0 === e
}, ControllerMenu.prototype.sceneLoader = function(e) {
    currentScene = nextScene, nextScene = this.sceneIndex[e]
}, ControllerMenu.prototype.update = function(e) {};
var RollMenu = pc.createScript("rollMenu");
RollMenu.attributes.add("menuGfx", {
    type: "entity",
    title: "menuGfx",
    array: !0
}), RollMenu.attributes.add("menuNodes", {
    type: "entity",
    title: "menuNodes",
    array: !0
}), RollMenu.prototype.initialize = function() {
    for (this.app.keyboard.on(pc.EVENT_KEYDOWN, this.onKeyDown, this), this.app.keyboard.on(pc.EVENT_KEYUP, this.onKeyUp, this), this.counter = 0, pMargin = 40, sMargin = .5, visibleNodes = 3, ent1 = null, ent2 = null, ent3 = null, ent4 = null, i = 0; i < this.menuGfx.length; i++) this.menuGfx[i].enabled = !1;
    this.goLeft()
}, RollMenu.prototype.calcWrap = function(t) {
    if (t < 0) return t < -2 ? this.menuGfx.length - 3 : t < -1 ? this.menuGfx.length - 2 : this.menuGfx.length - 1;
    if (t > this.menuGfx.length - 1) {
        if (t == this.menuGfx.length) return 0;
        if (t == this.menuGfx.length + 1) return 1
    }
    return t
}, RollMenu.prototype.goLeft = function() {
    for (this.counter -= 1, this.app.fire("rollMenu:this.counter", this.counter), this.counter = this.calcWrap(this.counter), ent1 = this.menuGfx[this.calcWrap(this.counter - 1)], ent2 = this.menuGfx[this.counter], ent3 = this.menuGfx[this.calcWrap(this.counter + 1)], ent4 = this.menuGfx[this.calcWrap(this.counter - 2)], k = 0; k < this.menuGfx.length; k++) this.menuGfx[k].enabled = !1;
    var t = 0 - (visibleNodes / 2 - .5) * pMargin,
        e = new pc.Vec3(t, 0, 0),
        n = new pc.Vec3(t + pMargin, 0, 0),
        i = new pc.Vec3(t + 2 * pMargin, 0, 0);
    ent1.setLocalPosition(e), ent2.setLocalPosition(n), ent3.setLocalPosition(i), ent4.setLocalPosition(-80, 0, 0), ent1.enabled = !0, ent2.enabled = !0, ent3.enabled = !0, ent4.enabled = !0, this.transFormNodes(ent1, 2), this.transFormNodes(ent2, 1), this.transFormNodes(ent3, 0), this.transFormNodes(ent4, 3)
}, RollMenu.prototype.goRight = function() {
    for (this.counter += 1, this.app.fire("rollMenu:this.counter", this.counter), this.counter = this.calcWrap(this.counter), ent1 = this.menuGfx[this.calcWrap(this.counter - 2)], ent2 = this.menuGfx[this.counter], ent3 = this.menuGfx[this.calcWrap(this.counter - 1)], ent4 = this.menuGfx[this.calcWrap(this.counter - 3)], l = 0; l < this.menuGfx.length; l++) this.menuGfx[l].enabled = !1;
    var t = 0 - (visibleNodes / 2 - .5) * pMargin,
        e = (new pc.Vec3(t, 0, 0), new pc.Vec3(t + pMargin, 0, 0)),
        n = new pc.Vec3(t + 2 * pMargin, 0, 0);
    ent1.setLocalPosition(e), ent2.setLocalPosition(80, 0, 0), ent3.setLocalPosition(n), ent4.setLocalPosition(-40, 0, 0), ent1.enabled = !0, ent2.enabled = !0, ent3.enabled = !0, ent4.enabled = !0, this.transFormNodes(ent1, 3), this.transFormNodes(ent2, 1), this.transFormNodes(ent3, 2), this.transFormNodes(ent4, 4)
}, RollMenu.prototype.transFormNodes = function(t, e) {
    var n = {
            xPos: 0,
            scale: 0
        },
        i = this.menuNodes[e].getLocalPosition().x,
        s = this.menuNodes[e].getLocalScale().x;
    n.xPos = t.getLocalPosition().x, n.scale = t.getLocalScale().x, t.tween(n).to({
        xPos: i,
        scale: s
    }, .25, pc.QuinticOut).on("update", (function() {
        this.entity.setLocalPosition(n.xPos, 0, 0), this.entity.setLocalScale(n.scale, n.scale, n.scale)
    })).on("complete", (function() {})).start()
}, RollMenu.prototype.update = function(t) {
    this.app.keyboard.wasPressed(pc.KEY_LEFT) ? this.goLeft() : this.app.keyboard.wasPressed(pc.KEY_RIGHT) && this.goRight()
};
var ind, RandomHud = pc.createScript("randomHud");
RandomHud.attributes.add("objAmnt", {
    type: "number",
    description: "ammount of hidden objects"
}), RandomHud.prototype.initialize = function() {
    this.ind = Math.floor(Math.random() * this.objAmnt);
    for (var t = 0; t <= this.objAmnt - 1; t++) {
        this.entity.children[t].enabled = !1
    }
    this.entity.children[this.ind].enabled = !0
}, RandomHud.prototype.update = function(t) {};
var randomLogo = pc.createScript("randomLogo");
randomLogo.attributes.add("materialAsset", {
    type: "asset",
    assetType: "material"
}), randomLogo.attributes.add("numFrames", {
    type: "number",
    default: 1,
    description: "Number of frames to play before looping"
}), randomLogo.attributes.add("startFrame", {
    type: "number",
    default: 0,
    description: "Frame to start animation from"
}), randomLogo.attributes.add("delayFrame", {
    type: "number",
    default: -1,
    description: "Frame to stop the animation"
}), randomLogo.attributes.add("delayDuration", {
    type: "number",
    default: 1,
    description: "duration for the delay"
}), randomLogo.attributes.add("width", {
    type: "number",
    default: 1,
    description: "Number of frames wide"
}), randomLogo.attributes.add("height", {
    type: "number",
    default: 1,
    description: "Number of frames high"
}), randomLogo.attributes.add("frameRate", {
    type: "number",
    default: 1,
    description: "Playback frames per second"
}), randomLogo.prototype.delayFrameBuffer = 0, randomLogo.prototype.delayTick = 0, randomLogo.prototype.isDelaying = !1, randomLogo.prototype.allowOneCycle = !1, randomLogo.prototype.initialize = function() {
    this.startFrame = Math.floor(9 * Math.random()), console.log("startFrame: " + this.startFrame), this.materialAsset && (this.material = this.materialAsset.resource), this.timer = 1 / this.frameRate, this.frame = this.startFrame, this.transform = new pc.Vec4, this.updateMaterial(this.frame), this.delayFrameBuffer = this.delayDuration * this.frameRate
}, randomLogo.prototype.update = function(t) {
    this.numFrames <= 1 || (this.timer -= t, this.timer < 0 && (this.isDelaying ? (this.delayTick += 1, this.delayTick >= this.delayFrameBuffer && (this.delayTick = 0, this.isDelaying = !1), this.frame = this.delayFrame) : this.frame++, this.frame >= this.numFrames + this.startFrame && (this.frame = this.startFrame), this.updateMaterial(this.frame), this.delayFrame >= 0 && (this.delayFrame != this.frame || this.isDelaying || (this.allowOneCycle && (this.isDelaying = !0), this.allowOneCycle = !this.allowOneCycle)), this.timer = 1 / this.frameRate))
}, randomLogo.prototype.updateMaterial = function(t) {
    var e = 1 / this.width,
        a = 1 / this.height,
        r = t % this.width,
        i = Math.floor(t / this.width),
        o = this.entity.model.meshInstances;
    this.transform.set(e, a, r * e, 1 - a - i * a), console.info(o);
    var s = [this.transform.x, this.transform.y, this.transform.z, this.transform.w];
    if (null !== o)
        for (var m = 0; m < o.length; m++) console.log("data: " + s), o[m].setParameter("texture_diffuseMapTransform", s), o[m].setParameter("texture_emissiveMapTransform", s), o[m].setParameter("texture_opacityMapTransform", s)
};
var rot, prevMargin, TunAsm = pc.createScript("tunAsm"),
    pps = 0;
TunAsm.attributes.add("cam", {
    type: "entity",
    title: "Camera"
}), TunAsm.attributes.add("rotSpd", {
    type: "number",
    title: "Cam Rotation Speed"
}), TunAsm.attributes.add("range", {
    type: "number",
    title: "Range"
}), TunAsm.attributes.add("twnTime", {
    type: "number",
    title: "Tween Time"
}), TunAsm.attributes.add("mInterv", {
    type: "number",
    title: "spawn Intervall"
}), TunAsm.attributes.add("assets", {
    type: "entity",
    array: !0
}), TunAsm.prototype.initialize = function() {
    this.rot = 0, this.time = 0, this.spawnNext = this.mInterv, this.prevMargin = 19.5, this.pps = this.range / this.twnTime;
    this.counter = 0;
}, TunAsm.prototype.update = function(t) {
    // this seems to be unused, but maybe it creates the generic debric - bubbles etc
    this.root.rotate(0, 0, this.rotSpd), this.time += t, this.time > this.spawnNext && (this.spawnNext = this.time + this.mInterv, this.spawn())
}, TunAsm.prototype.spawn = function() {
    var t, e = (this.counter % this.assets.length),
        s = this.assets[e].clone(),
        i = this.entity.getPosition();
    this.counter += 1;
    this.prvPos = this.mInterv * this.pps, i.z += 0 - this.prevMargin / 2, t = i.z / this.pps * -1, s.setPosition(0, 0, this.startPos), s.rotate(0, 0, 60 * Math.floor(6 * Math.random())), this.app.root.addChild(s), console.log("startPos" + i + " prvPos: 0 pps: " + pps + " tTime: " + t), s.tween(i).to({
        x: 0,
        y: 0,
        z: this.entity.getPosition().z
    }, this.twnTime, pc.Linear).on("complete", (function() {
        TunAsm.prototype.resetter(s)
    })).start(), prevMargin = s.children[1].getLocalPosition().z
}, TunAsm.prototype.resetter = function(t) {
    t.destroy()
};










var AnimatedTexture = pc.createScript("animatedTexture");
AnimatedTexture.attributes.add("materialAsset", {
    type: "asset",
    assetType: "material"
}), AnimatedTexture.attributes.add("numFrames", {
    type: "number",
    default: 1,
    description: "Number of frames to play before looping"
}), AnimatedTexture.attributes.add("startFrame", {
    type: "number",
    default: 0,
    description: "Frame to start animation from"
}), AnimatedTexture.attributes.add("delayFrame", {
    type: "number",
    default: -1,
    description: "Frame to stop the animation"
}), AnimatedTexture.attributes.add("delayDuration", {
    type: "number",
    default: 1,
    description: "duration for the delay"
}), AnimatedTexture.attributes.add("width", {
    type: "number",
    default: 1,
    description: "Number of frames wide"
}), AnimatedTexture.attributes.add("height", {
    type: "number",
    default: 1,
    description: "Number of frames high"
}), AnimatedTexture.attributes.add("frameRate", {
    type: "number",
    default: 1,
    description: "Playback frames per second"
}), AnimatedTexture.prototype.delayFrameBuffer = 0, AnimatedTexture.prototype.delayTick = 0, AnimatedTexture.prototype.isDelaying = !1, AnimatedTexture.prototype.allowOneCycle = !1, AnimatedTexture.prototype.initialize = function() {
    this.materialAsset && (this.material = this.materialAsset.resource), this.timer = 1 / this.frameRate, this.frame = this.startFrame, this.transform = new pc.Vec4, this.updateMaterial(this.frame), this.delayFrameBuffer = this.delayDuration * this.frameRate
}, AnimatedTexture.prototype.update = function(t) {
    this.numFrames <= 1 || (this.timer -= t, this.timer < 0 && (this.isDelaying ? (this.delayTick += 1, this.delayTick >= this.delayFrameBuffer && (this.delayTick = 0, this.isDelaying = !1), this.frame = this.delayFrame) : this.frame++, this.frame >= this.numFrames + this.startFrame && (this.frame = this.startFrame), this.updateMaterial(this.frame), this.delayFrame >= 0 && (this.delayFrame != this.frame || this.isDelaying || (this.allowOneCycle && (this.isDelaying = !0), this.allowOneCycle = !this.allowOneCycle)), this.timer = 1 / this.frameRate))
}, AnimatedTexture.prototype.updateMaterial = function(t) {
    var e = 1 / this.width,
        a = 1 / this.height,
        i = t % this.width,
        r = Math.floor(t / this.width),
        s = this.entity.model.meshInstances;
    this.transform.set(e, a, i * e, 1 - a - r * a);
    var m = [this.transform.x, this.transform.y, this.transform.z, this.transform.w];
    if (null !== s)
        for (var d = 0; d < s.length; d++) s[d].setParameter("texture_diffuseMapTransform", m), s[d].setParameter("texture_emissiveMapTransform", m), s[d].setParameter("texture_opacityMapTransform", m)
};
var ScrollingTexture = pc.createScript("ScrollingTexture");
ScrollingTexture.attributes.add("materialAsset", {
    type: "asset"
}), ScrollingTexture.attributes.add("speed", {
    type: "vec2"
}), ScrollingTexture.tmp = new pc.Vec2, ScrollingTexture.prototype.initialize = function() {
    this.materialAsset && (this.material = this.materialAsset.resource)
}, ScrollingTexture.prototype.update = function(e) {
    var t = ScrollingTexture.tmp;
    t.set(this.speed.x, this.speed.y), t.scale(e), this.material.glossMapOffset = this.material.diffuseMapOffset.add(t), this.material.opacityMapOffset.add(t), this.material.update()
};
var startPos, endPos, counter, prevMargin, pps, ent, container, TunnelAssembler = pc.createScript("tunnelAssembler");
TunnelAssembler.attributes.add("title", {
    type: "entity"
}), TunnelAssembler.attributes.add("rtz", {
    type: "entity"
}), TunnelAssembler.attributes.add("yce", {
    type: "entity"
}), TunnelAssembler.attributes.add("twc", {
    type: "entity"
}), TunnelAssembler.attributes.add("times3", {
    type: "entity"
}), TunnelAssembler.attributes.add("times4", {
    type: "entity"
}), TunnelAssembler.attributes.add("times500", {
    type: "entity"
}), TunnelAssembler.attributes.add("yourmom", {
    type: "entity"
}), TunnelAssembler.attributes.add("fin", {
    type: "entity"
}), TunnelAssembler.attributes.add("can", {
    type: "entity"
}), TunnelAssembler.attributes.add("rotSpd", {
    type: "number",
    title: "Cam Rotation Speed"
}), TunnelAssembler.attributes.add("range", {
    type: "number",
    title: "TunnelRange"
}), TunnelAssembler.attributes.add("mTime", {
    type: "number",
    title: "Time"
}), TunnelAssembler.attributes.add("assets", {
    type: "entity",
    array: !0
}), TunnelAssembler.attributes.add("assets_p2", {
    type: "entity",
    array: !0
}), TunnelAssembler.prototype.initialize = function() {
    this.container = this.app.root.findByName("tunnelContainer");
    this.container.setLocalEulerAngles(0, 90, 0);
    this.pps = this.range / this.mTime;
    // minimum z value (behind the screen) where the tunnel segment is considered offscreen
    this.startPos = this.entity.getPosition().z + this.range / 2;
    // maximum z value (far into the screen) where the tunnel segment is spawned far away
    this.endPos = this.entity.getPosition().z - this.range / 2;
    this.prevMargin = 0;
    this.prevPos = this.startPos; // position of previous objc
    this.app.timeScale = 1;
    this.tTween = null;
    this.app.on("buttonPressed", this.increaseTime, this);
    this.theTime = 0, this.timeCounter = !1, this.break1 = !0, this.break2 = !0, this.break3 = !0, this.break4 = !0, this.break5 = !0, this.break6 = !0, this.break7 = !0, this.break8 = !0, this.break9 = !0, this.break10 = !0, this.break11 = !0
    this.counter = 0;
    this.assetPool = {};
    this.ents = [];
    
    this.fades = [
		// list of [absolute realtime, string name, string in or out]
		[.5, "rtz", "in"],
		[5, "rtz", "out"],
		
		[6, "title", "in"],
		[8, "title", "out"],
		
		[30, "yce", "in"],
		[33, "yce", "out"],
		[34, "twc", "in"],
		[37, "twc", "out"],
		
		[45+0, "yce", "in"],
		[45+3, "yce", "out"],
		[45+6, "times3", "in"],
		[45+8, "times3", "out"],
		[45+9, "times4", "in"],
		[45+11, "times4", "out"],
		
		[60+0, "yce", "in"],
		[60+2, "yce", "out"],
		[60+3, "times500", "in"],
		[60+7, "times500", "out"],
		
		[90, "can", "in"],
		[100, "can", "out"],
		
		[120, "yourmom", "in"],
		[125, "yourmom", "out"],
		
		[140, "final"],
	];
}, TunnelAssembler.prototype.increaseTime = function(t) {
    if (console.log("buTtonbressed " + t), "start" === t) {
		this.startTime = Date.now(); // milliseconds
        this.timeCounter = !0, console.log("ict");
        var e = this;
        this.app.timeScale = 1;
        return;
        var i = {
            scl: .5
        };
        this.tTween = this.entity.tween(i).to({
            scl: 250
        }, 140, // real time start to finish
        pc.ExponentialIn
        ////    function(t) {
           //    return 0 === t ? 0 : Math.pow(2, t)-1
            //},
        ).on("update", (function() {
            e.app.timeScale = i.scl
        })).on("complete", (function() {})).start()
    }
}, TunnelAssembler.prototype.fadeBack = function() {
    console.log("ende echt finito");
    var t = {
            scale: 25
        },
        e = this;
    this.tTween.stop(), this.entity.tween(t).to({
        scale: 1
    }, 3, pc.Linear).on("update", (function() {
        e.app.timeScale = t.scale
    })).start()
}, TunnelAssembler.prototype.fadeStuff = function(t, e) {
    var i = {
        opacity: 0
    };
    mat = t.model.model.meshInstances[0].material, "in" == e && (console.log("dir:in"), i = {
        opacity: 0
    }, t.tween(i).to({
        opacity: 1
    }, .25, pc.Linear).on("update", (function() {
        mat.opacity = i.opacity, mat.update()
    })).start()), "out" == e && (i = {
        opacity: 1
    }, t.tween(i).to({
        opacity: 0
    }, .25, pc.Linear).on("update", (function() {
        mat.opacity = i.opacity, mat.update()
    })).start())
}, TunnelAssembler.prototype.update = function(t) {
	
	if(this.__stoopped) return;
	var realtime = 0;
	if(typeof this.startTime !== "undefined") {
		realtime = (Date.now() - this.startTime) / 1000;
		
		this.app.timeScale = Math.exp(realtime / 15)/2; // /15 was ok
	}
	
    // this is the main driver of animation. (TunAsm is an unused old version)
    this.container.rotate(this.rotSpd, 0, 0);
    while(this.spawn()) {} // loop outside of function so each call has its own local variables captured in closures
    this.timeCounter && (this.theTime += t);
    //realtime *= 3;
    
    while(this.fades.length > 0 && realtime > this.fades[0][0]) {
		// list of [time, name of what to fade, "in" or "out"]
		var fade = this.fades.shift();
		if(fade[1] == "final") {
			this.fadeStuff(this.fin, "in");
			console.log("lastscreen");
			this.fadeBack();
		} else {
			this.fadeStuff(this[fade[1]], fade[2]);
		}
	}
    
    /*
    realtime > .5 && this.break1 && (this.break1 = !1, this.fadeStuff(this.rtz, "in"))
    realtime > 5 && this.break2 && (this.break2 = !1, this.fadeStuff(this.rtz, "out"))
    realtime > 40 && this.break3 && (this.break3 = !1, this.fadeStuff(this.title, "in"))
    realtime > 42.3 && this.break4 && (this.break4 = !1, this.fadeStuff(this.title, "out"))
    realtime > 79.75 && this.break5 && (this.break5 = !1, this.fadeStuff(this.yce, "in"))
    realtime > 84.3 && this.break6 && (this.break6 = !1, this.fadeStuff(this.yce, "out"))
    realtime > 85 && this.break7 && (this.break7 = !1, this.fadeStuff(this.twc, "in"))
    realtime > 84.3 && this.break6 && (this.break6 = !1, this.fadeStuff(this.yce, "out"))
    //console.log(this.twc, this.times3, this.times4)
    /*realtime > 85 &&*//* this.break7 && (this.break7 = !1, /*this.fadeStuff(this.twc, "in"),*//* this.fadeStuff(this.times3, "in"), this.fadeStuff(this.times4, "in"), this.fadeStuff(this.times3, "in"))
    realtime > 89.6 && this.break8 && (this.break8 = !1, this.fadeStuff(this.twc, "out"))
    realtime > 93 && this.break10 && (this.break10 = !1, this.fadeStuff(this.can, "in"))
    realtime > 96 && this.break11 && (this.break11 = !1, this.fadeStuff(this.can, "out"))*/
    //this.theTime > 1170 && this.break9 && (this.break9 = !1, this.fadeStuff(this.fin, "in"), console.log("lastscreen"), this.fadeBack())
}

// typeID is index into this.assets
TunnelAssembler.prototype.getAsset = function(typeID) {
	if(this.assetPool[typeID] && this.assetPool[typeID].length > 0) {
		//console.log("from pool",typeID);
		return this.assetPool[typeID].pop();
	} else {
		//console.log("clone new",typeID);
		var x = this.assets[typeID].clone();
		x.__asset_type_id = typeID;
		return x;
	}
}

TunnelAssembler.prototype.returnAsset = function(x) {
	if (!this.assetPool[x.__asset_type_id]) {
		this.assetPool[x.__asset_type_id] = [];
		//console.log("new pool",x.__asset_type_id);
	}
	this.container.removeChild(x);
	//console.log("return ",x.__asset_type_id);
	this.assetPool[x.__asset_type_id].push(x);
	x.setPosition(0, 0, 1000000);
	/*setTimeout(function() {
		x.setLocalPosition(0, 0, 1000000);
	}, 0);*/
}

TunnelAssembler.prototype.spawn = function() {
	
	while(this.ents.length > 0 && (this.ents[0].getLocalPosition().z >= this.startPos || this.ents[0].__tunnel_done)) {
		//console.log("return one ",this.ents.length, this.ents[0].getLocalPosition().z, this.startPos);
		this.returnAsset(this.ents.shift());
	//	this.__stoopping = true;
	}
	
	//console.log("tun spawn ",this.ent?this.ent.getLocalPosition().z:0, this.endPos);
	//if(this.ents.length)
	//	console.log("spawn check ",this.ents[this.ents.length-1].getLocalPosition().z, this.endPos);
    if (this.ents.length == 0 || this.ents[this.ents.length-1].getLocalPosition().z > this.endPos) {
	//	if(this.__stoopping)
	//this.		__stoopped = true;
		this.prevPos = (this.ents.length == 0 ? this.startPos : this.ents[this.ents.length-1].getLocalPosition().z);
		if(this.prevPos > this.entity.getPosition().z)
			this.prevPos = this.entity.getPosition().z;
		
		//console.log("tun spawn now",this.prevPos, this.ents.length);
		// asset 0 "! ?" is a wireframe box
		// 1 "! L" is nothing?
		// 2 "! Z" is a wireframe square (not a cube)
		// 3 "! ," is a
		// 4 "! [" is a
		// 5 "! !" is a
		// 6 "! -" is a
		// 7 "! 0" is a
		// 8 "! N" is a
		// 9 "! ^" is a
		// 10 "! O" is a
		// 11 "! _" is a
		// 12 "! 8" is a
        var t = (this.counter % this.assets.length),
            //e = this.assets[t].clone(),
            e = this.getAsset(t),
            i = this.prevPos + this.prevMargin;
        e.__tunnel_done = false;
        this.counter++;
        e.setPosition(0, 0, i)
        //e.rotate(0, 0, 60 * Math.floor(6 * Math.random()))
        this.container.addChild(e);
        var s = (i < 0 ? this.range / 2 + -1 * i : this.range - this.range / 2 - i) / this.pps;
        var this_ = this;
        //var pos = e.getLocalPosition().clone();
        var tween = e.tween(e.getLocalPosition()).to({
            x: 0,
            y: 0,
            z: this.startPos
        }, s, pc.Linear).on("complete", (function() {
            //e.setLocalPosition(0, 0, this_.startPos+100); // make sure it triggers remove loop start of spawn()
            e.__tunnel_done=true;
        }))//.on("update", function(deltatime_seconds) {
			//if(e==this_.ent) console.log(e.getLocalPosition().z, evt);
			//e.setPosition(pos.x, pos.y, pos.z);
			//console.log(pos.x, pos.y, pos.z);
		//})
		.start()
        this.prevMargin = e.children[0].getLocalPosition().z
        //this.ent = e
        this.ents.push(e);
        //assert e.getLocalPosition().z < this.startPos; //else we infinitely loop!
        return true;
    }
    return false;
};









var MouseInput = pc.createScript("orbitMouseInput");
MouseInput.attributes.add("orbitSensitivity", {
    type: "number",
    default: .3,
    title: "Orbit Sensitivity",
    description: "How fast the camera moves around the orbit. Higher is faster"
}), MouseInput.attributes.add("distanceSensitivity", {
    type: "number",
    default: .15,
    title: "Distance Sensitivity",
    description: "How fast the camera moves in and out. Higher is faster"
}), MouseInput.prototype.initialize = function() {
    if (this.orbitCamera = this.entity.script.orbitCamera, this.orbitCamera) {
        var t = this,
            onMouseOut = function(o) {
                t.onMouseOut(o)
            };
        this.app.mouse.on(pc.EVENT_MOUSEDOWN, this.onMouseDown, this), this.app.mouse.on(pc.EVENT_MOUSEUP, this.onMouseUp, this), this.app.mouse.on(pc.EVENT_MOUSEMOVE, this.onMouseMove, this), this.app.mouse.on(pc.EVENT_MOUSEWHEEL, this.onMouseWheel, this), window.addEventListener("mouseout", onMouseOut, !1), this.on("destroy", (function() {
            this.app.mouse.off(pc.EVENT_MOUSEDOWN, this.onMouseDown, this), this.app.mouse.off(pc.EVENT_MOUSEUP, this.onMouseUp, this), this.app.mouse.off(pc.EVENT_MOUSEMOVE, this.onMouseMove, this), this.app.mouse.off(pc.EVENT_MOUSEWHEEL, this.onMouseWheel, this), window.removeEventListener("mouseout", onMouseOut, !1)
        }))
    }
    this.app.mouse.disableContextMenu(), this.lookButtonDown = !1, this.panButtonDown = !1, this.lastPoint = new pc.Vec2
}, MouseInput.fromWorldPoint = new pc.Vec3, MouseInput.toWorldPoint = new pc.Vec3, MouseInput.worldDiff = new pc.Vec3, MouseInput.prototype.pan = function(t) {
    var o = MouseInput.fromWorldPoint,
        i = MouseInput.toWorldPoint,
        e = MouseInput.worldDiff,
        s = this.entity.camera,
        n = this.orbitCamera.distance;
    s.screenToWorld(t.x, t.y, n, o), s.screenToWorld(this.lastPoint.x, this.lastPoint.y, n, i), e.sub2(i, o), this.orbitCamera.pivotPoint.add(e)
}, MouseInput.prototype.onMouseDown = function(t) {
    switch (t.button) {
        case pc.MOUSEBUTTON_LEFT:
            this.lookButtonDown = !0;
            break;
        case pc.MOUSEBUTTON_MIDDLE:
        case pc.MOUSEBUTTON_RIGHT:
            this.panButtonDown = !0
    }
}, MouseInput.prototype.onMouseUp = function(t) {
    switch (t.button) {
        case pc.MOUSEBUTTON_LEFT:
            this.lookButtonDown = !1;
            break;
        case pc.MOUSEBUTTON_MIDDLE:
        case pc.MOUSEBUTTON_RIGHT:
            this.panButtonDown = !1
    }
}, MouseInput.prototype.onMouseMove = function(t) {
    pc.app.mouse;
    this.lookButtonDown ? (this.orbitCamera.pitch -= t.dy * this.orbitSensitivity, this.orbitCamera.yaw -= t.dx * this.orbitSensitivity) : this.panButtonDown && this.pan(t), this.lastPoint.set(t.x, t.y)
}, MouseInput.prototype.onMouseWheel = function(t) {
    this.orbitCamera.distance -= t.wheel * this.distanceSensitivity * (.1 * this.orbitCamera.distance)
}, MouseInput.prototype.onMouseOut = function(t) {
    this.lookButtonDown = !1, this.panButtonDown = !1
};
var OrbitTouchInput = pc.createScript("orbitTouchInput");
OrbitTouchInput.attributes.add("orbitSensitivity", {
    type: "number",
    default: .4,
    title: "Orbit Sensitivity",
    description: "How fast the camera moves around the orbit. Higher is faster"
}), OrbitTouchInput.attributes.add("distanceSensitivity", {
    type: "number",
    default: .2,
    title: "Distance Sensitivity",
    description: "How fast the camera moves in and out. Higher is faster"
}), OrbitTouchInput.prototype.initialize = function() {
    this.orbitCamera = this.entity.script.orbitCamera, this.lastTouchPoint = new pc.Vec2, this.lastPinchMidPoint = new pc.Vec2, this.lastPinchDistance = 0, this.orbitCamera && this.app.touch && (this.app.touch.on(pc.EVENT_TOUCHSTART, this.onTouchStartEndCancel, this), this.app.touch.on(pc.EVENT_TOUCHEND, this.onTouchStartEndCancel, this), this.app.touch.on(pc.EVENT_TOUCHCANCEL, this.onTouchStartEndCancel, this), this.app.touch.on(pc.EVENT_TOUCHMOVE, this.onTouchMove, this), this.on("destroy", (function() {
        this.app.touch.off(pc.EVENT_TOUCHSTART, this.onTouchStartEndCancel, this), this.app.touch.off(pc.EVENT_TOUCHEND, this.onTouchStartEndCancel, this), this.app.touch.off(pc.EVENT_TOUCHCANCEL, this.onTouchStartEndCancel, this), this.app.touch.off(pc.EVENT_TOUCHMOVE, this.onTouchMove, this)
    })))
}, OrbitTouchInput.prototype.getPinchDistance = function(t, i) {
    var o = t.x - i.x,
        n = t.y - i.y;
    return Math.sqrt(o * o + n * n)
}, OrbitTouchInput.prototype.calcMidPoint = function(t, i, o) {
    o.set(i.x - t.x, i.y - t.y), o.scale(.5), o.x += t.x, o.y += t.y
}, OrbitTouchInput.prototype.onTouchStartEndCancel = function(t) {
    var i = t.touches;
    1 == i.length ? this.lastTouchPoint.set(i[0].x, i[0].y) : 2 == i.length && (this.lastPinchDistance = this.getPinchDistance(i[0], i[1]), this.calcMidPoint(i[0], i[1], this.lastPinchMidPoint))
}, OrbitTouchInput.fromWorldPoint = new pc.Vec3, OrbitTouchInput.toWorldPoint = new pc.Vec3, OrbitTouchInput.worldDiff = new pc.Vec3, OrbitTouchInput.prototype.pan = function(t) {
    var i = OrbitTouchInput.fromWorldPoint,
        o = OrbitTouchInput.toWorldPoint,
        n = OrbitTouchInput.worldDiff,
        h = this.entity.camera,
        c = this.orbitCamera.distance;
    h.screenToWorld(t.x, t.y, c, i), h.screenToWorld(this.lastPinchMidPoint.x, this.lastPinchMidPoint.y, c, o), n.sub2(o, i), this.orbitCamera.pivotPoint.add(n)
}, OrbitTouchInput.pinchMidPoint = new pc.Vec2, OrbitTouchInput.prototype.onTouchMove = function(t) {
    var i = OrbitTouchInput.pinchMidPoint,
        o = t.touches;
    if (1 == o.length) {
        var n = o[0];
        this.orbitCamera.pitch -= (n.y - this.lastTouchPoint.y) * this.orbitSensitivity, this.orbitCamera.yaw -= (n.x - this.lastTouchPoint.x) * this.orbitSensitivity, this.lastTouchPoint.set(n.x, n.y)
    } else if (2 == o.length) {
        var h = this.getPinchDistance(o[0], o[1]),
            c = h - this.lastPinchDistance;
        this.lastPinchDistance = h, this.orbitCamera.distance -= c * this.distanceSensitivity * .1 * (.1 * this.orbitCamera.distance), this.calcMidPoint(o[0], o[1], i), this.pan(i), this.lastPinchMidPoint.copy(i)
    }
};
var OrbitCamera = pc.createScript("orbitCamera");
OrbitCamera.attributes.add("distanceMax", {
    type: "number",
    default: 0,
    title: "Distance Max",
    description: "Setting this at 0 will give an infinite distance limit"
}), OrbitCamera.attributes.add("distanceMin", {
    type: "number",
    default: 0,
    title: "Distance Min"
}), OrbitCamera.attributes.add("pitchAngleMax", {
    type: "number",
    default: 90,
    title: "Pitch Angle Max (degrees)"
}), OrbitCamera.attributes.add("pitchAngleMin", {
    type: "number",
    default: -90,
    title: "Pitch Angle Min (degrees)"
}), OrbitCamera.attributes.add("inertiaFactor", {
    type: "number",
    default: 0,
    title: "Inertia Factor",
    description: "Higher value means that the camera will continue moving after the user has stopped dragging. 0 is fully responsive."
}), OrbitCamera.attributes.add("focusEntity", {
    type: "entity",
    title: "Focus Entity",
    description: "Entity for the camera to focus on. If blank, then the camera will use the whole scene"
}), OrbitCamera.attributes.add("frameOnStart", {
    type: "boolean",
    default: !0,
    title: "Frame on Start",
    description: 'Frames the entity or scene at the start of the application."'
}), Object.defineProperty(OrbitCamera.prototype, "distance", {
    get: function() {
        return this._targetDistance
    },
    set: function(t) {
        this._targetDistance = this._clampDistance(t)
    }
}), Object.defineProperty(OrbitCamera.prototype, "pitch", {
    get: function() {
        return this._targetPitch
    },
    set: function(t) {
        this._targetPitch = this._clampPitchAngle(t)
    }
}), Object.defineProperty(OrbitCamera.prototype, "yaw", {
    get: function() {
        return this._targetYaw
    },
    set: function(t) {
        this._targetYaw = t;
        var i = (this._targetYaw - this._yaw) % 360;
        this._targetYaw = i > 180 ? this._yaw - (360 - i) : i < -180 ? this._yaw + (360 + i) : this._yaw + i
    }
}), Object.defineProperty(OrbitCamera.prototype, "pivotPoint", {
    get: function() {
        return this._pivotPoint
    },
    set: function(t) {
        this._pivotPoint.copy(t)
    }
}), OrbitCamera.prototype.focus = function(t) {
    this._buildAabb(t, 0);
    var i = this._modelsAabb.halfExtents,
        e = Math.max(i.x, Math.max(i.y, i.z));
    e /= Math.tan(.5 * this.entity.camera.fov * pc.math.DEG_TO_RAD), e *= 2, this.distance = e, this._removeInertia(), this._pivotPoint.copy(this._modelsAabb.center)
}, OrbitCamera.distanceBetween = new pc.Vec3, OrbitCamera.prototype.resetAndLookAtPoint = function(t, i) {
    this.pivotPoint.copy(i), this.entity.setPosition(t), this.entity.lookAt(i);
    var e = OrbitCamera.distanceBetween;
    e.sub2(i, t), this.distance = e.length(), this.pivotPoint.copy(i);
    var a = this.entity.getRotation();
    this.yaw = this._calcYaw(a), this.pitch = this._calcPitch(a, this.yaw), this._removeInertia(), this._updatePosition()
}, OrbitCamera.prototype.resetAndLookAtEntity = function(t, i) {
    this._buildAabb(i, 0), this.resetAndLookAtPoint(t, this._modelsAabb.center)
}, OrbitCamera.prototype.reset = function(t, i, e) {
    this.pitch = i, this.yaw = t, this.distance = e, this._removeInertia()
}, OrbitCamera.prototype.initialize = function() {
    var t = this,
        onWindowResize = function() {
            t._checkAspectRatio()
        };
    window.addEventListener("resize", onWindowResize, !1), this._checkAspectRatio(), this._modelsAabb = new pc.BoundingBox, this._buildAabb(this.focusEntity || this.app.root, 0), this.entity.lookAt(this._modelsAabb.center), this._pivotPoint = new pc.Vec3, this._pivotPoint.copy(this._modelsAabb.center);
    var i = this.entity.getRotation();
    if (this._yaw = this._calcYaw(i), this._pitch = this._clampPitchAngle(this._calcPitch(i, this._yaw)), this.entity.setLocalEulerAngles(this._pitch, this._yaw, 0), this._distance = 0, this._targetYaw = this._yaw, this._targetPitch = this._pitch, this.frameOnStart) this.focus(this.focusEntity || this.app.root);
    else {
        var e = new pc.Vec3;
        e.sub2(this.entity.getPosition(), this._pivotPoint), this._distance = this._clampDistance(e.length())
    }
    this._targetDistance = this._distance, this.on("attr:distanceMin", (function(t, i) {
        this._targetDistance = this._clampDistance(this._distance)
    })), this.on("attr:distanceMax", (function(t, i) {
        this._targetDistance = this._clampDistance(this._distance)
    })), this.on("attr:pitchAngleMin", (function(t, i) {
        this._targetPitch = this._clampPitchAngle(this._pitch)
    })), this.on("attr:pitchAngleMax", (function(t, i) {
        this._targetPitch = this._clampPitchAngle(this._pitch)
    })), this.on("attr:focusEntity", (function(t, i) {
        this.frameOnStart ? this.focus(t || this.app.root) : this.resetAndLookAtEntity(this.entity.getPosition(), t || this.app.root)
    })), this.on("attr:frameOnStart", (function(t, i) {
        t && this.focus(this.focusEntity || this.app.root)
    })), this.on("destroy", (function() {
        window.removeEventListener("resize", onWindowResize, !1)
    }))
}, OrbitCamera.prototype.update = function(t) {
    var i = 0 === this.inertiaFactor ? 1 : Math.min(t / this.inertiaFactor, 1);
    this._distance = pc.math.lerp(this._distance, this._targetDistance, i), this._yaw = pc.math.lerp(this._yaw, this._targetYaw, i), this._pitch = pc.math.lerp(this._pitch, this._targetPitch, i), this._updatePosition()
}, OrbitCamera.prototype._updatePosition = function() {
    this.entity.setLocalPosition(0, 0, 0), this.entity.setLocalEulerAngles(this._pitch, this._yaw, 0);
    var t = this.entity.getPosition();
    t.copy(this.entity.forward), t.scale(-this._distance), t.add(this.pivotPoint), this.entity.setPosition(t)
}, OrbitCamera.prototype._removeInertia = function() {
    this._yaw = this._targetYaw, this._pitch = this._targetPitch, this._distance = this._targetDistance
}, OrbitCamera.prototype._checkAspectRatio = function() {
    var t = this.app.graphicsDevice.height,
        i = this.app.graphicsDevice.width;
    this.entity.camera.horizontalFov = t > i
}, OrbitCamera.prototype._buildAabb = function(t, i) {
    var e = 0;
    if (t.model) {
        var a = t.model.meshInstances;
        for (e = 0; e < a.length; e++) 0 === i ? this._modelsAabb.copy(a[e].aabb) : this._modelsAabb.add(a[e].aabb), i += 1
    }
    for (e = 0; e < t.children.length; ++e) i += this._buildAabb(t.children[e], i);
    return i
}, OrbitCamera.prototype._calcYaw = function(t) {
    var i = new pc.Vec3;
    return t.transformVector(pc.Vec3.FORWARD, i), Math.atan2(-i.x, -i.z) * pc.math.RAD_TO_DEG
}, OrbitCamera.prototype._clampDistance = function(t) {
    return this.distanceMax > 0 ? pc.math.clamp(t, this.distanceMin, this.distanceMax) : Math.max(t, this.distanceMin)
}, OrbitCamera.prototype._clampPitchAngle = function(t) {
    return pc.math.clamp(t, -this.pitchAngleMax, -this.pitchAngleMin)
}, OrbitCamera.quatWithoutYaw = new pc.Quat, OrbitCamera.yawOffset = new pc.Quat, OrbitCamera.prototype._calcPitch = function(t, i) {
    var e = OrbitCamera.quatWithoutYaw,
        a = OrbitCamera.yawOffset;
    a.setFromEulerAngles(0, -i, 0), e.mul2(a, t);
    var s = new pc.Vec3;
    return e.transformVector(pc.Vec3.FORWARD, s), Math.atan2(s.y, -s.z) * pc.math.RAD_TO_DEG
};
var ControllerHandler = pc.createScript("controllerHandler");
ControllerHandler.attributes.add("anim1", {
    type: "asset",
    title: "anim1"
}), ControllerHandler.attributes.add("anim2", {
    type: "asset",
    title: "anim2"
}), ControllerHandler.attributes.add("modules", {
    type: "entity",
    title: "modules"
}), ControllerHandler.attributes.add("sceneIndex", {
    type: "string",
    title: "scenes",
    array: !0
}), ControllerHandler.attributes.add("sounds", {
    type: "asset",
    title: "sounds: ",
    array: !0
}), ControllerHandler.prototype.initialize = function() {
    this.app.on("controller:register", this.onControllerRegister, this), this.app.on("controller:button", this.onButton, this), this.app.on("controller:axisY", this.onControllerAxisY, this), this.app.on("controller:axisX", this.onControllerAxisX, this), this.app.on("controller:loadScene", this.loadScene, this), this.app.on("controller:stick", this.move, this), this.app.on("controller:stickRotate", this.rotate, this), animL = null, animR = null, lTrigOnce = !0, rTrigOnce = !0, lGripOnce = !0, rGripOnce = !0, oneTimeAxL = !0, oneTimeAxR = !0, cntrlLeft = null, cntrlRight = null, configEnt = null, tConfig = null, moduleCounterL = 0, moduleCounterR = 0, entLeft = new Array([0]), entRight = new Array([0]), mcL = null, mcR = null, this.onSceneInit(), this.sceneCounter = 1, this.tMenu = !1, this.soundHolderL = null, this.soundHolderR = null, this.pSystemFloatL = null, this.pSystemFloatR = null, this.stickLeft = null, this.stickRight = null, this.stickRotLeft = null, this.stickRotRight = null, this.teleCubeL = null, this.teleCubeR = null, this.moveSndLoopL = !0, this.moveSndLoopR = !0, this.app.xr.on("end", this.endXR, this)
}, ControllerHandler.prototype.endXR = function() {
    this.app.root.findByName("burger").enabled = !0, location.reload()
}, ControllerHandler.prototype.onSceneInit = function() {
    configEnt = this.app.root.findByName("menuConfig"), tConfig = configEnt.script.menuConfigContainer.menuConf
}, ControllerHandler.prototype.onControllerRegister = function(e, t) {
    "left" == t ? (cntrlLeft = e, animL = e.children[2].animation, mcL = cntrlLeft.children[3].findByName(tConfig[0].name), this.soundHolderL = cntrlLeft.children[4], this.pSystemFloatL = cntrlLeft.children[5], this.stickLeft = cntrlLeft.children[3].findByName("move").children[3], this.stickRotLeft = cntrlLeft.children[3].findByName("rotate").children[3], this.teleCubeL = cntrlLeft.children[1].children[2]) : "right" == t && (cntrlRight = e, animR = e.children[2].animation, mcR = cntrlRight.children[3].findByName(tConfig[0].name), this.soundHolderR = cntrlRight.children[4], this.pSystemFloatR = cntrlRight.children[5], this.stickRight = cntrlRight.children[3].findByName("move").children[3], this.stickRotRight = cntrlRight.children[3].findByName("rotate").children[3], this.teleCubeR = cntrlRight.children[1].children[2])
}, ControllerHandler.prototype.loadScene = function(e) {
    this.tMenu && this.app.fire("sceneLoader:loadScene", this.sceneIndex[this.sceneCounter])
}, ControllerHandler.prototype.onButton = function(e, t, n) {
    "left" == e ? (1 == t && "down" == n && lTrigOnce && (lTrigOnce = !1, "float" == mcL.name && (this.soundHolderL.sound.play("thruster"), this.pSystemFloatL.particlesystem.reset(), this.pSystemFloatL.particlesystem.play()), "teleport" == mcL.name && (this.teleCubeL.enabled = !0)), 1 == t && "up" == n && (lTrigOnce || (this.tMenu && (this.tMenu = !0), "float" == mcL.name && (this.soundHolderL.sound.stop(), this.pSystemFloatL.particlesystem.stop()), "teleport" == mcL.name && (this.soundHolderL.sound.play("teleport"), this.teleCubeL.enabled = !0)), lTrigOnce = !0), 2 == t && "down" == n && (lGripOnce && (animL.play(this.anim2.name), this.soundHolderL.sound.play("open"), cntrlLeft.children[3].enabled = !0, cntrlLeft.children[3].children[2].enabled = !0, cntrlLeft.children[3].children[3].enabled = !1), lGripOnce = !1), 2 == t && "up" == n && (lGripOnce || (animL.play(this.anim1.name), this.soundHolderL.sound.play("close"), cntrlLeft.children[3].children[2].enabled = !1, cntrlLeft.children[3].children[3].enabled = !0, this.app.fire("controllerHandler:updateStates", "left", mcL.name)), lGripOnce = !0)) : "right" == e && (1 == t && "down" == n ? rTrigOnce && (rTrigOnce = !1, "float" == mcR.name && (this.pSystemFloatR.particlesystem.reset(), this.pSystemFloatR.particlesystem.play(), this.soundHolderR.sound.play("thruster")), "teleport" == mcR.name && (this.teleCubeR.enabled = !0)) : 1 == t && "up" == n && (rTrigOnce || (this.tMenu && (this.tMenu = !0), "float" == mcR.name && (this.soundHolderR.sound.stop(), this.pSystemFloatR.particlesystem.stop()), "teleport" == mcR.name && this.soundHolderR.sound.play("teleport")), rTrigOnce = !0), 2 == t && "down" == n && (rGripOnce && (animR.play(this.anim2.name), this.soundHolderR.sound.play("open"), cntrlRight.children[3].children[3].enabled = !1, cntrlRight.children[3].children[2].enabled = !0), rGripOnce = !1), 2 == t && "up" == n && (rGripOnce || (animR.play(this.anim1.name), this.soundHolderR.sound.play("close"), cntrlRight.children[3].children[3].enabled = !0, cntrlRight.children[3].children[2].enabled = !1, this.app.fire("controllerHandler:updateStates", "right", mcR.name)), rGripOnce = !0))
}, ControllerHandler.prototype.onControllerAxisY = function(e, t, n) {
    if (cntrlLeft) var l = cntrlLeft.children[3].findByName(tConfig[moduleCounterL].name);
    if (cntrlRight) var o = cntrlRight.children[3].findByName(tConfig[moduleCounterR].name);
    0 === t && (once = !0), 0 !== t && (once && (this.soundHolderL.sound.play("blip1"), t < -.12 && ("left" == e && (moduleCounterL += 1), "right" == e && (moduleCounterR += 1)), t > .12 && ("left" == e && (moduleCounterL -= 1), "right" == e && (moduleCounterR -= 1))), moduleCounterL < 0 ? moduleCounterL = tConfig.length - 1 : moduleCounterL > tConfig.length - 1 && (moduleCounterL = 0), moduleCounterR < 0 ? moduleCounterR = tConfig.length - 1 : moduleCounterR > tConfig.length - 1 && (moduleCounterR = 0), cntrlLeft && (mcL = cntrlLeft.children[3].findByName(tConfig[moduleCounterL].name)), cntrlRight && (mcR = cntrlRight.children[3].findByName(tConfig[moduleCounterR].name)), mcL && ("menu" == mcL.name && (cntrlLeft.script.controller.menu = !0, this.tMenu = !0), "teleport" == mcL.name ? this.teleCubeL.enabled = !0 : this.teleCubeL.enabled = !1), mcR && ("menu" == mcR.name && (cntrlRight.script.controller.menu = !0, this.tMenu = !0), "teleport" == mcR.name ? this.teleCubeR.enabled = !0 : this.teleCubeR.enabled = !1), "left" == e && (l.enabled = !1, mcL.enabled = !0), "right" == e && (o.enabled = !1, mcR.enabled = !0), once = !1)
}, ControllerHandler.prototype.onControllerAxisX = function(e, t, n) {
    var l = null;
    "left" == e ? l = cntrlLeft : "right" == e && (l = cntrlRight), this.soundHolderL.sound.play("blip2"), l.children[3].children[0].script.rollMenu && (t > .001 ? l.children[3].children[0].script.rollMenu.goLeft() : t < -.001 && l.children[3].children[0].script.rollMenu.goRight()), this.sceneCounter = l.children[3].children[0].script.rollMenu.counter
}, ControllerHandler.prototype.move = function(e, t, n) {
    this.soundHolderL && this.moveSndLoopL && (this.soundHolderL.sound.play("walk"), this.moveSndLoopL = !1), this.soundHolderR && this.moveSndLoopR && (this.soundHolderR.sound.play("walk"), this.moveSndLoopR = !1), 0 === t && (this.soundHolderL && this.soundHolderL.sound.stop(), this.soundHolderR && this.soundHolderR.sound.stop(), this.moveSndLoopL = !0, this.moveSndLoopR = !0), "left" == e ? this.stickLeft.setLocalEulerAngles(-20 * n, 0, 30 * t) : "right" == e && this.stickRight.setLocalEulerAngles(-20 * n, 0, 30 * t)
}, ControllerHandler.prototype.rotate = function(e, t, n) {
    "left" == e ? (this.stickRotLeft.setLocalEulerAngles(-20 * n, 0, 30 * t), this.soundHolderL.sound.play("teleportAlt")) : "right" == e && (this.stickRotRight.setLocalEulerAngles(-20 * n, 0, 30 * t), this.soundHolderL.sound.play("teleportAlt"))
}, ControllerHandler.prototype.update = function(e) {
    this.app.fire("debug", "xr.supported", this.app.xr.active, 1)
};
var MenuConfigContainer = pc.createScript("menuConfigContainer");
MenuConfigContainer.attributes.add("menuConf", {
    type: "entity",
    title: "config",
    array: !0
}), MenuConfigContainer.prototype.initialize = function() {
    tConf = this.menuConf
};
var ScrollingOpacity = pc.createScript("ScrollingOpacity");
ScrollingOpacity.attributes.add("materialAsset", {
    type: "asset"
}), ScrollingOpacity.attributes.add("speed", {
    type: "vec2"
}), ScrollingOpacity.tmp = new pc.Vec2, ScrollingOpacity.prototype.initialize = function() {
    this.materialAsset && (this.material = this.materialAsset.resource)
}, ScrollingOpacity.prototype.update = function(t) {
    var i = ScrollingOpacity.tmp;
    i.set(this.speed.x, this.speed.y), i.scale(t), this.material.opacityMapOffset.add(i), this.material.update()
};
var ScrollingDiffuseMap = pc.createScript("ScrollingDiffuseMap");
ScrollingDiffuseMap.attributes.add("materialAsset", {
    type: "asset"
}), ScrollingDiffuseMap.attributes.add("speed", {
    type: "vec2"
}), ScrollingDiffuseMap.tmp = new pc.Vec2, ScrollingDiffuseMap.prototype.initialize = function() {
    this.materialAsset && (this.material = this.materialAsset.resource)
}, ScrollingDiffuseMap.prototype.update = function(e) {
    var t = ScrollingDiffuseMap.tmp;
    t.set(this.speed.x, this.speed.y), t.scale(e), this.material.diffuseMapOffset.add(t), this.material.update()
};
var UiHandler = pc.createScript("uiHandler");
UiHandler.attributes.add("startButton", {
    type: "entity"
}), UiHandler.attributes.add("landScape", {
    type: "entity"
}), UiHandler.attributes.add("portrait", {
    type: "entity"
}), UiHandler.attributes.add("textCharts", {
    type: "entity",
    array: !0
}), UiHandler.attributes.add("fadeEnt", {
    type: "entity"
}), UiHandler.attributes.add("logos", {
    type: "entity"
}), UiHandler.attributes.add("vrButton", {
    type: "entity"
}), UiHandler.attributes.add("xrMessage", {
    type: "entity"
}), UiHandler.attributes.add("soundButton", {
    type: "entity"
}), UiHandler.attributes.add("syncLoop", {
    type: "entity"
}), UiHandler.attributes.add("syncObjects", {
    type: "entity"
}), UiHandler.attributes.add("uiElements", {
    type: "entity"
}), UiHandler.prototype.initialize = function() {
    that = this, this.syncLoopScript = this.syncLoop.script.soundSync, this.bPressed = !1, this.firsTime = !0, this.contentVisible = !1, this.tween = !1, this.counter = 0, this.preCounter = 0, this.currentScreen = null, this.resize = !1, this.direction = 0, this.showEnt = null, this.preEnt = null, this.callbackCounter = 0, this.soundSwitch = !0, this.oneTimeSound = !0, this.vrTweenBlock = !1;
    this.app.graphicsDevice.width, this.app.graphicsDevice.height;
    this.app.graphicsDevice.on("resizecanvas", (function(t, e) {
        var i = t / e;
        that.contentVisible && (that.resize = !0, that.hideAndShow(), that.showText(i))
    })), this.app.on("buttonPressed", this.buttonPressed, this), this.app.on("setBack", this.setBack, this), this.app.on("touch:swipedMenu", this.buttonPressed, this), this.app.on("xrMessage:out", this.xrOut, this), UiHandler.wasDragged = !1, UiHandler.firstX = 0, UiHandler.firstY = 0, UiHandler.deltaX = 0, UiHandler.deltaY = 0, UiHandler.startTime = 0, UiHandler.elapsedTime = 0, UiHandler.allowedTime = 600, UiHandler.threshold = 50, UiHandler.restraint = 100, UiHandler.mouseMoveAllowed = !1, UiHandler.touchArea = document.body, pc.platform.mobile ? (UiHandler.touchArea.addEventListener("touchstart", (function(t) {
        UiHandler.wasDragged = !1, UiHandler.firstX = t.targetTouches[0].pageX, UiHandler.firstY = t.targetTouches[0].pageY, UiHandler.startTime = (new Date).getTime()
    })), UiHandler.touchArea.addEventListener("touchmove", (function(t) {
        UiHandler.wasDragged = !0;
        var e = t.targetTouches[0].pageX;
        UiHandler.deltaX = e - UiHandler.firstX;
        var i = t.targetTouches[0].pageY;
        UiHandler.deltaY = i - UiHandler.firstY
    })), UiHandler.touchArea.addEventListener("touchend", (function(t) {
        UiHandler.prototype.detectSwipe()
    }))) : pc.platform.desktop && (UiHandler.touchArea.addEventListener("mousedown", (function(t) {
        UiHandler.mouseMoveAllowed = !0, UiHandler.wasDragged = !1, UiHandler.firstX = t.pageX, UiHandler.firstY = t.pageY, UiHandler.startTime = (new Date).getTime()
    })), UiHandler.touchArea.addEventListener("mousemove", (function(t) {
        if (UiHandler.mouseMoveAllowed) {
            UiHandler.wasDragged = !0;
            var e = t.pageX;
            UiHandler.deltaX = e - UiHandler.firstX;
            var i = t.pageY;
            UiHandler.deltaY = i - UiHandler.firstY
        }
    })), UiHandler.touchArea.addEventListener("mouseup", (function(t) {
        UiHandler.prototype.detectSwipe(), UiHandler.mouseMoveAllowed = !1
    }))), this.cameraEntity = this.app.root.findByName("VRCamera"), this.vrButton.element.on("click", (function() {
        var t = function() {
            this.uiElements.enabled = !1, console.log("vrstarter"), this.cameraEntity.camera.nearClip = .1, this.cameraEntity.camera.startXr(pc.XRTYPE_VR, pc.XRSPACE_LOCALFLOOR)
        }.bind(this);
        this.app.xr.isAvailable(pc.XRTYPE_VR) && (window.DeviceOrientationEvent && window.DeviceOrientationEvent.requestPermission ? DeviceOrientationEvent.requestPermission().then(function(e) {
            "granted" == e && window.addEventListener("deviceorientation", function(e) {
                t()
            }.bind(this))
        }.bind(this)).catch(console.error) : t())
    }), this)
}, UiHandler.prototype.xrOut = function() {
    console.log("XROUT");
    var t = this.xrMessage,
        e = t.getLocalPosition();
    t.tween(e).to({
        x: e.x,
        y: e.y - 500,
        z: e.z
    }, .25, pc.sineOut).on("complete", (function() {
        t.enabled = !1, console.log("tweened"), t.setLocalPosition(e.x, e.y + 500, e.z), that.fadeBlack("out", 0), that.vrTweenBlock = !1
    })).delay(1.5).start()
}, UiHandler.prototype.introAnim = function() {
    this.fadeBlack("out", 5);
    var t = this.app.root.findByName("button_burger"),
        e = this.app.root.findByName("numbers_l"),
        i = this.app.root.findByName("numbers_r"),
        n = e.getLocalPosition(),
        a = i.getLocalPosition(),
        s = t.getLocalPosition(),
        r = this.vrButton.getLocalPosition(),
        o = this.soundButton.getLocalPosition(),
        d = this.logos.getLocalPosition();
    this.soundButton.children[0].enabled = !1, s.y += 300, n.y -= 300, a.y -= 300, r.y += 300, o.y += 300, d.y += 300, t.tween(s).to({
        x: s.x,
        y: s.y - 300,
        z: s.z
    }, .3, pc.SineOut).delay(1.15).start(), this.logos.tween(d).to({
        x: d.x,
        y: d.y - 300,
        z: d.z
    }, .3, pc.SineOut).delay(1).start(), this.soundButton.tween(o).to({
        x: o.x,
        y: o.y - 300,
        z: o.z
    }, .3, pc.SineOut).delay(1.3).start(), this.vrButton.tween(r).to({
        x: r.x,
        y: r.y - 300,
        z: r.z
    }, .3, pc.SineOut).delay(1.45).start(), e.tween(n).to({
        x: n.x,
        y: n.y + 300,
        z: n.z
    }, .3, pc.SineOut).delay(1.15).start(), i.tween(a).to({
        x: a.x,
        y: a.y + 300,
        z: a.z
    }, .3, pc.SineOut).delay(1.3).start()
}, UiHandler.prototype.detectSwipe = function() {
    if (UiHandler.wasDragged && !that.bPressed) {
        var t = null;
        UiHandler.elapsedTime = (new Date).getTime() - UiHandler.startTime, UiHandler.elapsedTime <= UiHandler.allowedTime && (Math.abs(UiHandler.deltaX) >= UiHandler.threshold && Math.abs(UiHandler.deltaY) <= UiHandler.restraint ? t = UiHandler.deltaX < 0 ? "button_right" : "button_left" : Math.abs(UiHandler.deltaY) >= UiHandler.threshold && Math.abs(UiHandler.deltaX) <= UiHandler.restraint && (t = UiHandler.deltaY < 0 ? "button_right" : "button_left")), that.swipeTween || that.contentVisible && that.app.fire("touch:swipedMenu", t), UiHandler.firstX = 0, UiHandler.firstY = 0, UiHandler.deltaX = 0, UiHandler.deltaY = 0
    }
}, UiHandler.prototype.buttonPressed = function(t) {
    if ("start" == t) return this.startButton.enabled = !1, this.syncLoopScript.startSound(), void this.introAnim();
    if (null !== t) {
        this.resize = !1;
        var e = this.textCharts.length - 1,
            i = this.app.root.findByName("button_burger"),
            n = this.app.root.findByName("numbers_l"),
            a = this.app.root.findByName("numbers_r"),
            s = n.getLocalPosition(),
            r = a.getLocalPosition(),
            o = i.getLocalPosition(),
            d = this.vrButton.getLocalPosition(),
            l = this.soundButton.getLocalPosition(),
            h = this.logos.getLocalPosition();
        if (this.bPressed = !1, !this.tween) {
            if ("button_sound" == t) return this.oneTimeSound && (this.syncLoopScript.loadSounds(), this.oneTimeSound = !1), this.syncLoopScript.startSound(), void(this.soundSwitch ? (this.syncObjects.enabled = !0, this.soundButton.children[0].enabled = !0, this.soundSwitch = !1) : (this.app.fire("stopSounds"), this.syncObjects.enabled = !1, this.soundButton.children[0].enabled = !1, this.soundSwitch = !0));
            if ("button_VR" == t) {
                if (!this.vrTweenBlock && !this.app.xr.isAvailable(pc.XRTYPE_VR)) {
                    this.vrTweenBlock = !0;
                    var c = this.xrMessage;
                    c.enabled = !0, this.fadeBlack("in", 0);
                    var u = c.getLocalPosition();
                    c.setLocalPosition(u.x, u.y - 300, u.z), c.tween(c.getLocalPosition()).to({
                        x: u.x,
                        y: u.y + 300,
                        z: u.z
                    }, .25, pc.SineOut).on("complete", (function() {
                        that.app.fire("xrMessage:out")
                    })).start()
                }
                return
            }
            if ("button_burger" == t) {
                this.contentVisible = !0, this.bPressed = !0, this.firsTime && (this.counter = 0, this.preCounter = e, this.firsTime = !1);
                var p = this.app.graphicsDevice.width / this.app.graphicsDevice.height;
                i.tween(o).to({
                    x: o.x,
                    y: o.y + 300,
                    z: o.z
                }, .3, pc.SineOut).on("complete", (function() {
                    that.bPressed = !1
                })).delay(.15).start(), this.logos.tween(h).to({
                    x: h.x,
                    y: h.y + 300,
                    z: h.z
                }, .3, pc.SineOut).on("complete", (function() {
                    that.bPressed = !1
                })).start(), this.soundButton.tween(l).to({
                    x: l.x,
                    y: l.y + 300,
                    z: l.z
                }, .3, pc.SineOut).on("complete", (function() {
                    that.bPressed = !1
                })).delay(.3).start(), this.vrButton.tween(d).to({
                    x: d.x,
                    y: d.y + 300,
                    z: d.z
                }, .3, pc.SineOut).on("complete", (function() {
                    that.bPressed = !1
                })).delay(.45).start(), a.tween(r).to({
                    x: r.x,
                    y: r.y - 300,
                    z: r.z
                }, .3, pc.SineOut).on("complete", (function() {
                    that.bPressed = !1
                })).delay(.15).start(), n.tween(s).to({
                    x: s.x,
                    y: s.y - 300,
                    z: s.z
                }, .3, pc.SineOut).on("complete", (function() {
                    that.bPressed = !1
                })).delay(.3).start(), this.fadeBlack("in", 0), this.showText(p)
            }
            "button_x" == t ? (this.contentVisible = !1, this.bPressed = !0, i.tween(o).to({
                x: o.x,
                y: o.y - 300,
                z: o.z
            }, .3, pc.SineOut).delay(.15).start(), this.logos.tween(h).to({
                x: h.x,
                y: h.y - 300,
                z: h.z
            }, .3, pc.SineOut).start(), this.soundButton.tween(l).to({
                x: l.x,
                y: l.y - 300,
                z: l.z
            }, .3, pc.SineOut).delay(.3).start(), this.vrButton.tween(d).to({
                x: d.x,
                y: d.y - 300,
                z: d.z
            }, .3, pc.SineOut).delay(.45).start(), n.tween(s).to({
                x: s.x,
                y: s.y + 300,
                z: s.z
            }, .3, pc.SineOut).delay(.15).start(), a.tween(r).to({
                x: r.x,
                y: r.y + 300,
                z: r.z
            }, .3, pc.SineOut).delay(.3).start(), this.fadeBlack("out", 0), this.landScape.enabled = !1, this.portrait.enabled = !1) : "button_left" == t ? (this.bPressed = !1, this.direction = -1, this.preCounter = this.counter, this.counter -= 1) : "button_right" == t && (this.bPressed = !1, this.direction = 1, this.preCounter = this.counter, this.counter += 1), this.counter > e ? this.counter = 0 : this.counter < 0 && (this.counter = e), this.bPressed || this.hideAndShow()
        }
    }
}, UiHandler.prototype.fadeBlack = function(t, e) {
    var i = 0,
        n = 0;
    "in" == t ? (i = 0, n = .75) : "out" == t && (i = .75, n = 0);
    var a = {
            opacity: i
        },
        s = this.fadeEnt.model.material;
    this.app.tween(a).to({
        opacity: n
    }, .3, pc.Linear).on("update", (function() {
        s.opacity = a.opacity, s.update()
    })).delay(e).start()
}, UiHandler.prototype.hideAndShow = function() {
    for (var t = 0; t < this.textCharts.length; t++) {
        this.currentScreen.findByName(this.textCharts[t].name);
        this.currentScreen.children[t].enabled = !1
    }
    this.showEnt = this.currentScreen.findByName(this.textCharts[this.counter].name), this.preEnt = this.currentScreen.findByName(this.textCharts[this.preCounter].name), this.showEnt.enabled = !0, this.resize || (this.preEnt.enabled = !0, this.setTween(this.showEnt, this.preEnt))
}, UiHandler.prototype.setTween = function(t, e) {
    console.log(e.name), this.tween = !0;
    for (var i = this.app.graphicsDevice.width, n = 0; n < t.children.length; n++) {
        var a = t.children[n],
            s = a.getLocalPosition(),
            r = new pc.Vec3(s.x, s.y, s.z);
        a.setLocalPosition(r.x + i * this.direction, r.y, r.z), a.tween(a.getLocalPosition()).to({
            x: r.x,
            y: r.y,
            z: r.z
        }, .5 + .15 * n, pc.QuinticInOut).on("complete", (function() {})).start()
    }
    for (var o = 0; o < e.children.length; o++) {
        var d = e.children[o],
            l = d.getLocalPosition(),
            h = new pc.Vec3(l.x, l.y, l.z);
        d.tween(d.getLocalPosition()).to({
            x: h.x - i * this.direction,
            y: h.y,
            z: h.z
        }, .5 + .15 * o, pc.QuinticInOut).on("complete", (function() {
            that.app.fire("setBack", e)
        })).start()
    }
}, UiHandler.prototype.setBack = function(t) {
    this.callbackCounter += 1, this.callbackCounter == t.children.length && (this.tween = !1, this.callbackCounter = 0), t.script.resetChildren.resetNodes(this.direction)
}, UiHandler.prototype.showText = function(t) {
    var e = this.landScape,
        i = this.portrait;
    t > .85 ? (e.enabled = !0, i.enabled = !1, this.currentScreen = e) : (e.enabled = !1, i.enabled = !0, this.currentScreen = i)
}, UiHandler.prototype.update = function(t) {};
var ResetChildren = pc.createScript("resetChildren");
ResetChildren.prototype.initialize = function() {
    for (this.positionArray = new Array(0), i = 0; i < this.entity.children.length; i++) {
        var t = this.entity.children[i].getLocalPosition(),
            e = new pc.Vec3(t.x, t.y, t.z);
        this.positionArray.push(e)
    }
}, ResetChildren.prototype.resetNodes = function(i) {
    this.entity.enabled = !1;
    for (var t = 0; t < this.entity.children.length; t++) {
        var e = this.positionArray[t];
        this.entity.children[t].setLocalPosition(e.x, e.y, e.z)
    }
};
var TouchFix = pc.createScript("touchFix");
TouchFix.prototype.initialize = function() {
    var t = this.app.touch;
    t && t.on(pc.EVENT_TOUCHEND, (function(t) {
        t.event.preventDefault()
    }))
};
var ButtonEvent = pc.createScript("buttonEvent");
ButtonEvent.attributes.add("hoverAble", {
    type: "boolean",
    title: "hoverAble?:"
}), ButtonEvent.attributes.add("link", {
    type: "boolean",
    title: "link?"
}), ButtonEvent.attributes.add("linkAdress", {
    type: "string",
    title: "URL"
}), ButtonEvent.prototype.initialize = function() {
    this.touch = this.app.touch, this.entity.button.on("hoverstart", this.hoverS, this), this.entity.button.on("hoverend", this.hoverE, this), this.entity.element.on("mousedown", this.onPress, this), this.entity.element.on("touchstart", this.onTouch, this)
}, ButtonEvent.prototype.onTouch = function() {
    this.link ? window.open(window.location.href = this.linkAdress, window.location.target = "_blank") : this.app.fire("buttonPressed", this.entity.name)
}, ButtonEvent.prototype.onPress = function() {
    this.link ? window.open(window.location.href = this.linkAdress, window.location.target = "_blank") : this.app.fire("buttonPressed", this.entity.name)
}, ButtonEvent.prototype.hoverS = function() {
    this.hoverAble && (this.entity.children[0].enabled = !0)
}, ButtonEvent.prototype.hoverE = function() {
    this.hoverAble && (this.entity.children[0].enabled = !1)
}, ButtonEvent.prototype.update = function(t) {};
var AnimateSprite = pc.createScript("animateSprite");
AnimateSprite.attributes.add("startFrame", {
    type: "number",
    default: 0,
    description: "Frame to start animation from"
}), AnimateSprite.attributes.add("numFrames", {
    type: "number",
    default: 1,
    description: "Number of frames to play before looping"
}), AnimateSprite.attributes.add("frameRate", {
    type: "number",
    default: 1,
    description: "Playback frames per second"
}), AnimateSprite.prototype.initialize = function() {
    this.timer = 1 / this.frameRate, this.frame = this.startFrame
}, AnimateSprite.prototype.update = function(t) {
    this.timer -= t, this.timer < 0 && (this.frame++, this.frame >= this.numFrames + this.startFrame && (this.frame = this.startFrame), this.entity.element.spriteFrame = this.frame, this.timer = 1 / this.frameRate)
};
var SoundSync = pc.createScript("soundSync");
SoundSync.attributes.add("materialAr", {
    type: "entity",
    array: !0
}), SoundSync.prototype.initialize = function() {
    this.bufferLoadSounds = new Array(0), this.roomTextureLoops = new Array(0), this.loopCounter = 0, this.switcher = !0, this.channels = new Array(4), this.theLoop = "loop", this.allSoundsLoaded = !1, this.allSoundTexturesLoaded = !1, this.channelTargeting = new Array(this.materialAr.length), this.meshes = this.entity.model.meshInstances, this.timer = 0, this.music = this.entity.sound, this.mSlot = this.music.slots[0], this.animation = this.entity.animation, this.app.mouse.on(pc.EVENT_MOUSEDOWN, this.onMouseDown, this), this.music.on("end", this.onSoundEnd, this), this.setChannelTargets(), this.app.on("soundsLoaded", this.soundsLoaded, this), this.app.on("soundTexturesLoaded", this.soundTexturesLoaded, this)
}, SoundSync.prototype.soundsLoaded = function() {
    this.allSoundsLoaded = !0, this.loadTextureLoops()
}, SoundSync.prototype.soundTexturesLoaded = function() {
    this.allSoundTexturesLoaded = !0
}, SoundSync.prototype.loadSounds = function() {
    var t = 0;
    this.bufferLoadSounds = this.app.assets.findByTag("bufferLoops");
    for (var o = 0; o < this.bufferLoadSounds.length; o++) {
        var s = this.bufferLoadSounds[o],
            e = this.bufferLoadSounds.length;
        this.app.assets.load(s), this.music.addSlot(s.name, {
            loop: !1,
            autoPlay: !1,
            asset: s
        }), s.ready((function(o) {
            (t += 1) == e && that.app.fire("soundsLoaded")
        }))
    }
}, SoundSync.prototype.loadTextureLoops = function() {
    var t = 0;
    this.roomTextureLoops = this.app.assets.findByTag("roomTextureLoops");
    for (var o = 0; o < this.roomTextureLoops.length; o++) {
        var s = this.roomTextureLoops[o],
            e = this.roomTextureLoops.length;
        this.app.assets.load(s), s.ready((function(o) {
            (t += 1) == e && that.app.fire("soundTexturesLoaded")
        }))
    }
}, SoundSync.prototype.setChannelTargets = function() {
    2 == this.loopCounter && (this.loopCounter = 0, this.allSoundsLoaded && (this.theLoop = this.bufferLoadSounds[Math.floor(Math.random() * this.bufferLoadSounds.length)].name));
    for (var t = 0; t < this.materialAr.length; t++) this.channelTargeting[t] = Math.floor(4 * Math.random());
    this.loopCounter += 1
}, SoundSync.prototype.onSoundEnd = function() {}, SoundSync.prototype.startSound = function() {
    this.switcher ? (this.animation.enabled = !0, this.music.play(this.theLoop), this.animation.play("Take 001.glb"), this.switcher = !1) : (this.animation.enabled = !1, this.music.stop(), this.switcher = !0)
}, SoundSync.prototype.update = function(t) {
    this.channels[0] = this.meshes[0].node.getLocalScale().z, this.channels[1] = this.meshes[1].node.getLocalScale().z, this.channels[2] = this.meshes[2].node.getLocalScale().z, this.channels[3] = this.meshes[3].node.getLocalScale().z;
    for (var o = 0; o < this.materialAr.length; o++) this.materialAr[o].model.meshInstances[0].material.emissiveIntensity = this.channels[this.channelTargeting[o]], this.materialAr[o].model.meshInstances[0].material.update()
};
var ResetScene = pc.createScript("ResetScene");
ResetScene.attributes.add("sceneName", {
    type: "string",
    default: "",
    title: "Scene Name to Load"
}), ResetScene.prototype.initialize = function(e) {}, ResetScene.prototype.onXREnd = function() {
    this.loadScene(this.sceneName)
}, ResetScene.prototype.loadScene = function(e) {
    var t = this.app.root.findByName("RootMain"),
        n = this.app.scenes.find(e);
    this.app.scenes.loadSceneHierarchy(n.url, (function(e, n) {
        e ? console.error(e) : t.destroy()
    }))
};
pc.script.createLoadingScreen((function(e) {
    var t, a;
    t = ["body {", "    background-color: #000000;", "}", "#application-splash-wrapper {", "    position: absolute;", "    top: 0;", "    left: 0;", "    height: 100%;", "    width: 100%;", "    background-color: #000000;", "}", "#application-splash {", "    position: absolute;", "    top: calc(50% - 146px);", "    width: 264px;", "    left: calc(50% - 135px);", "}", "#application-splash img {", "    width: 100%;", "}", "#progress-bar-container {", "    margin: 20px auto 0 auto;", "    height: 10px;", "    width: 85%;", "    background-color: #222222;", "}", "#progress-bar {", "    width: 0%;", "    height: 100%;", "    background-color: #FFFFFF;", "}", "@media (max-width: 480px) {", "    #application-splash {", "        width: 170px;", "        left: calc(50% - 85px);", "    }", "}"].join("\n"), (a = document.createElement("style")).type = "text/css", a.styleSheet ? a.styleSheet.cssText = t : a.appendChild(document.createTextNode(t)), document.head.appendChild(a),
        function() {
            var e = document.createElement("div");
            e.id = "application-splash-wrapper", document.body.appendChild(e);
            var t = document.createElement("div");
            t.id = "application-splash", e.appendChild(t), t.style.display = "none";
            var a = document.createElement("img");
            a.src = "preloader.gif", t.appendChild(a), a.onload = function() {
                t.style.display = "block"
            };
            var o = document.createElement("div");
            o.id = "progress-bar-container", t.appendChild(o);
            var p = document.createElement("div");
            p.id = "progress-bar", o.appendChild(p)
        }(), e.on("preload:end", (function() {
            e.off("preload:progress")
        })), e.on("preload:progress", (function(e) {
            var t = document.getElementById("progress-bar");
            t && (e = Math.min(1, Math.max(0, e)), t.style.width = 100 * e + "%")
        })), e.on("start", (function() {
            var e = document.getElementById("application-splash-wrapper");
            e.parentElement.removeChild(e)
        }))
}));
var SimpleController = pc.createScript("simpleController");
SimpleController.prototype.initialize = function() {
    this.vecA = new pc.Vec3, this.vecB = new pc.Vec3, this.matA = new pc.Mat4, this.quat = new pc.Quat, this.color = new pc.Color(1, 1, 1), this.modelEntity = this.entity.findByName("model"), this.hoverEntity = null, this.targetPointerSize = 2, this.targetTeleportable = !1, this.pointerDistance = 3, this.moving = !0, this.rotating = !0, this.dir = 0, this.menu = !1, axLYonce = !0, axRYonce = !0, axLXonce = !0, axRXonce = !0, axMoveOnceL = !0, axMoveOnceR = !0, axRotOnceL = !0, axRotOnceR = !0, stateLeft = null, stateRight = null, this.app.on("controllerHandler:updateStates", this.updateStates, this)
}, SimpleController.prototype.setInputSource = function(t) {
    this.inputSource = t, this.inputSource.once("remove", this.onRemove, this), this.on("hover", this.onHover, this), this.on("blur", this.onBlur, this), this.inputSource.on("select", this.onSelect, this)
}, SimpleController.prototype.onSelect = function() {
    if (this.app.fire("object:pick", this), this.hoverEntity)
        if (this.targetTeleportable)("teleport" == stateLeft || "teleport" == stateRight) && this.app.fire("controller:teleport", this.hoverPoint);
        else if (this.hoverEntity.tags.has("interactive")) {
        var t = this.hoverEntity.model.meshInstances[0];
        t.pickedColor || (t.pickedColor = new pc.Color), t.pickedColor.set(Math.random(), Math.random(), Math.random()), t.setParameter("material_diffuse", t.pickedColor.data3)
    }
}, SimpleController.prototype.onHover = function(t, e) {}, SimpleController.prototype.onBlur = function() {
    this.hoverEntity = null, this.targetPointerSize = 4, this.targetTeleportable = !1
}, SimpleController.prototype.updateStates = function(t, e) {
    "left" == t ? stateLeft = e : "right" == t && (stateRight = e)
}, SimpleController.prototype.update = function(t) {
    var e = this.inputSource.gamepad;
    e && (this.inputSource.handedness === pc.XRHAND_LEFT && (e.axes[3] || e.axes[2]) && this.rotating && "rotate" == stateLeft && (this.app.fire("controller:rotate", -e.axes[2], t), this.app.fire("controller:stickRotate", "left", e.axes[2], e.axes[3]), axRotOnceL = !0), this.inputSource.handedness === pc.XRHAND_RIGHT && (e.axes[3] || e.axes[2]) && this.rotating && "rotate" == stateRight && (this.app.fire("controller:rotate", -e.axes[2], t), this.app.fire("controller:stickRotate", "right", e.axes[2], e.axes[3]), axRotOnceR = !0), this.inputSource.handedness !== pc.XRHAND_LEFT || e.axes[3] && e.axes[2] || axRotOnceL && (axRotOnceL = !1, this.app.fire("controller:stickRotate", "left", 0, 0)), this.inputSource.handedness !== pc.XRHAND_RIGHT || e.axes[3] && e.axes[2] || axRotOnceR && (axRotOnceR = !1, this.app.fire("controller:stickRotate", "right", 0, 0)))
};
var ButtonLinks = pc.createScript("buttonLinks");
ButtonLinks.attributes.add("theLink", {
    type: "string",
    title: "link"
}), ButtonLinks.prototype.initialize = function() {
    this.entity.element.on("mousedown", this.onPress, this), this.entity.element.on("touchstart", this.onTouch, this)
}, ButtonLinks.prototype.onTouch = function() {
    window.open(window.location.href = this.theLink, window.location.target = "_blank")
}, ButtonLinks.prototype.onPress = function() {
    window.open(this.theLink)
}, ButtonLinks.prototype.update = function(t) {};
var SegmentSound = pc.createScript("segmentSound");
SegmentSound.attributes.add("syncEnt", {
    type: "entity",
    title: "syncEnt"
}), SegmentSound.attributes.add("allSounds", {
    type: "asset",
    array: !0
}), SegmentSound.prototype.initialize = function() {
    this.loopCnt = 1, this.rnd = 1, this.app.on("reTrigger", this.reTrigger, this), this.app.on("stopSounds", this.stopSounds, this)
}, SegmentSound.prototype.reTrigger = function() {
    4 == this.loopCnt ? (this.rnd = Math.floor(Math.random() * this.allSounds.length), this.loopCnt = 1) : this.loopCnt < 4 && (this.loopCnt += 1), this.entity.sound.removeSlot("beep"), this.entity.sound.addSlot("beep", {
        loop: !0,
        asset: this.allSounds[this.rnd]
    }), console.log("loopcount: " + this.loopCnt), this.entity.sound.play("beep")
}, SegmentSound.prototype.stopSounds = function() {
    this.entity.sound.stop("beep")
};
var Xr = pc.createScript("xr");
Xr.attributes.add("buttonVr", {
    type: "entity"
}), Xr.attributes.add("buttonAr", {
    type: "entity"
}), Xr.attributes.add("cameraEntity", {
    type: "entity"
}), Xr.prototype.initialize = function() {
    this.buttonVr.button.active = this.app.xr.supported && this.app.xr.isAvailable(pc.XRTYPE_VR), this.buttonAr.button.active = this.app.xr.supported && this.app.xr.isAvailable(pc.XRTYPE_AR), this.clearColor = this.cameraEntity.camera.clearColor.clone(), this.clearColorAR = new pc.Color(0, 0, 0, 0), this.buttonVr.element.on("click", (function() {
        var t = function() {
            this.cameraEntity.camera.startXr(pc.XRTYPE_VR, pc.XRSPACE_LOCALFLOOR)
        }.bind(this);
        this.app.xr.isAvailable(pc.XRTYPE_VR) && (window.DeviceOrientationEvent && window.DeviceOrientationEvent.requestPermission ? DeviceOrientationEvent.requestPermission().then(function(i) {
            "granted" == i && window.addEventListener("deviceorientation", function(i) {
                t()
            }.bind(this))
        }.bind(this)).catch(console.error) : t())
    }), this), this.buttonAr.element.on("click", (function() {
        this.app.xr.isAvailable(pc.XRTYPE_AR) && this.cameraEntity.camera.startXr(pc.XRTYPE_AR, pc.XRSPACE_LOCALFLOOR)
    }), this), this.app.keyboard.on("keydown", (function(t) {
        t.key === pc.KEY_ESCAPE && this.app.xr.end()
    }), this), this.app.xr.on("start", (function() {
        this.buttonVr.enabled = !1, this.buttonAr.enabled = !1, this.app.xr.type === pc.XRTYPE_AR && (this.cameraEntity.camera.clearColor = this.clearColorAR, this.app.scene.root.findByTag("nonAr").forEach((function(t) {
            t.model.enabled = !1
        })))
    }), this), this.app.xr.on("end", (function() {
        this.buttonVr.enabled = !0, this.buttonAr.enabled = !0, this.cameraEntity.camera.clearColor = this.clearColor, this.app.scene.root.findByTag("nonAr").forEach((function(t) {
            t.model.enabled = !0
        }))
    }), this), this.app.xr.on("available", (function() {
        this.buttonVr.button.active = this.app.xr.supported && this.app.xr.isAvailable(pc.XRTYPE_VR), this.buttonAr.button.active = this.app.xr.supported && this.app.xr.isAvailable(pc.XRTYPE_AR)
    }), this)
};
var SubscribeSync = pc.createScript("subscribeSync");
SubscribeSync.prototype.initialize = function() {
    this.anim = this.entity.animation, this.app.on("reTrigger", this.retrig, this)
}, SubscribeSync.prototype.retrig = function() {
    this.anim.play("Take 001.glb")
}, SubscribeSync.prototype.update = function(i) {};
var SyncObjectCycle = pc.createScript("syncObjectCycle");
SyncObjectCycle.prototype.initialize = function() {
    this.app.on("reTrigger", this.synCycle, this), this.objects = new Array(0), this.objects = this.entity.findByTag("syncObj")
}, SyncObjectCycle.prototype.synCycle = function() {
    for (var t = 0; t < this.objects.length; t++) this.objects[t].enabled = !1;
    var e = Math.floor(Math.random() * this.objects.length);
    this.objects[e].enabled = !0
}, SyncObjectCycle.prototype.update = function(t) {};
pc.extend(pc, function() {
    function computeGaussian(e, t) {
        return 1 / Math.sqrt(2 * Math.PI * t) * Math.exp(-e * e / (2 * t * t))
    }

    function calculateBlurValues(e, t, s, o, r) {
        e[0] = computeGaussian(0, r), t[0] = 0, t[1] = 0;
        var i, a, l = e[0];
        for (i = 0, a = Math.floor(7.5); i < a; i++) {
            var u = computeGaussian(i + 1, r);
            e[2 * i] = u, e[2 * i + 1] = u, l += 2 * u;
            var h = 2 * i + 1.5;
            t[4 * i] = s * h, t[4 * i + 1] = o * h, t[4 * i + 2] = -s * h, t[4 * i + 3] = -o * h
        }
        for (i = 0, a = e.length; i < a; i++) e[i] /= l
    }
    var BloomEffect = function(e) {
        var t = {
                aPosition: pc.SEMANTIC_POSITION
            },
            s = ["attribute vec2 aPosition;", "", "varying vec2 vUv0;", "", "void main(void)", "{", "    gl_Position = vec4(aPosition, 0.0, 1.0);", "    vUv0 = (aPosition + 1.0) * 0.5;", "}"].join("\n"),
            o = ["precision " + e.precision + " float;", "", "varying vec2 vUv0;", "", "uniform sampler2D uBaseTexture;", "uniform float uBloomThreshold;", "", "void main(void)", "{", "    vec4 color = texture2D(uBaseTexture, vUv0);", "", "    gl_FragColor = clamp((color - uBloomThreshold) / (1.0 - uBloomThreshold), 0.0, 1.0);", "}"].join("\n"),
            r = ["precision " + e.precision + " float;", "", "#define SAMPLE_COUNT 15", "", "varying vec2 vUv0;", "", "uniform sampler2D uBloomTexture;", "uniform vec2 uBlurOffsets[SAMPLE_COUNT];", "uniform float uBlurWeights[SAMPLE_COUNT];", "", "void main(void)", "{", "    vec4 color = vec4(0.0);", "    for (int i = 0; i < SAMPLE_COUNT; i++)", "    {", "        color += texture2D(uBloomTexture, vUv0 + uBlurOffsets[i]) * uBlurWeights[i];", "    }", "", "    gl_FragColor = color;", "}"].join("\n"),
            i = ["precision " + e.precision + " float;", "", "varying vec2 vUv0;", "", "uniform float uBloomEffectIntensity;", "uniform sampler2D uBaseTexture;", "uniform sampler2D uBloomTexture;", "", "void main(void)", "{", "    vec4 bloom = texture2D(uBloomTexture, vUv0) * uBloomEffectIntensity;", "    vec4 base = texture2D(uBaseTexture, vUv0);", "", "    base *= (1.0 - clamp(bloom, 0.0, 1.0));", "", "    gl_FragColor = base + bloom;", "}"].join("\n");
        this.extractShader = new pc.Shader(e, {
            attributes: t,
            vshader: s,
            fshader: o
        }), this.blurShader = new pc.Shader(e, {
            attributes: t,
            vshader: s,
            fshader: r
        }), this.combineShader = new pc.Shader(e, {
            attributes: t,
            vshader: s,
            fshader: i
        });
        var a = e.width,
            l = e.height;
        this.targets = [];
        for (var u = 0; u < 2; u++) {
            var h = new pc.Texture(e, {
                format: pc.PIXELFORMAT_R8_G8_B8_A8,
                width: a >> 1,
                height: l >> 1
            });
            h.minFilter = pc.FILTER_LINEAR, h.magFilter = pc.FILTER_LINEAR, h.addressU = pc.ADDRESS_CLAMP_TO_EDGE, h.addressV = pc.ADDRESS_CLAMP_TO_EDGE;
            var n = new pc.RenderTarget(e, h, {
                depth: !1
            });
            this.targets.push(n)
        }
        this.bloomThreshold = .25, this.blurAmount = 4, this.bloomIntensity = 1.25, this.sampleWeights = new Float32Array(15), this.sampleOffsets = new Float32Array(30)
    };
    return (BloomEffect = pc.inherits(BloomEffect, pc.PostEffect)).prototype = pc.extend(BloomEffect.prototype, {
        render: function(e, t, s) {
            var o = this.device,
                r = o.scope;
            r.resolve("uBloomThreshold").setValue(this.bloomThreshold), r.resolve("uBaseTexture").setValue(e.colorBuffer), pc.drawFullscreenQuad(o, this.targets[0], this.vertexBuffer, this.extractShader), calculateBlurValues(this.sampleWeights, this.sampleOffsets, 1 / this.targets[1].width, 0, this.blurAmount), r.resolve("uBlurWeights[0]").setValue(this.sampleWeights), r.resolve("uBlurOffsets[0]").setValue(this.sampleOffsets), r.resolve("uBloomTexture").setValue(this.targets[0].colorBuffer), pc.drawFullscreenQuad(o, this.targets[1], this.vertexBuffer, this.blurShader), calculateBlurValues(this.sampleWeights, this.sampleOffsets, 0, 1 / this.targets[0].height, this.blurAmount), r.resolve("uBlurWeights[0]").setValue(this.sampleWeights), r.resolve("uBlurOffsets[0]").setValue(this.sampleOffsets), r.resolve("uBloomTexture").setValue(this.targets[1].colorBuffer), pc.drawFullscreenQuad(o, this.targets[0], this.vertexBuffer, this.blurShader), r.resolve("uBloomEffectIntensity").setValue(this.bloomIntensity), r.resolve("uBloomTexture").setValue(this.targets[0].colorBuffer), r.resolve("uBaseTexture").setValue(e.colorBuffer), pc.drawFullscreenQuad(o, t, this.vertexBuffer, this.combineShader, s)
        }
    }), {
        BloomEffect: BloomEffect
    }
}());
var Bloom = pc.createScript("bloom");
Bloom.attributes.add("bloomIntensity", {
    type: "number",
    default: 1,
    min: 0,
    title: "Intensity"
}), Bloom.attributes.add("bloomThreshold", {
    type: "number",
    default: .25,
    min: 0,
    max: 1,
    precision: 2,
    title: "Threshold"
}), Bloom.attributes.add("blurAmount", {
    type: "number",
    default: 4,
    min: 1,
    title: "Blur amount"
}), Bloom.prototype.initialize = function() {
    this.effect = new pc.BloomEffect(this.app.graphicsDevice), this.effect.bloomThreshold = this.bloomThreshold, this.effect.blurAmount = this.blurAmount, this.effect.bloomIntensity = this.bloomIntensity;
    var e = this.entity.camera.postEffects;
    e.addEffect(this.effect), this.on("attr", (function(e, t) {
        this.effect[e] = t
    }), this), this.on("state", (function(t) {
        t ? e.addEffect(this.effect) : e.removeEffect(this.effect)
    })), this.on("destroy", (function() {
        e.removeEffect(this.effect)
    }))
};
var Rotator = pc.createScript("rotator");
Rotator.prototype.initialize = function() {}, Rotator.prototype.update = function(t) {
    this.entity.rotate(0, .5, 0)
};
var Credits = pc.createScript("credits");
Credits.attributes.add("html", {
    type: "asset",
    assetType: "html"
}), Credits.attributes.add("css", {
    type: "asset",
    assetType: "css"
}), Credits.prototype.initialize = function() {
    var t = this.app,
        e = this.html.resource,
        s = document.createElement("div");
    s.classList.add("container"), s.innerHTML = e, document.body.appendChild(s);
    var d = pc.createStyle(this.css.resource);
    document.head.appendChild(d);
    var n = document.getElementById("mute-button");
    n.addEventListener("click", (function() {
        t.systems.sound.volume > 0 ? (t.systems.sound.volume = 0, n.textContent = "Unmute") : (t.systems.sound.volume = 1, n.textContent = "Mute")
    }), this)
};
var Analyser = pc.createScript("analyser");
Analyser.attributes.add("fftsize", {
    type: "number"
}), Analyser.prototype.initialize = function() {
    var t = this.app.systems.sound.context;
    this.analyser = t.createAnalyser(), this.analyser.smoothingTimeConstant = .6, this.analyser.fftSize = this.fftsize, this.freqData = new Float32Array(this.fftsize / 2), this.timeData = new Float32Array(this.fftsize / 2), this.entity.sound.slot("loop").setExternalNodes(this.analyser)
}, Analyser.prototype.update = function(t) {
    this.analyser.getFloatFrequencyData(this.freqData), this.analyser.getFloatTimeDomainData(this.timeData)
};
var Visualizer = pc.createScript("visualizer");
Visualizer.attributes.add("freqcolor", {
    type: "rgba"
}), Visualizer.attributes.add("timecolor", {
    type: "rgba"
}), Visualizer.attributes.add("heightScale", {
    type: "number",
    default: 1
}), Visualizer.prototype.initialize = function() {
    this.analyser = this.app.root.findByName("syncLoop"), this.lines = [];
    for (var i = this.analyser.script.analyser.fftsize, t = 0; t < i; t++) this.lines.push(new pc.Vec3);
    this.yScale = 1, this.xScale = 204.8 / i, this.minDb = this.analyser.script.analyser.analyser.minDecibels, this.maxDb = this.analyser.script.analyser.analyser.maxDecibels, this.freqScale = 1 / (this.maxDb - this.minDb), this.freqOffset = this.minDb
}, Visualizer.prototype.update = function(i) {
    this.freqScale = 1 / (this.maxDb - this.minDb), this.freqOffset = this.minDb;
    var t = this.analyser.script.analyser.freqData[0] / 100,
        e = this.entity.getLocalScale().x + t;
    this.entity.setLocalScale(e, e, e)
}, Visualizer.prototype.renderData = function(i, t, e, a) {};
var GetFft = pc.createScript("getFft");
GetFft.attributes.add("channel", {
    type: "number"
}), GetFft.attributes.add("scalator", {
    type: "number"
}), GetFft.prototype.initialize = function() {
    vis = this.app.root.findByName("visualizer"), this.scaler = 0, this.startScale = this.entity.getLocalScale().x, this.uniform = 0
}, GetFft.prototype.update = function(t) {
    this.scaler = vis.script.visualizer.analyser.script.analyser.freqData[this.channel] / this.scalator, this.uniform = this.startScale + this.scaler, this.entity.setLocalScale(this.uniform, this.uniform, this.uniform)
};
var VisualizerOpacity = pc.createScript("visualizerOpacity");
VisualizerOpacity.attributes.add("analyser", {
    type: "entity"
}), VisualizerOpacity.attributes.add("freqcolor", {
    type: "rgba"
}), VisualizerOpacity.attributes.add("timecolor", {
    type: "rgba"
}), VisualizerOpacity.attributes.add("heightScale", {
    type: "number",
    default: 1
}), VisualizerOpacity.prototype.initialize = function() {
    console.info(this.analyser.script.analyser.maxDecibels), this.lines = [];
    for (var i = this.analyser.script.analyser.fftsize, t = 0; t < i; t++) this.lines.push(new pc.Vec3);
    this.yScale = 1, this.xScale = 204.8 / i, console.info(this.analyser), this.minDb = this.analyser.script.analyser.minDecibels, this.maxDb = this.analyser.script.analyser.maxDecibels, this.freqScale = 1 / (this.maxDb - this.minDb), this.freqOffset = this.minDb, this.opacMat = this.entity.model.model.meshInstances[0].material
}, VisualizerOpacity.prototype.update = function(i) {
    this.freqScale = 1 / (this.maxDb - this.minDb), this.freqOffset = this.minDb;
    var t = this.analyser.script.analyser.freqData[0] / -100;
    this.entity.getLocalScale().x;
    this.opacMat.opacity = t, this.opacMat.update(), console.log("dings: " + this.opacMat.opacity)
}, VisualizerOpacity.prototype.renderData = function(i, t, a, e) {};
pc.extend(pc, function() {
        var TweenManager = function(t) {
            this._app = t, this._tweens = [], this._add = []
        };
        TweenManager.prototype = {
            add: function(t) {
                return this._add.push(t), t
            },
            update: function(t) {
                for (var i = 0, e = this._tweens.length; i < e;) this._tweens[i].update(t) ? i++ : (this._tweens.splice(i, 1), e--);
                if (this._add.length) {
                    for (let t = 0; t < this._add.length; t++) this._tweens.indexOf(this._add[t]) > -1 || this._tweens.push(this._add[t]);
                    this._add.length = 0
                }
            }
        };
        var Tween = function(t, i, e) {
                pc.events.attach(this), this.manager = i, e && (this.entity = null), this.time = 0, this.complete = !1, this.playing = !1, this.stopped = !0, this.pending = !1, this.target = t, this.duration = 0, this._currentDelay = 0, this.timeScale = 1, this._reverse = !1, this._delay = 0, this._yoyo = !1, this._count = 0, this._numRepeats = 0, this._repeatDelay = 0, this._from = !1, this._slerp = !1, this._fromQuat = new pc.Quat, this._toQuat = new pc.Quat, this._quat = new pc.Quat, this.easing = pc.Linear, this._sv = {}, this._ev = {}
            },
            _parseProperties = function(t) {
                var i;
                return t instanceof pc.Vec2 ? i = {
                    x: t.x,
                    y: t.y
                } : t instanceof pc.Vec3 ? i = {
                    x: t.x,
                    y: t.y,
                    z: t.z
                } : t instanceof pc.Vec4 || t instanceof pc.Quat ? i = {
                    x: t.x,
                    y: t.y,
                    z: t.z,
                    w: t.w
                } : t instanceof pc.Color ? (i = {
                    r: t.r,
                    g: t.g,
                    b: t.b
                }, void 0 !== t.a && (i.a = t.a)) : i = t, i
            };
        Tween.prototype = {
            to: function(t, i, e, s, n, r) {
                return this._properties = _parseProperties(t), this.duration = i, e && (this.easing = e), s && this.delay(s), n && this.repeat(n), r && this.yoyo(r), this
            },
            from: function(t, i, e, s, n, r) {
                return this._properties = _parseProperties(t), this.duration = i, e && (this.easing = e), s && this.delay(s), n && this.repeat(n), r && this.yoyo(r), this._from = !0, this
            },
            rotate: function(t, i, e, s, n, r) {
                return this._properties = _parseProperties(t), this.duration = i, e && (this.easing = e), s && this.delay(s), n && this.repeat(n), r && this.yoyo(r), this._slerp = !0, this
            },
            start: function() {
                var t, i, e, s;
                if (this.playing = !0, this.complete = !1, this.stopped = !1, this._count = 0, this.pending = this._delay > 0, this._reverse && !this.pending ? this.time = this.duration : this.time = 0, this._from) {
                    for (t in this._properties) this._properties.hasOwnProperty(t) && (this._sv[t] = this._properties[t], this._ev[t] = this.target[t]);
                    this._slerp && (this._toQuat.setFromEulerAngles(this.target.x, this.target.y, this.target.z), i = void 0 !== this._properties.x ? this._properties.x : this.target.x, e = void 0 !== this._properties.y ? this._properties.y : this.target.y, s = void 0 !== this._properties.z ? this._properties.z : this.target.z, this._fromQuat.setFromEulerAngles(i, e, s))
                } else {
                    for (t in this._properties) this._properties.hasOwnProperty(t) && (this._sv[t] = this.target[t], this._ev[t] = this._properties[t]);
                    this._slerp && (i = void 0 !== this._properties.x ? this._properties.x : this.target.x, e = void 0 !== this._properties.y ? this._properties.y : this.target.y, s = void 0 !== this._properties.z ? this._properties.z : this.target.z, void 0 !== this._properties.w ? (this._fromQuat.copy(this.target), this._toQuat.set(i, e, s, this._properties.w)) : (this._fromQuat.setFromEulerAngles(this.target.x, this.target.y, this.target.z), this._toQuat.setFromEulerAngles(i, e, s)))
                }
                return this._currentDelay = this._delay, this.manager.add(this), this
            },
            pause: function() {
                this.playing = !1
            },
            resume: function() {
                this.playing = !0
            },
            stop: function() {
                this.playing = !1, this.stopped = !0
            },
            delay: function(t) {
                return this._delay = t, this.pending = !0, this
            },
            repeat: function(t, i) {
                return this._count = 0, this._numRepeats = t, this._repeatDelay = i || 0, this
            },
            loop: function(t) {
                return t ? (this._count = 0, this._numRepeats = 1 / 0) : this._numRepeats = 0, this
            },
            yoyo: function(t) {
                return this._yoyo = t, this
            },
            reverse: function() {
                return this._reverse = !this._reverse, this
            },
            chain: function() {
                for (var t = arguments.length; t--;) t > 0 ? arguments[t - 1]._chained = arguments[t] : this._chained = arguments[t];
                return this
            },
            update: function(t) {
                if (this.stopped) return !1;
                if (!this.playing) return !0;
                if (!this._reverse || this.pending ? this.time += t * this.timeScale : this.time -= t * this.timeScale, this.pending) {
                    if (!(this.time > this._currentDelay)) return !0;
                    this._reverse ? this.time = this.duration - (this.time - this._currentDelay) : this.time -= this._currentDelay, this.pending = !1
                }
                var i = 0;
                (!this._reverse && this.time > this.duration || this._reverse && this.time < 0) && (this._count++, this.complete = !0, this.playing = !1, this._reverse ? (i = this.duration - this.time, this.time = 0) : (i = this.time - this.duration, this.time = this.duration));
                var e, s, n = 0 === this.duration ? 1 : this.time / this.duration,
                    r = this.easing(n);
                for (var h in this._properties) this._properties.hasOwnProperty(h) && (e = this._sv[h], s = this._ev[h], this.target[h] = e + (s - e) * r);
                if (this._slerp && this._quat.slerp(this._fromQuat, this._toQuat, r), this.entity && (this.entity._dirtifyLocal(), this.element && this.entity.element && (this.entity.element[this.element] = this.target), this._slerp && this.entity.setLocalRotation(this._quat)), this.fire("update", t), this.complete) {
                    var a = this._repeat(i);
                    return a ? this.fire("loop") : (this.fire("complete", i), this.entity && this.entity.off("destroy", this.stop, this), this._chained && this._chained.start()), a
                }
                return !0
            },
            _repeat: function(t) {
                if (this._count < this._numRepeats) {
                    if (this._reverse ? this.time = this.duration - t : this.time = t, this.complete = !1, this.playing = !0, this._currentDelay = this._repeatDelay, this.pending = !0, this._yoyo) {
                        for (var i in this._properties) {
                            var e = this._sv[i];
                            this._sv[i] = this._ev[i], this._ev[i] = e
                        }
                        this._slerp && (this._quat.copy(this._fromQuat), this._fromQuat.copy(this._toQuat), this._toQuat.copy(this._quat))
                    }
                    return !0
                }
                return !1
            }
        };
        var BounceOut = function(t) {
                return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + .75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + .9375 : 7.5625 * (t -= 2.625 / 2.75) * t + .984375
            },
            BounceIn = function(t) {
                return 1 - BounceOut(1 - t)
            };
        return {
            TweenManager: TweenManager,
            Tween: Tween,
            Linear: function(t) {
                return t
            },
            QuadraticIn: function(t) {
                return t * t
            },
            QuadraticOut: function(t) {
                return t * (2 - t)
            },
            QuadraticInOut: function(t) {
                return (t *= 2) < 1 ? .5 * t * t : -.5 * (--t * (t - 2) - 1)
            },
            CubicIn: function(t) {
                return t * t * t
            },
            CubicOut: function(t) {
                return --t * t * t + 1
            },
            CubicInOut: function(t) {
                return (t *= 2) < 1 ? .5 * t * t * t : .5 * ((t -= 2) * t * t + 2)
            },
            QuarticIn: function(t) {
                return t * t * t * t
            },
            QuarticOut: function(t) {
                return 1 - --t * t * t * t
            },
            QuarticInOut: function(t) {
                return (t *= 2) < 1 ? .5 * t * t * t * t : -.5 * ((t -= 2) * t * t * t - 2)
            },
            QuinticIn: function(t) {
                return t * t * t * t * t
            },
            QuinticOut: function(t) {
                return --t * t * t * t * t + 1
            },
            QuinticInOut: function(t) {
                return (t *= 2) < 1 ? .5 * t * t * t * t * t : .5 * ((t -= 2) * t * t * t * t + 2)
            },
            SineIn: function(t) {
                return 0 === t ? 0 : 1 === t ? 1 : 1 - Math.cos(t * Math.PI / 2)
            },
            SineOut: function(t) {
                return 0 === t ? 0 : 1 === t ? 1 : Math.sin(t * Math.PI / 2)
            },
            SineInOut: function(t) {
                return 0 === t ? 0 : 1 === t ? 1 : .5 * (1 - Math.cos(Math.PI * t))
            },
            ExponentialIn: function(t) {
                return 0 === t ? 0 : Math.pow(1024, t - 1)
            },
            ExponentialOut: function(t) {
                return 1 === t ? 1 : 1 - Math.pow(2, -10 * t)
            },
            ExponentialInOut: function(t) {
                return 0 === t ? 0 : 1 === t ? 1 : (t *= 2) < 1 ? .5 * Math.pow(1024, t - 1) : .5 * (2 - Math.pow(2, -10 * (t - 1)))
            },
            CircularIn: function(t) {
                return 1 - Math.sqrt(1 - t * t)
            },
            CircularOut: function(t) {
                return Math.sqrt(1 - --t * t)
            },
            CircularInOut: function(t) {
                return (t *= 2) < 1 ? -.5 * (Math.sqrt(1 - t * t) - 1) : .5 * (Math.sqrt(1 - (t -= 2) * t) + 1)
            },
            BackIn: function(t) {
                var i = 1.70158;
                return t * t * ((i + 1) * t - i)
            },
            BackOut: function(t) {
                var i = 1.70158;
                return --t * t * ((i + 1) * t + i) + 1
            },
            BackInOut: function(t) {
                var i = 2.5949095;
                return (t *= 2) < 1 ? t * t * ((i + 1) * t - i) * .5 : .5 * ((t -= 2) * t * ((i + 1) * t + i) + 2)
            },
            BounceIn: BounceIn,
            BounceOut: BounceOut,
            BounceInOut: function(t) {
                return t < .5 ? .5 * BounceIn(2 * t) : .5 * BounceOut(2 * t - 1) + .5
            },
            ElasticIn: function(t) {
                var i, e = .1;
                return 0 === t ? 0 : 1 === t ? 1 : (!e || e < 1 ? (e = 1, i = .1) : i = .4 * Math.asin(1 / e) / (2 * Math.PI), -e * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - i) * (2 * Math.PI) / .4))
            },
            ElasticOut: function(t) {
                var i, e = .1;
                return 0 === t ? 0 : 1 === t ? 1 : (!e || e < 1 ? (e = 1, i = .1) : i = .4 * Math.asin(1 / e) / (2 * Math.PI), e * Math.pow(2, -10 * t) * Math.sin((t - i) * (2 * Math.PI) / .4) + 1)
            },
            ElasticInOut: function(t) {
                var i, e = .1,
                    s = .4;
                return 0 === t ? 0 : 1 === t ? 1 : (!e || e < 1 ? (e = 1, i = .1) : i = s * Math.asin(1 / e) / (2 * Math.PI), (t *= 2) < 1 ? e * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - i) * (2 * Math.PI) / s) * -.5 : e * Math.pow(2, -10 * (t -= 1)) * Math.sin((t - i) * (2 * Math.PI) / s) * .5 + 1)
            }
        }
    }()),
    function() {
        pc.AppBase.prototype.addTweenManager = function() {
            this._tweenManager = new pc.TweenManager(this), this.on("update", (function(t) {
                this._tweenManager.update(t)
            }))
        }, pc.AppBase.prototype.tween = function(t) {
            return new pc.Tween(t, this._tweenManager)
        }, pc.Entity.prototype.tween = function(t, i) {
            var e = this._app.tween(t);
            return e.entity = this, this.once("destroy", e.stop, e), i && i.element && (e.element = i.element), e
        };
        var t = pc.AppBase.getApplication();
        t && t.addTweenManager()
    }();