/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.SequentialDataReader;

public class FixedRateMonoReader
extends SequentialDataReader {
    public FixedRateMonoReader() {
        this.output = new UnitOutputPort();
        this.addPort(this.output);
    }

    @Override
    public void generate(int start, int limit) {
        double[] amplitudes = this.amplitude.getValues();
        double[] outputs = this.output.getValues();
        for (int i = start; i < limit; ++i) {
            if (this.dataQueue.hasMore()) {
                double fdata = this.dataQueue.readNextMonoDouble(this.getFramePeriod());
                outputs[i] = fdata * amplitudes[i];
            } else {
                outputs[i] = 0.0;
                if (this.dataQueue.testAndClearAutoStop()) {
                    this.autoStop();
                }
            }
            this.dataQueue.firePendingCallbacks();
        }
    }
}

