/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RotaryController
extends JPanel {
    private static final long serialVersionUID = 6681532871556659546L;
    private static final double SENSITIVITY = 0.01;
    private final BoundedRangeModel model;
    private final double minAngle = 4.39822971502571;
    private final double maxAngle = -1.2566370614359172;
    private final double unitIncrement = 0.01;
    private int lastY;
    private int startX;
    private Color knobColor = Color.LIGHT_GRAY;
    private Color lineColor = Color.RED;
    private double baseValue;
    private Style style = Style.ARC;

    public RotaryController(BoundedRangeModel model) {
        this.model = model;
        this.setMinimumSize(new Dimension(50, 50));
        this.setPreferredSize(new Dimension(50, 50));
        this.addMouseListener(new MouseHandler());
        this.addMouseMotionListener(new MouseMotionHandler());
        model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RotaryController.this.safeRepaint();
            }
        });
    }

    public void safeRepaint() {
        this.repaint();
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    private int getModelRange() {
        return this.model.getMaximum() - this.model.getExtent() - this.model.getMinimum();
    }

    public double getFractionFromModel() {
        double value = this.model.getValue();
        return this.convertValueToFraction(value);
    }

    private double convertValueToFraction(double value) {
        return (value - (double)this.model.getMinimum()) / (double)this.getModelRange();
    }

    private void setKnobByXY(int x, int y) {
        int ydiff = this.lastY - y;
        int xdiff = this.startX - x;
        double power = (double)xdiff * 0.01;
        double perPixel = 0.01 * Math.pow(2.0, power);
        double fractionalDelta = (double)ydiff * perPixel;
        int valueDelta = (int)Math.round(fractionalDelta * (double)this.getModelRange());
        if (valueDelta != 0) {
            this.model.setValue(this.model.getValue() + valueDelta);
            this.lastY = y;
        }
    }

    private double fractionToAngle(double fraction) {
        return fraction * -5.654866776461628 + 4.39822971502571;
    }

    private void drawLineIndicator(Graphics g, int x, int y, int radius, double angle, boolean drawDot) {
        double dotScale;
        int dotRadius;
        double arrowSize = (double)radius * 0.95;
        int arrowX = (int)(arrowSize * Math.sin(angle));
        int arrowY = (int)(arrowSize * Math.cos(angle));
        g.setColor(this.lineColor);
        g.drawLine(x, y, x + arrowX, y - arrowY);
        if (drawDot && (dotRadius = (int)((dotScale = 0.1) * arrowSize)) > 1) {
            int dotX = x + (int)((0.99 - dotScale) * (double)arrowX) - dotRadius;
            int dotY = y - (int)((0.99 - dotScale) * (double)arrowY) - dotRadius;
            g.fillOval(dotX, dotY, dotRadius * 2, dotRadius * 2);
        }
    }

    private void drawArrowIndicator(Graphics g, int x0, int y0, int radius, double angle) {
        int arrowSize = (int)((double)radius * 0.95);
        int arrowWidth = (int)((double)radius * 0.2);
        int[] xp = new int[]{0, arrowWidth, 0, -arrowWidth};
        int[] yp = new int[]{arrowSize, -arrowSize / 2, 0, -arrowSize / 2};
        double sa = Math.sin(angle);
        double ca = Math.cos(angle);
        for (int i = 0; i < xp.length; ++i) {
            int x = xp[i];
            int y = yp[i];
            xp[i] = x0 - (int)((double)x * ca - (double)y * sa);
            yp[i] = y0 - (int)((double)x * sa + (double)y * ca);
        }
        g.fillPolygon(xp, yp, xp.length);
    }

    private void drawArcIndicator(Graphics g, int x, int y, int radius, double angle) {
        double DEGREES_PER_RADIAN = 57.29577951308232;
        int minAngleDegrees = 252;
        int maxAngleDegrees = -72;
        int zeroAngleDegrees = (int)(this.fractionToAngle(this.baseValue) * 57.29577951308232);
        double arrowSize = (double)radius * 0.95;
        int arcX = x - radius;
        int arcY = y - radius;
        int arcAngle = (int)(angle * 57.29577951308232);
        int arrowX = (int)(arrowSize * Math.cos(angle));
        int arrowY = (int)(arrowSize * Math.sin(angle));
        g.setColor(this.knobColor.darker().darker());
        g.fillArc(arcX, arcY, 2 * radius, 2 * radius, 252, -324);
        g.setColor(Color.ORANGE);
        g.fillArc(arcX, arcY, 2 * radius, 2 * radius, zeroAngleDegrees, arcAngle - zeroAngleDegrees);
        int arcWidth = radius / 4;
        int diameter = (radius - arcWidth) * 2;
        g.setColor(this.knobColor);
        g.fillOval(arcWidth + x - radius, arcWidth + y - radius, diameter, diameter);
        g.setColor(this.lineColor);
        g.drawLine(x, y, x + arrowX, y - arrowY);
    }

    public void drawIndicator(Graphics g, int x, int y, int radius, double angle) {
        g.setColor(this.isEnabled() ? this.lineColor : this.lineColor.darker());
        switch (this.style) {
            case LINE: {
                this.drawLineIndicator(g, x, y, radius, angle, false);
                break;
            }
            case LINEDOT: {
                this.drawLineIndicator(g, x, y, radius, angle, true);
                break;
            }
            case ARROW: {
                this.drawArrowIndicator(g, x, y, radius, angle);
                break;
            }
            case ARC: {
                this.drawArcIndicator(g, x, y, radius, angle);
            }
        }
    }

    public void drawKnob(Graphics g, int x, int y, int radius, double angle) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int diameter = radius * 2;
        g.setColor(this.knobColor.darker());
        g.fillOval(x - radius + 2, y - radius + 2, diameter, diameter);
        g.setColor(this.knobColor);
        g.fillOval(x - radius, y - radius, diameter, diameter);
        this.drawIndicator(g, x, y, radius, angle);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        int x = width / 2;
        int y = height / 2;
        int diameter = width < height ? width : height;
        int radius = (diameter -= 4) / 2;
        double angle = this.fractionToAngle(this.getFractionFromModel());
        this.drawKnob(g, x, y, radius, angle);
    }

    public Color getKnobColor() {
        return this.knobColor;
    }

    public void setKnobColor(Color knobColor) {
        this.knobColor = knobColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style;
    }

    public double getBaseValue() {
        return this.baseValue;
    }

    public void setBaseValue(double baseValue) {
        if (baseValue < 0.0) {
            baseValue = 0.0;
        } else if (baseValue > 1.0) {
            baseValue = 1.0;
        }
        this.baseValue = baseValue;
    }

    private class MouseMotionHandler
    extends MouseMotionAdapter {
        private MouseMotionHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (RotaryController.this.isEnabled()) {
                RotaryController.this.setKnobByXY(e.getX(), e.getY());
            }
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            RotaryController.this.lastY = e.getY();
            RotaryController.this.startX = e.getX();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (RotaryController.this.isEnabled()) {
                RotaryController.this.setKnobByXY(e.getX(), e.getY());
            }
        }
    }

    public static enum Style {
        LINE,
        LINEDOT,
        ARROW,
        ARC;

    }
}

