/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.Taskbar;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import processing.core.PApplet;

public class ThinkDifferent {
    private static Desktop desktop;
    private static Taskbar taskbar;
    static boolean attemptedQuit;

    public static void init(PApplet sketch) {
        ThinkDifferent.getDesktop().setQuitHandler((event, quitResponse) -> {
            boolean noKnownCrash;
            sketch.exit();
            boolean bl = noKnownCrash = PApplet.uncaughtThrowable == null;
            if (noKnownCrash && !attemptedQuit) {
                quitResponse.cancelQuit();
                attemptedQuit = true;
            } else {
                quitResponse.performQuit();
            }
        });
    }

    public static void cleanup() {
        ThinkDifferent.getDesktop().setQuitHandler(null);
    }

    public static void setIconImage(Image image) {
        ThinkDifferent.getTaskbar().setIconImage(image);
    }

    private static Taskbar getTaskbar() {
        if (taskbar == null) {
            taskbar = Taskbar.getTaskbar();
        }
        return taskbar;
    }

    private static Desktop getDesktop() {
        if (desktop == null) {
            desktop = Desktop.getDesktop();
        }
        return desktop;
    }

    public static native void hideMenuBar();

    public static native void showMenuBar();

    public static native void activateIgnoringOtherApps();

    static {
        String NATIVE_FILENAME = "libDifferent.jnilib";
        try {
            File temp = File.createTempFile("processing", "different");
            if (temp.delete() && temp.mkdirs()) {
                temp.deleteOnExit();
                File jnilibFile = new File(temp, "libDifferent.jnilib");
                InputStream input = ThinkDifferent.class.getResourceAsStream("libDifferent.jnilib");
                if (input != null) {
                    if (PApplet.saveStream(jnilibFile, input)) {
                        System.load(jnilibFile.getAbsolutePath());
                    } else {
                        System.err.println("Full screen disabled: could not save library");
                    }
                } else {
                    System.err.println("Full screen disabled: could not load libDifferent.jnilib from core.jar");
                }
            } else {
                System.err.println("Full screen disabled: could not create temporary folder");
            }
        }
        catch (IOException e) {
            System.err.println("Full screen disabled");
            e.printStackTrace();
        }
    }
}

