/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.softsynth.math.FourierMath;
import processing.core.PApplet;
import processing.sound.Analyzer;
import processing.sound.Engine;
import processing.sound.JSynFFT;

public class FFT
extends Analyzer {
    public float[] spectrum;
    private JSynFFT fft;

    public FFT(PApplet pApplet) {
        this(pApplet, 512);
    }

    public FFT(PApplet pApplet, int n) {
        super(pApplet);
        if (FFT.checkNumBands(n)) {
            this.fft = new JSynFFT(2 * n);
            this.spectrum = new float[n];
        }
    }

    private static boolean checkNumBands(int n) {
        if (n < 0 || Integer.bitCount(n) != 1) {
            Engine.printError("number of FFT bands needs to be a power of 2");
            return false;
        }
        if (n > 16384) {
            Engine.printError("the maximum number of FFT bands is 16384");
            return false;
        }
        return true;
    }

    @Override
    protected void removeInput() {
        this.fft.input.disconnectAll();
        this.input = null;
    }

    @Override
    protected void setInput(UnitOutputPort unitOutputPort) {
        Engine.getEngine().add((UnitGenerator)this.fft);
        this.fft.input.connect(unitOutputPort);
        this.fft.start();
    }

    public float[] analyze() {
        return this.analyze(this.spectrum);
    }

    public float[] analyze(float[] fArray) {
        if (this.input == null) {
            Engine.printWarning("this FFT has no sound source connected to it, nothing to analyze");
        }
        this.fft.calculateMagnitudes(fArray);
        return fArray;
    }

    public static float[] analyzeSample(float[] fArray, float[] fArray2) {
        FFT.calculateMagnitudesFromSample(fArray, fArray2);
        return fArray2;
    }

    public static float[] analyzeSample(float[] fArray, int n) {
        return FFT.analyzeSample(fArray, new float[n]);
    }

    protected static void calculateMagnitudesFromSample(float[] fArray, float[] fArray2, float[] fArray3) {
        if (FFT.checkNumBands(fArray3.length)) {
            FourierMath.transform((int)1, (int)fArray.length, (float[])fArray, (float[])fArray2);
            FourierMath.calculateMagnitudes((float[])fArray, (float[])fArray2, (float[])fArray3);
            int n = 0;
            while (n < fArray3.length) {
                int n2 = n++;
                fArray3[n2] = fArray3[n2] * 2.0f;
            }
        }
    }

    protected static void calculateMagnitudesFromSample(float[] fArray, float[] fArray2) {
        FFT.calculateMagnitudesFromSample(fArray, new float[fArray.length], fArray2);
    }
}

