const rows = 7;
const creaturesNum = 40;
const grassNum = 150;

let creatures = [];
let grasses = [];

let allObject = [];

let noiseTexture;
let frameTexture;
let cp;

function setup() {
    createCanvas(windowWidth, windowHeight);

    cp = random(colorPalletes).colors;

    noiseTexture = createGraphics(width, height);
    for(let i = 0; i < 50000; i++) {
        const x = random(width);
        const y = random(height*1.1);
        const l = pow(y / height, 3) * 25 + random(2, 5);
        const c = random(cp);
        noiseTexture.stroke(red(c), green(c), blue(c), 100);
        noiseTexture.line(x, y, x, y-l);
    }

    frameTexture = createGraphics(width, height);
    frameTexture.stroke(255);
    frameTexture.strokeWeight(2);

    for(let i = 0; i < creaturesNum; i++) {
        const x = random(width);
        const y = height*floor(random(1.1)*rows)/rows-random(height*0.08);
        const w = map(pow((y+random(height*0.1))/height, 3), 0, 1.2, width * 0.05, width * 0.2);
        const h = map(pow(y/height, 3), 0, 1, height*0.05, height*0.3);
        const c = random(cp);
        allObject.push(new Creature(x, y, w, h, c));
    }

    for(let i = 0; i < grassNum; i++) {
        const x = random(width);
        const y = map(pow(random(), 2), 0, 1, -height*0.3, height*1.1);
        const r = map(pow(y / height, 3), 0, 1, min(width, height) * 0.05, min(width, height) * 0.2);
        const c = color(30, random(50, 150), 30);
        const n = floor(random(2, 5) * 2);
        allObject.push(new Grass(x, y, r, n, c, random(1000)));
    }

    allObject.sort((a, b) => a.y - b.y);
}

function draw() {
    background(40, 127, 80, 180);
    image(noiseTexture, 0, 0);

    for(let i in allObject) {
        if (allObject[i].name == "creature") {
            allObject[i].move();
        }
        allObject[i].draw();
    }

    image(frameTexture, 0, 0);
}

const colorPalletes = [{
        name: "DeepEmeraldGold",
        colors: ["#005e55", "#fff9bf", "#edb50c", "#b8003d", "#5e001f"],
    },
    {
        name: "WarmRainbow",
        colors: ["#01204E", "#028391", "#F6DCAC", "#FAA968", "#F85525"],
    },
    {
        name: "ChocolateAndCream",
        colors: ["#D54751", "#EF9A48", "#FFFCC7", "#4DA394", "#59322B"],
    },
    {
        name: "PopArt",
        colors: ["#241965", "#653993", "#9F4094", "#B73D6E", "#F19406"],
    },
    {
        name: "DeepEmeraldGold",
        colors: ["#F87523", "#FFC31B", "#E7DCC9", "#1DB7B9", "#126D68"],
    },
    {
        name: "GreenPink",
        colors: ["#01B999", "#FAB3B3", "#DC958F", "#A1D8CE", "#F1FAF7"],
    },
    {
        name: "NatureTranquility",
        colors: ["#106A6B", "#07374B", "#CAB381", "#E9E0CE"],
    },
    {
        name: "VibrantHarmony",
        colors: ["#F15946", "#5681CB", "#FAAA2D", "#296647", "#453945"],
    },
    {
        name: "Serenity Bliss",
        colors: ["#FFB4B8", "#EF4B28", "#0A563A", "#FFBC54", "#ECE9E0"],
    }
];

function creature(x, y, w, h, c = 255, seed = 0, move = true, str="Hello") {
    push();
    noStroke();

    translate(x, y - h);

    // body
    fill(c);
    rect(0, 0, w, h * 0.8);
    fill(40);
    rect(0, 0, w, h * 0.1);

    // legs
    let leftLegPos = w * 0.2;
    let rightLegPos = w * 0.6;
    if (move) {
        leftLegPos += map(sin(frameCount * 0.1 + seed), -1, 1, -w * 0.05, w * 0.05);
        rightLegPos += map(sin(frameCount * 0.1 + seed + 1), -1, 1, -w * 0.05, w * 0.05);
    }

    fill(c);
    rect(leftLegPos, h, w * 0.2, -h * 0.5);
    rect(rightLegPos, h, w * 0.2, -h * 0.5);

    fill(40);
    rect(leftLegPos, h, w * 0.2, -h * 0.1);
    rect(rightLegPos, h, w * 0.2, -h * 0.1);

    // eyes
    const eyeSize = max(min(w, h) * 0.05, 3);
    const g = (red(c) + green(c) + blue(c)) / 3 / 255;
    if (g > 0.5) {
        fill(20);
    } else {
        fill(255);
    }
    rect(w * 0.1, h * 0.25, eyeSize, eyeSize);
    rect(w * 0.2, h * 0.25, eyeSize, eyeSize);
    rect(w * 0.15, h * 0.4, eyeSize, eyeSize);

    // speech bubble
    rect(w * 0.15, -h * 0.4, w * 0.7, h * 0.3, min(w, h)*0.05);
    triangle(w * 0.5, -h * 0.03, w * 0.4, -h * 0.2, w * 0.6 , - h * 0.2);

    if (g > 0.5) {
        fill(255);
    } else {
        fill(20);
    }
    textAlign(CENTER, CENTER);
    textSize(min(w, h) * 0.1);
    text(str, w * 0.5, -h * 0.25);

    const typeLineX = w * 0.5 + min(w, h) * 0.1 * str.length * 0.5;
    const alpha = pow(map(sin(frameCount * 0.1 + seed), -1, 1, 0, 1), 4) * 255;
    if (g > 0.5) {
        stroke(255, alpha);
    } else {
        stroke(20, alpha);
    }
    strokeWeight(2);
    line(typeLineX, -h * 0.2, typeLineX, -h * 0.3);

    pop();
}

class Creature {
    constructor(x, y, w, h, c) {
        this.name = "creature";
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.c = c;
        this.seed = random(1000);
        this.m = true;
        this.str = "www";

        this.vx = -(pow(random(), 2) * 2 + 1);
    }

    move() {
        const move = noise(frameCount * 0.001, this.seed) > 0.3;
        this.m = move;
        if (move) {
            this.x += this.vx;
        }
        if (this.x + this.w < 0) {
            this.x = width;
        }
    }

    draw() {
        const strLegth = floor(noise(frameCount * 0.01, this.seed) * 6);
        this.str = "";
        for (let i = 0; i < strLegth; i++) {
            this.str += "w";
        }
        noStroke();
        fill(255, 100);
        ellipse(this.x+this.w/2, this.y, this.w, this.h*0.4);
        creature(this.x, this.y, this.w, this.h, this.c, this.seed, this.m, this.str);
    }
}

function grass(x, y, r, n, seed = 0) {
    push();
    noStroke();
    translate(x, y);
    beginShape();
    for (let angle = PI; angle <= TAU; angle += 0.1) {
        const angleSeed = abs((angle % (PI / n)) - (PI / 2 / n));
        const rr = map(noise(angleSeed*3.0, seed), 0, 1, 0.2, 1.0) * r;
        const xx = cos(angle) * rr;
        const yy = sin(angle) * rr;
        curveVertex(xx, yy);
    }
    endShape();
    pop();
}

class Grass {
    constructor(x, y, r, n, c, seed = 0) {
        this.name = "grass";
        this.x = x;
        this.y = y;
        this.r = r;
        this.n = n;
        this.c = c;
        this.seed = seed;
    }

    draw() {
        fill(this.c);
        grass(this.x, this.y, this.r, this.n, this.seed);
    }
}