layout(location = 0)in vec3 vertex_position;
layout(location = 1)in vec3 vertex_normal;
layout(location = 2)in vec2 vertex_uv;

out vec3 normal;
out vec2 uv;
out vec3 frag_position;
out float mat;

uniform mat4 wvp;

uniform float fTime;

uniform int instanceX;
uniform int instanceZ;

mat2 rot(float a){
  float c=cos(a),s=sin(a);
  return mat2(c,s,-s,c);
}

void main() {
  normal = vertex_normal;
  uv = vertex_uv;

  float dir = (float((instanceX + instanceZ) & 1)-0.5)*2.0;

  vec4 pos = vec4(vertex_position, 1.0);
  mat2 rotation = rot(0.95+fTime*dir);
  pos.xz *= rotation;
  normal.xz *= rotation;
  pos.x += instanceX * 2.0-11;
  pos.z += instanceZ * 2.0-11;
  pos.y -= 1;
  frag_position = pos.xyz;
  gl_Position = vec4(pos * wvp);
}
