layout(location = 0)in vec3 vertex_position;
layout(location = 1)in vec3 vertex_normal;
layout(location = 2)in vec2 vertex_uv;

out vec3 normal;
out vec2 uv;
out vec3 frag_position;
out float mat;

uniform mat4 wvp;

uniform float fTime;

uniform int instanceX;
uniform int instanceZ;

mat2 rot(float a){
  float c=cos(a),s=sin(a);
  return mat2(c,s,-s,c);
}

void main() {
  normal = vertex_normal;
  uv = vertex_uv;
  //vec3 circ = vec3(sin(fTime) * 0.5, cos(fTime) * 0.5, 1.0);
  float hash = instanceX + instanceZ*10; 
  hash = fract(hash*hash*1.1134+hash*412.1234+5341.123);
  float anim = sin(fTime*3.14159*0.25+hash*100.0);
  anim = smoothstep(-0.5,0.5, anim)*0.6-0.1;
  vec4 pos = vec4(vertex_position, 1.0);
  mat=0;
  if (uv.x>=0 && uv.y >= 0) {
    pos.xyz += vec3(0,anim,0);
    mat=1;
    if (uv.y > 1.0) {
      float rate = fTime*4.0*sin(hash);
      mat2 r=rot(rate);
      pos.xz*=r;
      normal.xz*=r;
      mat=2;
    }
  }
 
  pos.x += instanceX * 2.0-10;
  pos.z += instanceZ * 2.0-10;
  pos.y -= 1;
  frag_position = pos.xyz;
  gl_Position = vec4(pos * wvp);
  //gl_Position = vec4(vertex_position, 1.0);
}
