pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

-- gloabl, we need this elsewhere
dithertab= {}

walkanim={
-- params    
    show= 0,
    fade= 10,
    spread= 1,
    posx= 0,
    posy= 0,
    scale= 1,
    frame= 0,
    
    colremap1= {},
    pals={},
    faces = {}
}

walkanim.setparams = function(this, p)
  this.show= p[1]&-1
  this.fade= clamp(p[2]&-1, 0, 16)
  this.spread= p[3]
  this.posx= p[4]*16
  this.posy= p[5]*16
  this.scale= p[6]
  this.frame= p[7]*32
end

walkanim.load = function(this)
    memset(0x8000, 0, 0x8000)
    
    -- 0: face1 = 8000
    -- 1: face2 = 8710
    -- 2: face3 = 9010
    -- 3: walk  = 97d0
    -- 4: pal   = 9fc0 walk
    -- 5: pal   = 9fd0 overlays
    -- 6: pal   = 9fe0 ??
    -- 6: pal   = 9ff0 ??
    --    table = a000
    
    reload(0x8000, 0x0, 0x4300, "data_1.p8")

    poke(0x5f54,0xe0) -- sget/sset point to 0xe000
    for i=0,3 do
        memset(0xe000, 0, 0x2000)
        px9_decomp(0,0, dict(0x8000,i), sget, sset) 
        this.faces[i+1]= storemem(0, 0x2000)
    end
    poke(0x5f54,0x0)

   local start= dict(0x8000,5)
    for i=0,15*4 do
      this.colremap1[i]= {}
      start= unpackmem( start, this.colremap1[i] )
    end

    unpackmem4( dict(0x8000,6), dithertab )

--   pal( {[0]=0,8,11,10,12,0x88,0x8b,7, 8,8,8,8,8,8,8,8},1) -- tobi
--   pal( {[0]=0,136,131,135,140,14,12,7, 8,8,8,8,8,8,8,8},1)
--              1   2  1+2  3  1+3 2+3 1+2+3 

   local start= dict(0x8000,4)
   for i=0,4 do
     this.pals[i]= {}
     start= unpackmem(start, this.pals[i] )
   end
end


walkanim.init = function(this)
    restoremem(0xe000, this.faces[4]) -- walk anim to sprite sheet

    memset(0x5f70, 0xaa, 16) -- scanline pal toggle

    poke(0x5f5f, 0x10)
    poke(0x5f2c, 0)

    poke(0x5f54, 0x0)

    palt(0,true)
end




walkanim.update = function(this)
--    this.frame+=1
--    if (this.frame>255) this.frame=0

--    this.spread = 9 - (frame & 63)/2.0
--    if (this.spread<1) this.spread= 1

--    this.scale= 1.5 - cos(this.frame/500.0)*0.5
end


walkanim.draw = function(this)
--    print(this.show.." "..this.fade.." "..this.spread.." "..this.scale.." "..this.frame)

    function draw_frame(fr, offsetx, scale)
        local x= (fr & 3)<<4
        local y= (fr >> 2 & 1)*56
        local p= (fr >> 3 & 3)

        local mask= 0x1111.1111 << p

        for r=0,55 do
            local src= 0xe000+(y+r)*64+x
            local dst= 0x0+(r<<6)
            for i=0,15,4 do
                local c= $(src+i) & mask
                poke4(dst+i, c)
            end
        end

        sspr( 0,0, 
            32,56, 
            this.posx + offsetx,
            this.posy, 
            32*scale, 56*scale
        )
    end

    local mask= {
        [0]=
        0x88.0, -- dark red (additional left, color 8) 8
        0x99.1, -- dark red (additional left, color 9) 8+1

        0xcc.6, -- dark blue (additional right, color b) 8+4
        0x0f.5, -- clear dark blue
        0xaa.5, -- dark blue (additional right, color a) 8+2

        0x0f.21, -- clear red
        0x0f.31, -- clear green
        0x0f.41, -- clear blue

        0x11.21, -- red (bitplane 1)
        0x22.31, -- green (bitplane 2)
        0x44.41  -- blue (bitplane 3)
    }


    if (this.show==0) then
    for i=1,2 do pal( this.pals[i], i ) end
--        pal( this.pals[2], 2 )

--        pal(15,1,1)
--        pal(15,0x81,2)
     
        for i=0,#mask do   
            local m= mask[i]
            local pos= m<<4&15
            local fr= (this.frame&0xffff)+pos       
            local p= (fr >> 3 & 3)
            pal( this.colremap1[((m>>4&15)<<2)|p], 0 )

            poke(0x5f5e, m) -- overwrite only bitplane i
            draw_frame(fr, (pos-3)*this.spread*this.scale, this.scale)
        end
        poke(0x5f5e, 255)
    end
    if (this.show>0) then
        pal( this.pals[3], 1 )
        pal( this.pals[4], 2 )
          
--        local d= this.fade
        restoremem(0x0, this.faces[this.show])

        sspr( 0,0, 
            128,128, 
            this.posx,this.posy, 
            128*this.scale, 128*this.scale
        )

    end

    -- fade out dither
    fillp( dithertab[this.fade] )
    rectfill(0,0,128,128,0)

    fillp()
end

