pico-8 cartridge // http://www.pico-8.com
version 41
__lua__
local scaleu,scalev,fov,radius=3/8,1.5/8,1.5,10
local function calc_grid(cam,width,height,scale_v,radius,scale,cx,cy)
local screenx,screeny,screenz,scaley=cam[3]*fov-cam[1]-cam[2],cam[7]*fov-cam[5]-cam[6],cam[11]*fov-cam[9]-cam[10],2/width
local deltaxx,deltaxy,deltaxz,deltayx,deltayy,deltayz,radius2,grid=cam[1]*scaley,cam[5]*scaley,cam[9]*scaley,cam[2]*scaley,cam[6]*scaley,cam[10]*scaley,radius*radius,{}
for y=0,height do
local dirx,diry,dirz,row=screenx,screeny,screenz,{}
for x=0,width do
local a=dirx*dirx+diry*diry
if a>.0001then
local t0=.5*radius/sqrt(a)
local ix,iy,iz=t0*dirx,t0*diry,t0*dirz
local z=1.3-sqrt(abs(iz))*.2
if(z<.01)z=.01
if(z>1)z=1
row[x]={
x*scale+cx,
y*scale+cy,
atan2(ix,iy)*128,
iz*scale_v,
flr(z*40)
}
else
row[x]={
x*scale+cx,
y*scale+cy,
row[x-1][3],
row[x-1][4],
0
}
end
dirx+=deltaxx
diry+=deltaxy
dirz+=deltaxz
end
grid[y]=row
screenx+=deltayx
screeny+=deltayy
screenz+=deltayz
end
return grid
end
function draw_grid(grid,offsetv)
local prevz,ul,ur,ll,lr=-1
local function draw_cell()
local left_u,right_u,ll_u,lr_u,left_v,right_v,ll_v,lr_v,x1,y1,x2,y2=ul[3],ur[3],ll[3],lr[3],ul[4]+offsetv,ur[4]+offsetv,ll[4]+offsetv,lr[4]+offsetv,ul[1],ul[2],lr[1],lr[2]
local s1,s2,s3,s4=1<<(ll_u+32>>6),1<<(lr_u+32>>6),1<<(left_u+32>>6),1<<(right_u+32>>6)
if(s1|s2|s3|s4)&5==5then
if(s1==1)ll_u+=128
if(s2==1)lr_u+=128
if(s3==1)left_u+=128
if(s4==1)right_u+=128
end
left_u*=scaleu
left_v*=scalev
ll_u*=scaleu
ll_v*=scalev
right_u*=scaleu
right_v*=scalev
lr_u*=scaleu
lr_v*=scalev
local left_du,left_dv,du,dv,stepy=(ll_u-left_u)/(y2-y1),(ll_v-left_v)/(y2-y1),(right_u-left_u)/(x2-x1),(right_v-left_v)/(x2-x1),-y1&.99999
left_u+=left_du*stepy
left_v+=left_dv*stepy
local stepx=-x1&.99999
left_u+=du*stepx
left_v+=dv*stepx
y1,y2,x1,x2=ceil(y1),ceil(y2),ceil(x1),ceil(x2)
local z=ul[5]
if(z~=prevz)memcpy(24416,17152+(z<<4),16)prevz=z
for y=y1,y2-1do
tline(x1,y,x2-1,y,left_u,left_v,du,dv)
left_u+=left_du
left_v+=left_dv
end
end
for y=0,#grid-1do
local row1,row2=grid[y],grid[y+1]
ul,ll=row1[0],row2[0]
for x=1,#row1 do
ur,lr=row1[x],row2[x]
draw_cell(offsetv)
ul,ll=ur,lr
end
end
end
