pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

room={
-- params    
    objx = 0,
    objy = 0,
    objz = 0,
    rot = 0,
    backx = 0,
    backy = 0,
    fade = 0,
    mode = 0,

    gfx={},
    colors={},
    vertices={},
    normals={},
    indices={}
}

function setshading(offset)
    local col={[0]=0,1,2,3,4,5,6,7,9,10,10,10,10,10,10,10}
    for i=0,15 do
      local i1= flr((i+offset)/2)
      local i2= flr((i+offset+1)/2)
      if (i1>9) i1=9
      if (i1<0) i1=0
      if (i2>9) i2=9
      if (i2<0) i2=0
      i1= col[i1]
      i2= col[i2]
      poke(0x5f60+i, (i1<<4)|i2)
    end
  end  
  
room.setparams = function(this, p)
  this.objx = p[1]
  this.objy = p[2]
  this.objz = p[3]
  this.rot =  p[4]
  this.backx = p[5]
  this.backy = p[6]
  this.fade = p[7]
  this.mode = p[8]
end

room.load = function(this)
    memset(0x8000, 0, 0x8000)
    
    reload(0x8000, 0x0, 0x4300, "data_2.p8")

    for i=0,1 do
      px9_decomp(0,0, dict(0x8000,i), sget, sset) 
      this.gfx[i]= storemem(0, 0x2000)
    end
    memset(0x0,0x0, 0x4300)

    readvectors( dict(0x8000,2), this.vertices )
    readvectors( dict(0x8000,3), this.normals )
    unpackmem2( dict(0x8000,4),  this.indices )

    unpackmem( dict(0x8000,5), this.colors )
end


room.init = function(this)
    restoremem(0x8000, this.gfx[0])
    restoremem(0xa000, this.gfx[1])
    pal(this.colors, 1)
    pal(13,140,1)
    pal(14,129,1)
    pal(15,0,1)

    for y=0,16 do
        for x=0,16 do
          mset(x,y, y*16+x)
        end
    end

    palt(0,false)
end




room.update = function(this)
	poke(0x5f5f, 0x0)
end

--local distance= 5
--local rotation_x= 0
--local rotation_y= 0

local move= 0

room.draw = function(this)
--    rotation_x+= 0.005
--    rotation_y+= 0.002

    local mode = this.mode
    local bx= this.backx
    local by= this.backy
    fillp()    
    

    --                   0  1  2   3  4  5  6   7  8  9 10 11 12   13  14 15
    local heller=  {[0]= 1, 2,13,  4, 5, 7, 8,  8, 9,10,11,11,11,   9, 14,15 }
    local dunkler= {[0]= 0, 0, 1,  0, 3, 4, 4,  5, 7, 8, 9,10,10,   2, 14,15 }

    local fade= clamp(this.fade&-1, -256, 256) -- 8+flr(sin(move)*8)

    -- TODO: store!
    if (fade>0) then
        local steps= fade>>4&15
        fade&=15
        for i=0,15 do
            local c1,c2= i,i
            for k=0,steps do 
                c2=c1 
                c1=heller[c1] 
            end
            pal(i, c2*16+c1, 2)
        end
    else
        fade=-fade
        local steps= fade>>4&15
        fade&=15
        for i=0,15 do
            local c1,c2= i,i
            for k=0,steps do 
                c2=c1 
                c1=dunkler[c1] 
            end
            pal(i, c2*16+c1, 2)
        end
    end

    fillp( (dithertab[fade]&-1)|0x0.4 )
--    fillp(0b0101101001011010.01)

    poke(0x5f54,0x80) -- background
    if (mode==0) then
        -- static background
      spr(0,0,0,16,16)
      fillp()
    elseif (mode>=1) then
        -- background flipped in x and y
        spr(7-(bx>>3&15)+16*(by>>3&15), 64+(bx&7)-8,-(by&7), 9,16)
        fillp()
        poke(0x5f54,0x60) -- sget/sset point to 0xe000
        spr(8,  -1,0, 8,16, true)
    end
    
    if (mode>=2) then
      -- background flipped in x and y
      poke(0x5f54,0x60) -- sget/sset point to 0xe000
      spr(0,  0,65, 16,8, false, true)
    end

    memcpy(0xc000, 0x6000, 0x2000)


    fillp(0xa5a5.4)
    setshading(3)    
    poke(0x5f54,0xa0) -- envmap

    local obj = matrix_mul( matrix_roty(this.rot*5/3), matrix_rotx(this.rot) )
    local cam = matrix_mul( matrix_translation(this.objx, this.objy, this.objz+1), obj )
    local world_normals = transform(this.normals, obj)  -- 0.022
    local screen_verts = transform(this.vertices, cam)   -- 0.022
    screen_verts= project(screen_verts, world_normals)   -- 0.015
    local vis_faces= cull_light_quads(screen_verts, this.indices, world_normals) 
    local sorted_faces= sort_faces(vis_faces)   -- 0.015
    
    draw_quads(sorted_faces)   -- ~0.2

    
    fillp()
    if (this.objz>=14) then
        palt(15,true)
        palt(14,true)
        poke(0x5f54,0xc0) -- overlay
        spr(4*16,0,4*8,16,8)
        palt(15,false)
        palt(14,false)
    end

end

