pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

-- performs matrix multiplication on source vertices (xyz)
-- and projects to 2d 
local function transform(src, mat)
    local xx,xy,xz,xw= mat[1],mat[2],mat[3],mat[4] 
    local yx,yy,yz,yw= mat[5],mat[6],mat[7],mat[8]
    local zx,zy,zz,zw= mat[9],mat[10],mat[11],mat[12]
  
    local dst = {}
    for i=1, #src do
      local v= src[i]  
      local x,y,z= v[1],v[2],v[3]
      
      dst[i] = {
        xx*x + xy*y + xz*z + xw,
        yx*x + yy*y + yz*z + yw,
        zx*x + zy*y + zz*z + zw
      }
    end
    return dst
end
  

local function project(src, normals)
  local dst = {}
  for i=1, #src do
    local n= normals[i]
    local v= src[i]
    
    -- viewport transformation
    local invz= 128.0 / v[3]

    -- save screen position
    dst[i]= { 
      64 + v[1] * invz, 
      64 + v[2] * invz, 
      v[3],
      (1+n[1])<<3,  -- *64/8
      (1+n[2])<<2   -- *32/8
    }
  end
  return dst
end



local function cull_light_quads(vertices, indices, vertex_normals)
  local visible= 1

  local faces= {}
  for i=1,#indices,4 do
    -- 3 indices of current triangle
    local i1= indices[i]
    local i2= indices[i+1]
    local i3= indices[i+2]
    local i4= indices[i+3]

    local v1= vertices[i1]
    local v2= vertices[i2]
    local v3= vertices[i3]
    local v4= vertices[i4]

--    if (v1[3]>1 and v2[3]>1 and v3[3]>1 and v4[3]>1) then
    -- backface culling
    local a= (v1[1] - v3[1]) * (v2[2] - v3[2])
    local b= (v2[1] - v3[1]) * (v1[2] - v3[2])
    if ( a < b ) then
        -- calc average depth of polygon
        local z= 255 - flr(v1[3] + v2[3] + v3[3] + v4[3])
        if (z < 1) then z=1 end
        if (z > 255) then z=255 end

        faces[visible] = 
        {
          [0]= z,
          v1,v2,v3,v4
        }
        visible+=1
    end
--  end
  end
  return faces
end


-- sort given "faces" by "".depth", fill "sortfaces"
function sort_faces(faces)
  
  -- initialize all buckets as empty
  local count = {}
  for i=0,255 do count[i]= 0 end

  -- count entries in each bucket
  for i=1,#faces do
    local face= faces[i]
    count[ face[0] ]+=1 -- [0]=depth
  end

  -- set start index for each bucket
  -- start[0]= 1
  -- start[1]= start[0] + count[0]
  -- start[2]= start[1] + count[1] 
  -- ...
  local start = {}
  local prev= 1
  for i=0,255 do 
    start[i]= prev
    prev+= count[i]
  end

  -- move faces into buckets
  local dst= {}
  for i=1,#faces do 
    local face= faces[i]
    local bucket= face[0]
    local index= start[bucket]
    dst[index]= face
    start[bucket]+=1 -- increase start index for this bucket
  end
  return dst
end

local function fillscan_affine(
  y,
  left_x, right_x,
  left_u, right_u,
  left_v, right_v,
  left_z, right_z )

  local x1= (left_x+0x0.ffff)&0xffff.0
  local x2= (right_x+0x0.ffff)&0xffff.0

  if (x1 < x2) then
      local width= right_x - left_x
      local u1,v1= left_u, left_v
      local u2,v2= right_u, right_v

      local du= (right_u-left_u)/width
      local dv= (right_v-left_v)/width
      local stepx = (x1 - left_x)

      tline(
          x1,   y, 
          x2-1, y, 
          u1 + du*stepx, 
          v1 + dv*stepx,
          du,
          dv
      )
  end
end


-- draw list of triangle indices
function draw_quads(faces)

  for i=1,#faces do
    draw_polygon(faces[i], fillscan_affine)
  end

end
