pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

local function unpack_template(addr, dst, step, get)
    local count= peek2(addr)
    addr+=2
    for i=0,count do
        dst[i]= get(addr)
        addr+=step
    end    
    return addr
end

local function readvec3(addr)
    local x,y,z= peek2(addr, 3)
    return {x>>8,y>>8,z>>8}
end

local function readvectors(addr, dst)
    local count= peek2(addr)
    addr+=2
    for i=0,count do
        dst[i]= readvec3(addr)
        addr+=6
    end    
    return addr
end

local function unpackmem(addr, dst)
    return unpack_template(addr, dst, 1, peek)
end

local function unpackmem2(addr, dst)
    return unpack_template(addr, dst, 2, peek2)
end

local function unpackmem4(addr, dst)
    return unpack_template(addr, dst, 4, peek4)
end

-- return memory region as lua string
local function storemem(addr, len)
    return chr(peek(addr,len))
end    

-- write lua string back into memory
local function restoremem(addr, data)
    poke(addr, ord(data, 1, #data))
end    

-- read start address from an dictionary index
local function dict(addr, index)
    return %(addr+(index<<1)) + addr
end

