pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

interference = {
  flash = 0,
  bounce = 0,
  phase = 0,
  cycle = 0,
  rad1 = 0,
  rad2 = 0,
  move = 0,
  maps = 0,

  colors = {},
  tables = {},
  bits = {}
}

interference.setparams= function(this, p)
  this.flash  = p[1]
  this.bounce = p[2]
  this.phase =  p[3]
  this.cycle =  p[4]
  this.rad1 =   p[5]
  this.rad2 =   p[6]
  this.move =   p[7]
  this.maps =   p[8]
end

--local interference_palette= { [0]= 0, 130, 2, 136, 8,14, 9, 15,135, 7, 6,12,13, 1,129,0 }

-- upscale bitmap
local function prepare_table()

local function interpy(x,y)
	local p1= sget( x,     y&127 )
	local p2= sget( x, (y+1)&127 )
--	return p1+(p2-p1)*(y&0x0.f)

	if ( (y&0x0.f)!=0 ) then
	   return (p1+p2)>>1
	else
		return p1
	end
end

	local table= {}
	for y=0,127 do
		-- calculate one row of the bitmap
		local line = {}

   	    local v0= interpy(x,y/2)
		for x=0,32 do
			local p0= 0
			for j=0,3 do
        	    local v1= interpy(x*4+j, y/2)
    			local p= (v0+v1)>>1

				-- we store 8 pixels (4bit each) in one 32 bit integer:
				p0= (p0>>>4) | ((p&-1)<<12)
				p0= (p0>>>4) | ((v1&-1)<<12)
				v0= v1
			end
			-- resulting integer p0 contains last pixel is in the top bits
			-- and the first pixel is in the low (fractional) bits
			line[x]= p0
		end

		-- put the new line into the bitmap
		table[y]= line
	end

	return table
end


interference.load = function(this)
    reload(0x8000, 0x0, 0x4300, "data_3.p8")
	
	for i=0,2 do
	  px9_decomp(0,0, dict(0x8000, i), sget, sset)
	  this.tables[i]= prepare_table()
	end

	local start= dict(0x8000, 4)
   unpackmem4( start, this.bits )
   for i=-20,-1 do this.bits[i]= 0xffff.ffff end

	local start= dict(0x8000, 6)
   for f=-10,10 do
      this.colors[f]= {}
      start= unpackmem(start, this.colors[f])
	end

end

interference.init = function(this)
	-- ist schon alles geladen
end

interference.update = function(this)
	local flash= clamp(this.flash, -10, 10)

    local colors= this.colors[flash&-1]
    local cycle= (this.cycle<<5)&15

	-- secondary pal for border
	pal(this.colors[0], 2)
	
	for i=0,15 do
		pal(i, colors[(i+cycle)&15], 1)
	end

	poke(0x5f5f, 0x10)
    poke(0x5f2c, 0)
end


-- draw effect
interference.draw= function(this)
	local function getrow(tab, y)
		if (y<0) y=0
		if (y>=128) y=255-y
		return tab[y]
	end  

	local amp=  clamp(this.bounce, -16, 16)
	local bounce= flr(cos(this.phase) * amp)+24

    memset(0x5f70, 0x0, 16)
	poke4(0x5f70, this.bits[bounce])
	poke4(0x5f7c, (0xffff.ffff-this.bits[bounce+88-96-8])) -- & 0x1fff.ffff)


	local time= this.move
	-- position of the first bitmap (0..128, 0..128)
	local x1= 64 + flr( cos(time/1.5) * this.rad1 ) 
	local y1= 64 - flr( sin(time/2.1) * this.rad1 )

	-- position of the second bitmap (0..128, 0..128)
	local x2= 64 + flr( cos(time/1.2) * this.rad2 )
	local y2= 64 - flr( sin(time/1.8) * this.rad2 )
	
	-- make sure coordinates are always in a safe range (never get to end of bitmap)
	x1= clamp(x1, 0, 128)
	x2= clamp(x2, 0, 128)

	-- each value in the bitmap contains 8 pixels
	-- one step in x skips 8 pixels
	-- pixels in between are accessed by bit shifting
	local shift1= (x1 & 7)<<2
	local shift2= (x2 & 7)<<2

	x1= (x1>>3&-1) + 1
	x2= (x2>>3&-1) + 1

	cls(0)

	-- test: static overlay
--	memcpy(0x6000, 0x0, 0x2000)
	
	local map1= this.tables[ this.maps\10 ]
	local map2= this.tables[ this.maps%10 ]

	local d1,d2= 0x0000.0000, 0x0202.0202
	for y=0,127-48 do

		-- flip dither matrix every row (0101 -> 1010)	

		d1,d2= d2,d1

		-- pointer to start of scanline in video memory
		-- local addr= 0x6000 + 64*y -- + sin(framecounter/32)*10
		local addr= 0x6000 + 64 * (y+bounce) -- clamp(y + abs(sin(y/132)/10),0,127)
		local row1= getrow(map1, y+y1) -- current row of bitmap1
		local row2= getrow(map2, y+y2) -- interference_distancemap2[y+y2] -- current row of bitmap2
		-- local row1= interference_distancemap1[clamp(y+y1+ceil(sin(framecounter/22)*12),1,127)] -- current row of bitmap1
		-- local row2= interference_distancemap2[clamp(y+y2+ceil(cos(framecounter/64)*32),1,127)] -- current row of bitmap2

		local a1,a2= row1[x1-1],row2[x2-1]
		for x=0,15 do
			local b1,b2= row1[x+x1],row2[x+x2]

			local t1= (a1 >>> shift1) | (b1 << (32-shift1))
			local t2= (a2 >>> shift2) | (b2 << (32-shift2))
--			local t3= $(addr) -- whats currently on the screen

			local add1= ( (t1 & 0x0f0f.0f0f)
			             +(t2 & 0x0f0f.0f0f)
--						 +(t3 & 0x0f0f.0f0f)
						 +d1 ) >> 1
			local add2= ( (t1>>>4 & 0x0f0f.0f0f)
			             +(t2>>>4 & 0x0f0f.0f0f)
--						 +(t3>>>4 & 0x0f0f.0f0f)
						 +d2 ) >> 1

			poke4(
				addr,  
				(add1  & 0x0f0f.0f0f) | (add2<<4 & 0xf0f0.f0f0)
			)

			-- 4 bytes (8 pixels) forward
			addr=addr+4
			a1,a2= b1,b2
		end
	end

end

