org 100h

; gfx mode
	mov	al, 13h
	int	10h

; init interrupts
	mov ax, 0x3508			;21h, ah=35h get interrupt handler | al=08h interrupt number (PIT timer)
	int 21h					;return: es:bx
	push es
	push bx					;backup current interrupt handler
	mov al, 149				;PIT counter divisor
	mov dx, irq				;new handler address
	call init

; init ES (0xa000: gfx segment) and BP (0xfa000: text buffer)
	push word 0xa000
	pop	es
	xor bx, bx

mainloop:
	inc	bx ; BX = timer

; generate text (hexdump)
	mov cl, 32 ; // ch already 0
	mov al, bh
	add al, bh
	mov ah, 1
	mov si, ax ; SI = ((BP >> 8) * 2) + 0x100
	xor ah, ah
	mov di, 0xfa00
fill:
	lodsb
	ror ax, 4
	shr ah, 4
	add ax, 0x3030
lp2:
	cmp al, 58
	jl digit
	add al, 7
digit:
	stosb
	shr ax, 8
	jnz lp2
	loop fill

; generate text (revilove)
	mov cx, 9*128
	and cx, bx
	shr cx, 7
	;mov cl, bh
	;and cl, 9
	mov ah, 0xfa
	xor al, bl
	shr al, 4
	mov si, revilove
	mov di, ax ; 0xfa00 + rnd_ish
	rep movsb

; write text
	pusha
	mov ax, 0x1301
	mov bx, 0x00ff ; 0xff = black (on black)
	mov cl, 38 ; ch = 0
	mov dx, 0x1800
	mov bp, 0xfa00
	int 10h
	popa

; fill screen
	xor di, di
pixloop:

	mov bp, 320
	mov ax, [irq.counter-2]
	test ax, 7*1024
	jnz nofuk
	add bp, bx
nofuk:
	xor dx, dx
	mov ax, di
	div bp
; coords (dx, ax) => (x, y)

	push ax
	push dx
	shr ax, 6
	mul bp
	pop dx
	add dx, ax
	pop ax
	and ax, 63

	mov cl, bl
	add dx, cx
	shr ax, 3
	shr dx, 3
	and al, 7 ; ah=0

	mov si, 320*192
	add si, dx
	mul bp
	add si, ax

	es lodsb
	and ax, di
	stosb
	cmp di, 320*192
	jnz	pixloop

	in	al, 60h
	dec	al
	jnz	mainloop

; back to text mode
	mov	ax, 3 ; ah=0
	int	10h

	pop dx
	pop ds					;restore handler address at exit
	salc						;al = 0 at exit
init:
	out 40h, al				;al = 0 or 108 => write PIT counter 0 divisor = 108 low byte
 	salc
 	out 40h, al				;al = 0 => write PIT counter 0 divisor again = 0 high byte
							;=> this results in a frequency for the interrupt call of 11025 Hz.
							;as clock is 1,19318181818 MHz => 1,19318181818 MHz / 108 = 11025 Hz
 	mov ax, 2508h			;21h, ah=25h set interrupt handler | al=08h interrupt number (PIT timer)
 	int 21h
 	retn

irq:
	pusha
	mov bp,255
	mov ax,0				;ax: t
.counter:

	; bytebeat
	mov si, ax
	shr si, 3
	mov cx, ax
	and cx, 0x1c18
	xchg ch, cl
	mov bx, ax
	shr bx, cl
	or bl, ch
	shr ax, 2
	mul bx
	or ax, si

	mov    dx,0378h			;LPT1 parallel port address
	out    dx,al				;write 8 Bit sample data
	inc    word[bp-255+irq.counter-2]
	mov    al,20h              ;00100000b
	out    20h,al				;Bit 5 = 1 send End Of Interrupt (EOI) signal
	popa
	iret

revilove:
	db 3, 'REVISION'
