org 100h
mov     al, 0x13 ; video mode : 320x200 : DI will move from 0 to 64 000
int     0x10	 ; switch video mode to AL

fninit ; init FPU

push 0xa000	; init
pop es

;;;; PALETTE
; .::. .::. .::. .::. .::. .::. .::. .::.
mov dx, 0x3c8 ; palette command
salc ; al = 0
out dx, al ; select palette colors
inc dx

mov cl, 62
red_palette:
	mov al, 60
	sub al, cl
	out dx, al
	
	xor al, al
	out dx, al
	out dx, al
loop red_palette

dec dx
mov al, 104 ; start at color 104
out dx, al
inc dx

mov cl, 100
dark_palette:
	mov al, cl
	sub al, 140
	
	cmp cl, 75
	jge draw_dark
	
		mov al, 80 
		sub al, cl
		
		cmp cl, 40
		jge draw_dark
		
			mov al, 40
			sub al, cl
	
	draw_dark:
	
	out dx, al
	out dx, al
	out dx, al
loop dark_palette

;;;; END PALETTE
; .::. .::. .::. .::. .::. .::. .::. .::.

mov bp, 0 ; TIME

; + MAIN LOOP
main:
	; + DRAW LOOP
	; mov cx, 64000 ; 320 x 200 pixels = 64K iterations : we don't need that LOL
	
	fragment: ; will draw the whole screen, pixel per pixel
		cwd
		
		; get coordinates : X into DX (0 - 320), Y into AX (0 - 200) 
		xor dx, dx
		mov ax, di
		mov bx, 320
		div bx
		
		; mov [coordx], dx
		; mov [coordy], ax
		push dx ; coord X : [ X ]
		push ax ; coord Y : [ X , Y ]
		
		; we will create a kinda spherical effect,
		; offset the X/Y coordinates so the effect is more 'centered'
		sub ax, 120 ; this will rollover for values of Y < 120
		sub dx, 160 ; this will rollover for values of X < 160
		
		; COMPUTE DISTANCE FROM CENTER
		mov     [si], ax  ; move X
		fild 	word [si] ; X
		fmul 	st0		  ; X²
		mov 	[si], dx  ; move Y
		fild 	word [si] ; Y X²
		fmul 	st0		  ; Y² X²
		fadd 	st0,st1	  ; Y²+X²
		fsqrt			  ; R
		fistp 	word [si] ; store as integer
		mov 	ax, [si]  ; AX : nb of pixels from center, 0-160 width / 0-100 height
		
		; add time to distance computed to create a movement 
		add ax, bp
		add ax, bp
		
		; add this value to Y coordinate to create the distortion effect
		push ax ; [ X, Y, add ]
		
		; ------------------------
		
		; EFFECT SCALE		
		mov al, byte 24
		mov [si], al
		fild word [si]
		
		; Y COORD
		pop ax ; [ X, Y ]
		pop bx ; [ X ]
		add bx, ax
		
		; X COORD
		pop ax ; [ ]
		
		; SAVE Y
		push bx ; [ Y+add ]		
		mul bx ; X * Y
		
		; time evolution
		add ax, bp ; X * Y + T
		add ax, bp ; X * Y + T + T
		
		; CALC
		mov [si], ax
		fild word [si]
		fdiv st1 ; (X * Y + T) / scale
		fsin ; sin((X * Y + T) / scale)
		
		; MORE SCALE
		mov bx, 63
		mov [si], bx
		fild word [si]
		fmul st1 ; 63 * sin((X * Y + T) / scale)
		fabs ; abs(63 * sin((X * Y + T) / scale))
		fistp word [si]	; convert to int and pop
		mov	ax,[si]	; store
		
		; UPDATE PIXEL
		pop bx ; [ ]
		sub al, bl  ; sub al, Y+add
		
		; FADE IN
		mov bx, 255
		sub bx, bp
		cmp ax, bx
		jge draw
			salc ; mov al, 255
		
		draw: 
		
		stosb ; draw pixel color stored in AL (1 byte) to address pointed by DI, and increment DI

	loop fragment ; loop as long as cx > 0
		
	; increment time counter
	inc bp
	
	; .... SOUND .....
	mov dx,	0x331 ;	MIDI Control Port
	
	test bp, word 3 ; play sound every 4 frames
	jnz input

	mov [synth], byte 128
	mov [drum], byte 36
	
	test bp, word 31
	jnz sound2
	
		shr al, 3
		mov bl, 68
		sub bl, al
		mov [synth], byte bl
		mov [drum], byte 40	
		
	sound2:

	mov si, music	
	outsb
	dec dx ; MIDI Data Port (0x330)
	
	; play partition
	mov cl, 8
	rep outsb 
			
	; ..... END SOUND ....
	
	input:
	
	cmp bp, word 479
	jge quit
	
	; + INPUT
	in 	al, 0x60 	; input from port 0x60 to AL : read keyboard
	dec	al			; decrement AL by 1 : is it ESC ?	
	
jnz 	main		; go back to frame drawing if AL is > 0

quit:
; + ABORT SEQUENCE

; sounds off
dec dx ; 0x331 -> 0x330
mov si, end
outsb
outsb
outsb

mov al, 0x10 		; back to text mode
int 0x10			; switch video mode
ret					; quit program

end:
	db 0xb0
	db 123
	db 0

music:
	db 0x3F ; UART mode
	db 0xc0 ; change instrument on channel 0
	db 102 ; instrument
	
	db 0x90 ; NOTE ON on channel 0
synth:
	db 50 ; note
	db 127 ; volume
	
	db 0x99 ; NOTE ON on channel 9
drum:
	db 42 ; note
	db 100 ; volume
