.pc =$0801 "Basic Upstart Program"
:BasicUpstart($4000)

.var music = LoadSid("Jingled.sid")

.pc = $4000 "Main Program"

	lda #$00
	jsr $1000


	sei
	lda #$7f
	sta $dc0d
	lda #$81
	sta $d01a
	lda #<irq
	sta $0314
	lda #>irq
	sta $0315
	lda #$f0
	sta $d012
	lda#$1b
	sta $d011

	

	lda #$18	// charmap $2000
        sta $d018

	cli


//random lentre fentre
	ldx #00
scinit:
	lda rnd,x
	clc
	adc #$20
	sta $400+40,x
	sta $400+240,x

	sta $400+14*40,x
	sta $400+14*40+200,x

	lda #$0f
	sta $d800+40,x
	sta $d800+240,x
	sta $d800+14*40,x
	sta $d800+14*40+200,x

	inx
	cpx #200
	bne scinit


//scrolltext szin

	ldx #$00
col:
	lda #$00
	sta $d800+11*40,x
	lda #24
	sta $0400+11*40,x
	
	inx
	cpx #120
	bne col
	
// 0 es 25 szintelenre
	ldx #$00
	lda #$0f
fl:
	sta $d800,x
	sta $d800+24*40,x

	inx
	cpx #40
	bne fl


// sprites cfg
// $d000 X
// $d001 Y...
//
// $d015 sprite be/ki '00000000'
//
// $d017 nyujtas y be/ki '00000000'
//
// $d01b sprite a szoveg elott(1) vagy mogott(0)
//
// $d01c multicolor be/ki '00000000'
//
// $d01d nyujtas x be/ki '00000000'
//
// $d025 multicol sp szin1 	     -> '01'
// $d026 multicol sp szin2     	     -> '11'
//
// $d027 sp1 szin	multi eseten -> '10'
// $d028 sp2 szin...
//
// screen+03f8 sp1 minta
// $07f8 sp1 minta
// $07f9 sp2 minta...


	lda #$0f
	sta $d020
	sta $d021

	

	lda #$ff
	sta $d015


	lda #%01111111
	sta $d01b
	sta $d017
	sta $d01d


	lda #%01100000		//6 7 jobbra
	sta $d010

	lda #$80
	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d


//spr PosX reset

	ldx #$00
	ldy #$00

sprposinit:
	lda defsprx,x
	
	sta $d000,y

	iny
	iny
	inx
	cpx #$07

	bne sprposinit





	lda #32
	sta $d000	
	lda #80
	sta $d002
	lda #128
	sta $d004
	lda #176
	sta $d006
	lda #224
	sta $d008
	lda #16
	sta $d00a
	lda #64
	sta $d00c


// QB
	lda #159+12
	sta $d00e
	lda #$9f
	sta $07ff
	lda #$01
	sta $d02e



	ldx #$a0
	stx $07f8
	inx
	stx $07f9
	inx
	stx $07fa
	inx
	stx $07fb
	inx
	stx $07fc
	inx
	stx $07fd
	inx
	stx $07fe


	lda #$0c
	sta $d027
	sta $d028
	sta $d029
	sta $d02a
	sta $d02b
	sta $d02c
	sta $d02d









ize:	jmp ize

//----------------------------------------------------------
irq:  	
	inc $d019

//dec $d020

// scroller

	lda scr
	sec
	sbc #$02
	sta scr 
	bpl tov

	lda #$07
	sta scr
	ldy #$00

masol:	lda $0400+11*40+1,y
	sta $0400+11*40,y

	lda $0400+12*40+1,y
	sta $0400+12*40,y

	lda $0400+13*40+1,y
	sta $0400+13*40,y

	iny
	cpy #$27
	bne masol

	jsr betucopy


tov:
	lda scr
	sta $d016

	lda $d000
	sec
	sbc #$04
	sta $d000

	lda $d002
	sec
	sbc #$04
	sta $d002

	lda $d004
	sec
	sbc #$04
	sta $d004

	lda $d006
	sec
	sbc #$04
	sta $d006

	lda $d008
	sec
	sbc #$04
	sta $d008

	lda $d00a
	sec
	sbc #$04
	sta $d00a

	lda $d00c
	sec
	sbc #$04
	sta $d00c

	lda $d000
	cmp #16
	bne vege

//spr PosX reset

	jsr spritecopy

	ldx #$00
	ldy #$00

sprposReset:
	lda defsprx,x
	sta $d000,y

	iny
	iny
	inx
	cpx #$07

	bne sprposReset

	


	


vege:
//inc $d020

////shadow swing
	inc sinpos
	ldx sinpos
	lda sintable,x
	sta $d001
	sta $d003
	sta $d005
	sta $d007
	sta $d009
	sta $d00b
	sta $d00d

/////////////
//BG noise//
///////////


// sin vs center diff

	ldx sinpos

	lda sintable,x
	cmp #$80	
	bcs nagyobb	

	
	lda #$80
	sec
	sbc sintable,x
	jmp abs

nagyobb:
	lda sintable,x
	sec
	sbc #$80

abs:
// diff over :)


	//+-$3c a range ebbol kell 0-9re konvertalni
	lsr
	lsr
	tax
	lda smConv,x
	tax
	
	stx $c000


	lda smlow,x

	clc
	adc noisepos
	sta shadowcopy+1

	lda smhi,x
	sta shadowcopy+2

	ldx #$00

shadowcopy:
	lda $4a00,x
	sta $2300,x

	inx
	cpx #$20
	bne shadowcopy
	
	lda noisepos
	clc
	adc #$08
	sta noisepos
	cmp #$20
	bne shadover
	lda #$00
	sta noisepos

shadover:


/////////////////
// scrollcolor//
///////////////

	ldx sinpos
	lda sintable,x
	sec
	sbc #68
	tax
	lda color,x

	ldx #120
fill:
	sta $d800+11*40-1,x
	dex
	bne fill


///////////////
// QB swing //
/////////////
	lda sinpos
	clc
	adc #$40
	tax
	lda sintable,x
	clc
	adc #10
	sta $d00f


	lda #$00
	jsr music.play


	jmp $ea31
	

//////////////
// CHR Copy//
////////////
betucopy:


	ldx tstart
	lda ts1,x
	sta $0400+39+40*11
	lda ts2,x
	sta $0400+39+40*12
	lda ts3,x
	sta $0400+39+40*13

	inx
	stx tstart

	cpx tend
	bne bcveg



	inc sctext
	ldx sctext
	lda szoveg,x
	tax

	lda tpos,x
	sta tstart
	
	lda chossz,x
	clc
	adc tstart
	sta tend

bcveg:

	rts


//////////////////
/// SprCopy /////
////////////////
spritecopy:


	ldx #$00

spc:
	lda $2801,x
	sta $2800,x 
	lda $2802,x
	sta $2801,x
	lda $2840,x
	sta $2802,x

	lda $2841,x
	sta $2840,x
	lda $2842,x
	sta $2841,x
	lda $2880,x
	sta $2842,x

	lda $2881,x
	sta $2880,x
	lda $2882,x
	sta $2881,x
	lda $28c0,x
	sta $2882,x

	lda $28c1,x
	sta $28c0,x
	lda $28c2,x
	sta $28c1,x
	lda $2900,x
	sta $28c2,x

	lda $2901,x
	sta $2900,x
	lda $2902,x
	sta $2901,x
	lda $2940,x
	sta $2902,x

	lda $2941,x
	sta $2940,x
	lda $2942,x
	sta $2941,x
	lda $2980,x
	sta $2942,x

	lda $2981,x
	sta $2980,x
	lda $2982,x
	sta $2981,x
	lda $29c0,x
	sta $2982,x

	inx
	inx
	inx
	
	cpx #63
	beq spcend
	jmp spc

spcend:



////////////////////0

	lda $0400+11*40+31

	tax
	and #%01100000
	lsr
	lsr
	lsr
	lsr
	lsr
	clc
	adc #$20
	sta b1+2
	
	txa
	asl
	asl
	asl

	ldy #$00
	tax

b1:	lda $2000,x
	sta $29c0,y
	
	inx
	iny
	iny
	iny

	cpy #24
	bne b1


	lda #$20
	sta b1+2


/////////////////1


	lda $0400+12*40+31
	
	tax
	and #%01100000
	lsr
	lsr
	lsr
	lsr
	lsr
	clc
	adc #$20
	sta b2+2
	
	txa
	asl
	asl
	asl

	ldy #$00
	tax

b2:	lda $2000,x
	sta $29c0+24,y
	
	inx
	iny
	iny
	iny

	cpy #24
	bne b2

/////////////////2

	lda $0400+13*40+31
	
	tax
	and #%01100000
	lsr
	lsr
	lsr
	lsr
	lsr
	clc
	adc #$20
	sta b3+2
	
	txa
	asl
	asl
	asl
	ldy #$00
	tax

b3:	lda $2000,x
	sta $29c0+48,y
	
	inx
	iny
	iny
	iny

	cpy #24
	bne b3

	rts




scr:
.byte 7

sctext:			//scrolltext melyik karakterenel jar
.byte 0

tstart:			//3x3 tilesetben hol jarunk
.byte 60

tend:			//hol a vege a legonak
.byte 61

defsprx:
.byte 32,80,128,176,224,16,64

sinpos:
.byte 0

noisepos:
.byte 0


.pc = $4500	"Tiles Row 1-3"
// Tileset/Rows
ts1:
.byte 53,54,55,0,1,2,1,0,1,0,12,0,1,0,14,0,15,2,1,25,24,25,25,28,25,24,32,31,33,32,33,0,1,34,3,0,15,34,1,0,1,42,44,25,25,45,48,45,46,47,25,25,25,25,56,57,0,24,1,24,24,24,25,33,33,24,24,24,24,33,0,1,24,24,24,24,24,24,77,78,0,1,25,0,1,0,1,25,25,34,15,0,1,56,15,0,1,0,1,73,73,24,75,24,0,1


ts2:
.byte 53,54,55,8,9,10,11,10,4,10,11,13,5,6,7,10,11,23,23,23,26,11,27,29,10,30,23,23,23,23,23,10,11,10,11,10,11,6,37,40,41,10,43,10,11,53,49,53,54,55,50,37,10,11,58,59,10,24,11,24,24,24,52,72,72,24,24,24,24,72,10,11,24,24,33,7,25,70,71,24,10,11,23,38,39,65,64,66,67,40,41,13,41,70,71,68,64,69,9,74,74,24,76,24,60,51


ts3:
.byte 53,54,55,16,17,18,19,16,19,16,17,16,19,22,24,21,20,22,22,22,16,19,22,22,18,17,22,22,22,22,22,16,19,35,19,16,36,22,22,16,19,16,19,16,19,61,63,61,62,63,22,22,21,20,18,17,16,24,19,24,24,24,22,24,24,24,24,24,24,24,16,19,24,24,72,24,22,22,24,24,16,19,22,18,17,16,19,24,22,16,19,16,19,22,24,16,19,16,19,24,72,24,24,24,22,24


// TileStartPos
tpos:
.byte 0,3,5,7,9,11,13,15,17,19,20,22,24,26,29,31,33,35,37,39,41,43,45,47,50,52,54,56,57,58,59,60,61,62,63,65,66,67,68,69,70,71,72,73,74,75,76,77,80,82,83,85,87,89,91,93,95,97,99,100,101,102,103,104


// CHR Length
chossz:
.byte 3,2,2,2,2,2,2,2,2,1,2,2,2,3,2,2,2,2,2,2,2,2,2,3,2,2,2,1,1,1,1,1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,3,2,1,2,2,2,2,2,2,2,2,1,1,1,1,1,2


.pc = $4700  "Scroll TXT"
szoveg: 
.text "      yooo! dnp presents this lame compofiller shadowscroll for the last qb party at it's old place."
.text " i hope feryx will continue the tradition of this oldschool party in the big 'village' :)      keep "
.text "the hope alive!    c=64 forever!    greets: oswald :)   "
//     0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789
//                                                             XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX



//shadowsin
.pc = $4800 "ShadowSin"
sintable:
.byte 128,131,134,137,140,143,145,148,151,154,156,159,161,164,166,168,170,172,174,176,178,179,181,182,183,184,185,186,187,187,188,188,188,188,188,187,187,186,185,184,183,182,181,179,178,176,174,172,170,168,166,164,161,159,156,154,151,148,145,143,140,137,134,131,128,125,122,119,116,113,111,108,105,102,100,97,95,92,90,88,86,84,82,80,78,77,75,74,73,72,71,70,69,69,68,68,68,68,68,69,69,70,71,72,73,74,75,77,78,80,82,84,86,88,90,92,95,97,100,102,105,108,111,113,116,119,122,125,128,131,134,137,140,143,145,148,151,154,156,159,161,164,166,168,170,172,174,176,178,179,181,182,183,184,185,186,187,187,188,188,188,188,188,187,187,186,185,184,183,182,181,179,178,176,174,172,170,168,166,164,161,159,156,154,151,148,145,143,140,137,134,131,128,125,122,119,116,113,111,108,105,102,100,97,95,92,90,88,86,84,82,80,78,77,75,74,73,72,71,70,69,69,68,68,68,68,68,69,69,70,71,72,73,74,75,77,78,80,82,84,86,88,90,92,95,97,100,102,105,108,111,113,116,119,122,125


.pc = $4a00 "ShadowMap"
noise:
.byte 0,32,0,0,2,12,0,4,0,0,4,32,128,128,0,16,16,0,0,96,0,4,1,0,12,0,24,16,0,0,0,0,0,5,0,2,0,0,64,16,0,0,0,8,0,1,2,12,32,4,0,4,32,0,16,0,0,0,128,144,0,0,0,136
.byte 96,16,0,0,11,32,2,48,64,88,1,132,64,0,2,4,32,8,8,0,97,4,16,17,98,0,8,14,32,128,128,0,32,33,0,2,96,0,1,152,64,45,1,8,0,2,2,8,1,0,131,0,164,0,1,192,64,68,16,33,4,1,80,0
.byte 72,128,32,37,4,99,1,9,8,164,208,0,36,136,9,129,24,172,17,65,0,8,130,12,73,132,48,22,33,4,0,6,76,2,130,0,192,0,43,69,36,10,72,2,128,72,146,10,68,4,3,17,12,1,104,20,133,16,144,0,97,228,192,0
.byte 14,38,8,1,37,160,116,200,34,21,194,0,48,77,14,168,139,8,132,60,36,0,42,51,6,144,81,26,184,192,129,18,196,128,39,128,192,152,208,112,67,69,32,136,0,15,8,243,38,76,17,12,50,30,8,36,36,164,6,202,3,1,76,88
.byte 89,79,110,192,20,34,14,12,200,42,52,24,36,161,235,134,24,50,131,53,176,10,30,105,57,35,193,224,241,16,168,56,138,152,129,39,23,10,94,136,147,25,246,114,137,16,34,80,74,29,206,168,26,7,200,8,43,92,113,164,32,76,9,149
.byte 230,233,50,16,141,201,86,75,21,77,3,150,55,246,104,70,217,186,14,132,88,46,70,188,73,94,185,97,200,136,239,3,29,123,204,81,56,119,16,148,165,151,119,22,72,182,16,58,111,211,123,12,80,144,105,146,67,23,29,176,209,30,176,118
.byte 228,35,245,25,249,134,177,175,167,50,215,87,22,105,27,87,188,100,108,124,120,110,126,84,208,195,89,245,127,148,12,175,31,236,111,167,7,39,18,236,188,183,54,200,121,73,15,242,100,95,168,225,27,231,27,233,183,179,142,205,144,16,107,127
.byte 231,246,13,181,169,253,228,55,240,45,107,203,252,211,137,255,215,237,21,246,221,59,71,51,106,29,223,25,98,254,235,126,229,193,106,151,173,222,255,58,180,51,175,247,95,129,255,131,50,13,215,226,183,223,252,151,246,95,127,83,209,27,15,107
.byte 115,127,133,188,104,14,230,133,103,205,46,111,234,178,40,100,244,217,180,112,28,161,238,173,172,170,120,154,124,127,176,14,53,182,159,129,131,115,17,247,9,112,190,133,189,37,232,247,173,87,167,3,120,178,179,141,207,138,92,230,127,105,192,81
.byte 255,139,111,223,239,178,251,254,254,116,119,234,157,255,255,247,253,91,126,255,185,239,255,209,253,254,127,43,127,123,191,241,255,255,117,246,60,250,175,253,223,247,247,248,191,63,238,118,255,247,250,159,231,250,252,205,255,254,110,255,247,243,199,15

smConv:		// shadow gradient
.byte 0,0,1,1,2,2,3,3,4,5,6,7,8,8,9,9

smlow:		// shadowmap hi/lo values
.byte $00,$40,$80,$c0,$00,$40,$80,$c0,$00,$40
smhi:
.byte $4a,$4a,$4a,$4a,$4b,$4b,$4b,$4b,$4c,$4c


.pc = $4d00 "BGRandomCharZ"
rnd:
.byte 64,65,67,66,66,67,64,67,67,66,67,66,66,67,66,66,66,66,66,66,65,64,65,64,64,66,65,64,65,65,67,66,67,65,65,65,64,66,64,65,64,67,67,66,64,64,66,66,64,64,64,65,67,64,66,67,65,65,67,67,67,64,67,65,66,64,67,65,65,65,66,64,64,64,66,66,65,66,66,64,65,65,64,65,64,66,64,66,66,67,64,64,65,65,67,64,67,64,65,65,66,65,65,66,66,65,66,64,65,66,64,64,67,66,65,66,65,65,66,65,66,67,65,66,65,66,65,66,66,66,66,64,67,66,66,64,64,67,65,65,66,67,64,64,66,64,67,67,67,67,64,66,67,66,64,65,64,64,67,66,64,67,65,65,65,67,67,64,65,66,67,66,67,66,65,67,64,65,65,67,67,66,65,65,65,67,67,64,66,66,66,66,64,66,66,65,65,65,65,64


.pc = $4e00 "ColorMAP"
color:
.byte 0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,11,11,11,11
.byte 6,6,6,6,6,14,14,14,14,14

.byte 3,3,3,3,13,13,13,1,1,1
.byte 1,1,1,13,13,13,3,3,3,3

.byte 14,14,14,14,14,6,6,6,6,6
.byte 11,11,11,11,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0
.byte 0,0,0,0,0,0,0,0,0,0
.byte 0




.pc = $2000
// Charset
.byte 0,0,0,0,63,127,127,126
.byte 0,0,0,0,252,254,254,126
.byte 126,126,126,126,127,127,127,126
.byte 0,0,0,0,252,254,254,126
.byte 126,0,0,0,126,126,254,254
.byte 126,254,254,254,0,126,254,254
.byte 126,127,127,127,126,126,126,126
.byte 0,254,254,254,0,0,0,0
.byte 0,63,127,127,126,126,127,127
.byte 126,254,254,254,126,126,254,254
.byte 126,126,126,126,126,126,127,127
.byte 126,126,126,126,126,126,254,254
.byte 126,126,126,126,254,254,254,126
.byte 126,127,127,127,126,126,127,127
.byte 0,0,0,0,254,254,254,0
.byte 0,0,0,0,254,254,254,126
.byte 63,0,0,0,0,0,0,0
.byte 254,0,0,0,0,0,0,0
.byte 127,0,0,0,0,0,0,0
.byte 252,0,0,0,0,0,0,0
.byte 254,126,126,254,254,252,0,0
.byte 63,0,0,127,127,127,0,0
.byte 126,0,0,0,0,0,0,0
.byte 126,126,126,126,126,126,126,126
.byte 0,0,0,0,0,0,0,0
.byte 0,0,0,0,126,126,126,126
.byte 0,0,0,126,126,126,127,127
.byte 127,127,127,127,127,126,126,126
.byte 0,0,0,0,126,126,252,252
.byte 248,248,240,248,248,252,252,126
.byte 0,0,0,0,0,0,254,254
.byte 0,0,0,0,124,254,255,126
.byte 0,0,0,0,126,126,127,126
.byte 0,0,0,0,124,254,254,126
.byte 0,0,0,0,127,127,127,126
.byte 127,126,126,126,126,126,0,0
.byte 254,126,126,126,126,126,0,0
.byte 126,252,248,252,126,126,126,126
.byte 0,63,127,127,126,126,127,127
.byte 126,254,254,252,0,126,254,254
.byte 126,127,127,63,0,126,127,127
.byte 0,252,254,254,126,126,254,254
.byte 0,0,0,0,126,255,255,255
.byte 0,0,126,126,126,126,254,254
.byte 0,0,0,0,0,254,254,254
.byte 0,0,0,0,126,126,126,63
.byte 0,0,0,0,62,62,62,127
.byte 0,0,0,0,63,63,63,126
.byte 0,0,0,0,63,63,63,126
.byte 126,124,252,248,248,240,240,224
.byte 126,63,31,63,126,126,126,126
.byte 126,254,254,252,0,0,0,0
.byte 126,126,126,126,0,0,126,126
.byte 63,31,31,15,15,7,7,3
.byte 127,127,255,247,247,227,227,193
.byte 126,124,252,248,248,240,240,224
.byte 0,0,0,0,127,127,127,0
.byte 0,0,0,0,254,254,254,252
.byte 1,3,7,15,31,63,127,127
.byte 248,240,224,192,128,0,254,254
.byte 0,63,127,127,126,126,0,126
.byte 3,0,0,0,0,0,0,0
.byte 193,0,0,0,0,0,0,0
.byte 224,0,0,0,0,0,0,0
.byte 126,252,248,252,126,126,254,254
.byte 0,31,31,31,0,126,127,127
.byte 126,126,127,127,63,0,0,0
.byte 126,126,254,254,254,126,126,126
.byte 126,63,31,63,126,126,127,127
.byte 126,127,127,63,0,126,127,127
.byte 0,0,1,3,7,15,31,63
.byte 126,252,248,240,224,192,128,0
.byte 126,124,240,192,0,0,0,0
.byte 0,0,0,0,0,126,126,126
.byte 126,0,0,0,126,126,126,126
.byte 0,0,0,0,0,0,0,255
.byte 254,252,0,252,254,255,0,0
.byte 0,0,0,0,7,15,31,63
.byte 0,0,0,0,224,192,128,0
.byte 0,0,0,0,0,0,0,0


.pc = $27c0 "qb"
qbsprite:
.byte 0,0,0,0,7,0,0,7,0,15,247,120,14,119,56,14,119,56,14,119,56,14,119,56,14,119,56,15,119,248,0,112,0,0,112,0,0,0,0,64,160,160,1,0,32,89,44,178,85,42,165,85,170,167,85,42,164,85,42,147,0,0,0,0



.pc=music.location "Music"
.fill music.size, music.getData(i)


