float4x4 WorldViewProj : WorldViewProjection;
float4x4 World : World;
float time : time;

float directionX
<
	string UIWidget = "slider";
	float UIMax = 1.0;
	float UIMin = 0.0;
	float UIStep = 0.001;
> = 0.003f;

float directionY
<
	string UIWidget = "slider";
	float UIMax = 0.0;
	float UIMin = 0.0;
	float UIStep = 0.0;
> = 0.0f;

texture BaseTex : DIFFUSE
<
	string ResourceName = "";
	string ResourceType = "2D";
>;

sampler BaseSamp = sampler_state
{
	Texture = <BaseTex>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU = Wrap;
	AddressV = Wrap;
};

struct app_in
{
	float4 pos : POSITION;
	float2 uv : TEXCOORD0;
};

struct vs_out
{
	float4 pos : POSITION;
	float2 uv : TEXCOORD0;
};

vs_out DefaultVertexShader( app_in IN )
{
	vs_out OUT;
	
	OUT.pos = mul( IN.pos, WorldViewProj );
	//modify uv co-ordinates using the time value
	OUT.uv = IN.uv + float2(directionX,directionY)*time;
	
	return OUT;
}

float4 DefaultPixelShader( vs_out IN ) : COLOR
{
	return tex2D(BaseSamp,IN.uv);
}

technique MyShader
{
	pass p0
	{
		VertexShader = compile vs_1_1 DefaultVertexShader( );
		PixelShader = compile ps_1_1 DefaultPixelShader( );
		AlphaBlendEnable = True;
 	        SrcBlend = srcAlpha;
 	        AlphaTestEnable = true;
                AlphaFunc = Greater;
                AlphaRef = 150;                 
 	    
	}
}