#version 450

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;

layout (set = 0, binding = 0) uniform Uniforms {
    vec2 scale;
    vec2 move;
    vec2 tex_start;
    vec2 tex_size;
};

void main() {
    vec2 size = vec2(0.7, 0.1) + tex_size;

    vec2 c = vec2(a_position.x, -a_position.z);
    vec2 pos = c * size * (scale + vec2(1, 1.37)) + move + vec2(-0.11, -0.64);

    gl_Position = vec4(pos, 0, 1);
    v_uv = a_uv * size + tex_start + vec2(0.12, 0);
}