#version 450


layout (location = 0) in vec2 v_uv;
layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 1) uniform sampler2D tex;

layout (set = 1, binding = 0) uniform Uniforms {
    vec4 color;
    float debug;
};

void main() {
    vec3 c = color.rgb + vec3(0.6, 0.1, 0);
    if (debug > 0) {
        f_color = vec4(c * vec3(0.4, 0, 0.1), color.a * texture(tex, v_uv).r + 0.4);
        return;
    }
    f_color = vec4(c, color.a * texture(tex, v_uv).r);
}
