#version 450

#include "/shaders/math.glsl"
#include "/shaders/image_based_lighting.glsl"

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal_worldspace;
layout (location = 2) out vec3 v_tangent_worldspace;
layout (location = 3) out vec3 v_pos_worldspace;
layout (location = 4) out vec3 v_camera_pos_worldspace;

layout (location = 5) out vec3 v_material_adjustment;

layout (set = 0, binding = 1) uniform sampler2D displacement_map;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_world;
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    vec3 g_light_dir_worldspace_norm;
    float g_app_time;

    vec3 instance_move;
    float displacement;
    vec3 zoom;
    float instances;
    vec3 scale;
};

void main() {
    float index = gl_InstanceIndex - instances/2;
    vec2 uv = (a_uv + index * vec2(1, -1)) * zoom.xy * zoom.z;

    vec3 move = instance_move * index;
    vec3 normal = -a_normal;

    float displacement_sample = sample_srgb_as_linear(displacement_map, uv).r;
    vec3 pos = a_position * scale + displacement_sample * displacement * 0.1 * normal + move;

    v_pos_worldspace = (g_world_from_model * vec4(pos, 1.0)).xyz;


    gl_Position = g_projection_from_world * vec4(v_pos_worldspace, 1.0);

    v_uv = uv;
    v_normal_worldspace = mat3(g_world_from_model) * normal;
    v_tangent_worldspace = mat3(g_world_from_model) * -a_tangent;
    v_camera_pos_worldspace = calculate_camera_pos_worldspace(g_camera_from_world);
}