#version 450

layout (location = 0) in vec2 v_uv;
layout (location = 0) out vec4 f_color;

layout (set = 1, binding = 0) uniform Uniforms {
    vec4 color;
    float debug;
} u;

layout (set = 1, binding = 1) uniform sampler2D base_color_map;

void main() {
    float p = texture(base_color_map, v_uv).r;
    if (p < 0.1) {
        discard;
    }
    f_color = vec4(u.color.rgb, p * u.color.a + (u.debug > 0 ? 0.1 : 0));
}
