#version 450

#include "/shaders/common.glsl"
#include "/shaders/math.glsl"
#include "/shaders/image_based_lighting.glsl"

layout (location = 0) in vec3 a_position;
layout (location = 1) in vec3 a_normal;
layout (location = 2) in vec3 a_tangent;
layout (location = 3) in vec2 a_uv;

layout (location = 0) out vec2 v_uv;
layout (location = 1) out vec3 v_normal_worldspace;
layout (location = 2) out vec3 v_tangent_worldspace;
layout (location = 3) out vec3 v_pos_worldspace;
layout (location = 4) out vec3 v_camera_pos_worldspace;

layout (location = 5) out vec3 v_material_adjustment;

//layout (set = 0, binding = 1) uniform sampler2D displacement_map;

layout (set = 0, binding = 0) uniform Context {
    mat4 g_projection_from_world;
    mat4 g_projection_from_model;
    mat4 g_camera_from_model;
    mat4 g_camera_from_world;
    mat4 g_world_from_model;
    vec3 g_light_dir_worldspace_norm;
    float g_app_time;

    vec3 instance_move;
    float displacement;
    float rank;
    float zoom;

    vec4 A;
    vec4 B;
    vec4 C;
    float time;
    vec4 D;
    float loop;
    float loop_height;

    vec4 E;
    vec4 Ei;
};

#include "distort.glsl"

void main() {
    float i = gl_InstanceIndex;

    vec3 pos = a_position;
    vec3 normal = a_normal;
    vec3 tangent = a_tangent;

    float t = time * (D.z + D.y * i) + i*D.x + D.w * 10;
    float e = cos(i*B.y+B.w)* loop_height;
    t = (fract((t+e+loop/2)/loop-0.5)-0.5)*loop;
    pos.y += t;

    distort_side(pos, normal, tangent, E + Ei * i);

    pos.z += C.x;
    pos.x += cos(i*B.x+B.w)* B.z;

    distort(pos, normal, tangent, A);

    v_pos_worldspace = (g_world_from_model * vec4(pos, 1.0)).xyz;

    gl_Position = g_projection_from_world * vec4(v_pos_worldspace, 1.0);

    v_uv = a_uv;
    v_normal_worldspace = mat3(g_world_from_model) * normal;
    v_tangent_worldspace = mat3(g_world_from_model) * tangent;
    v_camera_pos_worldspace = calculate_camera_pos_worldspace(g_camera_from_world);
}